/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'Q'


#include "lbwintex.h"
#include "lbcommon.h"
#include <stdlib.h>
#include "lbwad.h"
#include "lbdispl.h"
#include "lbtext.h"

#include "lbwaddef.h"
#include "lbwaddir.h"
#include "lbwadir.h"
#include "lbwadid.h"
#include "lbquake.h"
#include "lbqkmdl.h"



#if (DLLFORQUAK)
/****************************************************\
*
*
* Quake PACK mdl
*
*
\****************************************************/



/*
** MDL Directory Iterator
*/
typedef struct
{ pInt8 Dir;     /*Lump*/
  Int32 DirSz;   /*size of lump*/
  Int32 Pos;     /*position in lump*/
  pInt8 Pic;     /*pointer to picture*/
  Int32 PicSz;   /*size of picture*/
  Int32 SzX;     /*width*/
  Int32 SzY;     /*height*/
  Int16 NbSub;   /*remaining number of sub entries*/
  Int16 Entry;   /*current entry*/
  Int16 Group;    /*current skin group*/
  Int16 NbGroup;  /*number of skin groups*/
}MDLDIR;
typedef MDLDIR PTR *pMDLDIR;

static Int16 MDLdirDirInit(pMDLDIR pDir, pWADDEF This, Int16 Entry)
{
  pQKMDLH Head;
  pDir->Dir=WADreadEntryI(This, &pDir->DirSz, Entry);
  if(pDir->Dir==NULL)
  { return -1;}
  Head=(pQKMDLH)pDir->Dir;
  if((pDir->DirSz<sizeof(QKMDLH))||(Strncmp(Head->Name,"IDPO",4)<=0))
  { Free(pDir->Dir); return ERRfault(BAD_ENTRY);}
  if(Head->Version!= QKMDLVERSION)
  { Free(pDir->Dir); return ERRfault(ERR_VERSION);}
  /*pDir->NbEntry=(Int16)Head->FrameNb;*/
  pDir->Entry=-1; /*not known in advance*/
  pDir->NbSub=-1;
  pDir->Group=-1;
  pDir->NbGroup= (Int16) Head->NumSkin;
  if((Head->NumSkin<0)||(Head->NumSkin>0x40L))
  { return -1;}
  pDir->Pos=sizeof(QKMDLH);
  pDir->Pic=NULL;
  pDir->SzX= Head->SzX;
  pDir->SzY= Head->SzY;
  pDir->PicSz = (Head->SzX)*(Head->SzY);
  if((pDir->PicSz<0)||(pDir->PicSz>0x100000L))
  { return -1;}
  return 1;
}
static Int16 MDLdirNext(pMDLDIR pDir)
{
  pQKMDLID Head;
  /**/
  pDir->Pic=NULL;
  if((pDir->Pos + pDir->PicSz)>= pDir->DirSz)
  { return -1; }
  /*
  ** Tag Entry
  */
  pDir->Entry+=1;
  /*
  ** If not inside a list of pictures
  */
  if(pDir->NbSub<=0)
  {
	 /*Check group number*/
	 pDir->Group+=1;
	 if(pDir->Group >= pDir->NbGroup)
	 { return -1;}
	 /*Decode group head*/
	 Head=(pQKMDLID)&(pDir->Dir[pDir->Pos]);
	 if(Head->Id==0)
	 {  /*single picture*/
		 pDir->Pos+=sizeof(Head->Id);
		 pDir->NbSub=-1;
	 }
	 else
	 {  /*multi picture list*/
		 pDir->NbSub=(Int16)Head->Nb;
		 /*check number of pictures*/
		 if((Head->Nb<1)||(Head->Nb>0x20))
		 { return ERRfault(BAD_ENTRY);}
		 /*move to first picture*/
		 pDir->Pos+= sizeof(QKMDLID) + (Head->Nb - 1)*sizeof(Float32);
	 }
  }
  /*
  ** Get picture, SzX, SzY
  */
  pDir->Pic = &(pDir->Dir[pDir->Pos]);
  /*
  ** skip picture
  */
  pDir->Pos += pDir->PicSz;
  /*
  ** If multi-picture list, take next picture in the list
  */
  if(pDir->NbSub>0)
  {
	 pDir->NbSub -=1;
  }
  return pDir->Entry;
}
static void MDLdirFree(pMDLDIR pDir)
{
  Free(pDir->Dir);
  pDir->Dir=NULL;
  pDir->Pic=NULL;
  /*do not reset Start, Size, SzX, SzY*/
}
/*
** List Skins in Models
*/
Int16 MDLdirSkinList(pWADDEF This, Int16 Entry, pWINDOZE Wnd)
{
  TXTOBJ Txt;
  MDLDIR Dir;
  Int8 Name[NORMALISELEN*2+2];
  if(TXTinitWnd(&Txt,NORMALISELEN*2,Wnd)<0)
  { return ERR_SURE;}
  /**/
  if(MDLdirDirInit(&Dir,This,Entry)<0)
  { TXTfree(&Txt); return BAD_ENTRY;}
  /**/
  while(MDLdirNext(&Dir)>=0)
  { /*
	 ** Print
	 */
	 Strcpy(Name,"Skin ");
	 StrcatNum(Name,(Dir.Group&0xFFFFL),10);
	 Strcat(Name,":");
	 StrcatNum(Name,(Dir.Entry&0xFFFFL),10);
	 /**/
	 if(TXTprintName(&Txt, Dir.Entry, Name, sizeof(Name))<0)
	 { break; }
  }
  /**/
  MDLdirFree(&Dir);
  /**/
  TXTfree(&Txt);
  /**/
  return 1;
}
/*
** Convert MDL skin to Bmp
*/
Int16 MDLdirToBmp(pWADDEF This, pBMPOBJ Bmp,Int16 Entry,Int16 Sdir)
{
  Int16 res=-1;
  MDLDIR Dir;
  /**/
  if(MDLdirDirInit(&Dir,This,Entry)<0)
  { return BAD_ENTRY;}
  /**/
  while(MDLdirNext(&Dir)>=0)
  {
	 if(Dir.Entry<Sdir)
	 { continue; }
	 /*
	 ** Display as flat
	 */
	 if((Dir.Pic!=NULL)&&(Dir.SzX>0)&&(Dir.SzY>0))
	 {
		res=BMPinitFlat(Bmp,Dir.Pic,(Int16)Dir.SzX,(Int16)Dir.SzY);
	 }
	 break;
  }
  /**/
  MDLdirFree(&Dir);
  /**/
  return res;
}
#endif /*DLLFORQUAK*/