/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 't'

#include "lbwintex.h"
/*include windows.h after lbwintex.h*/
#if defined __WINDOWS__
#include <windows.h>
#endif
#include "lbcommon.h"
#include "lbwindoze.h"
#include "lbwad.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include "lbtext.h"

static Int16 TXTwinValid(pWINDOZE Wnd)
{
#if defined __WINDOWS__
  if((Wnd!=NULL)&&(Wnd->hWnd!=NULL))
  { switch(Wnd->Type)
	 { case WINDOZE_LISTBOX:
		case WINDOZE_DROPBOX:
		  return 1;
	 }
  }
#endif
  return ERRfault(BAD_PARM);
}
static Int16 TXTwinClear(Int32 Type, Int32 hWnd)
{
#if defined __WINDOWS__
  switch(Type)
  { case WINDOZE_LISTBOX:
		return LISTclear((HWND)hWnd);
	 case WINDOZE_DROPBOX:
		return CMBXclear((HWND)hWnd);
  }
#endif
  return ERR_SURE;
}
/*
** Set element Idx  with (Code, Text)
*/
static Int16 TXTwinSet(Int32 Type, Int32 hWnd, Int16 Index, Int32 Code, pInt8 Text)
{
#if defined __WINDOWS__
	switch(Type)
	{  case WINDOZE_LISTBOX:
		  return LISTset((HWND)hWnd,Index,Code,Text);
		case WINDOZE_DROPBOX:
		  return CMBXset((HWND)hWnd,Index,Text);
	}
#endif
	return ERR_SURE;
}


/*
** Text
*/

typedef struct
{ Int16 Type;  /*0=Memory  otherwise any kind of list.*/
  Int16 EltSz; /*if 0, variable size.  if >0, fixed size.*/
  Int32  Top;   /*Top of text.*/
					/*if fixed size, increases by steps of EltSz.*/
  Int32  DtaSz; /*Size of buffer*/
  pInt8 Dta;   /*Fixed size:    "Int32+string+\0" */
					/*Variable size: "string+\0" */
  Int32 hWnd;   /*if !=NULL and type!=0, handle of window*/
}TXTDEF;
typedef TXTDEF PTR *pTXTDEF;

#if sizeof(TXTOBJ) != sizeof(TXTDEF)
#error TXTOBJ must have the same size as TXTDEF
#endif
  /*
  ** Buffer for temp storage
  */

#define TXTDTASZ  (0x100)   /*size of line buffer*/
#define TXTSZ1    (0x400L)  /*base text size*/
#define TXTSZ2    (0x10000L)/*additional text increases*/
static Int8 TxtDta[TXTDTASZ];

static pTXTDEF TXTgetObj(pTXTOBJ Text)
{
  pTXTDEF Txt=(pTXTDEF) Text;
  if(Txt==NULL)
  { ERRfault(ERR_BUG); return NULL;}
  switch(Txt->Type)
  {
	 case WINDOZE_LISTBOX:
	 case WINDOZE_DROPBOX:
		if(Txt->hWnd!=NULL)
		{ break;}
	 case 0:
		if(Txt->Dta==NULL)
		{ ERRfault(BAD_PARM);}
		if((Txt->Top < 0)||(Txt->Top >= Txt->DtaSz))
		{ ERRfault(BAD_PARM);}
		break;
	 default:
		ERRfault(ERR_BUG);
		return NULL;
  }
  return Txt;
}
  /*
  ** Check that text can contain more text, resize if needed.
  **  Added = length of text to add
  ** returns >0 if ok.
  */
static Int16 TXTchkAdd(pTXTDEF Txt,Int32 Added)
{
  Int32 DtaSz;
  /*no checks on Txt*/
  if(Added>TXTSZ2)
  { return ERRfault(ERR_BUG); }
  if(Txt->Top + Added > Txt->DtaSz)
  {
	 DtaSz= Txt->DtaSz + TXTSZ2;
	 Txt->Dta= Realloc(Txt->Dta, DtaSz);
	 if(Txt->Dta==NULL)
	 {
		Txt->DtaSz=0;
		Txt->Top=0;
		return ERR_MEM;
	 }
	 Txt->DtaSz=DtaSz;
  }
  return 1;
}
  /*
  ** Init Txt, assumes uninitialised
  **  EltSz = fixed size of elements, or 0 if variable sized
  */
Int16 TXTinit(pTXTOBJ Text, Int16 EltSz)
{
  pTXTDEF Txt=(pTXTDEF) Text;
  if(Txt==NULL) return NULL;
  /*in memory*/
  Txt->Type= 0;
  Txt->hWnd= NULL;
  /*size of base element*/
  if(EltSz<=0)
	 Txt->EltSz=0;
  else
	 Txt->EltSz = (sizeof(Int32)+EltSz+1+3)&(~3); /*align4*/
  /*data*/
  Txt->Top=0;
  Txt->DtaSz = TXTSZ1;
  Txt->Dta = Malloc(TXTSZ1);
  if(Txt->Dta==NULL) return ERR_MEM;
  return 1;
}
Int16 TXTinitWnd(pTXTOBJ Text, Int16 EltSz, pWINDOZE Wnd)
{
  pTXTDEF Txt=(pTXTDEF)Text;
  if(Txt==NULL) return ERR_MEM;
  Txt->Type = 0;
  if(TXTwinValid(Wnd)<0) return ERR_SURE;
  if(EltSz<=0)
	 Txt->EltSz=0;
  else
	 Txt->EltSz = (sizeof(Int32)+EltSz+1+3)&(~3); /*align4*/
  Txt->Type= Wnd->Type;
  Txt->hWnd= Wnd->hWnd;
  Txt->Dta=NULL;
  Txt->DtaSz=0;
  Txt->Top=0;
  TXTwinClear(Txt->Type,Txt->hWnd);
  return 1;
}
  /*
  ** Init Txt, assumes uninitialised
  **  Lmp   = lump of text lines
  **  LmpSz = size of Lmp
  */
Int16 TXTinitLmp(pTXTOBJ Text,pInt8 Lmp,Int32 LmpSz)
{
  Int32 DtaSz,t,linSz;
  Int8 c;
  pTXTDEF Txt=(pTXTDEF) Text;
  if(Txt==NULL) return ERRfault(ERR_BUG);
  /*in memory*/
  Txt->Type= 0;
  Txt->hWnd= NULL;
  /*size of base element*/
  Txt->EltSz=0;
  Txt->DtaSz=0;
  Txt->Top =0;
  if((Lmp==NULL)||(LmpSz<=0))
  { return ERRfault(ERR_BUG);}
  DtaSz=(LmpSz+TXTSZ1-1)&(~(TXTSZ1-1));
  Txt->Dta = Malloc(DtaSz);
  if(Txt->Dta==NULL) return NULL;
  Txt->DtaSz =DtaSz;
  /*
  ** Translate Lmp into a text lump, ignore controls
  */
  DtaSz=0;
  for(linSz=0, t=0; t<LmpSz; t++)
  {
    c=Lmp[t];
    /*limit size of lines to 64*/
    if((c==' ')&&(linSz>64))
    { c='\0'; }
	 switch(c)
	 { case '\0': case '\n':
		  Txt->Dta[DtaSz++]='\0';
        linSz=0;
		  break;
		default:
		  if(iscntrl(c))continue;
		  /*no break;*/
      case ' ': case '\t':
		  Txt->Dta[DtaSz++]=c;
        linSz++;
		  break;
	 }
  }
  Txt->Top= (Txt->DtaSz > DtaSz)? DtaSz : Txt->DtaSz;
  return 1;
}
  /*
  ** Init from list box
  */
Int16 TxtInitFromList(pTXTOBJ Text,pWINDOZE Wnd)
{
  pTXTDEF Txt=(pTXTDEF) Text;
  Txt->Type=-1;
  Txt->Dta =NULL;
  (void)Txt;
  (void)Wnd;
  return 1; /*not implemented. ah ah. vewy funny.*/
}  /*
  ** Free Txt
  */
Int16 TXTfree(pTXTOBJ Text)
{
  pTXTDEF Txt= TXTgetObj(Text);
  if(Txt==NULL) return ERR_SURE;
  if((Txt->Type==0)&&(Txt->Dta!=NULL))
  { Free(Txt->Dta); }
  Txt->Dta=NULL;
  Txt->DtaSz=0;
  Txt->Top=0;
  Txt->Type=-1;
  return 1;
}
  /*
  ** Get Txt, size
  */
pInt8 TXTget(pTXTOBJ Text,pInt32 pLmpSz)
{
  Int32 t,tt,l;
  pInt8 Lmp;
  Int8 c;
  pTXTDEF Txt= TXTgetObj(Text);
  if(Txt==NULL)
  { return NULL;}
  Lmp=Malloc(Txt->Top);
  /*translate text lump into text*/
  if(Lmp==NULL) return NULL;

  if(Txt->EltSz>0)  /*fixed size. Int32 + Text*/
  {
	 for(l=0,t=0; t<Txt->Top; t+= Txt->EltSz)
	 { for(tt=sizeof(Int32); tt<Txt->EltSz; t++)
		{
		  c=Txt->Dta[t+tt];
		  if((c=='\0')||(c=='\n')) c='\n'; /*end of line*/
		  Lmp[l]=c;l++;
		}
	 }
  }
  else /*not fixed size*/
  {
	 for(l=0,t=0; t<Txt->Top; t++)
	 {
		c=Txt->Dta[t];
		if((c=='\0')||(c=='\n')) c='\n';
		Lmp[l]=c;l++;
	 }
  }
  /**/
  *pLmpSz=l;
  return Lmp;
}
  /*
  ** Generic add static TxtDta to lump
  **
  */
static Int16 TXTprintTxtDta(pTXTDEF Txt, Int16 Len, Int32 Code)
{
  if(Txt->Type!=0)
  { /*
	 ** directly load into list box
	 */
	 TXTwinSet(Txt->Type,Txt->hWnd,-1,Code,TxtDta);
  }
  else
  { /*
	 ** Add to text
	 */

	 if(Txt->EltSz>0) /*fixed  size*/
	 {
		if(TXTchkAdd(Txt,Txt->EltSz)<0) return ERR_SURE;
		/*Set code*/
		*(pInt32)(Txt->Dta[Txt->Top]) = Code;
		/*Set text*/
		Strncpy(&(Txt->Dta[Txt->Top+sizeof(Int32)]),TxtDta,Txt->EltSz-sizeof(Int32));
		Txt->Top+=Txt->EltSz;
	 }
	 else /*variable size*/
	 {
		if(TXTchkAdd(Txt,Len+1)<0) return ERR_SURE;
		if(Len>0)
		{ Strncpy(&(Txt->Dta[Txt->Top]),TxtDta,Len);}
		Txt->Top+= Len;
		Txt->Dta[Txt->Top]='\0';
		Txt->Top+= 1;
	 }

  }
  return 1;
}
/*
** Printf(Txt, "%8.8s %d ",...);
** Line automatically added at the end
*/
Int16 TXTprintFrm(pTXTOBJ Text,Int8 *Form, ...)
{
  Int16 Len;
  va_list args;
  pTXTDEF Txt= TXTgetObj(Text);
  if(Txt==NULL) return ERR_SURE;
  /**/
  va_start( args, Form);
  Len=vsprintf(TxtDta,Form,args);
  va_end(args);
  if(Len==EOF) return Len;
  /*
  ** Write TxtDta into list
  */
  return TXTprintTxtDta(Txt,Len,-1);
}
/*
** Print a Name
**  Code = code associated to the name (ItemData)
**	Name = name
*/
Int16 TXTprintName(pTXTOBJ Text,Int32 Code, pInt8 Name, Int16 NameSz)
{
  pTXTDEF Txt= TXTgetObj(Text);
  if(Txt==NULL) return ERR_SURE;
  /*
  ** Print name
  */
  if(Name==NULL)
  { return ERRfault(BAD_PARM);}
  if(NameSz<=0)
  { NameSz=Strlen(Name,TXTDTASZ-1);}
  if(NameSz>(TXTDTASZ-1)) NameSz = TXTDTASZ-1;
  Strncpy(TxtDta,Name,NameSz);
  /*
  ** Upload string
  */
  return TXTprintTxtDta(Txt,NameSz,Code);
}
/*
** Print Name
**  Code = code associated to the name (ItemData)
**	Name = name of 8 character
*/
Int16 TXTprintName8(pTXTOBJ Text,Int32 Code,pInt8 Name, Int16 How)
{
  pTXTDEF Txt= TXTgetObj(Text);
  Int16 length;
  if(Txt==NULL) return ERR_SURE;
  /*
  ** Print name
  */
  if(Name==NULL)
  { return ERRfault(BAD_PARM);}
  switch(How)
  { case 1:
		TxtDta[0]=' ';
		NormalizeS(&TxtDta[1],Name);
		length = NORMALISELEN+1;
		break;
	 case 0:
	 default:
		length = NORMALISELEN;
		NormalizeS(TxtDta,Name);
		break;
  }
  /*
  ** Upload string
  */
  return TXTprintTxtDta(Txt,length,Code);
}
/*
** Print Name X Y
*/
Int16 TXTprintName8XY(pTXTOBJ Text,Int32 Code,pInt8 Name, Int16 X, Int16 Y)
{
  pTXTDEF Txt= TXTgetObj(Text);
  if(Txt==NULL) return ERR_SURE;
  /*
  ** Print name X Y
  */
  if(Name==NULL)
  { return ERRfault(BAD_PARM);}
  NormalizeS(TxtDta,Name);
  NormalizeN(&TxtDta[NORMALISELEN+1],X);
  NormalizeN(&TxtDta[NORMALISELEN+5+1],Y);
  TxtDta[NORMALISELEN]=' ';
  TxtDta[NORMALISELEN+5]=' ';
  TxtDta[NORMALISELEN+5+5]='\0';
  /*sprintf(&TxtDta[NORMALISELEN]," %4.4d %4.4d\0",Name,(int)X,(int)Y);*/
  /*
  ** Upload string
  */
  return TXTprintTxtDta(Txt,NORMALISELEN+5+5+1,Code);
}
/*
** Put in listbox
*/
Int16 TXTputInWnd(pTXTOBJ Text,pWINDOZE Wnd)
{
  Int32 t,Code;
  Int16 tt,count;
  pInt8 TDta;
  pTXTDEF Txt=(pTXTDEF) Text;
  if((Txt->DtaSz<=0)||(Txt->Dta==NULL))
  { return ERRfault(ERR_BUG);}
  /*
  ** clear list
  */
  if(TXTwinValid(Wnd)<0) { return ERR_SURE;}
  TXTwinClear(Wnd->Type,Wnd->hWnd);
  /*
  ** upload list
  */
  if(Txt->EltSz<=0)
  {
	 count=0;tt=0;
	 for(t=0,TDta=Txt->Dta; t< Txt->Top; t++,TDta+=1)
	 { /*TDta = Txt->Dta[t]*/
		switch(*TDta)
		{ case '\n': case '\0':
			 TxtDta[tt]='\0'; tt = 0;
			 TXTwinSet(Wnd->Type,Wnd->hWnd, count, 0, TxtDta);
			 count +=1;
			 break;
		  default:
			 if(tt<TXTDTASZ)
			 { TxtDta[tt++]= *TDta;}
		}
	 }
  }
  else
  {
	 count=0;
	 for(t=0,TDta=Txt->Dta; t< Txt->Top; t+= Txt->EltSz, TDta+=Txt->EltSz)
	 { /*TDta = Txt->Dta[t]*/
		/*get Code*/
		Code = *(pInt32)TDta;
		/*get Text*/
		Strncpy(TxtDta,&TDta[sizeof(Int32)],Txt->EltSz-sizeof(Int32));
		TXTwinSet(Wnd->Type,Wnd->hWnd, count, Code, TxtDta);
	 }
  }
  return count;
}


/****************************************************\
*
*
*  Text counter object
*
*
\****************************************************/

struct COUNT
{ Int32 Count;
  Int8 Name[NORMALISELEN];
};
typedef struct COUNT PTR *pCOUNT;
struct CNTDEF
{ Int32  Top;   /*Top index*/
  Int32  LstNb; /*Nb in list*/
  pCOUNT Lst;   /*list*/
};
typedef struct CNTDEF PTR *pCNTDEF;
#if sizeof(struct CNTDEF) != sizeof(struct CNTOBJ)
#error Bad size for CNTOBJ
#endif
/*
** Init
*/
Int16 CNTinit(pCNTOBJ CntO, Int32 Size)
{
  pCNTDEF Cnt=(pCNTDEF) CntO;
  if(Cnt==NULL)
  { return ERRfault(ERR_BUG);}
  Cnt->Top=0;
  Cnt->LstNb = Size;
  Cnt->Lst= Malloc(Cnt->LstNb * sizeof(struct COUNT));
  if(Cnt->Lst==NULL) return ERR_MEM;
  return 1;
}
#if 0
static Int16 CNTcmp(pCOUNT C1, pCOUNT C2)
{ Int16 i;
  for(i=0; i<NORMALISELEN; i++)
  { if(C1->Name[i]< C2->Name[i]) return -1;
	 if(C1->Name[i]> C2->Name[i]) return 1;
  }
  return 0;
}
void CNTswap(pCOUNT C1, pCOUNT C2)
{
  struct COUNT Tmp;
  Memcpy(Tmp,C1, sizeof(struct COUNT));
  Memcpy(C1,C2, sizeof(struct COUNT));
  Memcpy(C2,Tmp, sizeof(struct COUNT));
}
#endif
/*
** Add one name
** Should use a hash table
*/
Int16 CNTaddName(pCNTOBJ CntO, pInt8 Name)
{ pCOUNT TLst;
  Int32  n;
  pCNTDEF Cnt=(pCNTDEF) CntO;
  if((Cnt==NULL)||(Cnt->Lst==NULL))
  { return ERRfault(ERR_BUG);}
  for(n=0,TLst=Cnt->Lst; n<Cnt->Top; n++, TLst+=1)
  { /*
	 ** check if name already exists
	 */
	 if(Strncmp(TLst->Name,Name,NORMALISELEN))
	 { TLst->Count +=1;
		return (Int16)n;
	 }
  }
  /*
  ** Add one name
  */
  if(n >= Cnt->LstNb)
  { n = Cnt->LstNb-1;}
  TLst = &( Cnt->Lst[n]);
  Normalise(TLst->Name,Name);
  TLst->Count=1;
  Cnt->Top=n+1;
  return (Int16)n;
}
/*
** List names
** Should sort the entries
*/
Int16 CNTlistNames(pCNTOBJ CntO, pTXTOBJ Text)
{
  pCOUNT TLst;
  Int32  n;
  pCNTDEF Cnt=(pCNTDEF) CntO;
  if((Cnt==NULL)||(Cnt->Lst==NULL))
  { return ERRfault(ERR_BUG);}
  for(n=0,TLst=Cnt->Lst; n<Cnt->Top; n++, TLst+=1)
  {
	TXTprintFrm(Text,"%-8.8s      %ld",TLst->Name, TLst->Count);
  }
  return (Int16)n;
}
/*
** Free
*/
Int16 CNTfree(pCNTOBJ CntO)
{
  pCNTDEF Cnt=(pCNTDEF) CntO;
  if((Cnt==NULL)||(Cnt->Lst==NULL))
  { return ERRfault(ERR_BUG);}
  Free(Cnt->Lst);
  Cnt->Lst=NULL;
  return 1;
}

