/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'V'

/*
** Visual Basic extension functions
**
*/
#include "lbwintex.h"
#include "lbcommon.h"
#include "lbvbasic.h"
#include <ctype.h>
#include <string.h>

/*************************************************************/
/* FILES UTILITY
** check if file or directory exist, make paths and split paths
*/
#include <dir.h>

Int16 EXPORT DIRexistFile(pInt8  File)
{ if(FILEexist(File,FALSE)==TRUE) return VbTRUE;
  return VbFALSE;
}
Int16 EXPORT DIRexistDir(pInt8  File)
{ if(FILEexist(File,TRUE)==TRUE) return VbTRUE;
  return VbFALSE;
}
/*
** common variables to the split functions
*/
static Int8 DIRdrive[MAXDRIVE];
static Int8 DIRdir[MAXDIR+MAXDRIVE];
static Int8 DIRfile[MAXFILE+MAXEXT];
static Int8 DIRext[MAXEXT];
/*
** get the directory name
*/
Int16 EXPORT DIRsplitDir(pInt8  direc,pInt8  path)
{ if(direc==NULL) return ERRfault(BAD_PARM);
  if(path==NULL) return ERRfault(BAD_PARM);
  Strncpy(Buff, path,MAXBUFFSZ-1);
  fnsplit(Buff,DIRdrive,DIRdir,DIRfile,DIRext);
  fnmerge(Buff,DIRdrive,DIRdir,"",""); /*drive+directory*/
  Strncpy(direc,Buff,MAXBUFFSZ-1);
  return Strlen(Buff,MAXBUFFSZ);/*direc length*/
}
/*
** get the filename +extension of a file
*/
Int16 EXPORT DIRsplitFile(pInt8  file,pInt8  path)
{ if(file==NULL) return ERRfault(BAD_PARM);
  if(path==NULL) return ERRfault(BAD_PARM);
  Strncpy(Buff, path,MAXBUFFSZ-1);
  fnsplit(Buff,DIRdrive,DIRdir,DIRfile,DIRext);
  fnmerge(Buff,"","",DIRfile,DIRext); /*file name+extension*/
  Strncpy(file,Buff,MAXBUFFSZ-1);
  return Strlen(Buff,MAXBUFFSZ);/*file length*/
}
/*
** get the root of a file
*/
Int16 EXPORT DIRsplitRoot(pInt8  root,pInt8  path)
{ if(root==NULL) return ERRfault(BAD_PARM);
  if(path==NULL) return ERRfault(BAD_PARM);
  Strncpy(Buff, path,MAXBUFFSZ-1);
  fnsplit(Buff,DIRdrive,DIRdir,DIRfile,DIRext);
  Strncpy(root,DIRfile,MAXBUFFSZ-1);              /*just the file name*/
  return Strlen(DIRfile,MAXBUFFSZ);/*root length*/
}
/*
** Make a path, from directory and file+extension
*/
Int16 EXPORT DIRmakePath(pInt8  path,pInt8  dir,pInt8  fname)
{ if(fname==NULL) return ERRfault(BAD_PARM);
  if(path==NULL) return ERRfault(BAD_PARM);
  if(dir==NULL) return ERRfault(BAD_PARM);
  Strncpy(DIRdir,dir,MAXDRIVE+MAXDIR-1);
  Strncpy(DIRfile,fname,MAXFILE+MAXEXT-1);
  fnmerge(Buff,"",DIRdir,DIRfile,"");
  Strncpy(path,Buff,MAXBUFFSZ-1);
  return Strlen(Buff,MAXBUFFSZ);
}





/*
** Start help file viewer
**  File = help file
**  Code = what to display
*/
#include <windows.h>
Int16 EXPORT EXEChelpViewer(pInt8 File, Int32 Code)
{ /* Open File with relevant handler, with CurrentDir = Dir*/
  Int16 Cmd;
  Int32 Key;
  if(File==NULL) return ERRfault(BAD_PARM);
  if(Code>0)
  {
	 /* HELP_CONTEXT=1*/
	 Cmd=1; Key=((Int32)Code)&0xFFFFL;
  }
  else
  {
	 Key=0;
	 switch(Code)
	 { default:
		case -1: /*HELP_CONTENTS =3 */
		  Cmd = HELP_CONTENTS; break;
		case -2: /*HELP_INDEX = 3 */
		  Cmd = HELP_CONTENTS; break;
		case -3: /*HELP_HELPONHELP = 4*/
		  Cmd = HELP_HELPONHELP; break;
	 }
  }
  return WinHelp(0, (LPSTR)File, Cmd, Key);
}

/*
** Execute, on a file, the editor associated
** to the extension of this file
*/
#if defined __WINDOWS__
#include <shellapi.h>
#endif
Int16 EXPORT EXECopenFile(pInt8  File,pInt8 Params, pInt8  Dir)
{ /* Open File with relevant handler, with CurrentDir = Dir*/
  Int16 res;
  if(File==NULL) return ERRfault(BAD_PARM);
#if defined __WINDOWS__
  res=ShellExecute(0,NULL,(LPSTR)File,(LPSTR)Params,(LPSTR)Dir,SW_SHOW);
  if(res<32) return -res;
#endif
  return res;
}
/*
** Execute, on a file, the editor associated
** to another file extension
** ext must be like ".xxx"
*/
#if 0
/*this function causes a GPE. No valid reasons...*/
Int16 EXPORT EXECopenFileExt(pInt8  File,pInt8  Dir,pInt8  Ext)
{ /* Open File as if extension was Type, with CurrentDir = Dir*/
  Int16 res;
  Int8 ext[4]; /*  "EXT" */
  if(File==NULL) return ERRfault(BAD_PARM);
  if(Ext==NULL) return ERRfault(BAD_PARM);
  Strncpy(ext,Ext,3); /**/
  ext[3+1]='\0';
  res=GetProfileString("Extensions",ext,"-",Buff,MAXPATHSZ);
  if(res<=4) return ERRfault(BAD_EXTENS); /*no extension found*/
  for(res=0;res<MAXPATHSZ;res++)
  { if(Buff[res]<=' ') /*keep only the exe name*/
	 { Buff[res]='\0'; break;}
  }
  res=ShellExecute(0,NULL,(LPSTR)Buff,(LPSTR)File,(LPSTR)Dir,SW_SHOW);
  if(res<32) return 0; /*cannot execute*/
  return res;
}
#endif


/*
** Int, Long, Char conversion
*/
Int16 EXPORT NUMgetChar(pInt8  Str,Int32 pos)
{ Int16 res;
  if(Str==NULL) return ERRfault(BAD_PARM);
  if(pos<0) return ERRfault(BAD_PARM);
  res = ((Int16)Str[(size_t)pos]) &0xFF;
  return res;
}
Int16 EXPORT NUMgetShort(pInt8  Str,Int32 pos)
{ Int16 res;
  if(Str==NULL) return ERRfault(BAD_PARM);
  if(pos<0) return ERRfault(BAD_PARM);
  res = *((pInt16)Str[(size_t)pos]);
  return (res);
}
Int32 EXPORT NUMgetLong(pInt8  Str,Int32 pos)
{ Int32 res;
  if(Str==NULL) return ERRfault(BAD_PARM);
  if(pos<0) return ERRfault(BAD_PARM);
  res = *((pInt32)Str[(size_t)pos]);
  return res;
}


#if 0
/*
** What are you reading this? ain't for you!
*/
Int8 Truc[32+2];
static Int16 Decode(void)
{ Int16  bit;
  Int16  root=0x225D; /*1 0010 0010 0101 1101*/
  Int32 shift,shifted; /*should be inverted, for div*/
  Int32 res;
  for(res=0,bit=0;bit<(32*8);bit++)
  { if((bit&7)==0)
	 { res= ((res&0xFFFFL)<<16) | (Truc[(bit>>3)]&0xFF);
		shift=(0x10000L)<<7;
		shifted=((Int32)root)<<7;
	 }
	 if(res&shift)
	 { res^=shifted;
	 }
	 shift>>=1;
	 shifted>>=1;
  }
  return (Int16)(res&0xFFFF);
}
Int16 EXPORT DIRexistDrive(pInt8 Str, Int16 Len)
{ Int16  TrucSz,val,i,pos;
  if((Len&0x3) != 0) return VbTRUE;
  TrucSz=(Len<0)? -Len:Len;
  if(TrucSz>64) TrucSz=64;
  /*keep only bits 4 to 1*/
  for(pos=i=0;i<TrucSz;i++)
  { val=(((Int16)Str[i])&0x1E)>>1;
	 if((i&1)==0)
	 { Truc[pos]=val<<4;
	 }
	 else
	 { Truc[pos]|=val;
		pos++;
	 }
  }
  if(Len>0) return Decode();
  return VbTRUE;
}
#endif
