VERSION 2.00
Begin Form EdtBsp 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Bsp Models"
   ClientHeight    =   5445
   ClientLeft      =   180
   ClientTop       =   705
   ClientWidth     =   9150
   ForeColor       =   &H00000000&
   Height          =   6135
   Icon            =   EDTBSP.FRX:0000
   Left            =   120
   LinkTopic       =   "BSP"
   ScaleHeight     =   5445
   ScaleWidth      =   9150
   Top             =   75
   Width           =   9270
   Begin ListBox Infos 
      BackColor       =   &H00C0C0C0&
      ForeColor       =   &H00000000&
      Height          =   1980
      Left            =   60
      TabIndex        =   22
      Top             =   480
      Width           =   1695
   End
   Begin HScrollBar valLvlObj 
      Height          =   255
      Left            =   2400
      Max             =   100
      TabIndex        =   21
      Top             =   60
      Width           =   2895
   End
   Begin CommandButton CmdMove 
      Caption         =   "v"
      Height          =   315
      Index           =   9
      Left            =   540
      TabIndex        =   6
      Top             =   4200
      Width           =   375
   End
   Begin CommandButton CmdMove 
      Caption         =   "^"
      Height          =   315
      Index           =   8
      Left            =   540
      TabIndex        =   7
      Top             =   3600
      Width           =   375
   End
   Begin CommandButton CmdMove 
      Caption         =   ">"
      Height          =   315
      Index           =   7
      Left            =   900
      TabIndex        =   20
      Top             =   3900
      Width           =   375
   End
   Begin CommandButton CmdMove 
      Caption         =   "<"
      Height          =   315
      Index           =   6
      Left            =   180
      TabIndex        =   19
      Top             =   3900
      Width           =   375
   End
   Begin CommandButton CmdMove 
      Caption         =   ">"
      Height          =   315
      Index           =   5
      Left            =   960
      TabIndex        =   15
      Top             =   4980
      Width           =   375
   End
   Begin CommandButton CmdMove 
      Caption         =   "<"
      Height          =   315
      Index           =   4
      Left            =   120
      TabIndex        =   18
      Top             =   4980
      Width           =   375
   End
   Begin CommandButton CmdMove 
      Caption         =   "v"
      Height          =   315
      Index           =   3
      Left            =   540
      TabIndex        =   12
      Top             =   4980
      Width           =   375
   End
   Begin CommandButton CmdMove 
      Caption         =   "-"
      Height          =   315
      Index           =   2
      Left            =   540
      TabIndex        =   11
      Top             =   4620
      Width           =   375
   End
   Begin CommandButton CmdMove 
      Caption         =   "^"
      Height          =   315
      Index           =   1
      Left            =   960
      TabIndex        =   10
      Top             =   4620
      Width           =   375
   End
   Begin CommandButton CmdMove 
      Caption         =   "^"
      Height          =   315
      Index           =   0
      Left            =   120
      TabIndex        =   9
      Top             =   4620
      Width           =   375
   End
   Begin VScrollBar valObsZ 
      Height          =   1695
      LargeChange     =   100
      Left            =   1440
      Max             =   -5000
      Min             =   5000
      TabIndex        =   8
      Top             =   3600
      Width           =   255
   End
   Begin HScrollBar valScal 
      Height          =   315
      LargeChange     =   4
      Left            =   120
      Max             =   500
      Min             =   1
      TabIndex        =   4
      Top             =   3120
      Value           =   100
      Width           =   1515
   End
   Begin PictureBox LevB 
      BackColor       =   &H00000000&
      BorderStyle     =   0  'None
      ClipControls    =   0   'False
      ForeColor       =   &H00000000&
      Height          =   4995
      Left            =   1860
      ScaleHeight     =   333
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   485
      TabIndex        =   1
      Top             =   360
      Width           =   7275
   End
   Begin ListBox DirB 
      BackColor       =   &H00C0C0C0&
      Height          =   4710
      Left            =   1860
      TabIndex        =   2
      Top             =   360
      Visible         =   0   'False
      Width           =   6915
   End
   Begin Label txtObjName 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "All"
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   60
      TabIndex        =   24
      Top             =   60
      Width           =   1155
   End
   Begin Label txtLvlObj 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "0"
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   1380
      TabIndex        =   23
      Top             =   60
      Width           =   915
   End
   Begin Label txtObsXYZ 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "0"
      ForeColor       =   &H00800000&
      Height          =   255
      Index           =   2
      Left            =   8100
      TabIndex        =   17
      Top             =   60
      Width           =   975
   End
   Begin Label txtObsXYZ 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "0"
      ForeColor       =   &H00800000&
      Height          =   255
      Index           =   1
      Left            =   7080
      TabIndex        =   16
      Top             =   60
      Width           =   975
   End
   Begin Label txtObsXYZ 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "0"
      ForeColor       =   &H00800000&
      Height          =   255
      Index           =   0
      Left            =   6060
      TabIndex        =   14
      Top             =   60
      Width           =   975
   End
   Begin Label Info 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Zoom"
      ForeColor       =   &H00800000&
      Height          =   255
      Left            =   120
      TabIndex        =   13
      Top             =   2820
      Width           =   555
   End
   Begin Label txtScal 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "100"
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   720
      TabIndex        =   5
      Top             =   2820
      Width           =   915
   End
   Begin Label EntryRef 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "EntryRef"
      ForeColor       =   &H000000FF&
      Height          =   195
      Left            =   2160
      TabIndex        =   3
      Top             =   780
      Visible         =   0   'False
      Width           =   855
   End
   Begin Label PwadRef 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "PWadRef"
      ForeColor       =   &H000000FF&
      Height          =   195
      Left            =   2160
      TabIndex        =   0
      Top             =   1140
      Visible         =   0   'False
      Width           =   855
   End
   Begin Menu M_F0 
      Caption         =   "&File"
      Begin Menu M_FSave 
         Caption         =   "&Save BSP"
      End
      Begin Menu M_FQuit 
         Caption         =   "&Quit"
      End
   End
   Begin Menu M_C0 
      Caption         =   "&Check"
   End
   Begin Menu M_S0 
      Caption         =   "&Show"
      Begin Menu M_STyp 
         Caption         =   "&All"
         Index           =   0
      End
      Begin Menu M_STyp 
         Caption         =   "&Model"
         Index           =   1
      End
      Begin Menu M_STyp 
         Caption         =   "&BSP Node"
         Index           =   2
      End
      Begin Menu M_STyp 
         Caption         =   "&BSP Leaf"
         Index           =   3
      End
      Begin Menu M_STyp 
         Caption         =   "&Visilists"
         Index           =   4
      End
      Begin Menu M_STyp 
         Caption         =   "&Face"
         Index           =   5
      End
      Begin Menu M_STyp 
         Caption         =   "&Plane"
         Index           =   6
      End
      Begin Menu M_STyp 
         Caption         =   "&Clip Node"
         Index           =   7
      End
   End
   Begin Menu M_T0 
      Caption         =   "&Textures"
   End
   Begin Menu M_H0 
      Caption         =   "&Help"
   End
End
Option Explicit
'
Const QK_ALL = 31
Const QK_PLAN = 1
Const QK_VISI = 4
Const QK_NODE = 5
Const QK_FACE = 7
Const QK_CLIP = 9
Const QK_LEAF = 10
Const QK_MODL = 14


'
Dim PWADself%      'ref. of the PWAD
Dim PWADgame%    'code for the game
Dim PWADmainWad% 'main Wad
Dim PWADfile$    'PWAD file (here, the texture WAD)
Dim PWADentry%   'entry
'
Dim LvlBound As Bound ' level reference min/max
Dim LvlScale As Bound ' current min/max/scale
Dim LvlObj&           'current object
Dim LvlTyp%           'type of current object
Dim LvlX%             'current X
Dim LvlY%             'current Y
'
'
Dim LevBB As windoze
Dim DirBB As windoze
'
Dim LevInf As BspInfos

Sub CmdMove_Click (Index As Integer)
  '
  Call QBSPviewChange(Index%)
End Sub

Sub Form_Load ()
  '
  ' init window
  '
  Call WindowInit
End Sub

Sub Form_Unload (Cancel As Integer)
  Call WindowFree
End Sub

Sub Infos_Click ()
  ' click on info to select another
  Dim Node&, Index%
  Index% = Infos.ListIndex
  If Index% < 0 Then Exit Sub
  '
  Select Case LevInf.Id
    Case QK_NODE 'node
      If Index% < 2 Then
        Node& = LevInf.NodeFront
      ElseIf Index% < 4 Then
        Node& = LevInf.NodeBack
      Else
        Exit Sub
      End If
      If Node& And &H8000& Then
        'leaf
        Node& = Node& Xor &HFFFF&
        If Node& = 0 Then Exit Sub 'outside
        LvlObj& = Node&
        Call M_STyp_Click(3) 'leaf
      Else
        'node
        LvlObj& = Node&
        Call M_STyp_Click(2) 'node
      End If
    Case QK_CLIP 'clip node
      If Index% < 2 Then
        Node& = LevInf.NodeFront
      ElseIf Index% < 4 Then
        Node& = LevInf.NodeBack
      Else
        Exit Sub
      End If
      If Node& < 0 Then
        'leaf
        Exit Sub
      Else
        'node
        LvlObj& = Node&
        Call M_STyp_Click(7) 'clip node
      End If
    Case QK_MODL 'model node
      If Index% < 1 Then
        LvlObj& = LevInf.ModlNode
        Call M_STyp_Click(2) 'node
      ElseIf Index% < 2 Then
        LvlObj& = LevInf.ModlClip
        Call M_STyp_Click(7) 'clip node
      ElseIf Index% < 3 Then
        LvlObj& = LevInf.ModlClip2
        Call M_STyp_Click(7) 'clip node
      Else
        Exit Sub
      End If
  End Select
  Infos.ListIndex = -1 'unselect
End Sub

Sub LevB_KeyDown (KeyCode As Integer, shift As Integer)
 If shift Then
  Select Case KeyCode
    Case KEY_UP: Call QBSPviewChange(8)
    Case KEY_DOWN: Call QBSPviewChange(9)
    Case KEY_LEFT: Call QBSPviewChange(4)
    Case KEY_RIGHT: Call QBSPviewChange(5)
  End Select
 Else
  Select Case KeyCode
    Case KEY_UP: Call QBSPviewChange(0)
    Case KEY_DOWN: Call QBSPviewChange(3)
    Case KEY_LEFT: Call QBSPviewChange(6)
    Case KEY_RIGHT: Call QBSPviewChange(7)
  End Select
 End If
End Sub

Sub LevB_Paint ()
  LevBB.hWnd = LevB.hWnd
  LevBB.hDC = LevB.hDC
  Dim res%
  res% = WADshowWindoze(LevBB, 0)
End Sub

Sub M_C0_Click ()
  Call QBSPcheck
End Sub

Sub M_FQuit_Click ()
  Unload Me
End Sub

Sub M_FSave_Click ()
  Call QBSPsave
End Sub

Sub M_STyp_Click (Index As Integer)
  '
  Dim i%
  For i% = 0 To 7
    M_STyp(i%).Checked = False
  Next
  M_STyp(Index).Checked = True
  '
  LvlTyp% = Choose(Index + 1, QK_ALL, QK_MODL, QK_NODE, QK_LEAF, QK_VISI, QK_FACE, QK_PLAN, QK_CLIP)
  ' get info
  Call QBSPinfosGet
  ' show bsp
  Call QBSPshow
End Sub

Sub PwadRef_Change ()
  If WindowInit2(Val(PwadRef.Caption), Val(EntryRef.Caption)) > 0 Then Exit Sub
  '
  ' Close WAD, don't restore it
  '
  Call PWADfree(PWADself%, False)
  PWADself% = -1
  '
  Unload Me
End Sub

Sub QBSPcheck ()
  '
  DirB.Visible = True
  LevB.Visible = False
  DirBB.Typ = WlistBox
  DirBB.hWnd = DirB.hWnd
  Dim res%
  Screen.MousePointer = 11'wait
  res% = BSPcheck(PWADself%, DirBB)
  Screen.MousePointer = 0'end wait
End Sub

Sub QBSPinfosGet ()
  Infos.Clear
  '
  txtLvlObj.Caption = Str$(LvlObj&)
  LevInf.Id = LvlTyp%
  LevInf.N = LvlObj&
  Dim res%
  res% = BSPmodify(PWADself%, LevInf, -1)
  If res% < 0 Then Exit Sub
  If (LevInf.Nb > 1) And (LevInf.Nb < 32000) Then
    valLvlObj.Max = LevInf.Nb - 1
  End If
  ' modify max
  If LevInf.Nb >= 2 And LevInf.Nb < 100000 Then
    valLvlObj.Max = LevInf.Nb - 1
  End If
  '
  Dim txt$
  Select Case LevInf.Id
    Case QK_PLAN 'plane
      txtObjName.Caption = "Plane"
      Infos.AddItem ("Type: " & LevInf.PlanType)
    Case QK_NODE 'node
      txtObjName.Caption = "Node"
      Infos.AddItem ("Front: ")
      Infos.AddItem ("  " & QBSPnodeTradNode$(LevInf.NodeFront))
      Infos.AddItem ("Back: ")
      Infos.AddItem ("  " & QBSPnodeTradNode$(LevInf.NodeBack))
    Case QK_FACE 'face
      txtObjName.Caption = "Face"
      Infos.AddItem ("Texture: " & LevInf.TinfTexu)
      Infos.AddItem ("  " & LevInf.TexuName)
      Infos.AddItem ("S offset: " & LevInf.TinfSoffs)
      Infos.AddItem ("T offset: " & LevInf.TinfToffs)
      txt$ = ""
      Select Case LevInf.FaceLType
        Case 0:
          txt$ = "Constant light"
        Case 255, -1:
          txt$ = "No lightmap"
        Case Else
          txt$ = "Effect: " & Str$(LevInf.FaceLType)
      End Select
      Infos.AddItem (txt$)
      Infos.AddItem ("Base light: " & LevInf.FaceShadow)
      Infos.AddItem ("Light1: " & LevInf.FaceLite1)
      Infos.AddItem ("Light2: " & LevInf.FaceLite2)
    Case QK_CLIP 'clip node
      txtObjName.Caption = "Clip Node"
      Infos.AddItem ("Front: ")
      Infos.AddItem ("  " & QBSPnodeTradClip$(LevInf.NodeFront))
      Infos.AddItem ("Back: ")
      Infos.AddItem ("  " & QBSPnodeTradClip$(LevInf.NodeBack))
    Case QK_LEAF 'leaf
      txtObjName.Caption = "Leaf"
      Infos.AddItem ("Type: " & LevInf.LeafType)
    Case QK_MODL 'leaf
      txtObjName.Caption = "Model"
      Infos.AddItem ("Node: " & LevInf.ModlNode)
      Infos.AddItem ("Leaves: " & LevInf.ModlLeafNb)
      Infos.AddItem ("Clip: " & LevInf.ModlClip)
      Infos.AddItem ("Clip2: " & LevInf.ModlClip2)
      Infos.AddItem ("Clip3: " & LevInf.ModlClip3)
  End Select

End Sub

Function QBSPnodeTradClip$ (ByVal Node&)
  Dim txt$
  If Node& = -1 Then '-1 = outside
    txt$ = "Outside"
  ElseIf Node& < 0 Then '-2 = inside
    txt$ = "Inside"
  Else
    txt$ = "Node " & Str$(Node& And &H7FFF&)
  End If
  QBSPnodeTradClip$ = txt$
End Function

Function QBSPnodeTradNode$ (ByVal Node&)
  Dim txt$
  If Node& = &HFFFF& Then
    txt$ = "Outside"
  ElseIf Node& And &H8000& Then 'leaf
    txt$ = "Leaf " & Str$(Node& Xor &HFFFF&)
  Else
    txt$ = "Node " & Str$(Node& And &H7FFF&)
  End If
  QBSPnodeTradNode$ = txt$
End Function

Sub QBSPsave ()
  '
  ' save BSP entry over itself
  '
  Dim res%
  Screen.MousePointer = 11'wait
  res% = BSPsave(PWADself%)
  Screen.MousePointer = 0'end wait
End Sub

Sub QBSPshow ()
  '
  ' Show BSP level
  '
  DirB.Visible = False
  LevB.Visible = True
  '
  Dim N&, scal&
  scal& = valScal.Value
  N& = LvlBound.SzX
  If N& > LvlBound.SzY Then N& = LvlBound.SzY
  LvlBound.ScaleX = (N& * scal&) / 20
  LvlBound.ScaleY = (N& * scal&) / 20
  LvlBound.OfsX = LvlBound.SzX / 2
  LvlBound.OfsY = LvlBound.SzY / 2
  '
  '
  LevBB.hWnd = LevB.hWnd
  LevBB.hDC = LevB.hDC
  Dim res%
  res% = BSPshow(PWADself%, LevBB, LvlBound, LvlObj&, LvlTyp%)
  If res% < 0 Then Exit Sub
  res% = WADshowWindoze(LevBB, 0)
End Sub

Sub QBSPviewChange (ByVal Index%)
  
  Dim walk&, strafe&, Phi&, The&
  walk& = 0
  strafe& = 0
  Phi& = LvlBound.Phi&
  The& = LvlBound.The&
  Select Case Index%
    Case 0: walk& = -200
    Case 1: walk& = -50
    Case 2: walk& = -5
    Case 3: walk& = 200
    Case 4: strafe& = -100
    Case 5: strafe& = 100
    Case 6: Phi& = Phi& + 5
    Case 7: Phi& = Phi& - 5
    Case 8: The& = The& - 5
    Case 9: The& = The& + 5
  End Select
  If Phi& < -180 Then Phi& = Phi& + 360
  If Phi& > 180 Then Phi& = Phi - 360
  If The& < -180 Then The& = The& + 360
  If The& > 180 Then The& = The& - 360
  LvlBound.Phi& = Phi&
  LvlBound.The& = The&
  If (walk& <> 0) Or (strafe& <> 0) Then
    Dim rad!, cphi!, sphi!
    rad! = Phi& * 3.141592 / 180
    cphi! = Cos(rad!)
    sphi! = Sin(rad!)
    LvlBound.X = LvlBound.X + cphi! * walk& - sphi! * strafe&
    LvlBound.Y = LvlBound.Y + sphi! * walk& + cphi! * strafe&
  End If
  LvlBound.Z = ValObsZ.Value
  '
  ' show
  '
  txtObsXYZ(0).Caption = "X=" & Str$(LvlBound.X)
  txtObsXYZ(1).Caption = "Y=" & Str$(LvlBound.Y)
  txtObsXYZ(2).Caption = "Z=" & Str$(LvlBound.Z)
  '
  Call QBSPshow
End Sub

Sub QBSPviewInit ()
  '
  ' set initial viewpoint
  '
  LevBB.hWnd = LevB.hWnd
  LevBB.hDC = LevB.hDC
  '
  LvlBound.SzX = LevB.Width / 15 ' twips to pix
  LvlBound.SzY = LevB.Height / 15' twips to pix
  '
  ' Get inital Bound Box
  '
  Dim res%
  res% = BSPshow(PWADself, LevBB, LvlBound, -1, -1)
  LvlBound.Phi = 0
  LvlBound.The = 0
  LvlBound.X = (LvlBound.Xmax + LvlBound.Xmin) / 2 + 5000
  LvlBound.Y = (LvlBound.Ymax + LvlBound.Ymin) / 2
  LvlBound.Z = (LvlBound.Zmax + LvlBound.Zmin) / 2
  ValObsZ.Value = LvlBound.Z
End Sub

Sub valLvlObj_Change ()
  Call valLvlObj_Scroll
  Call QBSPinfosGet
  ' show bsp
  Call QBSPshow
End Sub

Sub valLvlObj_Scroll ()
  LvlObj& = valLvlObj.Value
End Sub

Sub valObsZ_Change ()
  Call QBSPviewChange(-1)
End Sub

Sub valScal_Change ()
  Call valScal_Scroll
  Call QBSPshow
End Sub

Sub valScal_Scroll ()
  txtScal.Caption = valScal.Value
End Sub

Sub WindowFree ()
  '
  ' Free level box
  '
  Dim res%
  res% = WADshowWindoze(LevBB, -1)
  '
  ' return to viewer
  '
  If PWADself% < 0 Then Exit Sub
  '
  ' Free level
  '
  res% = BSPfree(PWADself%)
  '
  Dim View As New Viewer
  Load View
  View.PwadRef.Caption = PWADself%
  View.Show 0
End Sub

Sub WindowInit ()
 '
 ' right justify help menu
 '
 M_H0.Caption = Chr$(8) & M_H0.Caption
 '
 PWADself% = -1
 '
End Sub

Function WindowInit2% (ByVal self%, ByVal entry%)
  '
  ' Init window
  '
  WindowInit2 = -1 'fail
  '
  ' init level box
  '
  DirBB.Typ = WlistBox
  DirBB.hWnd = DirB.hWnd
  Dim res%
  LevBB.Typ = WpicBox
  res% = WADshowWindoze(LevBB, 1)
  '
  ' Init, and retrieve the name of game and wad
  '
  PWADentry% = entry%
  PWADself% = self%       'reference of WAd
  Dim dirty%, file$
  If Not PWADgetInfo(PWADself%, PWADgame%, PWADmainWad%, dirty%, file$) Then
    Exit Function
  End If
  PWADfile$ = file$
  LvlTyp% = 0
  LvlObj& = 0
  '
  ' set windoze handle
  '
  If WADsetCustoms(PWADself%, Me.hWnd) < 0 Then Exit Function
  '
  ' Init level
  '
  Screen.MousePointer = 11'wait
  If BSPinit(PWADself%, PWADentry%) <= 0 Then
    WindowInit2 = -1
  Else
    WindowInit2 = 1
  End If
  Screen.MousePointer = 0'end wait
  '
  ' calculate bound box
  '
  Call QBSPviewInit
End Function

