Option Explicit

'
' Use the internal name of libraries, not the external name
' Used LbWintex  not lbwintex.dll
'
'
'WAD editors
'
Dim IWADself% ' IWAD object reference in DLL
Dim IWADdir$  ' IWAD directory (c:\DOOM)
Dim IWADfile$ ' IWAD file (DOOM.WAD)
Dim IWADexe$  ' IWAD executable (DOOM.EXE)
Dim IWADgame% ' Type: &H10=DOOM &H20=HERETIC &H40=HEXEN
              ' +0=regd +1=sharew +2=commercial
'
Dim TWADfile$ ' PWAD to be called by DOOM
'
Dim IWADlock% ' count of PWAD using the IWAD
'
' DeuTex global var
'
'DIRECTORIES
Global DeuTexLastCmd As String   'last executed deutex command line
'
' DeuTex local var
'
Dim DeuTexHandle As Integer   'handle to deutex application

'OPTIONS
Dim DeuTexCommand As String   'base of command line
'


Dim hLibWinTex%
Declare Function LoadLibrary% Lib "Kernel" (ByVal lpLibFileName$)
Declare Sub FreeLibrary Lib "Kernel" (ByVal hLibModule%)



'
'
'
'
' check if a file exists
Declare Function DIRexistFile% Lib "lbwintex.dll" (ByVal filenam$)
' check if a directory exists
Declare Function DIRexistDir% Lib "lbwintex.dll" (ByVal filenam$)
' split a path into: directory, full file name, root file name
' static direc as string * 256 : static  filnam as string * 16 : static root as string * 16
Declare Function DIRsplitDir% Lib "lbwintex.dll" (ByVal direc$, ByVal Path$)
Declare Function DIRsplitFile% Lib "lbwintex.dll" (ByVal filnam$, ByVal Path$)
Declare Function DIRsplitRoot% Lib "lbwintex.dll" (ByVal root$, ByVal Path$)
' make a path, for directory and file name
' static path as string * 256
Declare Function DIRmakePath% Lib "lbwintex.dll" (ByVal Path$, ByVal direc$, ByVal filenam$)
'
'
'
Declare Function EXEChelpViewer% Lib "lbwintex.dll" (ByVal file$, ByVal Code&)
'/* Open a file, using the default Windows viewer associated
'** to the file extension.
'*/
Declare Function EXECopenFile% Lib "lbwintex.dll" (ByVal file$, ByVal Parms$, ByVal direc$)
'/* Open a file, using the default Windows viewer associated
'** to another file extension (provided as 3 char: "TXT")
'*/
'Declare Function EXECopenFileExt% Lib "lbwintex.dll" (ByVal file$, ByVal direc$, ByVal ext$)


Sub DtxEnds ()
  DeuTexHandle = 0  'not running anymore
  Dim file$
  'warnings and errors
  file$ = "error.txt"
  If DIRexistFile(file$) Then
    If FileLen(file$) > 0 Then
      Dim errors$
      Open file$ For Input As #1
      Do
        Line Input #1, errors
        If Left$(errors, 8) = "Error: *" Then
          errors = Mid$(errors, 11, Len(errors) - 13)
          Call Crash(errors)
        ElseIf Left$(errors, 10) = "Warning: *" Then
          errors = Mid$(errors, 12, Len(errors) - 13)
          If MsgBox(errors, 1 + 48, "Warning") = 2 Then Exit Do
        ElseIf Left$(errors, 6) = "Bug: *" Then
          errors = "Please report that bug:" & Chr$(10) & Mid$(errors, 10, Len(errors) - 12)
          If MsgBox(errors, 1 + 48, "DeuTex Bug") = 2 Then Exit Do
        End If
        DoEvents
      Loop While Not EOF(1)
      Close #1
      Kill file$
    End If
  End If
  'output
  file = "output.txt"
  If DIRexistFile(file$) Then
     Dim appli%
     appli% = XternFileEdit(".txt", file$)
     Kill file$
  End If
End Sub

Function DtxIsRunning () As Integer
   DtxIsRunning = False
   If DeuTexHandle <> 0 Then    'handle exists
     If GetModuleUsage(DeuTexHandle) > 0 Then 'program is running
       DtxIsRunning = True
     End If
   End If
End Function

Function DtxRun (ByVal cmd$, ByVal cmdtyp%)
' cmdtype = 0  doomdir, select=all
' returns true if successful
  DtxRun = False
  If DeuTexHandle <> 0 Then
    Call Crash("DeuSF is already running.")
    Exit Function
  End If
  '
  ' base of command line
  '
  Dim exec$
  exec$ = INIgetValue("Extern", "DeuSF")
  If Len(exec$) <= 0 Then exec = "deusf"
  '
  ' indicate main wad
  '
  exec$ = exec$ & " -wtx " & WinTexGetGameIWad()
  '
  ' add actual DeuSF command
  '
  exec$ = exec$ & " " & cmd$
  DeuTexLastCmd = exec$
  If Len(exec$) > 127 Then
    Crash ("The command line of DeuSF is too big for DOS (try using shorter paths).")
    Exit Function
  End If
   'EXECUTE COMMAND
   On Error GoTo nodeusf
   DtxRun = True
   DeuTexHandle = Shell(exec, 7)
   Exit Function
nodeusf:
   DtxRun = False
   Call Crash("Can't send commands to DeuSF.")
   Resume Next
End Function

Sub WinTexExit ()
  'clear entry and texture clipboard
  Dim res%
  res% = WADclipbClear()
  res% = WADTclipbClear()
  'clear main wad
  If IWADself% >= 0 Then
    IWADself% = WADfree(IWADself%, 0) 'exit, ignore
  End If
  'free the DLL
  Call FreeLibrary(hLibWinTex)
End Sub

Function WinTexGameHasIWAD% ()
  ' return tru if game has an IWAD
  WinTexGameHasIWAD% = True
  Select Case IWADgame%
    Case &H10, &H11, &H12'GAM_DOOM
    Case &H20, &H21, &H22'GAM_HTIC
    Case &H40, &H41, &H42'GAM_HEXN
    Case &H80, &H81, &H82'GAM_STRF
    Case Else
      WinTexGameHasIWAD% = False 'no main WAD
  End Select
End Function

Sub WinTexGetColor (R%, G%, B%)
  Dim res$
  R% = 0
  B% = 255
  G% = 255
  res$ = INIgetValue("Transparent", "Red")
  If Len(res$) > 0 Then R% = Val(res$)
  res$ = INIgetValue("Transparent", "Green")
  If Len(res$) > 0 Then G% = Val(res$)
  res$ = INIgetValue("Transparent", "Blue")
  If Len(res$) > 0 Then B% = Val(res$)
End Sub

Function WinTexGetGame% ()
' returns the type of game being used
  WinTexGetGame = IWADgame%
End Function

Function WinTexGetGameExe$ ()
  WinTexGetGameExe$ = IWADexe$
End Function

Function WinTexGetGameIWad$ ()
  WinTexGetGameIWad$ = IWADfile$
End Function

Function WinTexGetGameName$ ()
' returns the name of the game
' return null if illegal name
   Dim nam$
   Select Case IWADgame%
     Case &H10, &H11      'GAM_DOOM
        nam$ = "doom"
     Case &H12            'GAM_DOOM|GAM_CMRC
        nam$ = "doom2"
     Case &H20, &H21, &H22'GAM_HTIC
        nam$ = "heretic"
     Case &H40, &H41, &H42'GAM_HEXN
        nam$ = "hexen"
     Case &H80, &H81, &H82'GAM_STRF
        nam$ = "strife"
     Case GAM_QUAK
        nam$ = "quake"
     Case GAM_DUKE
        nam$ = "duke"
     Case Else
        nam$ = ""
   End Select
   WinTexGetGameName$ = nam$
End Function

Function WinTexGetGameSelf% ()
  WinTexGetGameSelf = IWADself%
End Function

Function WinTexGetHackedProg$ (hackedexe$, ref$)
  '
  ' get name of the exe editor for game
  ' return hackedexe$ = name of the hacked game.exe
  '        ref$ = reference of the prog in INI file
  Dim dheexe$
  dheexe$ = ""
  Select Case IWADgame%
    Case &H10, &H11, &H12'GAM_DOOM doom, doom2
      dheexe$ = "dehacked"
      hackedexe$ = "doomhack.exe"
      ref$ = "DHE"
    Case &H20, &H21, &H22'GAM_HTIC heretic
      dheexe$ = "hhe"
      hackedexe$ = "herehack.exe"
      ref$ = "HHE"
    Case &H40, &H41 'GAM_HEXN
      dheexe$ = "hhe"             'BUG
      hackedexe$ = "hexnhack.exe" 'BUG
      ref$ = "HEXEN"
    Case &H80, &H81'GAME_STRF
      dheexe$ = "sthacked"        'BUG
      hackedexe$ = "strfhack.exe" 'BUG
      ref$ = "STRIFE"
    Case Else
      Call Crash("No EXE editor defined")
  End Select
  WinTexGetHackedProg$ = dheexe$
End Function

Sub WinTexHelp (ByVal key&)
  '
  ' Open help file
  '
  Dim res%
  res% = EXEChelpViewer(app.HelpFile, key&)
End Sub

Sub WinTexInit ()
  '
  'setdefault directory
  '
  Dim default$
  default$ = CurDir$
  '
  ' try to find lbwintex.dll
  '
  hLibWinTex = LoadLibrary(app.Path & "\lbwintex.dll")
  'this is needed, if we want to find lbwintex
  'ChDir (app.Path)
  'ChDrive (app.Path)
  '
  ' set help file
  '
  Dim file$
  file$ = MakeFileName(app.Path, "wintex.hlp")
  If DIRexistFile(file$) Then app.HelpFile = file$
  '
  ' set default dir
  '
  ChooseSetDefault (default$)
  '
  'set INI file
  '
  Call INIinit(MakeFileName(app.Path, "wintex.ini"))
  '
  'clear entry and texture clipboard
  '
  Dim res%
  res% = WADclipbClear()
  res% = WADTclipbClear()
  '
  ' set default game file (IWAD)
  '
  IWADlock = 0  'iwad is not locked
  IWADself = -1  'no main WAD
  DeuTexHandle = 0
  '
  ' set game, according to type
  '

  '
  Dim game$
  game$ = INIgetValue("Settings", "LastGame")
  Call WinTexSetGame(Val(game$))
  '
  ' set temp directory
  '
  Call MakeTempDir("")
  '
  'tutorial mode
  '
  Call TutorInit(0)
  '
  ' warn user the first time wintex is launched
  '
  If INIgetValue("Settings", "Newbie") <> "no" Then
    Load AboutInfo
    AboutInfo.Show 1
    Call INIputValue("Settings", "Newbie", "no", False)
  End If
End Sub

Sub WinTexLockIWAD (ByVal yes%)
  '
  ' maintain a lock count
  '
  If yes% Then
    IWADlock% = IWADlock% + 1
  Else
    IWADlock% = IWADlock% - 1
  End If
End Sub

Sub WinTexSetColor (ByVal R%, ByVal G%, ByVal B%)
  Call INIputValue("Transparent", "Red", Str$(R%), False)
  Call INIputValue("Transparent", "Green", Str$(G%), False)
  Call INIputValue("Transparent", "Blue", Str$(B%), False)
End Sub

Sub WinTexSetGame (ByVal game%)
' set the game used by wintex and declare a new
' IWAD object.
'
' typ = which game
   If IWADlock% > 0 Then
     If Not QueryCancel("There are still " & IWADlock & " editors using the main WAD: changing the main WAD may crash them. Continue?") Then Exit Sub
   End If
   IWADexe$ = ""
   IWADfile$ = ""
   IWADdir$ = ""
   '
   IWADgame% = game% 'DOOM, DOOM2, HERETIC HEXEN STRIFE
   If Not WinTexGameHasIWAD%() Then Exit Sub
   '
   Dim nam$, mainwad$
   nam$ = WinTexGetGameName()
   If nam$ = "" Then Exit Sub
   ' Find the main WAD file
   '  look in the INI file, section [Directory]
   mainwad$ = INIgetValue("MainWad", nam$)
   If Not DIRexistFile(mainwad$) Then
     ' find the directory of the main WAD
     mainwad$ = INIgetValue("Directory", nam$)
     If Not DIRexistDir(mainwad$) Then
       '  look for the environement variable xxxWADDIR
       mainwad$ = Environ$(Left$(nam$, 4) & "WADDIR")
       If mainwad$ = "" Then mainwad$ = "."
     End If
     'build a main WAD
     mainwad$ = MakeFileName(mainwad$, nam$ & ".wad")
     If Not DIRexistFile(mainwad$) Then
       '  Prompt the user
       mainwad$ = ChooseFile(mainwad$, "*.wad", True, "Please select the main WAD file of " & nam$)
       If Not DIRexistFile(mainwad$) Then
         IWADgame% = -1 'no game
         Exit Sub
       End If
     End If
   End If
   '
   IWADfile$ = mainwad$
   IWADdir$ = FilePath(mainwad$)
   IWADexe$ = MakeFileName(IWADdir$, nam$ & ".exe")
   '
   ' Save the name of the game directory, and last game used.
   '
   Call INIputValue("Settings", "LastGame", Str$(IWADgame%), False)
   Call INIputValue("MainWad", nam$, IWADfile$, False)
   'Call INIputValue("Directory", nam$, IWADdir$, False)
   '
   ' Free previous IWAD
   '
   If IWADself% >= 0 Then IWADself% = WADfree(IWADself%, 0) 'ignore
   '
   Dim R%, G%, B%
   Call WinTexGetColor(R%, G%, B%)
   '
   ' Init IWAD, no main WAD
   '
   IWADself% = WADinit(IWADfile$, -1, 1, RGB(R%, G%, B%)) 'write locked
   If IWADself% < 0 Then IWADself% = -1
End Sub

