VERSION 2.00
Begin Form WinTex 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "WinTex"
   ClientHeight    =   5700
   ClientLeft      =   570
   ClientTop       =   1320
   ClientWidth     =   8730
   ClipControls    =   0   'False
   Height          =   6390
   HelpContextID   =   1
   Icon            =   WINTEX.FRX:0000
   Left            =   510
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   5700
   ScaleWidth      =   8730
   Top             =   690
   Width           =   8850
   Begin Frame Frm 
      BackColor       =   &H00C0C0C0&
      Caption         =   "PWAD to examine or modify"
      ForeColor       =   &H00000000&
      Height          =   2775
      Index           =   2
      Left            =   2160
      TabIndex        =   26
      Top             =   2880
      Width           =   4215
      Begin DriveListBox DTxTDriv 
         BackColor       =   &H00C0C0C0&
         Height          =   315
         HelpContextID   =   200
         Left            =   2040
         TabIndex        =   12
         TabStop         =   0   'False
         Top             =   2400
         Width           =   2055
      End
      Begin DirListBox DTxTDir 
         BackColor       =   &H00C0C0C0&
         Height          =   2055
         HelpContextID   =   200
         Left            =   2040
         TabIndex        =   28
         TabStop         =   0   'False
         Top             =   300
         Width           =   2055
      End
      Begin FileListBox DTxTWad 
         BackColor       =   &H00C0C0C0&
         Height          =   2370
         HelpContextID   =   200
         Left            =   120
         Pattern         =   "*.wad;*.grp;*.pak"
         TabIndex        =   27
         TabStop         =   0   'False
         Top             =   300
         Width           =   1815
      End
   End
   Begin Frame Frm 
      BackColor       =   &H00C0C0C0&
      Caption         =   "PWAD to join"
      ForeColor       =   &H00000000&
      Height          =   1575
      Index           =   1
      Left            =   2160
      TabIndex        =   22
      Top             =   1200
      Width           =   4215
      Begin DriveListBox DTxSDriv 
         BackColor       =   &H00C0C0C0&
         Height          =   315
         HelpContextID   =   200
         Left            =   2040
         TabIndex        =   25
         TabStop         =   0   'False
         Top             =   1200
         Width           =   2055
      End
      Begin DirListBox DTxSDir 
         BackColor       =   &H00C0C0C0&
         Height          =   930
         HelpContextID   =   200
         Left            =   2040
         TabIndex        =   24
         TabStop         =   0   'False
         Top             =   240
         Width           =   2055
      End
      Begin FileListBox DTxSWad 
         BackColor       =   &H00C0C0C0&
         Height          =   1200
         HelpContextID   =   200
         Left            =   120
         Pattern         =   "*.wad"
         TabIndex        =   23
         TabStop         =   0   'False
         Top             =   300
         Width           =   1815
      End
   End
   Begin Frame Frm 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Current Game"
      ForeColor       =   &H00000000&
      Height          =   975
      Index           =   0
      Left            =   2160
      TabIndex        =   16
      Top             =   120
      Width           =   4215
      Begin CommandButton GameTyp 
         Caption         =   "Strife"
         Height          =   315
         Index           =   5
         Left            =   3360
         TabIndex        =   13
         Top             =   540
         Width           =   735
      End
      Begin CommandButton GameTyp 
         Caption         =   "Quake"
         Height          =   315
         Index           =   0
         Left            =   3360
         TabIndex        =   29
         Top             =   180
         Width           =   735
      End
      Begin CommandButton GameTyp 
         Caption         =   "Hexen"
         Height          =   315
         Index           =   4
         Left            =   2520
         TabIndex        =   21
         Top             =   540
         Width           =   735
      End
      Begin CommandButton GameTyp 
         Caption         =   "Heretic"
         Height          =   315
         Index           =   3
         Left            =   1680
         TabIndex        =   20
         Top             =   540
         Width           =   735
      End
      Begin CommandButton GameTyp 
         Caption         =   "Doom2"
         Height          =   315
         Index           =   2
         Left            =   2520
         TabIndex        =   19
         Top             =   180
         Width           =   735
      End
      Begin CommandButton GameTyp 
         Caption         =   "Doom"
         Height          =   315
         Index           =   1
         Left            =   1680
         TabIndex        =   18
         Top             =   180
         Width           =   735
      End
      Begin Label GameName 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "-"
         ForeColor       =   &H00000000&
         Height          =   315
         Left            =   120
         TabIndex        =   17
         Top             =   420
         Width           =   1455
      End
   End
   Begin CommandButton Cmd 
      Caption         =   "Edit PWAD"
      Height          =   375
      HelpContextID   =   500
      Index           =   2
      Left            =   240
      TabIndex        =   0
      Top             =   3960
      Width           =   1455
   End
   Begin CommandButton Cmd 
      Caption         =   "Add all Flats"
      Height          =   375
      HelpContextID   =   300
      Index           =   9
      Left            =   6780
      TabIndex        =   6
      Top             =   4620
      Width           =   1515
   End
   Begin CommandButton Cmd 
      Caption         =   "Restore PWAD"
      Height          =   375
      HelpContextID   =   300
      Index           =   7
      Left            =   6780
      TabIndex        =   7
      Top             =   5160
      Width           =   1515
   End
   Begin CommandButton Cmd 
      Caption         =   "Check PWAD"
      Height          =   375
      HelpContextID   =   800
      Index           =   6
      Left            =   240
      TabIndex        =   11
      Top             =   4620
      Width           =   1455
   End
   Begin CommandButton Cmd 
      Caption         =   "Merge in IWAD"
      Height          =   375
      HelpContextID   =   400
      Index           =   1
      Left            =   6780
      TabIndex        =   3
      Top             =   1140
      Width           =   1515
   End
   Begin CommandButton Cmd 
      Caption         =   "Restore IWAD"
      Height          =   375
      HelpContextID   =   400
      Index           =   0
      Left            =   6780
      TabIndex        =   2
      Top             =   120
      Width           =   1515
   End
   Begin CommandButton Cmd 
      Caption         =   "Add all Sprites"
      Height          =   375
      HelpContextID   =   300
      Index           =   10
      Left            =   6780
      TabIndex        =   5
      Top             =   4020
      Width           =   1515
   End
   Begin CommandButton Cmd 
      Caption         =   "Join PWADs"
      Height          =   375
      HelpContextID   =   300
      Index           =   8
      Left            =   6780
      TabIndex        =   4
      Top             =   2700
      Width           =   1515
   End
   Begin Timer DeuTexTime 
      Enabled         =   0   'False
      Left            =   780
      Top             =   2520
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   14
      X1              =   6480
      X2              =   6660
      Y1              =   4800
      Y2              =   4845
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   10
      X1              =   6660
      X2              =   6480
      Y1              =   4140
      Y2              =   4200
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   5
      X1              =   6480
      X2              =   6660
      Y1              =   4200
      Y2              =   4245
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   8
      X1              =   2220
      X2              =   1620
      Y1              =   4140
      Y2              =   4140
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   18
      X1              =   2220
      X2              =   1620
      Y1              =   4800
      Y2              =   4800
   End
   Begin Label Info 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Completion of WADs"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00800000&
      Height          =   495
      Index           =   6
      Left            =   6900
      TabIndex        =   15
      Top             =   3420
      Width           =   1275
   End
   Begin Label Info 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Examine and Modify WADs"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00800000&
      Height          =   495
      Index           =   4
      Left            =   360
      TabIndex        =   14
      Top             =   3060
      Width           =   1455
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   4
      X1              =   6300
      X2              =   7080
      Y1              =   900
      Y2              =   900
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   17
      X1              =   6300
      X2              =   7380
      Y1              =   360
      Y2              =   360
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   11
      X1              =   6660
      X2              =   6480
      Y1              =   4740
      Y2              =   4800
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   7
      X1              =   8460
      X2              =   6300
      Y1              =   4200
      Y2              =   4200
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   3
      X1              =   8460
      X2              =   8460
      Y1              =   4800
      Y2              =   660
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   2
      X1              =   8460
      X2              =   6300
      Y1              =   4800
      Y2              =   4800
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   6
      X1              =   6300
      X2              =   7080
      Y1              =   2460
      Y2              =   2460
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   1
      X1              =   6300
      X2              =   7080
      Y1              =   1740
      Y2              =   1740
   End
   Begin Label Info 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Combine WADs"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00800000&
      Height          =   435
      Index           =   5
      Left            =   6960
      TabIndex        =   10
      Top             =   1860
      Width           =   1275
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   16
      X1              =   6660
      X2              =   6480
      Y1              =   840
      Y2              =   900
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   13
      X1              =   7080
      X2              =   6300
      Y1              =   5340
      Y2              =   5340
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   12
      X1              =   6660
      X2              =   6480
      Y1              =   3240
      Y2              =   3300
   End
   Begin Label Info 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "by"
      ForeColor       =   &H00800000&
      Height          =   255
      Index           =   2
      Left            =   420
      TabIndex        =   8
      Top             =   720
      Width           =   315
   End
   Begin Label Info 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "WinTex 4.4"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   13.5
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00800000&
      Height          =   375
      Index           =   0
      Left            =   180
      TabIndex        =   9
      Top             =   120
      Width           =   1875
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   34
      X1              =   6480
      X2              =   6660
      Y1              =   3300
      Y2              =   3345
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   33
      X1              =   7080
      X2              =   7080
      Y1              =   2460
      Y2              =   3300
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   29
      X1              =   6660
      X2              =   6480
      Y1              =   945
      Y2              =   900
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   22
      X1              =   7080
      X2              =   6300
      Y1              =   3300
      Y2              =   3300
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   9
      X1              =   6300
      X2              =   8460
      Y1              =   660
      Y2              =   660
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   0
      X1              =   7080
      X2              =   7080
      Y1              =   900
      Y2              =   1740
   End
   Begin Image Sleep 
      BorderStyle     =   1  'Fixed Single
      Height          =   510
      Index           =   0
      Left            =   960
      Picture         =   WINTEX.FRX:0302
      Top             =   600
      Width           =   510
   End
   Begin Label DeuTexRun 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "DeuSF at work!"
      ForeColor       =   &H00000080&
      Height          =   255
      Left            =   300
      TabIndex        =   1
      Top             =   1380
      Visible         =   0   'False
      Width           =   1515
   End
   Begin Menu M_F0 
      Caption         =   "&File"
      Begin Menu M_Fnew 
         Caption         =   "&New WAD"
      End
      Begin Menu M_Fopen 
         Caption         =   "&Open WAD"
      End
      Begin Menu M_Fclean 
         Caption         =   "&Clean WAD"
      End
      Begin Menu M_F1 
         Caption         =   "-"
      End
      Begin Menu M_FopenG 
         Caption         =   "Open &GRP"
      End
      Begin Menu M_FopenP 
         Caption         =   "Open &PAK"
      End
      Begin Menu M_F2 
         Caption         =   "-"
      End
      Begin Menu M_ini 
         Caption         =   "&Edit wintex.ini"
         HelpContextID   =   11
      End
      Begin Menu M_Deutex 
         Caption         =   "DeuSF command"
      End
      Begin Menu M_F3 
         Caption         =   "-"
      End
      Begin Menu M_Quit 
         Caption         =   "&Quit"
      End
   End
   Begin Menu M_M0 
      Caption         =   "&Merge"
      HelpContextID   =   1300
      Begin Menu M_Merge 
         Caption         =   "&Merge PWAD into main WAD"
      End
      Begin Menu M_M1 
         Caption         =   "-"
      End
      Begin Menu M_Join 
         Caption         =   "&Join two PWADs"
      End
      Begin Menu M_M2 
         Caption         =   "-"
      End
      Begin Menu M_AppS 
         Caption         =   "Add all &Sprites in PWAD"
      End
      Begin Menu M_AppF 
         Caption         =   "Add all &Flats in PWAD"
      End
      Begin Menu M_App 
         Caption         =   "&Add all Sprites&&Flats"
      End
   End
   Begin Menu M_R0 
      Caption         =   "&Restore"
      Begin Menu M_RestoreI 
         Caption         =   "&Restore main WAD"
      End
      Begin Menu M_R1 
         Caption         =   "-"
      End
      Begin Menu M_RestoreP 
         Caption         =   "Restore &PWAD"
      End
   End
   Begin Menu M_O0 
      Caption         =   "&Options"
      Begin Menu M_OT0 
         Caption         =   "&Transparent color"
         Begin Menu M_OTCol 
            Caption         =   "&Cyan"
            Index           =   0
         End
         Begin Menu M_OTCol 
            Caption         =   "&Black"
            Index           =   1
         End
         Begin Menu M_OTCol 
            Caption         =   "&Grey"
            Index           =   2
         End
         Begin Menu M_OTCol 
            Caption         =   "&Custom"
            Index           =   3
         End
      End
      Begin Menu M_Otmp 
         Caption         =   "Temp. &Directory"
      End
   End
   Begin Menu M_H0 
      Caption         =   "&Help"
      Begin Menu M_About 
         Caption         =   "&About"
      End
      Begin Menu M_H1 
         Caption         =   "-"
      End
      Begin Menu M_Help 
         Caption         =   "&Contents"
      End
      Begin Menu M_Helpnh 
         Caption         =   "&Using Help"
      End
      Begin Menu M_Hreg 
         Caption         =   "&Registering"
      End
      Begin Menu M_H2 
         Caption         =   "-"
      End
      Begin Menu M_Hedt 
         Caption         =   "&Edit a WAD"
      End
      Begin Menu M_Hmerg 
         Caption         =   "&Combine WADs"
      End
      Begin Menu M_Hrest 
         Caption         =   "&Modify Games"
      End
      Begin Menu M_H3 
         Caption         =   "-"
      End
      Begin Menu M_Tutor 
         Caption         =   "&Tutorial mode"
      End
   End
End
Option Explicit
Dim WinTexRunning%
Dim WinTexCmd$  ' command line

Dim DeuTexTWad  As String      'target pwad
Dim DeuTexSWad  As String      'source pwad
Dim DehackPatch As String     'dehacked patch

Sub Cmd_click (Index As Integer)
  Select Case Index
    Case 0
      Call M_RestoreI_Click
    Case 1 'merge
      If Not Tutor(2, "merge the WAD " & DeuTexTWad$ & " into the main WAD." & Chr$(10) & "This modification is reversible.") Then Exit Sub
      If Not DIRexistFile(DeuTexSWad$) Then Exit Sub
      Call DeuTex(DeuTexSWad$, "-merg " & DeuTexSWad$, 0)
    Case 2 'edit PWAD
      If Not Tutor(1, "let you edit the WAD " & DeuTexTWad$ & "." & Chr$(10) & "The modifications can be canceled if needed.") Then Exit Sub
      Call InvoqueViewer(DeuTexTWad)
    Case 6
      Dim file$
      file = DeuTexTWad
      If Not Tutor(0, "checks the WAD " & file$ & ".") Then Exit Sub
      Call DeuTex(file$, "-check " & file$, 0)
    Case 7
      Call M_RestoreP_Click
    Case 8 'join
      If Not Tutor(1, "join the WAD " & DeuTexTWad$ & " and the WAD " & DeuTexSWad$ & "." & Chr$(10) & "This is recommended if both WADs contain redefined Textures, Sprites, or Floors.") Then Exit Sub
      If Not DIRexistFile(DeuTexSWad$) Then Exit Sub
      Call DeuTex(DeuTexTWad$, "-join " & DeuTexTWad$ & " " & DeuTexSWad$, 0)
    Case 9  'af
      Call Infos("This function is obsolete. You don't need it (unless your flat list doesn't end with S_END)")
      If Not Tutor(1, "add all missing flats to the WAD " & DeuTexTWad$ & ".") Then Exit Sub
      Call DeuTex(DeuTexTWad$, "-af " & DeuTexTWad$, 0)'no flats
    Case 10 'as
      If Not Tutor(1, "add all missing sprites to the WAD " & DeuTexTWad$ & "." & Chr$(10) & "This is needed if the WAD contains redefined Sprites.") Then Exit Sub
      Call DeuTex(DeuTexTWad$, "-as " & DeuTexTWad$, 0)'no flats
  End Select
End Sub

Sub DeuTex (file$, cmd$, ByVal cmdtyp%)
 ' call DeuTex
 ' beware that command lines above 128 char will crash SHELL
 ' cmdtyp = see DtxRun
 If file$ <> "@" Then  'ignore "@"
    If Not DIRexistFile(file$) Then  'checks
      Call Crash("No WAD to modify")
      Exit Sub
    End If
  End If
  If DtxRun(cmd$, cmdtyp%) Then Call DeuTexRunning(True)
End Sub

Sub DeuTexEnds ()
  Call DeuTexRunning(False)
  Call DtxEnds
  DTxSDir.Refresh
  DTxSWad.Refresh
End Sub

Sub DeuTexRunning (ByVal yes%)
  If yes% Then
    DeuTexRun.Visible = False
    DeuTexTime.Interval = 250 '1/4 second
    DeuTexTime.Enabled = True
  Else
    DeuTexTime.Enabled = False
    DeuTexRun.Visible = False
  End If
End Sub

Sub DeuTexTime_Timer ()
   If DtxIsRunning() Then  'DeuTex is still running
     DeuTexRun.Visible = Not (DeuTexRun.Visible)
   Else                  'DeuTex ended
     Call DeuTexEnds
   End If
End Sub

Sub DTxSDir_Change ()
  Dim file$
  file$ = DTxSDir.Path
  DTxSWad.Path = file$
  If DTxSWad.ListCount > 0 Then DTxSWad.ListIndex = 0
  DTxSDriv.Drive = Left$(file$, 1)
End Sub

Sub DTxSDriv_Change ()
    Dim old$
    old$ = DTxSDir.Path
    On Error GoTo DrivS
    DTxSDir.Path = DTxSDriv.Drive
    Exit Sub
DrivS:
    DTxSDir.Path = old$
    Resume Next
End Sub

Sub DTxSWad_Click ()
  If DTxSWad.ListCount < 0 Then Exit Sub
  If DTxSWad.ListIndex < 0 Then Exit Sub
  Dim file$
  file$ = MakeFileName(DTxSWad.Path, DTxSWad.FileName)
  If DIRexistFile(file$) Then
    DeuTexSWad = file$
  End If
End Sub

Sub DTxSWad_KeyDown (KeyCode As Integer, Shift As Integer)
  If DTxSWad.ListIndex < 0 Then Exit Sub
  If DTxSWad.ListCount <= 0 Then Exit Sub
  If KeyCode = KEY_DELETE Then
    Dim file$
    file = MakeFileName(DTxSWad.Path, DTxSWad.List(DTxSWad.ListIndex))
    FileDeleteOk (file$)
    DTxSWad.Refresh
  End If
End Sub

Sub DTxTDir_Change ()
  Dim file$
  file$ = DTxTDir.Path
  DTxTWad.Path = file$
  Call ChooseSetDefault(file$)
  If DTxTWad.ListCount > 0 Then DTxTWad.ListIndex = 0
  On Error Resume Next
  DTxTDriv.Drive = Left$(file$, 1)
End Sub

Sub DTxTDriv_Change ()
    Dim old$
    old$ = DTxTDir.Path
    On Error GoTo DrivT
    DTxTDir.Path = DTxTDriv.Drive
    Exit Sub
DrivT:
    DTxTDir.Path = old$
    Resume Next
End Sub

Sub DTxTWad_Click ()
  If DTxTWad.ListCount <= 0 Then Exit Sub
  If DTxTWad.ListIndex < 0 Then Exit Sub
  Dim file$
  file$ = MakeFileName(DTxTWad.Path, DTxTWad.FileName)
  If DIRexistFile(file$) Then
    DeuTexTWad = file$
  End If
End Sub

Sub DTxTWad_DblClick ()
  Call Cmd_click(2)  'edit pwad
End Sub

Sub DTxTWad_KeyDown (KeyCode As Integer, Shift As Integer)
  If DTxTWad.ListIndex < 0 Then Exit Sub
  If DTxTWad.ListCount <= 0 Then Exit Sub
  If KeyCode = KEY_DELETE Then
    Dim file$
    file$ = MakeFileName(DTxTWad.Path, DTxTWad.FileName)
    FileDeleteOk (file$)
    DTxTWad.Refresh
  End If
End Sub

Sub Form_Activate ()
  Call WindowRefresh
End Sub

Sub Form_Load ()
  Call WindowInit
  
End Sub

Sub Form_Unload (Cancel As Integer)
  Call WindowFree
End Sub

Sub GameSet (ByVal Index%)
  Dim game%
  Select Case Index%
    Case 0  'quake
      game% = GAM_QUAK
    Case 1  'doom
      game% = &H11  'GAM_DOOM
    Case 2  'doom2
      game% = &H12  'GAM_DOOM|GAM_CMRC
    Case 3  'heretic
      game% = &H21  'GAM_HTIC
    Case 4  'heretic2
      game% = &H42  'GAM_HEXN|GAM_CMRC
    Case 5  'strife
      game% = &H80  'GAM_STRF
    Case Else 'no game files
      Exit Sub
  End Select
  Call WinTexSetGame(game%)
End Sub

Sub GameShow ()
  ' show the name of the current game
  Dim txt$, color%
  txt$ = WinTexGetGameName()
  color% = &H0 'black
  If txt$ = "" Then
    txt$ = "Select a game"
    color% = &HFF 'red
  End If
  GameName.Caption = txt$
  GameName.ForeColor = color%
End Sub

Sub GameTyp_Click (Index As Integer)
  Call GameSet(Index%)
  Call GameShow
End Sub

Sub InvoqueViewer (ByVal file$)
' Load a viewer form and let it grab the focus
 'load WAD, directory and colors
 Screen.MousePointer = 11 'wait
 Dim View As New Viewer
 Load View
 '
 ' intitialise the WAD form
 '
 View.Show 0
 View.PwadFile.Caption = file$ 'wad to edit
 Screen.MousePointer = 0' end wait
 '
 ' check if intialisation was correct
 '  NO: it reloads View, and bugs!
 'If View.PwadFile.Caption = "" Then Exit Sub
End Sub

Sub M_About_Click ()
  Load AboutInfo
  AboutInfo.Show 1
  Unload AboutInfo
End Sub

Sub M_App_Click ()
  Dim file$
  file = DeuTexTWad
  If Not Tutor(1, "append all the sprites and flats to the WAD [" & file$ & "].") Then Exit Sub
  Call DeuTex(file$, "-app " & file$, 0)
End Sub

Sub M_AppF_Click ()
  Dim file$
  file$ = ChooseFile(DeuTexTWad$, "*.wad", True, "Select a WAD to complete with flats.")
  If file$ = "" Then Exit Sub
  DeuTexTWad = file$
  Call Cmd_click(9) 'af
End Sub

Sub M_AppS_Click ()
  Dim file$
  file$ = ChooseFile(DeuTexTWad$, "*.wad", True, "Select a WAD to complete with sprites.")
  If file$ = "" Then Exit Sub
  DeuTexTWad = file$
  Call Cmd_click(10) 'as
End Sub

Sub M_Deutex_Click ()
  If Not Tutor(0, "display the last command sent to DeuSF.") Then Exit Sub
  Call Infos("Last DeuSF Command: " & Chr$(10) & DeuTexLastCmd)
End Sub

Sub M_Fclean_Click ()
 If Not Tutor(2, "cleanup a WAD, removing all wasted space.") Then Exit Sub
 Dim file$
 file$ = ChooseFile("", "*.wad", True, "Select a WAD to be cleaned")
 If file$ = "" Then Exit Sub'cancel
 Call XternCleanWAD(file$)
End Sub

Sub M_Fnew_Click ()
 If Not Tutor(0, "create a new WAD that you can edit") Then Exit Sub
 Dim file$
 file$ = ChooseFile("default.wad", "*.wad", False, "Select a name for a new WAD")
 If file$ = "" Then Exit Sub
 Call InvoqueViewer(file$)
End Sub

Sub M_Fopen_Click ()
 If Not Tutor(0, "open a WAD for editing") Then Exit Sub
 Dim file$
 file$ = ChooseFile("", "*.wad", True, "Select a WAD to open")
 If file$ = "" Then Exit Sub'cancel
 Call InvoqueViewer(file$)
End Sub

Sub M_FopenG_Click ()
 If Not Tutor(0, "open a GRP file, for viewing") Then Exit Sub
 Dim file$
 '
 ' get old file name
 '
 file$ = INIgetValue("Directory", "LastGRP")
 file$ = ChooseFile(file$, "*.grp", True, "Select a GRP file to open")
 If file$ = "" Then Exit Sub'cancel
 '
 ' put new file name
 '
 Call INIputValue("Directory", "LastGRP", file$, False)
 Call InvoqueViewer(file$)
End Sub

Sub M_FopenP_Click ()
 If Not Tutor(0, "open a PACK file, for viewing") Then Exit Sub
 Dim file$
 '
 ' get old file name
 '
 Call Infos("Warning: Quake support is very limited. The code isn't complete yet.")
 '
 file$ = INIgetValue("Directory", "LastPACK")
 file$ = ChooseFile(file$, "*.pak", True, "Select a PACK file to open")
 If file$ = "" Then Exit Sub'cancel
 '
 ' put new file name
 '
 Call INIputValue("Directory", "LastPACK", file$, False)
 Call InvoqueViewer(file$)
End Sub

Sub M_Hedt_Click ()
  Call WinTexHelp(500)  'E_EDT
End Sub

Sub M_Help_Click ()
  Call WinTexHelp(-1)
End Sub

Sub M_Helpnh_Click ()
   Call WinTexHelp(-3)
End Sub

Sub M_Hmerg_Click ()
  Call WinTexHelp(300)  'C_COMBINE
End Sub

Sub M_Hreg_Click ()
  Call WinTexHelp(20) 'REGISTER
End Sub

Sub M_Hrest_Click ()
  Call WinTexHelp(400)  'M_MERGE
End Sub

Sub M_ini_Click ()
  If Not Tutor(1, "edit the WINTEX.INI file, so that you can modify the command lines of external tools.") Then Exit Sub
  Call INIedit
End Sub

Sub M_Join_Click ()
  Dim file$
  file = DeuTexTWad
  Dim filein$
  filein = DeuTexSWad
  If Not Tutor(1, "join the WAD " & filein$ & " and the WAD " & file$ & ".") Then Exit Sub
  If Not DIRexistFile(filein$) Then
    Call Crash("No WAD to join")
    Exit Sub
  End If
  Call DeuTex(file$, "-join " & file$ & " " & filein$, 0)
End Sub

Sub M_Merge_Click ()
  Dim file$
  file$ = ChooseFile(DeuTexTWad$, "*.wad", True, "Select a WAD to put into your main WAD.")
  If file$ = "" Then Exit Sub
  DeuTexSWad = file$
  Call Cmd_click(1) 'merge
  Call Infos("Don't forget to restore your main WAD once you've finished playing")
End Sub

Sub M_OTCol_Click (Index As Integer)
   If Not Tutor(2, "select a transparent color. All the picture parts of *exactly* that color will be considered as transparent.") Then Exit Sub
   Select Case Index
     Case 0
       Call WinTexSetColor(0, 255, 255)
     Case 1
       Call WinTexSetColor(0, 0, 0)
     Case 2
       Call WinTexSetColor(192, 192, 192)
     Case 3
       Load Transp
       Transp.Show 1
       Unload Transp
   End Select
   Dim i%
   For i% = 0 To 3
      M_OTCol(i%).Checked = False
   Next i%
   M_OTCol(Index).Checked = True
End Sub

Sub M_Otmp_Click ()
   Dim direc$
   direc$ = ChooseDir(direc$, "Please select a directory for all temporary files")
   Call MakeTempDir(direc$)
End Sub

Sub M_Quit_Click ()
  Unload Me
  End
End Sub

Sub M_RestoreI_Click ()
  If Not Tutor(2, "restore the main WAD file.") Then Exit Sub
  Dim file$
  file$ = WinTexGetGameIWad()
  Dim res%
  res% = WADrestore(file$, 1)'safe
  If res% < 0 Then
    Call Crash("Could not restore main WAD. The restoration info could not be located.")
  ElseIf res% = 0 Then
    Call Crash("Restoration was not needed")
  Else
    Call Infos("The main WAD was successfully restored.")
  End If
End Sub

Sub M_RestoreP_Click ()
  Dim file$
  file = DeuTexTWad
  If Not Tutor(1, "restore the WAD " & file$ & " to it's previous state.") Then Exit Sub
'    Restore a WAD file
'    whose directory was modified
  Dim res%
  res% = WADrestore(file$, 1)
  '
  ' if it was a wintex modification, warn the user
  '
  If res% = 0 Then
    If Not QueryCancel("Warning:" & Chr$(10) & "You last modifications will be discarded, and lost definitively.") Then Exit Sub
    res% = WADrestore(file$, 0)
  End If

  If res% < 0 Then
    Call Crash("Could not restore WAD. No restoration information")
  ElseIf res% = 0 Then
    Call Crash("Restoration was not needed")
  Else
    Call Infos("The WAD " & file$ & " was successfully restored.")
  End If
End Sub

Sub M_Tutor_Click ()
   Call TutorInit(1)
End Sub

Sub Sleep_Click (Index As Integer)
  Call M_About_Click
End Sub

Sub WindowFree ()
  '
  ' check wintex is actually running
  '
  If Not WinTexRunning% Then Exit Sub
  '
  Call INIputValue("Directory", "WadSource", DTxSDir.Path, False)
  Call INIputValue("Directory", "WadTarget", DTxTDir.Path, False)
  '
  ' Exit from WinTex
  '
  Call WinTexExit

End Sub

Sub WindowInit ()
  '
  ' Init WinTex
  '
  WinTexRunning% = True
  'change dir to deutex directory, for DLLs
  Call WinTexInit
  ' right justify help menu
  M_H0.Caption = Chr$(8) & M_H0.Caption
  '
  ' Init Form
  '
  DeuTexTime.Enabled = False
  DeuTexSWad = ""       'source pwad
  Dim res$
  res$ = INIgetValue("Directory", "WadSource")
  If Not DIRexistDir(res$) Then res$ = "."
  DTxSDir.Path = res$
  DeuTexTWad = ""       'target pwad
  res$ = INIgetValue("Directory", "WadTarget")
  If Not DIRexistDir(res$) Then res$ = "."
  DTxTDir.Path = res$
  '
  WinTexCmd$ = Trim$(Command$)
  If WinTexCmd$ <> "" Then
    Dim i%
    i% = InStr(WinTexCmd$, " ")
    If i% > 1 Then WinTexCmd$ = Left$(WinTexCmd$, i% - 1)
  End If
End Sub

Sub WindowRefresh ()
  DoEvents
  DTxTDir.Refresh
  DTxTWad.Refresh
  DTxSDir.Refresh
  DTxSWad.Refresh
  Call GameShow
  '
  ' start a PWAD
  '
  If WinTexCmd$ <> "" Then
    If DIRexistFile(WinTexCmd$) Then
      Call InvoqueViewer(WinTexCmd$)
      WinTexCmd$ = ""
    End If
  End If
End Sub

