Option Explicit

Sub CmdEditor (cmd$, ByVal pwad$, ByVal texwd$, ByVal level$)
  '
  ' launch level editor
  '
  Dim Iwad$
  Iwad$ = WinTexGetGameIWad()
  Dim game$, waded$, edmap$
  '
  ' edmap hack
  '
  If level$ Like "MAP??" Then
    edmap$ = "/M:" & Mid$(level$, 3 + 1)
  ElseIf level$ Like "E?M?" Then
    edmap$ = "/M:" & level$
  End If
  '
  ' waded hack
  '
  game$ = UCase$(WinTexGetGameName$())
  Select Case WinTexGetGame()
   Case &H10, &H11 'GAM_DOOM
     waded$ = "-1"
   Case &H12       'GAM_DOOM|GAM_CMRC
     waded$ = "-2"
   Case &H20, &H21, &H22 'GAM_HTIC
     waded$ = "-h"
   Case &H40, &H41, &H42 'GAM_HEXN
     waded$ = "-h"
   Case &H80, &H81 'GAM_STRF
     waded$ = "-2"
  End Select
  cmd$ = SubstitStr(cmd$, "%WADED%", waded$)
  cmd$ = SubstitStr(cmd$, "%EDMAP%", edmap$)
  cmd$ = SubstitStr(cmd$, "%GAME%", game$)
  cmd$ = SubstitStr(cmd$, "%IWAD%", Iwad$)
  cmd$ = SubstitStr(cmd$, "%TEXU%", texwd$)
  cmd$ = SubstitStr(cmd$, "%WAD%", pwad$)
  cmd$ = SubstitStr(cmd$, "%RWAD%", Left$(pwad$, Len(pwad$) - 4))
  cmd$ = SubstitStr(cmd$, "%LEVEL%", level$)
End Sub

Function CmdShell2% (cmd$, effect%)
   ' same as Shell(), but protected.
  ' 1 = normal with focus
  ' 3 = maximised with focus
  ' 6 = minimised without focus
  If Len(cmd$) > 127 Then
     Call Crash("The command line of is too big for DOS.")
     Exit Function
  End If
  Dim res%
  On Error GoTo Hell2
  CmdShell2% = Shell(cmd, effect%)
  Exit Function
Hell2:
  MsgBox "Bad Command " & Chr$(10) & cmd$, 16, "External Tool Error"
  Resume Next
End Function

Function SubstitStr (ByVal s As String, ByVal varnam As String, ByVal Value As String) As String
' non critical function
'
' substitute characters in a string
 Dim res As String
 Dim varlen, pos As Integer
 varlen = Len(varnam)
 res = s
 If InStr(Value, varnam) >= 0 Then 'security
   Do
    pos = InStr(res, varnam)
    If pos <= 0 Then Exit Do
    res = Left$(res, pos - 1) & Value & Mid$(res, pos + varlen)
   Loop
 End If
 SubstitStr = res
End Function

Sub XternCleanWAD (ByVal file$)
  If Not DIRexistFile(file$) Then Exit Sub
  Dim cmd$
  cmd$ = INIgetValue("Tools", "CleanWad")
  If Len(cmd$) <= 0 Then
     cmd$ = ChooseFile("cleanwad.exe", "*.exe", True, "Please select a WAD cleaner (like CLEANWAD.EXE)")
     If cmd$ = "" Then Exit Sub
     cmd$ = cmd$ & " %OLD% %WAD%"
     Call INIputValue("Tools", "CleanWad", cmd$, True)
  End If
  Dim file2$
  file2$ = MakeFileOld(file$)
  Call FileCopyOk(file$, file2$)
  cmd = SubstitStr(cmd, "%OLD%", file2$)
  cmd = SubstitStr(cmd, "%WAD%", file$)
  Call Infos("Cleaning WAD " & file$ & "." & Chr$(10) & " A backup file is preserved as " & file2$ & ".")
  Dim appli%
  appli% = CmdShell2(cmd, 3)'normal, focus
End Sub

Function XternEditor (ByVal which%, ByVal file$, ByVal level$, ByVal texwd$)
  '
  ' invoque external editor
  '
  XternEditor = 0
  Dim Iwad$, edtnam$, res%
  Iwad$ = WinTexGetGameIWad()
  If Not DIRexistFile(file$) Then Exit Function
  If Not DIRexistFile(Iwad$) Then Exit Function
  If Not DIRexistFile(texwd$) Then texwd$ = ""
  '
  'editor name
  '          #---+---#---+---#---+---#---+---#---+---#---+---#---+---#---+---#---+---#---+---#---+---#---+---
  edtnam$ = "DCK     DEU     DeeP    DoomCAD DoomEd  Edmap   EGOED   WinDEU  WadAuth WadEd   DmapEditDETH"
  edtnam$ = Trim$(Mid$(edtnam$, 8 * which% + 1, 8))
  If edtnam$ = "" Then edtnam$ = "Editor"
  Dim cmd$
  cmd$ = INIgetValue("LevelEdit", edtnam$)
  '
  ' check if command already defined
  '
  If cmd$ = "" Then
     cmd$ = ChooseFile(LCase$(edtnam$) & ".exe", "*.exe;*.bat", True, "Please select the executable of " & edtnam$)
     If cmd$ = "" Then Exit Function
     Dim ln$
     Select Case LCase$(edtnam$)
       Case "dck"
        'DCK [/t file1 [file2]] [/game xxx] [file [map]]
        '/T loads texture files, eg: DCK /T FLATS.WAD MYTEXTUR.WAD
        '/GAME switches to one of the "GD" games, the defaults being: DOOM1  DOOM2  HERETIC
        '[file [map]] edits a particular file and map.
         ln$ = "/t %TEXU% /GAME %GAME%  %WAD%"
       Case "deu", "windeu", "deth"
         ln$ = "-w %IWAD% -file  %TEXU%  %WAD%"
       Case "deep"
         ln$ = "-main %IWAD% -file %TEXU% %WAD%"
       Case "edmap"
         ln$ = "%TEXU% %WAD% %EDMAP%"
       Case "waded"
         'WADED  -1 file
         'WADED  -2 file
         'WADED  -h file
         ln$ = "%WADED% %WAD%"
       Case "wadauth"
         ln$ = "%WAD%"
       Case "dmapedit"
         ln$ = "%WAD%"
       Case Else
         ln$ = "  "
     End Select
     '
     ' put in .ini file
     '
     ln$ = InputBox$("Please confirm or modify the command line for " & edtnam$, "WinTex", ln$)
     DoEvents
     If ln$ = "" Then Exit Function
     cmd$ = cmd$ & " " & ln$
     Call INIputValue("LevelEdit", edtnam$, cmd$, True)
     '
     ' editor specific tests
     '
     Select Case LCase$(edtnam$)
       Case "dck", "deep"
         Call Infos("Make sure that windpmi.386 is in your system directory and the section [386Enh] of SYSTEM.INI contains device=windpmi.386.")
       Case "windeu", "doomcad"
         Call Infos("Please put the file " & edtnam$ & ".ini in directory " & CurDir$ & " for best results.")
     End Select
  End If
  '
  ' special execs
  '
  Select Case LCase$(edtnam$)
    Case "doomcad"
      ln$ = MakeFileName(CurDir$, "doomcad.ini")
      res = WritePrivateProfileString("DOOMCAD", "CurWADfile", file$, ln$)
      res = WritePrivateProfileString("DOOMCAD", "Game", Str$(1), ln$)
    Case "wadauth"
      'write texure file in [TEXTURES]  WinTex = texwd$
      If LCase$(Right$(file$, 4)) = ".wad" Then
        ln$ = Left$(file$, Len(file$) - 4) & ".waw"
        res = WritePrivateProfileString("Textures", "WinTex", texwd$, ln$)
      End If
  End Select
  '
  Call CmdEditor(cmd$, file$, texwd$, level$)
  '
  XternEditor = CmdShell2(cmd, 1) 'normal, with focus
End Function

Function XternFileEdit (ByVal ext$, ByVal file$)
  '
  ' invoque file editor, for file of the given type
  ' 0=txt 1=bmp 2=wav 3=lmp 4=end screen 5=mid
  '
  If ext$ = "" Then Exit Function
  Dim edtnam$
  '          #---#---#---#---#---#---
  Select Case LCase$(ext$)
   Case ".txt", ".con", ".acs":
     edtnam$ = "txt (text)"
   Case ".bmp":
     edtnam$ = "bmp (picture)"
   Case ".wav":
     edtnam$ = "wav (sound)"
   Case ".voc":
     edtnam$ = "voc (sound)"
   Case ".lmp", ".dat", ".art", ".map", ".tmb":
     edtnam$ = "lmp (raw data)"
   Case ".scr", ".bin":
     edtnam$ = "scr (end screen)"
   Case ".mid":
     edtnam$ = "mid (midi music)"
   Case ".mus":
     edtnam$ = "mus (mus format music)"
   Case ".wad":
     edtnam$ = "wad (game file)"
   Case Else
     edtnam$ = "lmp (raw data)"
  End Select
  XternFileEdit = 0
  If Not DIRexistFile(file$) Then Exit Function
  '
  ' find editor for name edtnam$, or ask for one
  '
  Dim tool$, cmd$, res%
  tool$ = Left$(edtnam$, 3)
  cmd$ = INIgetValue("Tools", tool$)
  If Not cmd$ Like "*%FILE%*" Then
     'command line
     Dim ln$
     ln$ = "%FILE%"
     'applications
     cmd$ = ""
     ' first try the default editor, if any
     Dim buffer As String * 256
     res% = GetProfileString("Extensions", tool$, "-", buffer$, 256)
     If res% > 2 Then
       cmd$ = Left$(buffer$, res%)
       res% = InStr(cmd$, " ")
       If res% > 1 Then cmd$ = Left$(cmd$, res% - 1)
       If Not QueryOk("Do you want to use " & cmd$ & " to edit " & edtnam$ & " files?") Then
         cmd$ = ""
       End If
     End If
     'ask the user for a specific editor
     If cmd$ = "" Then
       cmd$ = ChooseFile(cmd$, "*.exe", True, "Please select an editor for " & edtnam$ & " files")
       If cmd$ = "" Then Exit Function
       ln$ = InputBox$("Please confirm or modify the command line of your editor", "WinTex", ln$)
       If ln$ = "" Then Exit Function
     End If
     If cmd$ = "" Then Exit Function
     'write command line
     cmd$ = cmd$ & " " & ln$
     Call INIputValue("Tools", tool$, cmd$, True)
  End If
  '
  ' editor was found, use it
  '
  cmd$ = SubstitStr(cmd$, "%FILE%", file$)
  XternFileEdit = CmdShell2(cmd$, 1)'normal with focus
End Function

Function XternGetHackedExt$ (ByVal game%)
  '
  ' file extension for Dehacked
  '
  Dim ext$
  ext$ = ".txt"
  Select Case game%
    Case &H10, &H11, &H12 'GAM_DOOM
      ext$ = ".deh"
    Case &H20, &H21, &H22 'GAM_HTIC
      ext$ = ".hhe"
    Case &H40, &H41'GAM_HEXN
    Case &H80, &H81'GAM_STRF
  End Select
  XternGetHackedExt$ = ext$
End Function

Sub XternHackEd (ByVal ops%, ByVal file$)
' call Dehacked
'  patch  = name of patch file, without extension
'  ops = 0 edit
'  ops = 1 save
'  ops  = 2 reload
'
  Dim Iwad$
  Iwad$ = WinTexGetGameIWad()
  If Not DIRexistFile(Iwad$) Then Exit Sub
  ' Find the executable
  Dim exe$, exenam$, exedefault$
  exedefault$ = WinTexGetHackedProg$(exe$, exenam$)
  exe$ = INIgetValue("ExeEdit", exenam$)
  If Not DIRexistFile(exe$) Then
    exe$ = ChooseFile(exedefault$, "*.exe", True, "Please select a .EXE editor for the game")
    If exe$ = "" Then Exit Sub
    Call INIputValue("ExeEdit", "DHE", exe, True)
    If Not DIRexistFile(exe$) Then
      Call Crash(exe$ & " not found")
      Exit Sub
    End If
  End If
  ' Declare DOOM directory
  exe$ = exe$ & " " & FilePath(Iwad$)
  ' Declare patch if needed
  On Error Resume Next
  Select Case ops%
    Case 0 'edit
    Case 1 'save
      If DIRexistFile(file$) Then
         Dim old$
         old$ = MakeFileOld(file$)
         Call FileCopyOk(file$, old$)
      End If
      exe$ = exe$ & " -save " & file$
      Call Infos("Saving the exe patch file " & file$)
    Case 2 'reload
      If Not DIRexistFile(file$) Then
         Call Crash("No Exe patch file " & file$)
         Exit Sub
      End If
      exe$ = exe$ & " -reload -load " & file$
      Call Infos("Reloading the exe patch file " & file$)
  End Select
  ' Call dehacked.
  ' If no command, dehacked starts in editing mode
  Dim appli%
  appli% = CmdShell2(exe$, 1) 'normal, focus
End Sub

Sub XternInstall (bat$, pwad$, exepatch$, ByVal oksprite%, ByVal okflat%, ByVal okdeh%)
'
' create an install batch
' bat = batch file to create
' pwad = pwad fiel to install
' exepatch = dehacked patch to include
'  oksprite  = bool custom sprites
'  okflat    = bool custom flats
'  ok deh    = bool custom deh
  Dim mainwad$ ' doom file
  Dim mainexe$ ' doom exe
  mainexe$ = FileName(WinTexGetGameExe$())
  mainwad$ = FileName(WinTexGetGameIWad$())

  Dim dheexe$, hackedexe$, ref$
  dheexe$ = WinTexGetHackedProg(hackedexe$, ref$)
  If dheexe$ = "" Then Exit Sub
  '
  ' write file
  '
  On Error GoTo nobatch
  Open bat For Output As #1
  Print #1, "@echo."
  Print #1, "@echo. Installation of " & UCase$(pwad$)
  Print #1, "@echo."
  Print #1, "@echo. This will take some seconds, be patient."
  Print #1, "@echo."
  '
  'check main wad
  Print #1, "@rem Check main WAD"
  Print #1, "@if not exist " & mainwad$ & " goto miss"
  Print #1, "@echo @echo. Restoration > restore.bat"
  Print #1, "@echo " & mainexe$ & " -file " & pwad$ & " > play.bat "
  Print #1, "@rem"
  '
  'dehacked patch
  If okdeh Then
    Print #1, "@rem Check EXE Patch"
    Print #1, "@if not exist " & mainexe$ & " goto miss"
    Print #1, "@if not exist " & exepatch$ & " goto miss"
    Print #1, "@rem"
    Print #1, "@rem Install EXE Patch"
    Print #1, "@copy " & mainexe$ & " " & hackedexe$
    Print #1, "@echo rm " & hackedexe$ & " >> restore.bat"
    Print #1, "@rem"
    Print #1, "@" & dheexe$ & " -reload -load " & exepatch$ & " > hacked.log"
    Print #1, "@if not ERRORLEVEL 0 goto fail "
    Print #1, "@rem Modify game command"
    If Len(pwad$) > 0 Then
      Print #1, "@echo " & hackedexe$ & " -file " & pwad$ & " > play.bat "
    End If
    Print #1, "@echo Warning: for network games, rename " & hackedexe$ & " to " & mainexe$
    Print #1, "@echo but first save " & mainexe$ & " somewhere!"
    Print #1, "@echo This is true if you use SETUP, IPXSETUP or SERSETUP."
    Print #1, "@rem"
  End If
  If oksprite Or okflat Then
    Print #1, "@rem Install Sprites or Flats in WAD"
    Print #1, "@if not exist " & pwad$ & " goto miss"
    Print #1, "@echo deusf -res " & pwad$ & " >> restore.bat"
    Dim slct$
    If oksprite Then
      If okflat Then
        slct$ = "-app" 'add all
      Else
        slct$ = "-as"  'add sprite
      End If
    Else
      slct$ = "-af"    'add flat
    End If
    Print #1, "@echo  Completing sprites and flats, please wait..."
    Print #1, "@deusf -main .\" & mainwad$ & " " & slct & " " & pwad$ & "> deusf.log"
    Print #1, "@if not ERRORLEVEL 0 goto fail "
  End If
  Print #1, "@rem"
  Print #1, "@rem"
  Print #1, "@echo Installation succeeded."
  Print #1, "@echo type PLAY to play the modified game."
  Print #1, "@echo type RESTORE to uninstall."
  Print #1, "@goto end"
  Print #1, ":fail"
  Print #1, "@echo. Installation failed: A tool didn't work."
  Print #1, "@echo. See hack.log or deusf.log for details."
  Print #1, "@goto end"
  Print #1, ":miss"
  Print #1, "@echo. Installation impossible: some files are missing."
  Print #1, "@echo. Did you have deusf.exe and " & dheexe$ & ".exe ?"
  Print #1, "@echo. Please copy all your files in the main game directory."
  Print #1, "@echo. And try install again."
  Print #1, "@goto end"
  Print #1, ":end"
  Close #1
  Call Infos("Please distribute " & Chr$(10) & bat$ & Chr$(10) & "deusf.exe" & Chr$(10) & dheexe$ & Chr$(10) & "together with " & pwad$)
  Exit Sub
nobatch:
  Call Crash("Could not create " & bat)
  Exit Sub
End Sub

Function XternMidi2Mus$ (ByVal file$)
  '
  ' converts MIDI to MUS, return name of MUS file
  '
  XternMidi2Mus$ = ""
  If Not DIRexistFile(file) Then Exit Function
  If Not LCase$(Right$(file, 4)) = ".mid" Then Exit Function
  Dim file2$
  file2 = Left$(file, Len(file) - 3) & "mus"
  Dim cmd$
  cmd = INIgetValue("Extern", "Midi2Mus")
  If Not (cmd Like "*%MIDI%*") Then
     cmd$ = ChooseFile("midi2mus.exe", "*.exe", True, "Please select a MIDI to MUS converter")
     If cmd$ = "" Then Exit Function
     cmd = cmd$ & " %MIDI%"
     Call INIputValue("Extern", "Midi2Mus", cmd, True)
  End If
  cmd = SubstitStr(cmd, "%MIDI%", file)
  cmd = SubstitStr(cmd, "%MUS%", file2)
  Dim appli%
  appli% = CmdShell2(cmd, 4)  'normal, no focus
  XternMidi2Mus$ = file2$
  Call XternWaitEnd(appli%)
End Function

Function XternNode (ByVal which%, ByVal file$, ByVal level$)
  '
  ' invoque external node builder
  '
  XternNode = 0
  Dim Iwad$, edtnam$, res%
  Iwad$ = WinTexGetGameIWad()
  If Not DIRexistFile(file$) Then Exit Function
  If Not DIRexistFile(Iwad$) Then Exit Function
  '
  'editor name
  '          #---+---#---+---#---+---#---+---#---+---#---+---#---+---#---+---#---+---#---+---
  edtnam$ = "Warm    DeepBSP BSP"
  edtnam$ = Trim$(Mid$(edtnam$, 8 * which% + 1, 8))
  If edtnam$ = "" Then edtnam$ = "Custom"
  Dim cmd$
  cmd$ = INIgetValue("NodeEdit", edtnam$)
  '
  ' check if command already defined
  '
  If Not cmd$ Like "*%WAD%*" Then
     cmd$ = ChooseFile(LCase$(edtnam$) & ".exe", "*.exe", True, "Please select the executable of " & edtnam$)
     If cmd$ = "" Then Exit Function
     Dim ln$
     Select Case LCase$(edtnam$)
       Case "warm"
         ln$ = "-n=a -b -z %OLD% %WAD%"
       Case "bsp", "deepbsp"
         ln$ = "%OLD% %WAD%"
       Case Else
         ln$ = "%OLD% %WAD%"
     End Select
     '
     ' put in .ini file
     '
     ln$ = InputBox$("Please confirm or modify the command line for " & edtnam$, "WinTex", ln$)
     If ln$ = "" Then Exit Function
     cmd$ = cmd$ & " " & ln$
     Call INIputValue("NodeEdit", edtnam$, cmd$, True)
  End If
  Dim file2$
  file2$ = MakeFileOld(file$)
  Call FileMoveOk(file$, file2$)
  Call CmdEditor(cmd$, file$, "", level)
  cmd$ = SubstitStr(cmd$, "%OLD%", file2$)
  XternNode = CmdShell2(cmd, 1) 'normal, with focus
End Function

Function XternReject (ByVal which%, ByVal file$, ByVal level$)
  '
  ' invoque external reject builder
  '
  XternReject = 0
  Dim Iwad$, edtnam$, res%
  Iwad$ = WinTexGetGameIWad()
  If Not DIRexistFile(file$) Then Exit Function
  If Not DIRexistFile(Iwad$) Then Exit Function
  '
  'editor name
  '          #---+---#---+---#---+---
  edtnam$ = "RMB     Warm    Reject"
  edtnam$ = Trim$(Mid$(edtnam$, 8 * which% + 1, 8))
  If edtnam$ = "" Then edtnam$ = "Custom"
  Dim cmd$
  cmd$ = INIgetValue("RejectEdit", edtnam$)
  '
  ' check if command already defined
  '
  If Not cmd$ Like "*%WAD%*" Then
     cmd$ = ChooseFile(LCase$(edtnam$) & ".exe", "*.exe", True, "Please select the executable of " & edtnam$)
     If cmd$ = "" Then Exit Function
     Dim ln$
     Select Case LCase$(edtnam$)
       Case "warm"
         ln$ = "-n=a -z %OLD% %WAD%"
       Case "rmb"
         ln$ = "%OLD% %WAD% NOMAP"
       Case "reject"
         Call Infos("Avoid reject.exe, it's outdated.")
         ln$ = "%RWAD% %LEVEL% 1000"
       Case Else
         ln$ = "%OLD% %WAD%"
     End Select
     '
     ' put in .ini file
     '
     ln$ = InputBox$("Please confirm or modify the command line for " & edtnam$, "WinTex", ln$)
     If ln$ = "" Then Exit Function
     cmd$ = cmd$ & " " & ln$
     Call INIputValue("RejectEdit", edtnam$, cmd$, True)
  End If
  Dim file2$
  file2$ = MakeFileOld(file$)
  Call FileMoveOk(file$, file2$)
  Call CmdEditor(cmd$, file$, "", level)
  cmd$ = SubstitStr(cmd$, "%OLD%", file2$)
  XternReject = CmdShell2(cmd, 1) 'normal, with focus
End Function

Sub XternRunGame (ByVal levelwad$, ByVal texwad$)
  '
  ' Run Game from within Windows
  '
  If Not DIRexistFile(levelwad$) Then Exit Sub
  If Not DIRexistFile(texwad$) Then texwad = ""
  Dim exe$, direc$
  exe$ = WinTexGetGameExe()
  If Not DIRexistFile(exe$) Then Exit Sub
  direc$ = FilePath(exe$)
  direc$ = Left$(direc$, Len(direc$) - 1)
  Dim parm$
  parm$ = " -file " & texwad$ & " " & levelwad$
  Dim res%
  res% = EXECopenFile(exe$, parm$, direc$)
End Sub

Sub XternWaitEnd (ByVal appli%)
  '
  ' wait for an application to stop running
  '
  While GetModuleUsage(appli%) > 0
    DoEvents
  Wend
End Sub

