// Main Routine for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

// The entire program structure has been changed from DoomEd 2.x,
// however many of the routines are retained.

// Except where (clearly) noted, all code is original and written
// by Geoff Allan; no code is from any other Doom editor.

#include "DoomEd40.hpp"

int PASCAL WinMain(HANDLE hInstance,
                   HANDLE hPrevInstance,
                   LPSTR lpszCmdLine,
                   int nCmdShow)
{
  int       nReturn;
  int       len, i;
  DWORD     dwVersion;
  char      szModuleName[260];
  OFSTRUCT  ofs;

  GetModuleFileName(hInstance, szModuleName, sizeof(szModuleName));
  len = strlen(szModuleName);
  for(i = len; i > 0; i--)
    if(szModuleName[i] == '\\') {
      szModuleName[i + 1] = '\0';
      break;
      }

  strcat(szModuleName, "CTL3DV2.DLL");
  if(OpenFile(szModuleName, &ofs, OF_EXIST) != HFILE_ERROR) {
    char lpszMess[200], lpsys[128];
    GetSystemDirectory(lpsys, 128);
    wsprintf(lpszMess, "You have not installed DoomEd properly.\n"
                       "Please delete the file:\n%s"
                       "\nThis file must still be in\n%s", szModuleName, lpsys);
    MessageBox(NULL, lpszMess,
               ProgErr,
               MB_ICONSTOP | MB_OK);
    return 0;
    }

  dwVersion = GetVersion();
  
  if(LOWORD(dwVersion) < 0x30a) {
    ErrorMessage(IDS_WINDOWSVERSION);
    return 0;
    }
  
  Ctl3dRegister(hInstance);         // for 3d dialogs:
  Ctl3dAutoSubclass(hInstance);     // automate everything
  
  if(DoomEdInit(hInstance, hPrevInstance, lpszCmdLine, nCmdShow))
    nReturn = DoMain(hInstance);    // run program if init=OK
    
  Ctl3dUnregister(hInstance);       // done with 3d support
  
  return nReturn;
}

int DoMain(HANDLE hInstance)
{
  MSG msg;

  while(GetMessage(&msg, NULL, 0, 0)) {

    if(Frontmost == NULL ||
       !IsDialogMessage(Frontmost, &msg)) {
      if(!TranslateAccelerator(hwnd, hAccel, &msg)) {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
        }
      }                                                
    }
  return msg.wParam;
}

long EXPORT DoomEdWindowProc (HWND   hWnd,
                              UINT   wMsgID,
                              WPARAM wParam,
                              LONG   lParam)
{
// Note: Design goal is to have as little code here as possible.
//       This switch statement will only dispatch events off to
//       the routines to handle them (where possible)

  switch (wMsgID) {
    case WM_PALETTECHANGED:     // and of course, the exceptions are first <g>
      if(!PaletteLoaded)
        return 0L;
      if((HWND)wParam == hwnd)
        return 0L;
    case WM_QUERYNEWPALETTE:
      if(!PaletteLoaded)
        return 0L;
      {
      UINT      ii;
      HPALETTE  hpalT;
      hdc = GetDC(hwnd);
      hpalT = SelectPalette(hdc, hPalette, FALSE);
      ii = RealizePalette(hdc);
      SelectPalette(hdc, hpalT, FALSE);
      SetBkColor(hdc, ColorBackground);
      ReleaseDC(hwnd, hdc);
      if(ii>0)
        InvalidateRect(hwnd, NULL, TRUE);
      return ii;
      }
      break;
      
    case WM_CLOSE:
      return DoomEdClose(hWnd);
      break;
    
    case WM_DESTROY:
      DoomEdDestroy();
      return 0L;
      break;

    case WM_TIMER:
      if(!TaskFindHandle(&te, TaskToWatch))
        TaskComplete();
      return 0L;
      break;

    case WM_RBUTTONDOWN:
      DoomEdRButtonDown(hdc, wParam, lParam);
      return 0L;
      break;

    case WM_RBUTTONUP:
      DoomEdRButtonUp  (hdc, wParam, lParam);
      return 0L;
      break;

    case WM_RBUTTONDBLCLK:
      DoomEdRDouble  (hdc, wParam, lParam);
      return 0L;
      break;

    case WM_LBUTTONDOWN:             
      DoomEdLButtonDown(hdc, wParam, lParam);
      return 0L;
      break;

    case WM_LBUTTONUP:
      DoomEdLButtonUp  (hdc, wParam, lParam);
      return 0L;
      break;

    case WM_LBUTTONDBLCLK:
      DoomEdLDouble  (hdc, wParam, lParam);
      return 0L;
      break;

    case WM_MOUSEMOVE:
      DoomEdMouseMove  (hdc, wParam, lParam);
      return 0L;
      break;

    case WM_NCMOUSEMOVE:
      DoomEdNCMouseMove();
      return 0L;
      break;

    case WM_VSCROLL:
      DoomEdVScroll(wParam);
      return 0L;
      break;

    case WM_HSCROLL:
      DoomEdHScroll(wParam);
      return 0L;
      break;

    case WM_PAINT:
      DoomEdPaint();
      return 0L;
      break;

    case WM_SIZE:
      DoomEdSize(lParam);
      return TRUE;
      break;

    case WM_MENUSELECT:
      DoomEdMenuSelect(wParam);
      return 0L;
      break;
// modeless dialogs need special handling. They can't close
// or hide themselves, so they ask the main loop to do so.
    case DOOMED_HIDE_THING:
      HIDE_HWND(hwndDialogThing)
      return 0L;
      break;
    case DOOMED_SHOW_THING:
      SHOW_HWND(hwndDialogThing)
      return 0L;
      break;

    case DOOMED_HIDE_SECTOR:
      HIDE_HWND(hwndDialogSector)
      return 0L;
      break;
    case DOOMED_SHOW_SECTOR:
      SHOW_HWND(hwndDialogSector)
      return 0L;
      break;

    case DOOMED_HIDE_LINEDEF:
      HIDE_HWND(hwndDialogLineDef)
      return 0L;
      break;
    case DOOMED_SHOW_LINEDEF:
      SHOW_HWND(hwndDialogLineDef)
      return 0L;
      break;

    case DOOMED_HIDE_PROBLEMS:
      HIDE_HWND(hwndProblems)
      return 0L;
      break;
    case DOOMED_SHOW_PROBLEMS:
      SHOW_HWND(hwndProblems)
      return 0L;
      break;

    case WM_COMMAND:
      switch(wParam) {

        case ID_FILE_OPEN:
          DoomEdFileOpen();
          return 0L;
          break;

        case ID_FILE_SAVE:
          DoomEdFileSave();
          return 0L;
          break;

        case ID_FILE_SAVEAS:
          DoomEdFileSaveAs();
          return 0L;
          break;

        case ID_FILE_NEW:
          DoomEdFileNew();
          return 0L;
          break;

        case ID_FILE_CONTENTS:
          DoDirectory();
          return 0L;
          break;

        case ID_FILE_PRINT:
          PrintMap();       // in Print.c
          return 0L;
          break;

        case ID_FILE_EXPORT:
          DoomEdFileExport();
          return 0L;
          break;

        case ID_FILE_EXIT:
          PostMessage(hwnd,WM_CLOSE,0,0L);
          return 0L;
          break;

        case ID_FILE_FILE1:
        case ID_FILE_FILE2:
        case ID_FILE_FILE3:
        case ID_FILE_FILE4:
          // load the previous file
          LoadPreviousFile(wParam);
          return 0L;
          break;

        case ID_EDIT_UNDO:
          DoomEdEditUndo();
          return 0L;
          break;

        case ID_EDIT_REDO:
          DoomEdEditRedo();
          return 0L;
          break;

        case ID_EDIT_CUT:
          DoomEdEditCut();
          return 0L;
          break;

        case ID_EDIT_COPY:
          DoomEdEditCopy();
          return 0L;
          break;

        case ID_EDIT_PASTE:
          DoomEdEditPaste();
          return 0L;
          break;

        case ID_EDIT_DELETE:
          DoomEdEditPartDelete();
          return 0L;
          break;

        case ID_EDIT_PARTDELETE:
          DoomEdEditDelete();
          return 0L;
          break;

        case ID_EDIT_OPTIONS:
          DoOptions();
          return 0L;
          break;

        case ID_EDIT_DEFAULTSECTORSTYLE:
          DoSectorDefault();
          return 0L;
          break;

        case ID_EDIT_GRIDSIZE:
          DoGrid();
          return 0L;
          break;

        case ID_EDIT_STYLES:
          DoStyles();
          return 0L;
          break;

        case ID_EDIT_TAGS:
          DoPlatforms();
          return 0L;
          break;

        case ID_TOOLS_3D:
          Do3d();
          return 0L;
          break;

        case ID_RESOURCE_STATISTICS:
          DoomEdStatistics();
          return 0L;
          break;

        case ID_RESOURCE_GRAPHICS:
          DoViewer();
          return 0L;
          break;

        case ID_RESOURCE_SEARCH:
          DoSearch();
          return 0L;
          break;

        case ID_RESOURCE_REPLACE:
          DoReplace();
          return 0L;
          break;

        case ID_RESOURCE_CHECKMAP:
          SHOW_HWND(hwndProblems)
          return 0L;
          break;

        case ID_HELP_CONTENTS:
          WinHelp(hwnd, HelpFile, HELP_CONTEXT, 666L);
          return 0L;
          break;

        case ID_HELP_ABOUT:
          DoomEdHelpAbout();
          return 0L;
          break;

        case POPUP_CANCEL:
          if(ShowingSectorRectangle) {
            ShowingSectorRectangle = FALSE;
            HDC rDC = GetDC(hwnd);
            int oldROP = SetROP2(rDC, R2_XORPEN);
            SelectBrush(rDC, hBrushNull);
            SelectPen(rDC, hPenSelected);
            // erase selection rectangle
            Rectangle(rDC, SelRect.left, SelRect.top,
                           SelRect.right, SelRect.bottom);
            SetROP2(rDC, oldROP);
            ReleaseDC(hwnd, rDC);
            BottomMessage("");
            }
          return 0L;  
          break;

        case POPUP_RECTANGLE:
        case POPUP_POLYGON:
        case POPUP_SHAPE_STAR:
        case POPUP_SHAPE_CROSS:
        case POPUP_SHAPE_SWAST:
        case POPUP_STEPS:
          AddNewSector(wParam);
          return 0L;
          break;
        
        case POPUP_MAKEDOOR:
          MakeSectorDoor(CurrentSector);
          return 0L;
          break;

        case POPUP_ROTATESCALE:
          SectorRotateScale();
          return 0L;
          break;

        case POPUP_DUPLICATE:
          SectorDuplicate();
          return 0L;
          break;

        case POPUP_STYLE00:
        case POPUP_STYLE01:
        case POPUP_STYLE02:
        case POPUP_STYLE03:
        case POPUP_STYLE04:
        case POPUP_STYLE05:
        case POPUP_STYLE06:
        case POPUP_STYLE07:
        case POPUP_STYLE08:
        case POPUP_STYLE09:
        case POPUP_STYLE10:
        case POPUP_STYLE11:
        case POPUP_STYLE12:
        case POPUP_STYLE13:
        case POPUP_STYLE14:
        case POPUP_STYLE15:
        case POPUP_STYLE16:
        case POPUP_STYLE17:
        case POPUP_STYLE18:
        case POPUP_STYLE19:
        case POPUP_STYLE20:
        case POPUP_STYLE21:
        case POPUP_STYLE22:
        case POPUP_STYLE23:
        case POPUP_STYLE24:
        case POPUP_STYLE25:
        case POPUP_STYLE26:
        case POPUP_STYLE27:
        case POPUP_STYLE28:
        case POPUP_STYLE29:
        case POPUP_STYLE30:
        case POPUP_STYLE31:
          ApplyStyle(wParam - POPUP_STYLE00);
          return 0L;
          break;

        case POPUP_STYLES:
          DoStyles();
          return 0L;
          break;

        case ID_MAP_ZOOMIN:
          DoomEdZoomIn();
          return 0L;
          break;

        case ID_MAP_ZOOMOUT:
          DoomEdZoomOut();
          return 0L;
          break;

          }
      break;

    default:
      return DefWindowProc(hWnd, wMsgID, wParam, lParam);
    }
  return 0;
}

long EXPORT CustomDialogProc(HWND   hDlg,
                             UINT   wMsgID,
                             WPARAM wParam,
                             LONG   lParam)
{
  if((wMsgID == WM_CTLCOLOR) &&(HIWORD(lParam) != CTLCOLOR_SCROLLBAR)) {
      return (LPARAM)hBrushBackground;
      }
  return DefDlgProc(hDlg, wMsgID, wParam, lParam);
}

