// Textures for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

void ReadTextures(void)
{
  HFILE WadFile;
  int   PNameEntry,
        TextureBlock, TextureCount;
  int   i, j;
  long  PNameOffset, TextureOffset,
        BlockCount, BlockOffset;

  // PNames (panel names):
  WadFile = _lopen(szDoomWad, OF_READ);
  PNameEntry = DoomEntry("PNAMES");
  PNameOffset = Doom[PNameEntry].Offset + 4;
  PNamesNum = (int)Doom[PNameEntry].Length / 8;
  PName = (struct::PNameInfo __far *)calloc(PNamesNum, sizeof(PNames));
  _llseek(WadFile, PNameOffset, 0);
  for(i=0; i<PNamesNum; i++) {
    _lread(WadFile, &PName[i].name, 8);
    PName[i].name[8]='\0';
    }
  
  // next, allocate space for textures:
  TextureBlock = DoomEntry("TEXTURE1");
  TextureOffset = Doom[TextureBlock].Offset;
  _llseek(WadFile, TextureOffset, 0);
  _lread(WadFile, &TextureCount, 4);
  TexturesNum = (int)TextureCount;
  TextureBlock = DoomEntry("TEXTURE2");
  if(TextureBlock != NotFound) {
    TextureOffset = Doom[TextureBlock].Offset;
    _llseek(WadFile, TextureOffset, 0);
    _lread(WadFile, &TextureCount, 4);
    TexturesNum += (int)TextureCount;
  }
  Texture = (struct::TextureInfoTag __far *)calloc(TexturesNum, sizeof(TextureInfo));

  // now, read texture information:
  j=0;
  TextureBlock = DoomEntry("TEXTURE1");
  TextureOffset = Doom[TextureBlock].Offset;
  _llseek(WadFile, TextureOffset, 0);
  _lread(WadFile, &BlockCount, 4);
  for(i=0; i<(int)BlockCount; i++) {
    _llseek(WadFile, TextureOffset + 4 + (i * 4), 0);
    _lread(WadFile, &BlockOffset, 4);       // offset to texture info
    BlockOffset += TextureOffset;           // add offset to block
    _llseek(WadFile, BlockOffset, 0);       // move to offset
    _lread(WadFile, Texture[j].name, 8);    // texture name
    Texture[j].name[8]='\0';                // pad with null
    Texture[j].offset = BlockOffset + 22;   // offset to data records
    _lread(WadFile, &Texture[j].v1, 14);    // all other data
    j++;
    }
    
  TextureBlock = DoomEntry("TEXTURE2");
  if(TextureBlock != NotFound) {
    TextureOffset = Doom[TextureBlock].Offset;
    _llseek(WadFile, TextureOffset, 0);
    _lread(WadFile, &BlockCount, 4);
    for(i=0; i<(int)BlockCount; i++) {
      _llseek(WadFile, TextureOffset + 4 + (i * 4), 0);
      _lread(WadFile, &BlockOffset, 4);
      BlockOffset += TextureOffset;
      _llseek(WadFile, BlockOffset, 0);
      _lread(WadFile, Texture[j].name, 8);
      Texture[j].name[8]='\0';
      Texture[j].offset = BlockOffset + 22;
      _lread(WadFile, &Texture[j].v1, 14);
      j++;
      }     // next i
    }       // end if
  _lclose(WadFile);
  return;
}
