// Bitmap viewers for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

int         TileWhich = Nothing, TileWhere = Nothing;
int         TextureWhich = Nothing;
HBITMAP     hCurrentTile = NULL;
HBITMAP     hCurrentTexture = NULL;

void PutTileInViewer(char *Title)
{
  
  int       which = strlen(Title);
  
  which += 3;
}

int EXPORT DialogTileViewer(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  PAINTSTRUCT   ps;
  
  switch(wMsg) {

    case WM_INITDIALOG:
      return TRUE;
      break;

    case WM_PAINT:
      if(hCurrentTile) {
        // Quick and Clean.
        HDC hMemoryDC;
        BeginPaint(hDlg, &ps);
        hMemoryDC = CreateCompatibleDC(ps.hdc);
        SelectObject(hMemoryDC, hCurrentTile);
        SelectPalette(ps.hdc, hPalette, FALSE);
        RealizePalette(ps.hdc);
        BitBlt(ps.hdc, 0, 0, 64, 64,
               hMemoryDC, 0, 0, SRCCOPY);
        DeleteDC(hMemoryDC);
        EndPaint(hDlg, &ps);
        return FALSE;
        }
      else
        return TRUE;
      break;

    default:
      return FALSE;
    }
}

void PutTextureInViewer(int TextureNum)
{
  BITMAP    bm;
  int       cWidth, cHeight;
  RECT      cRect, wRect;

  if(TextureNum == Nothing) {
    ShowWindow(hwndTextureViewer, SW_HIDE);
    return;
    }

  if(!IsWindowVisible(hwndTextureViewer))
    ShowWindow(hwndTextureViewer, SW_SHOWNOACTIVATE);

  if(TextureWhich == TextureNum)
    return;     // do nothing, same Texture.

  TextureWhich = TextureNum;

  if(hCurrentTexture)
    DeleteBitmap(hCurrentTexture);

  hCurrentTexture = TextureImageFromDoom(TextureWhich);
  // get the bitmap size:
  GetObject(hCurrentTexture, sizeof(BITMAP), (LPSTR)&bm);
  // get the sizes of the window and its client area:
  GetWindowRect(hwndTextureViewer, &wRect);
  GetClientRect(hwndTextureViewer, &cRect);
  // calculate the extra pixels of width:
  cWidth = (wRect.right - wRect.left) - (cRect.right - cRect.left);
  // calculate the extra pixels of height:
  cHeight = (wRect.bottom - wRect.top) - (cRect.bottom - cRect.top);
  // make the window just big enough to contain the bitmap:
  SetWindowPos(hwndTextureViewer, HWND_TOPMOST, 0, 0,
               bm.bmWidth + cWidth,
               bm.bmHeight + cHeight,
               SWP_NOMOVE | SWP_NOACTIVATE | SWP_SHOWWINDOW);
  SetWindowText(hwndTextureViewer, Texture[TextureWhich].name);
  // the paint procedure will draw it:
  InvalidateRect(hwndTextureViewer, NULL, TRUE);
}

int EXPORT DialogTextureViewer(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  PAINTSTRUCT   ps;
  
  switch(wMsg) {

    case WM_INITDIALOG:
      return TRUE;
      break;

    case WM_PAINT:
      if(hCurrentTexture) {
        // Quick and Clean.
        HDC     hMemoryDC;
        BITMAP  bm;
        
        GetObject(hCurrentTexture, sizeof(BITMAP), (LPSTR)&bm);
        BeginPaint(hDlg, &ps);
        hMemoryDC = CreateCompatibleDC(ps.hdc);
        SelectObject(hMemoryDC, hCurrentTexture);
        SelectPalette(ps.hdc, hPalette, FALSE);
        RealizePalette(ps.hdc);
        BitBlt(ps.hdc, 0, 0, bm.bmWidth, bm.bmHeight,
               hMemoryDC, 0, 0, SRCCOPY);
        DeleteDC(hMemoryDC);
        EndPaint(hDlg, &ps);
        return FALSE;
        }
      else
        return TRUE;
      break;

    default:
      return FALSE;
    }
}

// Viewer module from 2.60b4
// Copyright  1994 by Geoff Allan

void DoViewer(void)
{
  FARPROC lpfnDlgProc;
  lpfnDlgProc = MakeProcInstance((FARPROC)DialogViewer, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_VIEWER),
              hwnd,
              lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);
    }
}

static HWND     ViewerList;
static HWND     hZoom, hLock;
static HWND     hInfo;
static BOOL     ShowingFloors = FALSE;
static BOOL     ShowingTextures = FALSE;
static BOOL     LockCenter = TRUE, DoubleSize = FALSE;;
static HBITMAP  hViewerBitmap;
static RECT     ViewerImageArea;
static int      ViewerX, ViewerY;

int EXPORT DialogViewer(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  int       i, k;
  RECT      ca;     // client area
  HDC       tDC;
  HPALETTE  hpalT;
  char      szInfo[20];
  
  switch(wMsg) {
    case WM_PALETTECHANGED:
      if((HWND)wParam == hDlg)        
        return 0L;
    case WM_QUERYNEWPALETTE:
      tDC = GetDC(hDlg);
      hpalT = SelectPalette(tDC, hPalette, FALSE);
      i = RealizePalette(tDC);
      SelectPalette(tDC, hpalT, FALSE);
      ReleaseDC(hDlg, tDC);
      if(i>0)
        InvalidateRect(hDlg, NULL, TRUE);
      return i;
      break;
      
    case WM_INITDIALOG:
      ViewerList = GetDlgItem(hDlg, IDC_BITMAPLIST);
      hZoom      = GetDlgItem(hDlg, IDC_USEZOOM);
      hLock      = GetDlgItem(hDlg, IDC_USELOCK);
      hInfo      = GetDlgItem(hDlg, IDC_IMAGEINFO);
      sprintf(szInfo, " ");
      Static_SetText(hInfo, szInfo);
      
      ListBox_ResetContent(ViewerList);
      for(i = 0; i < DoomEntries; i++) {
        if((Doom[i].Type == WD_SPRITE) ||
           (Doom[i].Type == WD_STATUS) ||
           (Doom[i].Type == WD_LEVEL)  ||
           (Doom[i].Type == WD_MENU)   ||
           (Doom[i].Type == WD_GRAPHIC)) {
          k = ListBox_AddString(ViewerList, Doom[i].Title);
          ListBox_SetItemData(ViewerList, k, i);
          }
        }
      ListBox_SetCurSel(ViewerList, Nothing);
      ShowingFloors = FALSE;
      ShowingTextures = FALSE;
      ViewerImageArea.top  = 30;     // set upper left corner
      ViewerImageArea.left = 150;
      Button_SetCheck(hLock, LockCenter);
      Button_SetCheck(hZoom, DoubleSize);
      Button_SetCheck(GetDlgItem(hDlg, IDC_VIEWER_SPRITES), 1);
      tDC = GetDC(hDlg);
      SelectPalette(tDC, hPalette, 0);
      RealizePalette(tDC);
      ReleaseDC(hDlg, tDC);
      return FALSE;
      break;

    case WM_SIZE:
      switch (wParam)
        {
        case SIZE_MAXIMIZED:
        case SIZE_RESTORED:
          InvalidateRect(hDlg, NULL, TRUE);
          return FALSE;
          break;
        default:
          return FALSE;
          break;
        }
      break;

    case WM_PAINT:
      {
      PAINTSTRUCT   ps;
      HDC           hMemDC;
      HBITMAP       old;
      HPEN          hpen, hpenOld;
      
      BeginPaint(hDlg, &ps);
      // SetBkColor(ps.hdc, ColorDialogs);
      GetClientRect(hDlg, &ca);
      hpen=CreatePen(PS_DOT, 0, PALETTERGB(0, 0, 192));
      hpenOld = SelectObject(ps.hdc, hpen);
      MoveTo(ps.hdc, 150,(ca.bottom - ca.top)/2);
      LineTo(ps.hdc, ca.right,(ca.bottom - ca.top)/2);
      MoveTo(ps.hdc, 150+(ca.right - ca.left - 150)/2, 0);
      LineTo(ps.hdc, 150+(ca.right - ca.left - 150)/2, ca.bottom);
      SelectObject(ps.hdc, hpenOld);
      DeleteObject(hpen);
      if(hViewerBitmap) {  // if a valid bitmap exists...
        SelectPalette(ps.hdc, hPalette, 0);
        RealizePalette(ps.hdc); // setup palette for dialog box
        hMemDC=CreateCompatibleDC(ps.hdc);
        SelectPalette(hMemDC, hPalette, 0);
        RealizePalette(hMemDC); // setup palette for memory DC
        old = SelectObject(hMemDC, hViewerBitmap);
        if(DoubleSize)
          StretchBlt(ps.hdc, ViewerImageArea.left, ViewerImageArea.top,
                     ViewerX * 2, ViewerY * 2,
                     hMemDC, 0, 0, ViewerX, ViewerY, SRCCOPY);
        else
          BitBlt(ps.hdc, ViewerImageArea.left, ViewerImageArea.top,
                 ViewerX, ViewerY,
                 hMemDC, 0, 0, SRCCOPY);
        SelectObject(hMemDC, old);
        DeleteDC(hMemDC);
        }
      EndPaint(hDlg, &ps);
      }
      return FALSE;
      break;

    case WM_COMMAND:
      switch (wParam)
        {
        case IDC_BITMAPLIST:
          if(HIWORD(lParam)==LBN_SELCHANGE) {   // an entry in list was selected
            if(hViewerBitmap)   {   // already one there, turf it.
              DeleteObject(hViewerBitmap);
              InvalidateRect(hDlg, (LPRECT)&ViewerImageArea, TRUE);
              }
            k = ListBox_GetCurSel(ViewerList);
            i = (int)ListBox_GetItemData(ViewerList, k);
            if(ShowingFloors)
              hViewerBitmap = TileFromDoom(i);
            else
            if(ShowingTextures)
              hViewerBitmap = TextureImageFromDoom(i);
            else
              hViewerBitmap = BitmapFromDoom(i);
            GetClientRect(hDlg, &ca);
            ViewerX = BitmapWidth;
            ViewerY = BitmapHeight;
            sprintf(szInfo, "%ix%i", BitmapWidth, BitmapHeight);
            Static_SetText(hInfo, szInfo);
            if(DoubleSize) {
              if(((ViewerOffsetX==0) && (ViewerOffsetY==0)) || !LockCenter) {
                ViewerImageArea.left  = 150;
                ViewerImageArea.top   = 10; }
              else {
                ViewerImageArea.left  = 150 + ((ca.right - ca.left - 150)/2) - ViewerOffsetX*2;
                ViewerImageArea.top   = ((ca.bottom - ca.top)/2) - ViewerOffsetY*2;
                }
              ViewerImageArea.right = ViewerImageArea.left + ViewerX*2;
              ViewerImageArea.bottom= ViewerImageArea.top + ViewerY*2; 
              InvalidateRect(hDlg, (LPRECT)&ViewerImageArea, TRUE); }
            else {
              if(((ViewerOffsetX==0) && (ViewerOffsetY==0)) || !LockCenter) {
                ViewerImageArea.left  = 150;
                ViewerImageArea.top   = 10; }
              else {
                ViewerImageArea.left  = 150 + ((ca.right - ca.left - 150)/2) - ViewerOffsetX;
                ViewerImageArea.top   = ((ca.bottom - ca.top)/2) - ViewerOffsetY; }
              ViewerImageArea.right = ViewerImageArea.left + ViewerX;
              ViewerImageArea.bottom= ViewerImageArea.top + ViewerY; }
            InvalidateRect(hDlg, (LPRECT)&ViewerImageArea, TRUE);
            }
          return FALSE;
          break;
        
        case IDC_USELOCK:    // use center coordinates
          LockCenter=!LockCenter;
          Button_SetCheck(hLock, LockCenter);
          GetClientRect(hDlg, &ca);
          if(DoubleSize) {
            if(((ViewerOffsetX==0) && (ViewerOffsetY==0)) || !LockCenter) {
              ViewerImageArea.left = 150;
              ViewerImageArea.top = 10;
              }
            else {
              ViewerImageArea.left  = 150 + ((ca.right - ca.left - 150)/2) - ViewerOffsetX*2;
              ViewerImageArea.top   = ((ca.bottom - ca.top)/2) - ViewerOffsetY*2;
              }
            ViewerImageArea.right = ViewerImageArea.left + ViewerX*2;
            ViewerImageArea.bottom= ViewerImageArea.top + ViewerY*2; 
            }
          else {
            if(((ViewerOffsetX==0) && (ViewerOffsetY==0)) || !LockCenter) {
              ViewerImageArea.left = 150;
              ViewerImageArea.top = 10;
              }
            else {
              ViewerImageArea.left  = 150 + ((ca.right - ca.left - 150)/2) - ViewerOffsetX;
              ViewerImageArea.top   = ((ca.bottom - ca.top)/2) - ViewerOffsetY;
              }
            ViewerImageArea.right = ViewerImageArea.left + ViewerX;
            ViewerImageArea.bottom= ViewerImageArea.top + ViewerY; 
            }
          ca.left+=150;
          InvalidateRect(hDlg, &ca, TRUE);
          break;
          
        case IDC_USEZOOM:    // double size option
          DoubleSize = !DoubleSize; // toggle it
          Button_SetCheck(hZoom, DoubleSize);
          GetClientRect(hDlg, &ca);
          if(DoubleSize) {
            if(((ViewerOffsetX==0) && (ViewerOffsetY==0)) || !LockCenter) {
              ViewerImageArea.left = 150;
              ViewerImageArea.top = 10;
              }
            else {
              ViewerImageArea.left  = 150 + ((ca.right - ca.left - 150)/2) - ViewerOffsetX*2;
              ViewerImageArea.top   = ((ca.bottom - ca.top)/2) - ViewerOffsetY*2;
              }
            ViewerImageArea.right = ViewerImageArea.left + ViewerX*2;
            ViewerImageArea.bottom= ViewerImageArea.top + ViewerY*2; 
            }
          else {
            if(((ViewerOffsetX==0) && (ViewerOffsetY==0)) || !LockCenter) {
              ViewerImageArea.left = 150;
              ViewerImageArea.top = 10;
              }
            else {
              ViewerImageArea.left  = 150 + ((ca.right - ca.left - 150)/2) - ViewerOffsetX;
              ViewerImageArea.top   = ((ca.bottom - ca.top)/2) - ViewerOffsetY;
              }
            ViewerImageArea.right = ViewerImageArea.left + ViewerX;
            ViewerImageArea.bottom= ViewerImageArea.top + ViewerY; 
            }
          ca.left+=150;
          InvalidateRect(hDlg, &ca, TRUE);
          return TRUE;
          break;
          
        case IDC_VIEWER_SPRITES:
          ListBox_ResetContent(ViewerList);
          for(i = 0; i < DoomEntries; i++)
            if((Doom[i].Type == WD_SPRITE) ||
               (Doom[i].Type == WD_STATUS) ||
               (Doom[i].Type == WD_LEVEL)  ||
               (Doom[i].Type == WD_MENU)   ||
               (Doom[i].Type == WD_GRAPHIC)) {
              k = ListBox_AddString(ViewerList, Doom[i].Title);
              ListBox_SetItemData(ViewerList, k, i);
              }
          ShowingFloors=FALSE;
          ShowingTextures = FALSE;
          ListBox_SetCurSel(ViewerList, Nothing);
          return FALSE;
          break;
          
        case IDC_VIEWER_PANELS:
          ListBox_ResetContent(ViewerList);
          for(i = 0; i < DoomEntries; i++)
            if(Doom[i].Type == WD_PANEL) {
              k = ListBox_AddString(ViewerList, Doom[i].Title);
              ListBox_SetItemData(ViewerList, k, i);
              }
          ShowingFloors=FALSE;
          ShowingTextures = FALSE;
          ListBox_SetCurSel(ViewerList, Nothing);
          return FALSE;
          break;
          
        case IDC_VIEWER_FLOORS:
          ListBox_ResetContent(ViewerList);
          for(i = 0; i < DoomEntries; i++)
            if(Doom[i].Type == WD_TILE) {
              k = ListBox_AddString(ViewerList, Doom[i].Title);
              ListBox_SetItemData(ViewerList, k, i);
              }
          ShowingFloors=TRUE;
          ShowingTextures = FALSE;
          ListBox_SetCurSel(ViewerList, Nothing);
          return FALSE;
          break;

        case IDC_VIEWER_TEXTURES:
          ListBox_ResetContent(ViewerList);
          for(i = 0; i < TexturesNum; i++) {
            k = ListBox_AddString(ViewerList, Texture[i].name);
            ListBox_SetItemData(ViewerList, k, i);
            }
          ShowingFloors=FALSE;
          ShowingTextures = TRUE;
          ListBox_SetCurSel(ViewerList, Nothing);
          return FALSE;
          break;

        case IDOK:              // OK button
          EndDialog(hDlg, IDOK);
          if(hViewerBitmap)
            DeleteObject(hViewerBitmap);
          hViewerBitmap = NULL;
          return TRUE;
          break;
          
        default:
          return FALSE;
          break;
        }
    default:
      return FALSE;
    }
}


