/*
 *  BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 *  Copyright (C) 1993  Hartmut Schirmer
 *
 *  see bccgrx.c for details
 */

#include "bccgrx00.h"

static unsigned short usr_pat = 0x0000;

#define user_len 32
static unsigned char user[user_len];

void getlinesettings(struct linesettingstype  *lineinfo)
{
  _DO_INIT_CHECK;
  lineinfo->linestyle = __gr_lstyle;
  lineinfo->upattern  = usr_pat;
  lineinfo->thickness = LNE.lno_width;
}

/* ----------------------------------------------------------------- */
void setlinestyle(int linestyle, unsigned upattern, int thickness)
{
  int i, j;

  _DO_INIT_CHECK;
  switch (linestyle) {
    case SOLID_LINE  : LNE.lno_pattlen = 0;
		       LNE.lno_dashpat = NULL;
		       break;
    case DOTTED_LINE : LNE.lno_pattlen = 3;
		       LNE.lno_dashpat = "\0\2\2";
		       break;
    case CENTER_LINE : LNE.lno_pattlen = 5;
		       LNE.lno_dashpat = "\0\3\4\3\6";
		       break;
    case DASHED_LINE : LNE.lno_pattlen = 5;
		       LNE.lno_dashpat = "\0\3\5\3\5";
		       break;
    case USERBIT_LINE: usr_pat = upattern;
		       if (upattern == 0xFFFF) {
			 LNE.lno_pattlen = 0;
			 LNE.lno_dashpat = NULL;
			 break;
		       }
		       j = 0;
		       user[0] = 0;
		       for (i=0; i < 16; ++i) {
			 if ( (upattern & 1) == 0) {
			   if ( (j&1) == 0) {
			     ++j;
			     user[j] = 0;
			   }
			   ++user[j];
			 } else {
			   if ( (j&1) != 0) {
			     ++j;
			     user[j] = 0;
			   }
			   ++user[j];
			 }
			 upattern >>= 1;
		       }
		       LNE.lno_pattlen = j+1;
		       LNE.lno_dashpat = user;
		       break;
    default          : ERR = grError;
		       return;
  }
  __gr_lstyle     = linestyle;
  LNE.lno_width   = thickness;
}
