/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 W_SECTOR.C - Sector types and properties.

*/

#include "deu.h"
#include "d_main.h"
#include "w_sector.h"

/*
   Get the highest valid sector type for the current game.
*/

int GetMaxSectorType(void)
{
  if (DoomVersion < 16)
    return 17; /* Doom */
  else
    return 51; /* Heretic */
}


/*
   Get a short (13 char.) description of the type of a sector.
*/

char *GetSectorTypeName(UInt16 type)
{
  switch (type)
    {
    case 0:
      return "Normal";
    case 1:
      return "Random off";
    case 2:
      return "Fast blink";
    case 3:
      return "Slow blink";
    case 4:
      return "-20% & blink";
    case 5:
      return "-10% health";
#ifdef ID_DID_IT
    case 6:
      return "Ceiling crush";
#endif
    case 7:
      return "-5% health";
    case 8:
      return "Light glows";
    case 9:
      return "Secret";
    case 10:
      return "Close door 30s";
    case 11:
      return "-20% & end lev";
    case 12:
      return "Fast blink syn";
    case 13:
      return "Slow blink syn";
    case 14:
      return "Open Door 5 mn";
    case 15:
      if (DoomVersion >= 16)
        return "Friction";
      else
#ifdef ID_DID_IT
        return "Creates ammo";
#else
        return "INVALID - DO NO USE!";
#endif
    case 16:
      return "-20% health";
    case 17:
      return "Light flickers";
    }
  return "DO NOT USE!";
}



/*
   Get a long description of the type of a sector.
*/

char *GetSectorTypeLongName(UInt16 type)
{
  switch (type)
    {
    case 0:
      return "Normal";
    case 1:
      return "Light goes off randomly (normally on)";
    case 2:
      return "Light blinks fast (twice per second)";
    case 3:
      return "Light blinks slow (once per second)";
    case 4:
      return "-20% health and light blinks fast";
    case 5:
      return "-10% health";
#ifdef ID_DID_IT
    case 6:
      return "Crushing ceiling";
#endif
    case 7:
      return "-5% health (nukage floor)";
    case 8:
      return "Light glows between set level and nearby level";
    case 9:
      return "Secret (credit if discovered)";
    case 10:
      return "Door closes after 30 seconds";
    case 11:
      return "-20% health and end level when health <= 10%";
    case 12:
      return "Light blinks fast, syncronized";
    case 13:
      return "Light blinks slow, syncronized";
    case 14:
      return "Door closes, then raises after 5 minutes";
    case 15:
      if (DoomVersion >= 16)
        return "Friction (player slows down)";
      else
#ifdef ID_DID_IT
        return "Creates ammo";
#else
        return "INVALID - DO NO USE!";
#endif
    case 16:
      return "-20% health";
    case 17:
      return "Light goes on and off randomly (flickers)";
    }
  return "INVALID - DO NOT USE!";
}

