/*--------------------------------------------------------------------------*

  maquina.c, la maquinaria para manipular wads,
  por LSJMDM, Corrales, Zamora, Espaa.
  v 1.02, Junio-1997.
*-------------------------------------------------------------------------*/
/*- FUNCS.C ----------------------------------------------------------------*/
/*- terminate the program reporting an error -------------------------------*/
static void ProgError( char *errstr, ...)
{
   va_list args;

   va_start( args, errstr);
   printf( "\nError de Programa: *** ");
   vprintf( errstr, args);
   printf( " ***\n");
   va_end( args);
   getche();
   exit( 5);
}
/*- allocate memory with error checking ------------------------------------*/
static __inline__ void *GetMemory( size_t size)
{
   void *ret = malloc( size);
   if (!ret)
      ProgError( "sin memoria (no se pueden colocar %u bytes)", size);
   return ret;
}
/*- reallocate memory with error checking ----------------------------------*/
static __inline__ void *ResizeMemory( void *old, size_t size)
{
   void *ret = realloc( old, size);
   if (!ret)
      ProgError( "sin memoria (no se pueden recolocar %u bytes)", size);
   return ret;
}
/*- get the directory from a wad file --------------------------------------*/
static __inline__ void OpenWadFile(char *filename)
{
	struct directory *dir;

	long n;

	if((infile = fopen(filename,"rb")) == NULL)
		{
		printf("Error: No se puede localizar el fichero WAD %s", filename);
		exit(1);
		}

	wad = GetMemory( sizeof( struct wad_header));

	fread(wad,sizeof( struct wad_header),1,infile);

	printf("Fichero %c%c%c%c abierto: %s. %lu entradas en offset %lu.\n",
		wad->type[0],wad->type[1],wad->type[2],wad->type[3],filename,
		wad->num_entries,wad->dir_start);

	direc = dir = GetMemory( sizeof( struct directory) * wad->num_entries);

	outdirec = GetMemory( sizeof( struct directory));//Memoria para el directorio de salida
	fseek(infile,wad->dir_start,0);

	for(n = 0; n < wad->num_entries; n++)
		{
		fread(dir,sizeof( struct directory),1,infile);
/*		Printname(dir);
		printf(" of size %lu at %lu.\n",dir->length,dir->start);*/
		dir++;
		}
}
/*- find the offset into the directory of a resource -----------------------*/
/*
static __inline__ int FindDir(char *name)
{
	struct directory *dir;
	int n;

	dir = direc;

	for(n=0; n< wad->num_entries; n++)
  	  if(strncmp(dir++->name,name,8) == 0) return n;
	ProgError( "No se puede localizar %s en el directorio del WAD", name);
	return 0;
}*/

/*- read the things from the wad file and place in 'things' ----------------*/

static __inline__ void GetThings(int nivel)
{
	int n;

	n = FindDirSeek("THINGS", nivel);
	if(direc[n].length == 0) ProgError("No se encuentra el lump THINGS");
	num_things = (direc[n].length) / (sizeof( struct Thing));
//	printf("Colcando %lu bytes para %d things\n",direc[n].length,num_things);
//	printf("%s\n", direc[n].name);
	things = GetMemory( direc[n].length);
	fseek(infile,direc[n].start,0);
	fread(things,direc[n].length,1,infile);
}

/*- read the vertices from the wad file and place in 'vertices' ------------
    Rewritten by Lee Killough, to speed up performance                       */

static __inline__ void GetVertexes(int nivel)
{
	long n,used_verts,i;
        int *translate;

	n = FindDirSeek("VERTEXES", nivel);

	if(direc[n].length == 0)
	  ProgError("No se puede localizar ningn vrtice en el WAD");

	fseek(infile,direc[n].start,0);

	num_verts = (direc[n].length) / (sizeof( struct Vertex));

	vertices = GetMemory(sizeof(struct Vertex)*num_verts);
        translate = GetMemory(num_verts*sizeof(*translate));

	fread(vertices,direc[n].length,1,infile);

        for (n=0;n<num_verts;n++)     /* Unmark all vertices */
          translate[n]= -1;

        for (i=n=0;i<num_lines;i++)   /* Mark all used vertices */
         {                            /* Remove 0-length lines */
          int s=linedefs[i].start;
          int e=linedefs[i].end;
          if (s<0 || s>=num_verts || e<0 || e>=num_verts)
            ProgError("Un Linedef tiene un vrtice fuera de lugar(out of range)\n");
          if (vertices[s].x!=vertices[e].x || vertices[s].y!=vertices[e].y)
           {
            linedefs[n++]=linedefs[i];
            translate[s]=translate[e]=0;
           }
         }
        i-=num_lines=n;
        used_verts=0;

        for (n=0;n<num_verts;n++)     /* Sift up all unused vertices */
          if (!translate[n])
            vertices[translate[n]=used_verts++]=vertices[n];

/*        else
           printf("El Vrtice [%d] no es usado.\n",n); */

        for (n=0;n<num_lines;n++)     /* Renumber vertices */
         {
          int s=translate[linedefs[n].start];
          int e=translate[linedefs[n].end];
          if (s < 0 || s >= used_verts || e < 0 || e >= used_verts)
            ProgError("Problema en GetVertexes: Renumerando\n");
          linedefs[n].start=s;
          linedefs[n].end=e;
         }

 	free(translate);
        if(!gfxsi && !ver)
	   printf("Se leyeron %ld vertices, aunque %ld estaban sin usar.\nSe eliminaron %ld Linedefs de longitud 0.\n",
	       num_verts,num_verts-used_verts,i);
	num_verts = used_verts;
}

/*- read the linedefs from the wad file and place in 'linedefs' ------------*/

static __inline__ void GetLinedefs(int nivel)
{
	int n;

	n = FindDirSeek("LINEDEFS", nivel);
	if(direc[n].length == 0) ProgError("No se puede encontrar ningn Linedef");
	num_lines = (direc[n].length) / (sizeof( struct LineDef));
//	printf("Colocando %lu bytes para %d Linedefs\n",direc[n].length,num_lines);
  	linedefs = GetMemory( direc[n].length);
	fseek(infile,direc[n].start,0);
	fread(linedefs,direc[n].length,1,infile);
}

/*- read the sidedefs from the wad file and place in 'sidedefs' ------------*/

static __inline__ void GetSidedefs(int nivel)
{
	int n;

	n = FindDirSeek("SIDEDEFS", nivel);
	if(direc[n].length == 0) ProgError("No se puede encontrar ningn Sidedef");
	num_sides = (direc[n].length) / (sizeof( struct SideDef));
//      printf("Colocando %u bytes para %d Sidedefs\n",direc[n].length,num_sides);
        sidedefs = GetMemory( direc[n].length);
	fseek(infile,direc[n].start,0);
	fread(sidedefs,direc[n].length,1,infile);
}

/*- read the sectors from the wad file and place in 'sectors' ------------*/

static __inline__ void GetSectors(int nivel)
{
	int n;

	n = FindDirSeek("SECTORS", nivel);
	if(direc[n].length == 0) ProgError("No se puede encontrar ningn Sector");
	num_sects = (direc[n].length) / (sizeof( struct Sector));
//	printf("Colcando %lu bytes para %d Sectores\n",direc[n].length,num_sects);
	sectors = GetMemory( direc[n].length);
	fseek(infile,direc[n].start,0);
	fread(sectors,direc[n].length,1,infile);
}  
void Leenodos(int nivel)
{
     int n;

     n = FindDirSeek("NODES", nivel);
     if(direc[n].length == 0) ProgError("El nivel %s no tiene los nodos construidos", direc[n-1].name);
     num_pnodes =(direc[n].length) / (sizeof( struct Pnode));
//   printf("Colocando %lu bytes para %d Nodos\n", direc[n].length, num_pnodes);
     pnodes = GetMemory( direc[n].length);
     fseek(infile, direc[n].start, 0);
     fread(pnodes, direc[n].length, 1, infile);
}
void Leereject(int nivel)
{
     int n;

     n = FindDirSeek("REJECT", nivel);
     if(direc[n].length == 0) ProgError("El nivel %s no tiene reject", direc[n-1].name);
     data = GetMemory( direc[n].length);
     fseek(infile, direc[n].start, 0);
     fread(data, direc[n].length, 1, infile);
}
static __inline__ Bool Encuentranivel(int nivel)
{
//printf("findir:things nivel= %i== %i\n",nivel,FindDirSeekNivel("THINGS", nivel)); 
  if(FindDirSeekNivel("THINGS", nivel)==1)
  {
//   printf("encuentranivel retorna 1 para nivel = %i\n", nivel);
     return 1;
  }
//printf("encuentranivel retorna 0 para nivel = %i\n", nivel);
  return 0;
}
/*- find the offset into the directory of a resource, pero controlando  ----*/
static __inline__ int FindDirSeek(char *name, int nivel)
{
	struct directory *dir;
	int n, anterior = 0, vez = 1;

	dir = direc;
        //escanea el directorio, con un offset dado por anterior
     /* for(n=0; n< wad->num_entries; n++)
  	  if(strncmp(dir++->name,name,8) == 0) return n;*/
        for(n=anterior; n< wad->num_entries; n++)
  	{  
//  	    printf("%s\n", dir->name);
  	    if(strncmp(dir++->name, name, 8) == 0) 
  	    {
  	       if(vez == nivel) return n;//sale del for
  	       anterior = n;
  	       vez++;//siguiente nivel
  	       anterior++;//busca a partir del offset del primero 
  	    }   
   	    //Incrementa el directorio(en el bucle de comparacion).
   	}     
	ProgError( "FindDirSeek: No se puede localizar %s en el WAD, nivel %i", 
	name, nivel);
	return 0;
} 
static __inline__ Bool FindDirSeekNivel(char *name, int nivel)
{
	struct directory *dir;
	int n, anterior, vez=1;

	dir = direc;
        anterior = 0;
        //escanea el directorio, con un offset dado por anterior
          for(n=anterior; n < wad->num_entries; n++)
  	  {  
//  	    printf("%s\n", dir->name);
  	    if(strncmp(dir->name,name,8) == 0) 
  	    {
//  	       printf("vez = %i\nnivel = %i\n", vez, nivel);
  	       anterior = n;
  	       if(vez == nivel) return 1;//sale del for
//  	       anterior;//busca a partir del offset encontrado!!   
  	       vez++;//siguiente nivel
  	    }   
   	    dir++;//incrementa el directorio
   	  }     
          return 0;//si llega aqu es por que no ha encontrado nada para
  	           //un nivel dado.
}
void Guardanivel(int nivel)
{
    fwrite(things,(sizeof(struct Thing)*num_things),1,outfile);
	if(debug && !gfxsi)
	  printf("Escritos %li bytes en THINGS\n", (sizeof(struct Thing)*num_things));
	fwrite(linedefs,(sizeof(struct LineDef)*num_lines),1,outfile);
	if(debug && !gfxsi)
	  printf("Escritos %li bytes en LINEDEFS\n", (sizeof(struct LineDef)*num_lines));
	fwrite(sidedefs,(sizeof(struct SideDef)*num_sides),1,outfile);
	if(debug && !gfxsi)
	  printf("Escritos %li bytes en SIDEDEFS\n", (sizeof(struct SideDef)*num_sides));
	fwrite(vertices,(sizeof(struct Vertex)*num_verts),1,outfile);
	if(debug && !gfxsi)
	  printf("Escritos %li bytes en VRTICES\n", (sizeof(struct Vertex)*num_verts));
	fwrite(psegs,(sizeof(struct Pseg)*num_psegs),1,outfile);
	if(debug && !gfxsi)
	  printf("Escritos %li bytes en SEGS\n", (sizeof(struct Pseg)*num_psegs));
	fwrite(ssectors,(sizeof(struct SSector)*num_ssectors),1,outfile);
	if(debug && !gfxsi)
	  printf("Escritos %li bytes en SUBSECTORS\n", (sizeof(struct SSector)*num_ssectors));
	fwrite(pnodes,(sizeof(struct Pnode)*num_pnodes),1,outfile);
	if(debug && !gfxsi)
	  printf("Escritos %li bytes en NODOS\n", (sizeof(struct Pnode)*num_pnodes));
	fwrite(sectors,(sizeof(struct Sector)*num_sects),1,outfile);
	if(debug && !gfxsi)
	  printf("Escritos %li bytes en SECTORES\n", (sizeof(struct Sector)*num_sects));
	fwrite(data, reject_size, 1, outfile);
	if(debug && !gfxsi)
	  printf("Escritos %li bytes en REJECT\n", reject_size);
	fwrite(&blockhead,(sizeof(struct Block)),1,outfile);
	if(debug && !gfxsi)
	  printf("Escritos %li bytes en BLOCKMAP #1\n", (sizeof(struct Block)));
	fwrite(blockptrs, blockptrs_size, 1, outfile);
	if(debug && !gfxsi)
	  printf("Escritos %li bytes en BLOCKMAP #2\n", blockptrs_size);
	fwrite(blocklists, blockmap_size, 1, outfile);
	if(debug && !gfxsi)
	  printf("Escritos %li bytes en BLOCKMAP #3\n", blockmap_size);
}	 
void GuardaLump(int lump)
{
	char *buffer;
	long lump_start;
	
	buffer = GetMemory( direc[lump].length);
	fseek(infile, direc[lump].start, 0);
	fread(buffer, direc[lump].length, 1, infile);
	fwrite(buffer, direc[lump].length, 1, outfile);
	free( buffer);
	
	//RECOLOCA el directorio de salida
	outdirec = ResizeMemory( outdirec, sizeof(struct directory)*(dir_entries+1));
	lump_start = dir_start;//Ejem
	//Calcula el start del nuevo lump
	dir_start = dir_start + (direc[lump].length);
	//Copia el offset y la longitud
	outdirec[dir_entries].start = lump_start;
	outdirec[dir_entries].length = direc[lump].length;
	//Copia el nombre
	strcpy(outdirec[dir_entries].name , direc[lump].name);
	//Incrementa el numero de lump
	dir_entries++;
}	

void freemem(void)
{
        free(things);
        free(vertices);
        free(linedefs);
        free(sidedefs);
        free(sectors);
        free(ssectors);
        free(psegs);
        free(pnodes);
        free(tsegs);
        free(nodelist);
        free(data);
        free(blockptrs);
        free(blocklists);
                    
	num_ssectors = 0;
	num_psegs = 0;//Si esto no es cero, se bloquea

	blocklists = NULL;	
	psegs = NULL;
	pnodes = NULL;
	tsegs = NULL;
	nodelist = NULL;

    	pixel = 0;//para gprogress()
}
void Leenivel(int nivel)
{
          GetThings(nivel);/* of wad file */
	  GetLinedefs(nivel);/* Get linedefs and vertices */
	  GetVertexes(nivel);/* and delete redundant. */
	  GetSidedefs(nivel);
	  GetSectors(nivel);        
}	  
void Salvanivel(int nivel)
{
          int n;
          outdirec = ResizeMemory( outdirec, sizeof(struct directory)*(dir_entries+10));

  	  //Copia el nombre del nivel
  	  n = FindDirSeek("THINGS", nivel)-1;
  	  strcpy(outdirec[dir_entries].name, direc[n].name);
  	  dir_entries++;/* Skip level number*/
  	  
	  things_start = dir_start;
	  dir_start = dir_start + (sizeof(struct Thing)*num_things);
//	  direc[dir_entries].start = things_start;
//	  direc[dir_entries].length = (sizeof(struct Thing)*num_things);
          outdirec[dir_entries].start = things_start;
          outdirec[dir_entries].length = (sizeof(struct Thing)*num_things);
	  strcpy(outdirec[dir_entries].name , "THINGS");
          dir_entries++;

          linedefs_start = dir_start;
          dir_start = dir_start + (sizeof(struct LineDef)*num_lines);
//	  direc[dir_entries].start = linedefs_start;
//	  direc[dir_entries].length = (sizeof(struct LineDef)*num_lines);
	  outdirec[dir_entries].start = linedefs_start;
	  outdirec[dir_entries].length = (sizeof(struct LineDef)*num_lines);
	  strcpy(outdirec[dir_entries].name , "LINEDEFS");
	  dir_entries++;

	  sidedefs_start = dir_start;
	  dir_start = dir_start + (sizeof(struct SideDef)*num_sides);
//	  direc[dir_entries].start = sidedefs_start;
//	  direc[dir_entries].length = (sizeof(struct SideDef)*num_sides);
	  outdirec[dir_entries].start = sidedefs_start;
	  outdirec[dir_entries].length = (sizeof(struct SideDef)*num_sides);
	  strcpy(outdirec[dir_entries].name, "SIDEDEFS");
	  dir_entries++;

          vertices_start = dir_start;
	  dir_start = dir_start + (sizeof(struct Vertex)*num_verts);
//	  direc[dir_entries].start = vertices_start;
//	  direc[dir_entries].length = (sizeof(struct Vertex)*num_verts);
	  outdirec[dir_entries].start = vertices_start;
	  outdirec[dir_entries].length = (sizeof(struct Vertex)*num_verts);
	  strcpy(outdirec[dir_entries].name, "VERTEXES");
	  dir_entries++;

	  segs_start = dir_start;
	  dir_start = dir_start + (sizeof(struct Pseg)*num_psegs);
//	  direc[dir_entries].start = segs_start;
//	  direc[dir_entries].length = (sizeof(struct Pseg)*num_psegs);
	  outdirec[dir_entries].start = segs_start;
	  outdirec[dir_entries].length = (sizeof(struct Pseg)*num_psegs);
	  strcpy(outdirec[dir_entries].name, "SEGS");
	  dir_entries++;

	  ssectors_start = dir_start;
	  dir_start = dir_start + (sizeof(struct SSector)*num_ssectors);
//	  direc[dir_entries].start = ssectors_start;
//	  direc[dir_entries].length = (sizeof(struct SSector)*num_ssectors);
	  outdirec[dir_entries].start = ssectors_start;
	  outdirec[dir_entries].length = (sizeof(struct SSector)*num_ssectors);
	  strcpy(outdirec[dir_entries].name, "SSECTORS");
	  dir_entries++;

	  pnodes_start = dir_start;
	  dir_start = dir_start + (sizeof(struct Pnode)*num_pnodes);
//	  direc[dir_entries].start = pnodes_start;
//	  direc[dir_entries].length = (sizeof(struct Pnode)*num_pnodes);
	  outdirec[dir_entries].start = pnodes_start;
	  outdirec[dir_entries].length = (sizeof(struct Pnode)*num_pnodes);
	  strcpy(outdirec[dir_entries].name, "NODES");
	  dir_entries++;

	  sectors_start = dir_start;
	  dir_start = dir_start + (sizeof(struct Sector)*num_sects);
//	  direc[dir_entries].start = sectors_start;
//	  direc[dir_entries].length = (sizeof(struct Sector)*num_sects);
	  outdirec[dir_entries].start = sectors_start;
	  outdirec[dir_entries].length = (sizeof(struct Sector)*num_sects);
	  strcpy(outdirec[dir_entries].name, "SECTORS");
	  dir_entries++;

	  reject_start = dir_start;
	  dir_start+=reject_size;
//	  direc[dir_entries].start = reject_start;/* Skip reject map*/
//	  direc[dir_entries].length = reject_size;
	  outdirec[dir_entries].start = reject_start;/* Skip reject map*/
	  outdirec[dir_entries].length = reject_size;
	  strcpy(outdirec[dir_entries].name, "REJECT");
	  dir_entries++;
        
	  blockmap_start = dir_start;
	  dir_start = dir_start + (blockmap_size+blockptrs_size+8);
//	  direc[dir_entries].start = blockmap_start;
//	  direc[dir_entries].length = (blockmap_size+blockptrs_size+8);
	  outdirec[dir_entries].start = blockmap_start;
	  outdirec[dir_entries].length = (blockmap_size+blockptrs_size+8);
	  strcpy(outdirec[dir_entries].name, "BLOCKMAP");
	  dir_entries++;
}
void ConstruyeNodos(int nivel)
{
	Leenivel(nivel);
  
  	num_tsegs = 0;
     if(bsp15)
	  	tsegs = CreateSegs15();	  	/* Initially create segs*/
     else
     	tsegs = CreateSegs21();		/* Idem	*/

 	FindLimits(tsegs);			/* Find limits of vertices*/

  	mapminx = lminx;			/* store as map limits*/
	mapmaxx = lmaxx;
	mapminy = lminy;
	mapmaxy = lmaxy;

     if(bsp15) printf("Usando BSP 1.5x\n");
     if(bsp21) printf("Usando BSP 2.1x\n");

  	   printf("El mapa va desde (%d,%d) hasta (%d,%d)\n",lminx,lminy,lmaxx,lmaxy);
        printf("VRTICES %li\n", num_verts);
        printf("LINEDEFS %li\n", num_lines);
        printf("SIDEDEFS %li\n", num_sides);
        printf("SECTORES %li\n", num_sects);
        if(gfxsi)
        {
            Iniciagraf();
            Dibujacontorno();
            DibujaMapa();
        }
        
        if(idbsp)
        {
//           BuildBSP();
        }
        else
        {
            reject_size = (num_sects*num_sects+7)/8;
            if(!gfxsi)
               printf("Creando el REJECT\n");
            if(jmreject)
            {
 	       if(!gfxsi)
	       	   printf("Distancia entre sectores: %i\n", dstreject);
	       data = CreaReject(dstreject); /* Por LSJmDM */
	    }
	    else
	       	data = CreateRejectData();/* de DEU 5.3*/
	    if(!gfxsi)
	       	printf("Creando los NODOS usando un factor %d\n",factor);
	    num_nodes = 0;
         nodelist = CreateNode(tsegs);/* Por Colin Reed */						/* recursively create nodes*/
         if(!gfxsi)
              	printf("Se crearon %lu NODOS, con %lu SSECTORS.\n",num_nodes,num_ssectors);
         pnodes = GetMemory(sizeof(struct Pnode)*num_nodes);
 	    num_pnodes = 0;
	    pnode_indx = 0;
	    ReverseNodes(nodelist);
	    if(!gfxsi)
            	printf("Creando BLOCKMAP\n");
            blockmap_size = CreateBlockmap();
        }
        Salvanivel(nivel);
}	  
//EOF