/*
  WAD_DWD.C - version 1.0 (06/03/94)
  (c) 1994 Ron Rossbach (ej070@cleveland.freenet.edu)

  This program converts an ordinary WAD file into a slightly extended version
  of a DWD file.  The DWD file can then be used as input to IDBSP

  This program is provided with NO WARRANTY.

  Use and distribution of this code permitted according to the terms of the GNU
	General Public License.
*/

#include "wad_dwd.h"
#define VERSION "1.1BETA"

/*
===============
=
= main
=
===============
*/
int main(int argc, char *argv[])
{
	char dwd_name[81] = { '\0' };
	char wad_name[81];
	char tmp[9];
	char level_name[81];
	char *specific_levels[MAX_SPECIFIC];
	int		num_specific = 0;
	FILE *dwd,*wad;
	int i;
	int episode, level;
	boolean specific_level = false;
	boolean firstfile = true;
	lumpinfo_t *lumps = NULL;
	wadinfo_t wadheader;

	printf("**** WAD_DWD - a WAD->DWD converter for DOOM - version %s ****"
				"\n**** (c) 1994 Ron Rossbach (ej070@cleveland.freenet.edu)       ****"
				"\n\nDOOM is a registered trademark of id Software, Inc."
				"\n\nSee the accompanying README for terms of use, distribution, etc.",
				VERSION);

	if (argc < 2 || argc > 4)
		{
		printf("\n\nUsage: \"wad_dwd wadfile [-level=maplevel1,...] [dwdfile]\""
					"\nTMP.DWD is the default if dwdfile is not specified.");
		Error("\nExiting....");
		}

	for (i=1; i<argc; i++)
		{
		if (*argv[i] == '-')
			{
			if (!strncmp(argv[i],"-level",6))
				{
				num_specific = ParseSpecificLevels(argv[i], specific_levels);
				specific_level = true;
				}
			else
				Error("\nUnrecognized argument");
			}
		else
			{
			if (firstfile)
				{
				firstfile = false;
				strcpy(wad_name, argv[i]);
				}
			else
				strcpy(dwd_name, argv[i]);
			}
		}

	if (!dwd_name[0])
		strcpy(dwd_name,"tmp.dwd");

	if ((wad = fopen(wad_name,"rb"))==NULL)
		Error("Cannot open WAD file");

	if ((dwd = fopen(dwd_name,"w"))==NULL)
		{
		fclose(wad);
		Error("Cannot open DWD file");
		}

	/*
		Read the WAD header
	*/
	fread(&wadheader,sizeof(wadinfo_t),1,wad);
	fseek(wad, wadheader.infotableofs, SEEK_SET);

	printf("\n\nWAD file: %s\nDWD file: %s\n",wad_name,dwd_name);

	/*
		Read the WAD directory
	*/
	lumps = ReadWAD(wad, wadheader.numlumps, sizeof(lumpinfo_t));

	/*
		Process directory entries
	*/
	WriteHeader(dwd);
	for (i=0; i<wadheader.numlumps; i++)
		{
		strncpy(tmp, lumps[i].name, 8);
		tmp[8] = '\0';

		/* Handle map levels */
/*
		if (specific_level)
			{
			if (!strcmp(tmp, level_name))
				{
				printf("\nWriting Level: %s",tmp);
				fprintf(dwd,"\nlevel:%s\n",tmp);
				ExtractLevel(wad, dwd, &lumps[i]);
				i += 10;
				}
			continue;
			}
*/

		if (sscanf(tmp,"E%dM%d",&episode,&level) == 2 ||
				sscanf(tmp,"MAP%d",&level) == 1)
			{
			if (specific_level)
			{
				if (TestSpecificLevel(tmp, specific_levels, num_specific))
				{
					printf("\nWriting Specific Level: %s",tmp);
					fprintf(dwd,"\nlevel:%s\n",tmp);
					ExtractLevel(wad, dwd, &lumps[i]);
				}
				i += 10;
				continue;
			}
			printf("\nWriting Level: %s",tmp);
			fprintf(dwd,"\nlevel:%s\n",tmp);
			ExtractLevel(wad, dwd, &lumps[i]);
			i += 10;
			}
		/* Other Resources */
		else if (!specific_level && *tmp)
			{
			printf("\nWriting Resource: %s",tmp);
			fprintf(dwd, "\n%s :%d\n", tmp, lumps[i].size);
			ExtractResource(wad, &lumps[i]);
			}
		}

		free(lumps);
		fclose(wad);
		fclose(dwd);

		return 0;
}

/*
===============
=
= progress
=
= provides some visual feedback for the user....
=
===============
*/
void progress(void)
{
				char *s="/-\\|/-\\|";
				static unsigned char pcnt=0;

				if((pcnt&15) == 0)
								{
								printf("%c\b",s[((pcnt)/16)&7]);
								fflush(stdout);
								}
				pcnt++;
}

/*
====================
=
= Error
=
= Displays an error message and exits program
=
====================
*/
void Error (char *error, ...)
{
				va_list argptr;
				va_start (argptr,error);
				vprintf (error,argptr);
				va_end (argptr);
				printf ("\n");
				exit (1);
}


void *SafeCalloc(unsigned num, size_t size)
{
				void *ret = (void *)calloc(num,size);
				if (!ret)
								Error("\nSafeCalloc: Failed to allocate %u of %u bytes",num,size);

				return ret;
}

