/* command.c */
/*
 
 * Copyright 1994 A.Oliver De Guzman
 * All rights reserved

 *   Permission is granted to any individual to copy, use, and/or
 * distribute this software provided that the distribution retains this
 * entire copyright notice. No part of this software may be used and/or
 * sold for profit or used with any commercial product.

 * DISCLAIMER:
 *   This software comes with NO WARRANTIES of any kind. In no event
 * will the author be liable for any financial, physical, moral, and/or
 * mental damages incurred directly or indirectly by the use or intent
 * to use of this software.
 
 */

#include <stdlib.h>
#include <string.h>
#include "dfcss.h"
#include "server.h"
#include "node.h"
#include "sockio.h"
#include "fileio.h"

void PrintStat();
void PrintSet();
void Banner();
void ListServers();
void Who();
void QuitCmd();
void Help();
extern void HelpSet();
void ToPlayer();
void ToGuest();

typedef struct{
	char *name;
	void (*func)();
} Command;

Command commands[] = {
	{ "status", PrintStat },
	{ "stat", PrintStat },
	{ "who", Who },
    { "quit", QuitCmd },
	{ "banner", Banner },
	{ "servers", ListServers },
	{ "player", ToPlayer },
	{ "guest", ToGuest },
	{ "help", Help },
	{ "help set", HelpSet },
	{ "?", Help },
};
#define NCOMMANDS		(sizeof(commands)/sizeof(Command))

char *helpstr[] = {
	"/status                - print server status",
	"/set <param> <value>   - set the value of parameter <param>",
	"/who                   - list all nodes logged in",
	"/banner                - print server's banner message",
	"/servers               - list all known servers",
	"/player                - become a player",
	"/guest                 - become a guest",
	"/help                  - this help message",
	"/help set              - list parameter names",
	"/quit                  - quit",
};
#define NHELP		(sizeof(helpstr)/sizeof(char *))
	

int ServerStat(sd)
int sd;
{
	extern int NUMPLAYERS;
	char msg[MAXMSG+1], buff[64];
	int i;

	sprintf(msg, "* Server version: %s", SERVERID);
	sprintf(buff, "\n* Current Game: %d Player Game, %d Players, %d Guest(s)",
		NUMPLAYERS, NumPlayers(), NumGuests());
	strcat(msg, buff);
	if (NumPlayers()){
		strcat(msg, "\n");
		strcat(msg, PlayersStat());
	}
	if (NumGuests()){
		strcat(msg, "\n");
		strcat(msg, GuestsStat());
	}
	ASockWrite(sd, msg);
}

void PrintStat()
{
	int i;
	ServerStat(nodes[nodeidx].sd);
}

void Banner()
{
	extern char banner[];
	ASockWrite(nodes[nodeidx].sd, banner);
}

static char servers[MAXMSG+1];
void ListServers()
{
	extern char SERVERLIST[];

	servers[0] = '\0';
	if (readfile(SERVERLIST, servers, MAXMSG) < 0)
		sprintf(servers, "List of Servers not found[%s].", SERVERLIST);
	ASockWrite(nodes[nodeidx].sd, servers);
}

void Who()
{
	if (NumPlayers()) ASockWrite(nodes[nodeidx].sd, PlayersStat());
	if (NumGuests()) ASockWrite(nodes[nodeidx].sd, GuestsStat());
}

void ToPlayer()
{
	extern int NUMPLAYERS;

	if (NumPlayers() < NUMPLAYERS && !IsUnused(nodes[nodeidx]))
		nodes[nodeidx].type = PLAYER;
	ServerStat(nodes[nodeidx].sd);
}

void ToGuest()
{
	if (NumGuests() < MAX_GUESTS && !IsUnused(nodes[nodeidx]))
		nodes[nodeidx].type = GUEST;
	ServerStat(nodes[nodeidx].sd);
}

void QuitCmd()
{
	ASockWrite(nodes[nodeidx].sd, ABORT);
	ResetNode();
}

void Help()
{
	char msg[MAXMSG+1];
	int i;

	msg[0] = '\0';
	for (i=0; i< NHELP; i++){
		strncat(msg, "\n", MAXMSG);
		strncat(msg, helpstr[i], MAXMSG);
	}

	ASockWrite(nodes[nodeidx].sd, msg);
}

int DoCommand(n, command)
int n;
char *command;
{
	int i;

	nodeidx = n;

	for (i=0; i<NCOMMANDS; i++){
		if (!strcmp(command+1, commands[i].name)){
			(commands[i].func)();
			return(i);
		}
	}
	return(-1);
}
