/* config.c */
/*
 
 * Copyright 1994 A.Oliver De Guzman
 * All rights reserved

 *   Permission is granted to any individual to copy, use, and/or
 * distribute this software provided that the distribution retains this
 * entire copyright notice. No part of this software may be used and/or
 * sold for profit or used with any commercial product.

 * DISCLAIMER:
 *   This software comes with NO WARRANTIES of any kind. In no event
 * will the author be liable for any financial, physical, moral, and/or
 * mental damages incurred directly or indirectly by the use or intent
 * to use of this software.
 
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "config.h"

#define MAXPATH			1024

int readconfig(fname, configs, nconfigs)
char *fname;
Config configs[];
int nconfigs;
{
	FILE *fp;
	char *home, *comment, path[MAXPATH];
	char line[MAXCFGLINE];
	char line2[MAXCFGLINE];
	int n=0, k=0;

	strcpy(path, fname);

	if (!(fp = fopen(path, "r"))) return -1;

	while (fgets(line, MAXCFGLINE, fp) != NULL){
		k += strlen(line);
		while (isspace(line[strlen(line)-1]))
			line[strlen(line)-1] = '\0';

		while (!((comment=(char *)strstr(line,"#")) &&
			!(comment!=line && (*(comment-1)=='%'))) &&
			line[strlen(line)-1] == '\\'){

			line[strlen(line)-1] = '\0';
			if (fgets(line2, MAXCFGLINE,fp))
				strncat(line, line2, MAXCFGLINE);
		}

		if (comment && !(comment!=line && (*(comment-1)=='%')))
			*comment = '\0';

		 n += (configline(line, configs, nconfigs) != -1);
	}

	fclose(fp);
	return(n);
}


int configline(line, configs, nconfigs)
char *line;
Config configs[];
int nconfigs;
{
	char name[MAXCFGLINE], *s;
	int i, n= -1;

	name[0] = '\0';
	sscanf(line," %[_A-Za-z]", name);
	for (i=0; i<nconfigs; i++){
		if (!strcmp(name, configs[i].cfgname)){
			n = i;
			switch (configs[i].cfgtype){
				case CFG_KEY :
					break;
				case CFG_INT :
					sscanf(line," %[_A-Za-z] %d",name,configs[i].cfgvar);
					break;
				case CFG_CHAR :
					sscanf(line," %[_A-Za-z] %c",name,configs[i].cfgvar);
					break;
				case CFG_STR :
					s = line+strlen(name);
					while (*s && isspace(*s)) s++;
					strcpy((char *)configs[i].cfgvar, s);	
					break;
				default:
					break;
			}
		}
	}
	return(n);
}
