#ifndef __WADHDR_H__
#define __WADHDR_H__

/**********************************************************************************************************************************/
/********************************************************* Documentation **********************************************************/
/**********************************************************************************************************************************/

/*

Wad file header

*/

/**********************************************************************************************************************************/
/*********************************************************** Systemics ************************************************************/
/**********************************************************************************************************************************/

// Includes
#include "services.h"
#include "waddef.h"

/**********************************************************************************************************************************/
/******************************************************** WAD File Header *********************************************************/
/**********************************************************************************************************************************/

// WAD file header
typedef struct
{
	char magic[5];												// magic string ("IWAD" or "PWAD")
	size_t num_entries;											// entry count
	fofs_t dir_start;											// start of directory
}
WADHDR_t;

/**********************************************************************************************************************************/
/************************************************** WAD File Header Maintanance ***************************************************/
/**********************************************************************************************************************************/

// Initialise a WAD file header
void WADInitHeader (
	WADHDR_t **WADHDRp);										// WAD file header to be initialised

// Deinitialise a WAD file header
void WADDoneHeader (
	WADHDR_t **WADHDRp);										// WAD file header to be deinitialised

/**********************************************************************************************************************************/
/***************************************************** WAD File Header Usage ******************************************************/
/**********************************************************************************************************************************/

// Read a WAD file header into memory from a file
void WADReadHeader (
	WADHDR_t *WADHDR,											// WAD file header to read from file
	FILE *infile);												// file to read WAD file header from

// Write a WAD file header from memory out to a file
void WADWriteHeader (
	const WADHDR_t *WADHDR,										// WAD file header to write to file
	FILE *outfile);												// file to write WAD file header to

/**********************************************************************************************************************************/
/********************************************************** End of File ***********************************************************/
/**********************************************************************************************************************************/

#endif // __WADHDR_H__
