#ifndef __WAD__LIN_H__
#define __WAD__LIN_H__

/**********************************************************************************************************************************/
/********************************************************* Documentation **********************************************************/
/**********************************************************************************************************************************/

/*

Wad lump type identification by name

*/

/**********************************************************************************************************************************/
/*********************************************************** Systemics ************************************************************/
/**********************************************************************************************************************************/

// Includes
#include "services.h"
#include "waddef.h"

/**********************************************************************************************************************************/
/****************************************************** Lump Identification *******************************************************/
/**********************************************************************************************************************************/

// Identify lump kind by metrics
kind_t LINIdentifyLumpKindByMetrics (
	const char *s,												// name of the lump whose kind is to be determined
	list_t list,												// list membership of the lump
	game_t game);												// game in which this combination of lump name and list appears

// Identify lump type by syntax then name
type_t LINIdentifyLumpTypeBySyntaxThenName (
	const char *s,												// lump to be identified
	size_t index,												// index of entry in WAD directory
	bool_t identify_names,										// identify screen images by name (READ MANUAL BEFORE USING!)
	bool_t identify_pages,										// identify screen images as pages (READ MANUAL BEFORE USING!)
	bool_t identify_graphics,									// identify screen images as graphics (READ MANUAL BEFORE USING!)
	bool_t identify_voices,										// identify loose STRIFE VOICES by name (READ MANUAL BEFORE USING!)
	bool_t detect_sounds,										// detect sounds by content (READ MANUAL BEFORE USING!)
	bool_t detect_musics,										// detect musics by content (READ MANUAL BEFORE USING!)
	bool_t detect_graphics,										// detect graphics by content (READ MANUAL BEFORE USING!)
	bool_t recognised_names,									// identify sounds/musics/dialogs/conversations by recognised names
	bool_t loose_markers,										// allow nonstandard list marker characters
	bool_t named_markers,										// loose markers use names only (READ MANUAL BEFORE USING!)
	bool_t loose_headers,										// allow nonstandard map name headers (not just E\?M\? and MAP\?\?)
	bool_t isempty,												// lump has zero size
	bool_t issound,												// lump data indicates a sound file
	bool_t ismusic,												// lump data indicates a music entry
	bool_t isgraphic,											// lump data indicates a graphic entry
	game_t game);												// game for which WAD was designed

/**********************************************************************************************************************************/
/********************************************************** End of File ***********************************************************/
/**********************************************************************************************************************************/

#endif // __WAD__LIN_H__
