#ifndef __WAD__LPS_H__
#define __WAD__LPS_H__

/**********************************************************************************************************************************/
/********************************************************* Documentation **********************************************************/
/**********************************************************************************************************************************/

/*

Wad list parse stack

*/

/**********************************************************************************************************************************/
/*********************************************************** Systemics ************************************************************/
/**********************************************************************************************************************************/

// Includes
#include "services.h"
#include "waddef.h"

/**********************************************************************************************************************************/
/******************************************************** List Parse Stack ********************************************************/
/**********************************************************************************************************************************/

// List parse stack entry
typedef struct
{
	list_t list;												// list identifier
	bool_t start;												// start of list flag (FALSE means end of list)
	bool_t corrected;											// corrected (e.g., PP_END -> P_END) flag
} LPSentry_t;

// List parse stack
typedef struct
{
	size_t limit;												// maximum number of entries
	size_t count;												// current number of entries
	LPSentry_t *entries;										// entries
} LPS_t;

/**********************************************************************************************************************************/
/************************************************* List Parse Stack Maintainance **************************************************/
/**********************************************************************************************************************************/

// Initialise a list parse stack
void LPSInit (
	LPS_t **LPSp);												// list parse stack to be initialised

// Deinitialise a list parse stack
void LPSDone (
	LPS_t **LPSp);												// list parse stack to be deinitialised

/**********************************************************************************************************************************/
/***************************************************** List Parse Stack Usage *****************************************************/
/**********************************************************************************************************************************/

// Push a list marker on a list parse stack
void LPSPush (
	LPS_t *LPS,													// list parse stack on which to put the marker
	list_t list,												// list identifier associated with marker
	bool_t start,												// start of list flag (FALSE means end of list) for marker
	bool_t corrected);											// corrected (e.g., PP_END -> P_END) flag

// Pop a list marker off a list parse stack
void LPSPop (
	LPS_t *LPS,													// list parse stack from which to pop the marker
	list_t *list,												// list identifier associated with marker
	bool_t *start,												// start of list flag (FALSE means end of list) for marker
	bool_t *corrected);											// corrected (e.g., PP_END -> P_END) flag

// Get the depth of a list parse stack
size_t LPSGetStackDepth (
	const LPS_t *LPS);											// list parse stack to be queried

// Get the list type on top of a list parse stack
void LPSGetStackTopList (
	const LPS_t *LPS,											// list parse stack from which to pop the marker
	list_t *list);												// list identifier associated with marker

// Get details of top two on a list parse stack
void LPSGetStackTopTwoLists (
	const LPS_t *LPS,											// list parse stack to get details from
	list_t *curr_list,											// list on top
	bool_t *curr_corrected,										// corrected flag for lump name associated with list on top
	list_t *prev_list,											// list below top
	bool_t *prev_corrected);							// corrected flag for lump name associated with list below top

/**********************************************************************************************************************************/
/********************************************************** End of File ***********************************************************/
/**********************************************************************************************************************************/

#endif // __WAD__LPS_H__
