#ifndef __WAD__LST_H__
#define __WAD__LST_H__

/**********************************************************************************************************************************/
/********************************************************* Documentation **********************************************************/
/**********************************************************************************************************************************/

/*

Wad list symbol table

*/

/**********************************************************************************************************************************/
/*********************************************************** Systemics ************************************************************/
/**********************************************************************************************************************************/

// Includes
#include "services.h"
#include "waddef.h"

/**********************************************************************************************************************************/
/************************************************************* Lists **************************************************************/
/**********************************************************************************************************************************/

// List metrics
#define LIST_MAXFLAGLENGTH	 2									// maximum length of a list flag (e.g., the "S" in "S_START")
#define LIST_MAXCODELENGTH  32									// maximum length of a list code (e.g., "SPRITES")
#define LIST_MAXNAMELENGTH  64									// maximum length of a list name (e.g., "sprites")
#define LIST_MAXDESCLENGTH  64									// maximum length of a list description (e.g., "Actor sprites")

/**********************************************************************************************************************************/
/******************************************************* List Symbol Table ********************************************************/
/**********************************************************************************************************************************/

// List symbol table entry
typedef struct
{
	size_t seen;												// number of times this list has been encounterd
	bool_t font;												// FALSE-->("X"-->X_START/X_END), TRUE-->("X"-->FONTX_S/FONTX_E)
	char flag[LIST_MAXFLAGLENGTH+1];							// flag
	char code[LIST_MAXCODELENGTH+1];							// code
	char name[LIST_MAXNAMELENGTH+1];							// name
	char desc[LIST_MAXDESCLENGTH+1];							// description
} LSTentry_t;

// List symbol table
typedef struct
{
	size_t limit;												// maximum number of entries
	size_t count;												// current number of entries
	LSTentry_t *entries;										// entries
} LST_t;


/**********************************************************************************************************************************/
/************************************************* List Symbol Table Maintainance *************************************************/
/**********************************************************************************************************************************/

// Initialise a list symbol table
void LSTInit (
	LST_t **LSTp);												// list symbol table to be initialised

// Deinitialise a list symbol table
void LSTDone (
	LST_t **LSTp);												// list symbol table to be deinitialised

/**********************************************************************************************************************************/
/**************************************************** List Symbol Table Usage *****************************************************/
/**********************************************************************************************************************************/

// Add new symbol into a list symbol table and return metrics
void LSTAddSymbolAndGetMetrics (
	LST_t *LST,													// list symbol table to add symbol to (if not already there)
	const char *name,											// lump name from which to derive flag, list and start flag
	type_t type,												// lump name type
	list_t *list,												// list identifier associated with lump name
	bool_t *start);												// start of list flag (FALSE means end of list) for lump name

// Return metrics of an existing symbol via a lump name
void LSTGetMetricsViaLumpName (
	LST_t *LST,													// list symbol table to get list metrics from
	const char *name,											// lump name from which to identify list
	type_t type,												// lump name type
	list_t *list,												// list identifier associated with lump name
	bool_t *start);												// start of list flag (FALSE means end of list) for lump name

// Get a lump name from a list symbol table and name metrics
void LSTGetLumpName (
	const LST_t *LST,											// list symbol table to get flag from
	list_t list,												// list identifier associated with lump name
	bool_t start,												// start of list flag (FALSE means end of list) for lump name
	char *s);													// lump name to construct from flag, list and start flag

// Check if any list was found more than once
bool_t LSTCheckForDuplicates (
	const LST_t *LST);											// list symbol table to check for duplicate flags

/**********************************************************************************************************************************/
/********************************************************** End of File ***********************************************************/
/**********************************************************************************************************************************/

#endif // __WAD__LST_H__
