// ------------------------------
// Type and structure definitions
// ------------------------------

typedef struct stWadFileHeader
{
	char wadtag[4];					/* wad identification tag */
	unsigned long waddirlen;		/* number of entries in directory*/
	unsigned long waddiraddr;		/* byte file offset of directory*/
} WadHeader;

/* wad directory entry structure*/

typedef struct stWadDirEntry
{
	unsigned long resptr;			/* byte file offset of resource*/
	unsigned long reslen;			/* byte length of resource*/
	char resname[8];				/* name of resource nul termed if < 8 char*/
} WadDirEntry;

/* Directory locations for start/end tags */

/* wad directory structure*/

typedef struct stWadDir
{
	WadDirEntry *dirp;				/* dynamic array of directory entries*/
	int nentries;					/* number of entries used */
	int allentries;					/* number of entries allocated */
} WadDir;

/* wad data structures */

#define CYANCOLOR 0xf7

typedef struct stPicData
{
	short pwid;
	short phgt;
	short pxoff;
	short pyoff;
	
	long *coloffs;
	unsigned char *posts;
	long postlen;
} PicData;

typedef struct stPatch
{
	short xoff;
	short yoff;
	short pidx;
	short stepdir;  //1
	short cmap;		//0

} Patch;

typedef struct stTextureDesc
{
	char textname[8];
	short res1;
	short res2;
	short twid;
	short thgt;
	short res3;
	short res4;
	short npatches;
	Patch *patches;
} TextureDesc;

typedef struct stTextureHeader
{
	char textname[8];
	short res1;
	short res2;
	short twid;
	short thgt;
	short res3;
	short res4;
	short npatches;
} TextureHeader;

typedef struct stTextureLump
{
	long N;
	long *offs;
	TextureDesc *textures;
} TextureLump;

typedef struct stPNamesLump
{
	long npnames;
	char **patchname;
} PNamesLump;

typedef struct stWadTextures
{
	TextureLump t1;
	TextureLump t2;
	TextureLump t3;
	PNamesLump pnames;
} WadTextures;

typedef struct stDTex
{
	int isp;
	char name[24];
	int num1;
	int num2;
} DTex;

typedef struct stRng
{
	int typ;
	int num;
	int start;
	int end;
} Rng;

typedef struct stWaveHeader
{
	char riff[4];
	long flen;
	char wave[8];
	long a0;
	short a1;
	short a2;
	long s1;
	long s2;
	short a3;
	short a4;
	char data[4];
	long nsamps;
} WaveHeader;

typedef struct stRawHeader
{
	short three;
	short srate;
	short nsamps;
	short zero;
} RawHeader;

typedef struct stSegment
{
	int color;
	int bright;
	int fsel;
	int haln;
	int valn;
	int row;
	int col;
	int len;
	int ncols;
	int align;
	char str[128];
} Segment;

/* thing structure*/

typedef struct stThing
{
	short int x,y;
	short int ang;
	short int typ;
	short int attr;
} Thing;

/* linedef structure*/

typedef struct stLinedef
{
	short int from;
	short int to;
	short int attr;
	short int typ;
	short int tag;
	short int sdef1;
	short int sdef2;
} Linedef;

/* sidedef structure*/

typedef struct stSidedef
{
	short int xoff;
	short int yoff;
	char utxt[8];
	char ltxt[8];
	char ntxt[8];
	short int sect;
} Sidedef;

/* vertex structure*/

typedef struct stVertex
{
	short int x;
	short int y;
} Vertex;

/* sector structure*/

typedef struct stSector
{
	short int fhgt;
	short int chgt;
	char ftxt[8];
	char ctxt[8];
	short int lite;
	short int typ;
	short int tag;
} Sector;

typedef enum
{
	V_TOP,
	V_MIDDLE,
	V_BOTTOM
} VAlign;

typedef enum
{
	H_LEFT,
	H_CENTER,
	H_RIGHT
} HAlign;

typedef enum
{
	RES_UNKNOWN=0,
	RES_LUMPS,
	RES_LEVELS,
	RES_TEXTURES,
	RES_PNAMES,
	RES_SOUNDS,
	RES_MUSICS,
	RES_GRAPHICS,
	RES_PICTURES,
	RES_SPRITES,
	RES_PATCHES,
	RES_FLATS
} ResType;

typedef enum
{
	I_PLAYPAL=1,
	I_COLORMAP,
	I_ENDOOM,
	I_DEMO1,
	I_DEMO2,
	I_DEMO3,
	I_GENMIDI,
	I_DMXGUSC,
	I_DPPISTOL,
	I_DSPISTOL,
	I_DPSHOTGN,
	I_DSSHOTGN,
	I_DPSGCOCK,
	I_DSSGCOCK,
	I_DPSAWUP,
	I_DSSAWUP,
	I_DPSAWIDL,
	I_DSSAWIDL,
	I_DPSAWFUL,
	I_DSSAWFUL,
	I_DPSAWHIT,
	I_DSSAWHIT,
	I_DPRLAUNC,
	I_DSRLAUNC,
	I_DPRXPLOD,
	I_DSRXPLOD,
	I_DPFIRSHT,
	I_DSFIRSHT,
	I_DPFIRXPL,
	I_DSFIRXPL,
	I_DPPSTART,
	I_DSPSTART,
	I_DPPSTOP,
	I_DSPSTOP,
	I_DPDOROPN,
	I_DSDOROPN,
	I_DPDORCLS,
	I_DSDORCLS,
	I_DPSTNMOV,
	I_DSSTNMOV,
	I_DPSWTCHN,
	I_DSSWTCHN,
	I_DPSWTCHX,
	I_DSSWTCHX,
	I_DPPLPAIN,
	I_DSPLPAIN,
	I_DPDMPAIN,
	I_DSDMPAIN,
	I_DPPOPAIN,
	I_DSPOPAIN,
	I_DPSLOP,
	I_DSSLOP,
	I_DPITEMUP,
	I_DSITEMUP,
	I_DPWPNUP,
	I_DSWPNUP,
	I_DPOOF,
	I_DSOOF,
	I_DPTELEPT,
	I_DSTELEPT,
	I_DPPOSIT1,
	I_DSPOSIT1,
	I_DPPOSIT2,
	I_DSPOSIT2,
	I_DPPOSIT3,
	I_DSPOSIT3,
	I_DPBGSIT1,
	I_DSBGSIT1,
	I_DPBGSIT2,
	I_DSBGSIT2,
	I_DPSGTSIT,
	I_DSSGTSIT,
	I_DPBRSSIT,
	I_DSBRSSIT,
	I_DPSGTATK,
	I_DSSGTATK,
	I_DPCLAW,
	I_DSCLAW,
	I_DPPLDETH,
	I_DSPLDETH,
	I_DPPDIEHI,
	I_DSPDIEHI,
	I_DPPODTH1,
	I_DSPODTH1,
	I_DPPODTH2,
	I_DSPODTH2,
	I_DPPODTH3,
	I_DSPODTH3,
	I_DPBGDTH1,
	I_DSBGDTH1,
	I_DPBGDTH2,
	I_DSBGDTH2,
	I_DPSGTDTH,
	I_DSSGTDTH,
	I_DPBRSDTH,
	I_DSBRSDTH,
	I_DPPOSACT,
	I_DSPOSACT,
	I_DPBGACT,
	I_DSBGACT,
	I_DPDMACT,
	I_DSDMACT,
	I_DPNOWAY,
	I_DSNOWAY,
	I_DPBAREXP,
	I_DSBAREXP,
	I_DPPUNCH,
	I_DSPUNCH,
	I_DPTINK,
	I_DSTINK,
	I_DPBDOPN,
	I_DSBDOPN,
	I_DPBDCLS,
	I_DSBDCLS,
	I_DPITMBK,
	I_DSITMBK,
	I_DPGETPOW,
	I_DSGETPOW,
	I_DPPLASMA,
	I_DSPLASMA,
	I_DPBFG,
	I_DSBFG,
	I_DPCACSIT,
	I_DSCACSIT,
	I_DPCYBSIT,
	I_DSCYBSIT,
	I_DPSPISIT,
	I_DSSPISIT,
	I_DPSKLATK,
	I_DSSKLATK,
	I_DPCACDTH,
	I_DSCACDTH,
	I_DPSKLDTH,
	I_DSSKLDTH,
	I_DPCYBDTH,
	I_DSCYBDTH,
	I_DPSPIDTH,
	I_DSSPIDTH,
	I_DPHOOF,
	I_DSHOOF,
	I_DPMETAL,
	I_DSMETAL,
	I_DPDSHTGN,
	I_DSDSHTGN,
	I_DPDBOPN,
	I_DSDBOPN,
	I_DPDBCLS,
	I_DSDBCLS,
	I_DPDBLOAD,
	I_DSDBLOAD,
	I_DPVIPAIN,
	I_DSVIPAIN,
	I_DPMNPAIN,
	I_DSMNPAIN,
	I_DPPEPAIN,
	I_DSPEPAIN,
	I_DPBSPSIT,
	I_DSBSPSIT,
	I_DPKNTSIT,
	I_DSKNTSIT,
	I_DPVILSIT,
	I_DSVILSIT,
	I_DPMANSIT,
	I_DSMANSIT,
	I_DPPESIT,
	I_DSPESIT,
	I_DPSKEPCH,
	I_DSSKEPCH,
	I_DPVILATK,
	I_DSVILATK,
	I_DPSKESWG,
	I_DSSKESWG,
	I_DPBSPDTH,
	I_DSBSPDTH,
	I_DPVILDTH,
	I_DSVILDTH,
	I_DPKNTDTH,
	I_DSKNTDTH,
	I_DPPEDTH,
	I_DSPEDTH,
	I_DPSKEDTH,
	I_DSSKEDTH,
	I_DPBSPACT,
	I_DSBSPACT,
	I_DPBSPWLK,
	I_DSBSPWLK,
	I_DPVILACT,
	I_DSVILACT,
	I_DPFLAME,
	I_DSFLAME,
	I_DPFLAMST,
	I_DSFLAMST,
	I_DPBOSPIT,
	I_DSBOSPIT,
	I_DPBOSCUB,
	I_DSBOSCUB,
	I_DPBOSSIT,
	I_DSBOSSIT,
	I_DPBOSPN,
	I_DSBOSPN,
	I_DPBOSDTH,
	I_DSBOSDTH,
	I_DPMANATK,
	I_DSMANATK,
	I_DPMANDTH,
	I_DSMANDTH,
	I_DPSSSIT,
	I_DSSSSIT,
	I_DPSSDTH,
	I_DSSSDTH,
	I_DPKEENPN,
	I_DSKEENPN,
	I_DPKEENDT,
	I_DSKEENDT,
	I_DPSKEACT,
	I_DSSKEACT,
	I_DPSKESIT,
	I_DSSKESIT,
	I_DPSKEATK,
	I_DSSKEATK,
	I_DPRADIO,
	I_DSRADIO,
	I_D_RUNNIN,
	I_D_STALKS,
	I_D_COUNTD,
	I_D_BETWEE,
	I_D_DOOM,
	I_D_THE_DA,
	I_D_SHAWN,
	I_D_DDTBLU,
	I_D_IN_CIT,
	I_D_DEAD,
	I_D_STLKS2,
	I_D_THEDA2,
	I_D_DOOM2,
	I_D_DDTBL2,
	I_D_RUNNI2,
	I_D_DEAD2,
	I_D_STLKS3,
	I_D_ROMERO,
	I_D_SHAWN2,
	I_D_MESSAG,
	I_D_COUNT2,
	I_D_DDTBL3,
	I_D_AMPIE,
	I_D_THEDA3,
	I_D_ADRIAN,
	I_D_MESSG2,
	I_D_ROMER2,
	I_D_TENSE,
	I_D_SHAWN3,
	I_D_OPENIN,
	I_D_EVIL,
	I_D_ULTIMA,
	I_D_READ_M,
	I_D_DM2TTL,
	I_D_DM2INT,
	I_HELP,
	I_VICTORY2,
	I_PFUB1,
	I_PFUB2,
	I_END0,
	I_END1,
	I_END2,
	I_END3,
	I_END4,
	I_END5,
	I_END6,
	I_TITLEPIC,
	I_CREDIT,
	I_BOSSBACK,
	I_AMMNUM0,
	I_AMMNUM1,
	I_AMMNUM2,
	I_AMMNUM3,
	I_AMMNUM4,
	I_AMMNUM5,
	I_AMMNUM6,
	I_AMMNUM7,
	I_AMMNUM8,
	I_AMMNUM9,
	I_STBAR,
	I_STGNUM0,
	I_STGNUM1,
	I_STGNUM2,
	I_STGNUM3,
	I_STGNUM4,
	I_STGNUM5,
	I_STGNUM6,
	I_STGNUM7,
	I_STGNUM8,
	I_STGNUM9,
	I_STTMINUS,
	I_STTNUM0,
	I_STTNUM1,
	I_STTNUM2,
	I_STTNUM3,
	I_STTNUM4,
	I_STTNUM5,
	I_STTNUM6,
	I_STTNUM7,
	I_STTNUM8,
	I_STTNUM9,
	I_STTPRCNT,
	I_STYSNUM0,
	I_STYSNUM1,
	I_STYSNUM2,
	I_STYSNUM3,
	I_STYSNUM4,
	I_STYSNUM5,
	I_STYSNUM6,
	I_STYSNUM7,
	I_STYSNUM8,
	I_STYSNUM9,
	I_STKEYS0,
	I_STKEYS1,
	I_STKEYS2,
	I_STKEYS3,
	I_STKEYS4,
	I_STKEYS5,
	I_STDISK,
	I_STCDROM,
	I_STARMS,
	I_STCFN033,
	I_STCFN034,
	I_STCFN035,
	I_STCFN036,
	I_STCFN037,
	I_STCFN038,
	I_STCFN039,
	I_STCFN040,
	I_STCFN041,
	I_STCFN042,
	I_STCFN043,
	I_STCFN044,
	I_STCFN045,
	I_STCFN046,
	I_STCFN047,
	I_STCFN048,
	I_STCFN049,
	I_STCFN050,
	I_STCFN051,
	I_STCFN052,
	I_STCFN053,
	I_STCFN054,
	I_STCFN055,
	I_STCFN056,
	I_STCFN057,
	I_STCFN058,
	I_STCFN059,
	I_STCFN060,
	I_STCFN061,
	I_STCFN062,
	I_STCFN063,
	I_STCFN064,
	I_STCFN065,
	I_STCFN066,
	I_STCFN067,
	I_STCFN068,
	I_STCFN069,
	I_STCFN070,
	I_STCFN071,
	I_STCFN072,
	I_STCFN073,
	I_STCFN074,
	I_STCFN075,
	I_STCFN076,
	I_STCFN077,
	I_STCFN078,
	I_STCFN079,
	I_STCFN080,
	I_STCFN081,
	I_STCFN082,
	I_STCFN083,
	I_STCFN084,
	I_STCFN085,
	I_STCFN086,
	I_STCFN087,
	I_STCFN088,
	I_STCFN089,
	I_STCFN090,
	I_STCFN091,
	I_STCFN092,
	I_STCFN093,
	I_STCFN094,
	I_STCFN095,
	I_STCFN121,
	I_STFB1,
	I_STFB0,
	I_STFB2,
	I_STFB3,
	I_STPB1,
	I_STPB0,
	I_STPB2,
	I_STPB3,
	I_STFST01,
	I_STFST00,
	I_STFST02,
	I_STFTL00,
	I_STFTR00,
	I_STFOUCH0,
	I_STFEVL0,
	I_STFKILL0,
	I_STFST11,
	I_STFST10,
	I_STFST12,
	I_STFTL10,
	I_STFTR10,
	I_STFOUCH1,
	I_STFEVL1,
	I_STFKILL1,
	I_STFST21,
	I_STFST20,
	I_STFST22,
	I_STFTL20,
	I_STFTR20,
	I_STFOUCH2,
	I_STFEVL2,
	I_STFKILL2,
	I_STFST31,
	I_STFST30,
	I_STFST32,
	I_STFTL30,
	I_STFTR30,
	I_STFOUCH3,
	I_STFEVL3,
	I_STFKILL3,
	I_STFST41,
	I_STFST40,
	I_STFST42,
	I_STFTL40,
	I_STFTR40,
	I_STFOUCH4,
	I_STFEVL4,
	I_STFKILL4,
	I_STFGOD0,
	I_STFDEAD0,
	I_M_DOOM,
	I_M_RDTHIS,
	I_M_OPTION,
	I_M_QUITG,
	I_M_NGAME,
	I_M_SKULL1,
	I_M_SKULL2,
	I_M_THERMO,
	I_M_THERMR,
	I_M_THERMM,
	I_M_THERML,
	I_M_ENDGAM,
	I_M_PAUSE,
	I_M_MESSG,
	I_M_MSGON,
	I_M_MSGOFF,
	I_M_EPISOD,
	I_M_EPI1,
	I_M_EPI2,
	I_M_EPI3,
	I_M_HURT,
	I_M_JKILL,
	I_M_ROUGH,
	I_M_SKILL,
	I_M_NEWG,
	I_M_ULTRA,
	I_M_NMARE,
	I_M_SVOL,
	I_M_OPTTTL,
	I_M_SAVEG,
	I_M_LOADG,
	I_M_DISP,
	I_M_MSENS,
	I_M_GDHIGH,
	I_M_GDLOW,
	I_M_DETAIL,
	I_M_DISOPT,
	I_M_SCRNSZ,
	I_M_SGTTL,
	I_M_LGTTL,
	I_M_SFXVOL,
	I_M_MUSVOL,
	I_M_LSLEFT,
	I_M_LSCNTR,
	I_M_LSRGHT,
	I_BRDR_TL,
	I_BRDR_T,
	I_BRDR_TR,
	I_BRDR_L,
	I_BRDR_R,
	I_BRDR_BL,
	I_BRDR_B,
	I_BRDR_BR,
	I_WIOSTK,
	I_WIOSTI,
	I_WIF,
	I_WIMSTT,
	I_WIOSTS,
	I_WIOSTF,
	I_WITIME,
	I_WIPAR,
	I_WIMSTAR,
	I_WIMINUS,
	I_WIPCNT,
	I_WINUM0,
	I_WINUM1,
	I_WINUM2,
	I_WINUM3,
	I_WINUM4,
	I_WINUM5,
	I_WINUM6,
	I_WINUM7,
	I_WINUM8,
	I_WINUM9,
	I_WICOLON,
	I_WISUCKS,
	I_WIFRGS,
	I_WILV00,
	I_WILV01,
	I_WILV02,
	I_WILV03,
	I_WILV04,
	I_WILV05,
	I_WILV06,
	I_WILV07,
	I_WILV08,
	I_WILV11,
	I_WILV12,
	I_WILV14,
	I_WILV15,
	I_WILV16,
	I_WILV17,
	I_WILV18,
	I_WILV20,
	I_WILV21,
	I_WILV22,
	I_WILV23,
	I_WILV24,
	I_WILV25,
	I_WILV26,
	I_WILV27,
	I_WILV28,
	I_WILV13,
	I_WILV10,
	I_WIP1,
	I_WIP2,
	I_WIP3,
	I_WIP4,
	I_WIBP1,
	I_WIBP2,
	I_WIBP3,
	I_WIBP4,
	I_WIKILRS,
	I_WIVCTMS,
	I_WISCRT2,
	I_WIENTER,
	I_CWILV00,
	I_CWILV01,
	I_CWILV02,
	I_CWILV03,
	I_CWILV04,
	I_CWILV05,
	I_CWILV06,
	I_CWILV07,
	I_CWILV08,
	I_CWILV09,
	I_CWILV10,
	I_CWILV11,
	I_CWILV12,
	I_CWILV13,
	I_CWILV14,
	I_CWILV15,
	I_CWILV16,
	I_CWILV17,
	I_CWILV18,
	I_CWILV19,
	I_CWILV22,
	I_CWILV21,
	I_CWILV20,
	I_CWILV23,
	I_CWILV25,
	I_CWILV26,
	I_CWILV27,
	I_CWILV28,
	I_CWILV29,
	I_CWILV24,
	I_CWILV30,
	I_CWILV31,
	I_INTERPIC,
} ResourceNames;

