#include "patch.h"

/************************************************************
 WDIR.C
			 /-------------------------\
			|| Wad Directory Routines  ||
			 \-------------------------/
									
************************************************************/

int IsMapName(WadDirEntry *wde)
{
	return IsDMap(wde->resname);
}

/* return true if wde points to a level graphic resource */

int IsGraphicResource(WadDirEntry *wde)
{
	return !strnicmp("THINGS",wde->resname,6)
		||  !strnicmp("VERTEXES",wde->resname,8)
		||	!strnicmp("LINEDEFS",wde->resname,8)
		||  !strnicmp("SIDEDEFS",wde->resname,8)
		||  !strnicmp("SECTORS",wde->resname,7);
}

/* return true if wde points to a resource added during level build */

int IsBuilderResource(WadDirEntry *wde)
{
	return !strnicmp("SEGS",wde->resname,4)
		||  !strnicmp("SSECTORS",wde->resname,8)
		||  !strnicmp("NODES",wde->resname,5)
		||  !strnicmp("REJECT",wde->resname,6)
		||  !strnicmp("BLOCKMAP",wde->resname,8);
}

/* return true if wde points level resource */

int IsMapResource(WadDirEntry *wde)
{
	return IsGraphicResource(wde) || IsBuilderResource(wde);
}

/* return true if is a sprite start tag */

int IsSpriteStartFlag(WadDirEntry *wde)
{
	char *p;
	if ((p=strstr(Str8(wde->resname),"_START"))!=NULL)
		if (p[6]!='\0') return 0;

	if (strstr(Str8(wde->resname),"S_START")!=NULL)
		return 1;
	else if (strstr(Str8(wde->resname),"S1_START")!=NULL)
		return 1;
	else if (strstr(Str8(wde->resname),"S2_START")!=NULL)
		return 1;
	else if (strstr(Str8(wde->resname),"S3_START")!=NULL)
		return 1;
	return 0;
}

/* return true if is any patch start tag */

int IsPatchStartFlag(WadDirEntry *wde)
{
	char *p;
	if ((p=strstr(Str8(wde->resname),"_START"))!=NULL)
		if (p[6]!='\0') return 0;

	if (strstr(Str8(wde->resname),"P_START")!=NULL)
		return 1;
	else if (strstr(Str8(wde->resname),"P1_START")!=NULL)
		return 1;
	else if (strstr(Str8(wde->resname),"P2_START")!=NULL)
		return 1;
	else if (strstr(Str8(wde->resname),"P3_START")!=NULL)
		return 1;
	return 0;
}

/* return true if is any flat start tag */

int IsFlatStartFlag(WadDirEntry *wde)
{
	char *p;
	if ((p=strstr(Str8(wde->resname),"_START"))!=NULL)
		if (p[6]!='\0') return 0;

	if (strstr(Str8(wde->resname),"F_START")!=NULL)
		return 1;
	else if (strstr(Str8(wde->resname),"F1_START")!=NULL)
		return 1;
	else if (strstr(Str8(wde->resname),"F2_START")!=NULL)
		return 1;
	else if (strstr(Str8(wde->resname),"F3_START")!=NULL)
		return 1;
	return 0;
}

/* return true if is a sprite end tag */

int IsSpriteEndFlag(WadDirEntry *wde)
{
	char *p;
	if ((p=strstr(Str8(wde->resname),"_END"))!=NULL)
		if (p[4]!='\0') return 0;

	if (strstr(Str8(wde->resname),"S_END")!=NULL)
		return 1;
	else if (strstr(Str8(wde->resname),"S1_END")!=NULL)
		return 1;
	else if (strstr(Str8(wde->resname),"S2_END")!=NULL)
		return 1;
	else if (strstr(Str8(wde->resname),"S3_END")!=NULL)
		return 1;
	return 0;
}

/* return true if is any patch end tag */

int IsPatchEndFlag(WadDirEntry *wde)
{
	char *p;
	if ((p=strstr(Str8(wde->resname),"_END"))!=NULL)
		if (p[4]!='\0') return 0;

	if (strstr(Str8(wde->resname),"P_END")!=NULL)
		return 1;
	else if (strstr(Str8(wde->resname),"P1_END")!=NULL)
		return 1;
	else if (strstr(Str8(wde->resname),"P2_END")!=NULL)
		return 1;
	else if (strstr(Str8(wde->resname),"P3_END")!=NULL)
		return 1;
	return 0;
}

/* return true if is any flat end tag */

int IsFlatEndFlag(WadDirEntry *wde)
{
	char *p;
	if ((p=strstr(Str8(wde->resname),"_END"))!=NULL)
		if (p[4]!='\0') return 0;

	if (strstr(Str8(wde->resname),"F_END")!=NULL)
		return 1;
	else if (strstr(Str8(wde->resname),"F1_END")!=NULL)
		return 1;
	else if (strstr(Str8(wde->resname),"F2_END")!=NULL)
		return 1;
	else if (strstr(Str8(wde->resname),"F3_END")!=NULL)
		return 1;
	return 0;
}

int ResourceType(WadDirEntry *wde)
{
	int i;

	if (IsMapName(wde) || IsMapResource(wde))
		return RES_LEVELS;

	if (strnicmp(wde->resname,"PNAMES",6)==0) return RES_PNAMES;
	if (strnicmp(wde->resname,"TEXTURE",7)==0) return RES_TEXTURES;

	for (i=I_PLAYPAL;i<=I_INTERPIC;i++)
		if (strnicmp(resstr[i],wde->resname,strlen(resstr[i]))==0)
			break;

	if (i<=I_DMXGUSC) return RES_LUMPS;
	if (i<=I_DSRADIO) return RES_SOUNDS;
	if (i<=I_D_DM2INT) return RES_MUSICS;
	if (i<=I_INTERPIC) return RES_GRAPHICS;

	return RES_PICTURES;
}

// This routine decodes the type fully, but the base and patch ranges
// must be initialized and gotten prior to calling

int RangeResourceType(WadDirEntry *wde,int isbase)
{
	int i;

	i = ResourceType(wde);
	if (i==RES_PICTURES)
	{

	}

	if (IsMapName(wde) || IsMapResource(wde))
		return RES_LEVELS;

	if (strnicmp(wde->resname,"PNAMES",6)==0) return RES_PNAMES;
	if (strnicmp(wde->resname,"TEXTURE",7)==0) return RES_TEXTURES;

	for (i=I_PLAYPAL;i<=I_INTERPIC;i++)
		if (strnicmp(resstr[i],wde->resname,strlen(resstr[i]))==0)
			break;

	if (i<=I_DMXGUSC) return RES_LUMPS;
	if (i<=I_DSRADIO) return RES_SOUNDS;
	if (i<=I_D_DM2INT) return RES_MUSICS;
	if (i<=I_INTERPIC) return RES_GRAPHICS;

	return RES_PICTURES;
}

/* Initialize a new directory */

void InitDir(WadDir *d)
{
	int i;

	d->allentries=0;
	d->nentries=0;
	d->dirp = NULL;
}

/* set a wad directory entry to values passed in */

void SetDirEntry(WadDirEntry *wde,unsigned iresptr, unsigned ireslen, char *iresname)
{
	wde->resptr = iresptr;
	wde->reslen = ireslen;
	strncpy(wde->resname,iresname,8);
}

/* Wad directory routines*/

/* Add a directory entry to the wad, allocate more memory if necessary
   and initialize the new directory entry */

int AddDirEntry(WadDir *wdd,unsigned iresptr, unsigned ireslen, char *iresname)
{
	char resn[16];

	if (wdd->nentries>=wdd->allentries)
	{
		wdd->allentries += 256;
		wdd->dirp = realloc(wdd->dirp,wdd->allentries*sizeof(WadDirEntry));
		assert(wdd->dirp!=NULL);
	}

	strcpy(resn,Str8(iresname));
	strupr(resn);
	ConvertMarker(resn);	// translate X_END/START <-> XX_END/START
		
	SetDirEntry(&wdd->dirp[wdd->nentries++],iresptr,ireslen,resn);
	return 0;
}

/* Insert a directory entry to the wad, allocate more memory if necessary
   and initialize the new directory entry */

int InsDirEntry(WadDir *wdd,int inspt,unsigned iresptr, unsigned ireslen, char *iresname)
{
	int j;

	if (wdd->nentries>=wdd->allentries)
	{
		wdd->allentries += 256;
		wdd->dirp = realloc(wdd->dirp,wdd->allentries*sizeof(WadDirEntry));
		assert(wdd->dirp!=NULL);
	}
	if (inspt<wdd->nentries-1)
		for (j=wdd->nentries-1;j>=inspt;j--)
			wdd->dirp[j+1]=wdd->dirp[j];
	
	SetDirEntry(&wdd->dirp[inspt],iresptr,ireslen,iresname);
	return 0;
}

/* Read the directory from a wad file with header hdr to the specified
   dir structure */

int ReadDir(WadHeader *hdr,WadDir *dir,FILE *st)
{
	WadDirEntry wde;
	int entry;

	fseek(st,hdr->waddiraddr,SEEK_SET);
	for (entry=0;entry<hdr->waddirlen;entry++)
	{
		fread(&wde,sizeof(WadDirEntry),1,st);
		AddDirEntry(dir,wde.resptr,wde.reslen,Str8(wde.resname));
	}
	return 0;
}

/* Get location of resource in directory or return -1 */

int IsIn(char *res,WadDir *d)
{
	int i;

	for (i=0;i<d->nentries;i++)
		if (strnicmp(res,d->dirp[i].resname,8)==0) return i;

	return -1;
}

/* Dump a directory entry */

void PrintDirEntry(WadDirEntry *wde)
{
	printf("%9s Off:%8x Len:%8x\n",Str8(wde->resname),wde->resptr,wde->reslen);
}

/* Dump a directory */

void PrintWadDir(WadDir *d)
{
	long i;
	
	for (i=0;i<d->nentries;i++) PrintDirEntry(&d->dirp[i]);
}

/* Dump directory and header */

void PrintDir(WadDir *wdir)
{
	printf("Wad directory:\n");
	printf("RESOURCE  OFFSET   LENGTH\n");
	printf("-------------------------\n");
	PrintWadDir(wdir);
	printf("\n\n");
}


