#!/usr/bin/perl

my %maps = ();
my $counter = 0;
sub MapLookup($)
{
	local $_ = shift;
	return $_ if m!^common/!;
	return $_ if m!^blueamuse/energyliquid1$!;
	return $_ if m!^dsi/dsiglass$!;
	return $maps{$_} if exists $maps{$_};
	return ($maps{$_} = sprintf "blueamuse81_wsw/color%03d", $counter++);
}

while(<STDIN>)
{
	chomp;
	if(/^patchDef2$/)
	{
		print "$_\n";
		$_ = <STDIN>;
		print "$_\n";
		$_ = <STDIN>;
		chomp;
		$_ = MapLookup($_);
	}
	elsif(/^((?:\( [-.0-9]+ [-.0-9]+ [-.0-9]+ \) ){3})(\S+)( .*)/)
	{
		$_ = $1 . MapLookup($2) . $3;
	}
	elsif(/^\( [^(].*\(.*\(/)
	{
		die "Brush not detected: $_";
	}
	print "$_\n";
}

print "// counter at $counter\n";
