// Shaders for the map "Cleft Village" by sev

//------------------------------------------------------------------------------
// Environment
//------------------------------------------------------------------------------

textures/cleftvillage_sky/cvsky
{
        qer_editorimage textures/cleftvillage_sky/cvsky_dn.jpg

        surfaceparm sky
        surfaceparm noimpact
        surfaceparm nolightmap
        surfaceparm nodlight
        surfaceparm nomarks

        nopicmip
        nomipmaps

        skyparms textures/cleftvillage_sky/cvsky - - //farbox cloudheight nearbox
        q3map_sunExt 1 1 1 320 12 45 3 16 //rgb intensity degrees elevation deviance samples
        q3map_lightmapFilterRadius 0 0 //self other
        q3map_skyLight 128 3 //amount iterations
	q3map_surfaceLight 128
}

textures/cleftvillage_water/sea01
{
	qer_editorimage textures/cleftvillage_water/sea01.tga
	qer_trans 0.5

	surfaceparm water
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nolightmap

	cull none

	deformVertexes wave 144 sin 0 32 0 0.25 //div func base amplitude phase freq
	deformVertexes move 0 0 32 sin 2 1 0 0.25 //x y z func base amplitude phase freq
	Q3map_TessSize 256

	q3map_globaltexture
	{
		map textures/cleftvillage_water/sea01.tga
		blendFunc blend
		tcMod scroll 0.025 0.075
	}
}

textures/cleftvillage_water/water
{
	qer_editorimage textures/cleftvillage_water/water.tga
	qer_trans 0.5

	surfaceparm water
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nolightmap
}

textures/cleftvillage_water/nosteps
{
	qer_editorimage textures/cleftvillage_water/nosteps.tga

	surfaceparm nodraw
	surfaceparm nolightmap
	surfaceparm nomarks

	surfaceparm nosteps
}

//------------------------------------------------------------------------------
// Plants
//------------------------------------------------------------------------------

textures/cleftvillage_plants/leaves01
{
	qer_editorimage textures/cleftvillage_plants/leaves01.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow

	nopicmip
	nomipmaps

	deformVertexes autosprite
	deformVertexes wave 144 sin 0 8 0 0.25 //div func base amplitude phase freq

	{
		map textures/cleftvillage_plants/leaves01.tga
		alphaFunc GT0
		rgbGen vertex
	}
}

textures/cleftvillage_plants/leaves02
{
	qer_editorimage textures/cleftvillage_plants/leaves02.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow

	cull none
	nopicmip
	nomipmaps

	{
		map textures/cleftvillage_plants/leaves02.tga
		alphaFunc GT0
		rgbGen vertex
	}
}

textures/cleftvillage_plants/leaves03
{
	qer_editorimage textures/cleftvillage_plants/leaves03.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow

	cull none
	nopicmip
	nomipmaps

	{
		map textures/cleftvillage_plants/leaves03.tga
		alphaFunc GT0
		rgbGen vertex
	}
}

textures/cleftvillage_plants/grass01
{
	qer_editorimage textures/cleftvillage_plants/grass01.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow

	cull none
	nopicmip
	nomipmaps

	{
		map textures/cleftvillage_plants/grass01.tga
		alphaFunc GT0
		rgbGen vertex
	}
}

textures/cleftvillage_plants/grass02
{
	qer_editorimage textures/cleftvillage_plants/grass02.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow

	cull none
	nopicmip
	nomipmaps

	{
		map textures/cleftvillage_plants/grass02.tga
		alphaFunc GT0
		rgbGen vertex
	}
}

textures/cleftvillage_plants/grass03
{
	qer_editorimage textures/cleftvillage_plants/grass03.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow

	cull none
	nopicmip
	nomipmaps

	{
		map textures/cleftvillage_plants/grass03.tga
		alphaFunc GT0
		rgbGen vertex
	}
}

textures/cleftvillage_plants/grass04
{
	qer_editorimage textures/cleftvillage_plants/grass04.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow

	cull none
	nopicmip
	nomipmaps

	{
		map textures/cleftvillage_plants/grass04.tga
		alphaFunc GT0
		rgbGen vertex
	}
}

textures/cleftvillage_plants/grass05
{
	qer_editorimage textures/cleftvillage_plants/grass05.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow

	cull none
	nopicmip
	nomipmaps

	{
		map textures/cleftvillage_plants/grass05.tga
		alphaFunc GT0
		rgbGen vertex
	}
}

textures/cleftvillage_plants/swamp01
{
	qer_editorimage textures/cleftvillage_plants/swamp01.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow

	cull none
	nopicmip
	nomipmaps

	{
		map textures/cleftvillage_plants/swamp01.tga
		alphaFunc GT0
		rgbGen vertex
	}
}



//------------------------------------------------------------------------------
// Village
//------------------------------------------------------------------------------

textures/cleftvillage_wood/branches01
{
	qer_editorimage textures/cleftvillage_wood/branches01.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow

	cull none
	nopicmip
	nomipmaps

	{
		map textures/cleftvillage_wood/branches01.tga
		alphaFunc GT0
		rgbGen vertex
	}
}

textures/cleftvillage_village/teleporter01_blue
{
	qer_editorimage textures/cleftvillage_village/teleporter01_blue.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow

	nopicmip
	nomipmaps

	deformVertexes autosprite

	{
		map textures/cleftvillage_village/teleporter01_blue.tga
		blendFunc blend
		tcMod stretch sin 1 0.05 0 0.5 //func base amplitude phase frequency
	}
}

textures/cleftvillage_village/teleporter01_red
{
	qer_editorimage textures/cleftvillage_village/teleporter01_red.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow

	nopicmip
	nomipmaps

	deformVertexes autosprite

	{
		map textures/cleftvillage_village/teleporter01_red.tga
		blendFunc blend
		tcMod stretch sin 1 0.05 0 0.5 //func base amplitude phase frequency
	}
}

textures/cleftvillage_village/teleporter02
{
	qer_editorimage textures/cleftvillage_village/teleporter02.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow

	cull none
	nopicmip
	nomipmaps

	{
		map textures/cleftvillage_village/teleporter02.tga
		blendFunc blend
		tcMod rotate -90
		tcMod stretch sin 1.25 0.25 0 0.5 //func base amplitude phase frequency
	}
}

textures/cleftvillage_village/rod_feathers_blue
{
	qer_editorimage textures/cleftvillage_village/rod_feathers_blue.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow

	cull none
	nopicmip
	nomipmaps

	{
		map textures/cleftvillage_village/rod_feathers_blue.tga
		alphaFunc GT0
		rgbGen vertex
	}
}

textures/cleftvillage_village/rod_feathers_red
{
	qer_editorimage textures/cleftvillage_village/rod_feathers_red.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow

	cull none
	nopicmip
	nomipmaps

	{
		map textures/cleftvillage_village/rod_feathers_red.tga
		alphaFunc GT0
		rgbGen vertex
	}
}

textures/cleftvillage_village/statue_feathers_blue
{
	qer_editorimage textures/cleftvillage_village/statue_feathers_blue.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow
	cull none
	nopicmip
	nomipmaps

	{
		map textures/cleftvillage_village/statue_feathers_blue.tga
		alphaFunc GT0
		rgbGen vertex
	}
}

textures/cleftvillage_village/statue_feathers_red
{
	qer_editorimage textures/cleftvillage_village/statue_feathers_red.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow
	cull none
	nopicmip
	nomipmaps

	{
		map textures/cleftvillage_village/statue_feathers_red.tga
		alphaFunc GT0
		rgbGen vertex
	}
}

textures/cleftvillage_village/skull01
{
	qer_editorimage textures/cleftvillage_village/skull01.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow

	nopicmip
	nomipmaps

	{
		map textures/cleftvillage_village/skull01.tga
		alphaFunc GT0
		rgbGen vertex
	}
}

textures/cleftvillage_village/chest01
{
	qer_editorimage textures/cleftvillage_village/chest01.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow

	cull none
	nopicmip
	nomipmaps

	{
		map textures/cleftvillage_village/chest01.tga
		alphaFunc GT0
		rgbGen vertex
	}
}

textures/cleftvillage_village/hand01
{
	qer_editorimage textures/cleftvillage_village/hand01.tga

	surfaceparm nomarks
	surfaceparm trans
	surfaceparm alphashadow

	nopicmip
	nomipmaps

	{
		map textures/cleftvillage_village/hand01.tga
		alphaFunc GT0
		rgbGen vertex
	}
}

