use strict;
use warnings;
use Params;

my %params = Params::get(qw/-i -s -v/);

my $infile = $params{-i};
my $scale = $params{-s};
my @shift = split / /, $params{-v};

sub TranslateCoordinate(@)
{
	my ($x, $y, $z) = @_;
	return ($x * $scale + $shift[0], $z * $scale + $shift[1], $y * $scale + $shift[2]);
}

open my $inlights, "<", $infile
	or die "$infile: $!";

sub gets()
{
	return 0
		unless defined ($_ = <$inlights>);
	y/\r//d;
	chomp;
	return 1;
}

while(gets())
{
	if(/^\[LightBegin\]$/)
	{
		my $strength = 0;
		my $radius1 = 0;
		my $radius2 = 0;
		my @origin = (0, 0, 0);
		my @color = (1, 1, 1);
		while(gets())
		{
			if(/^Position=\s*(.*)$/)
			{
				@origin = TranslateCoordinate split /\s+/, $1;
			}
			elsif(/^Color=\s*(.*)$/)
			{
				@color = split /\s+/, $1;
			}
			elsif(/^Strength=\s*(.*)$/)
			{
				$strength = $1;
			}
			elsif(/^Radius1=\s*(.*)$/)
			{
				$radius1 = $1;
			}
			elsif(/^Radius2=\s*(.*)$/)
			{
				$radius2 = $1;
			}
			elsif(/^\[LightEnd\]$/)
			{
				last;
			}
		}
		print "{\n";
		print "\"classname\" \"light\"\n";
		print "\"origin\" \"@origin\"\n";
		print "\"color\" \"@color\"\n";
		print "\"light\" \"@{[$strength + $radius2]}\"\n";
		print "}\n";
	}
}
