use strict;
use warnings;

my $brushes = q{
	// brush 0
	{
	brushDef
	{
	( 768 768 0 ) ( 768 0 0 ) ( 0 768 0 ) ( ( 0.015625 0 0 ) ( 0 0.015625 0 ) ) evil8_floor/e8clangfloor04_red 0 0 0
	( 768 640 0 ) ( 0 640 0 ) ( 768 640 -256 ) ( ( 0.015625 0 0 ) ( 0 0.015625 28 ) ) evil8_floor/e8clangfloor04_red 0 0 0
	( 640 768 0 ) ( 640 768 -256 ) ( 640 0 0 ) ( ( 0.015625 0 0 ) ( 0 0.015625 28 ) ) evil8_floor/e8clangfloor04_red 0 0 0
	( 0 0 -256 ) ( 768 0 -256 ) ( 0 768 -256 ) ( ( 0.015625 0 0 ) ( 0 0.015625 0 ) ) evil8_floor/e8clangfloor04_red 0 0 0
	( 0 0 -256 ) ( 0 0 0 ) ( 768 0 -256 ) ( ( 0.015625 0 0 ) ( 0 0.015625 28 ) ) evil8_floor/e8clangfloor04_red 0 0 0
	( 0 0 -256 ) ( 0 768 -256 ) ( 0 0 0 ) ( ( 0.015625 0 0 ) ( 0 0.015625 28 ) ) evil8_floor/e8clangfloor04_red 0 0 0
	}
	}
	// brush 1
	{
	brushDef
	{
	( -128 416 32 ) ( -128 544 32 ) ( 0 512 0 ) ( ( 0.0078125 0 15 ) ( 0 -0.0078125 9.8507118225 ) ) evil8_base/e8base_blue 0 0 0
	( -128 416 0 ) ( -128 544 0 ) ( -128 544 32 ) ( ( -0.0078125 0 11 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( 0 384 -32 ) ( -128 416 -32 ) ( -128 416 0 ) ( ( -0.0078125 0 2.6380336285 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( -128 544 0 ) ( -128 416 0 ) ( 0 384 -32 ) ( ( 0.0078125 0 15 ) ( 0 -0.0078125 15.8507118225 ) ) evil8_base/e8base_blue 0 0 0
	( 0 384 -32 ) ( 0 512 224 ) ( 0 512 -32 ) ( ( -0.0078125 0 5 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( -128 544 32 ) ( -128 544 0 ) ( 0 512 0 ) ( ( -0.0078125 0 13.3619661331 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	}
	}
	// brush 2
	{
	brushDef
	{
	( -128 96 32 ) ( -128 224 32 ) ( 0 256 0 ) ( ( 0.0078125 0 -0 ) ( -0 0.0078125 0 ) ) evil8_base/e8base_blue 0 0 0
	( -128 96 0 ) ( -128 224 0 ) ( -128 224 32 ) ( ( 0.0078125 0 -0 ) ( -0 0.0078125 0 ) ) evil8_base/e8base_blue 0 0 0
	( -128 224 0 ) ( -128 224 -32 ) ( 0 256 -32 ) ( ( 0.0078125 0 -0 ) ( -0 0.0078125 0 ) ) evil8_base/e8base_blue 0 0 0
	( -128 224 0 ) ( -128 96 0 ) ( 0 256 -32 ) ( ( 0.0078125 0 -0 ) ( -0 0.0078125 0 ) ) evil8_base/e8base_blue 0 0 0
	( 0 128 -32 ) ( 0 128 224 ) ( 0 256 -32 ) ( ( 0.0078125 0 -0 ) ( -0 0.0078125 0 ) ) evil8_base/e8base_blue 0 0 0
	( -128 96 -32 ) ( -128 96 0 ) ( 0 128 0 ) ( ( 0.0078125 0 -0 ) ( -0 0.0078125 0 ) ) evil8_base/e8base_blue 0 0 0
	}
	}
	// brush 3
	{
	brushDef
	{
	( 768 224 32 ) ( 768 96 32 ) ( 640 128 0 ) ( ( 0.0078125 0 4 ) ( 0 -0.0078125 4.9999995232 ) ) evil8_base/e8base_blue 0 0 0
	( 768 224 0 ) ( 768 96 0 ) ( 768 96 32 ) ( ( -0.0078125 0 0 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( 640 256 -32 ) ( 768 224 -32 ) ( 768 224 0 ) ( ( -0.0078125 0 15 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( 768 96 0 ) ( 768 224 0 ) ( 640 256 -32 ) ( ( 0.0078125 0 10 ) ( 0 -0.0078125 11 ) ) evil8_base/e8base_blue 0 0 0
	( 640 256 -32 ) ( 640 128 224 ) ( 640 128 -32 ) ( ( -0.0078125 0 0 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( 768 96 32 ) ( 768 96 0 ) ( 640 128 0 ) ( ( -0.0078125 0 1 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	}
	}
	// brush 4
	{
	brushDef
	{
	( 416 768 32 ) ( 544 768 32 ) ( 512 640 0 ) ( ( 0.0078125 0 15 ) ( 0 -0.0078125 5 ) ) evil8_base/e8base_blue 0 0 0
	( 416 768 0 ) ( 544 768 0 ) ( 544 768 32 ) ( ( -0.0078125 0 11 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( 384 640 -32 ) ( 416 768 -32 ) ( 416 768 0 ) ( ( -0.0078125 0 13.7873220444 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( 544 768 0 ) ( 416 768 0 ) ( 384 640 -32 ) ( ( 0.0078125 0 15 ) ( 0 -0.0078125 11 ) ) evil8_base/e8base_blue 0 0 0
	( 384 640 -32 ) ( 512 640 224 ) ( 512 640 -32 ) ( ( -0.0078125 0 5 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( 544 768 32 ) ( 544 768 0 ) ( 512 640 0 ) ( ( -0.0078125 0 2.212678194 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	}
	}
	// brush 5
	{
	brushDef
	{
	( 96 768 32 ) ( 224 768 32 ) ( 256 640 0 ) ( ( 0.0078125 0 15 ) ( 0 0.0078125 0 ) ) evil8_base/e8base_blue 0 0 0
	( 96 768 0 ) ( 224 768 0 ) ( 224 768 32 ) ( ( 0.0078125 0 0 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( 224 768 0 ) ( 224 768 -32 ) ( 256 640 -32 ) ( ( 0.0078125 0 15 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( 224 768 0 ) ( 96 768 0 ) ( 256 640 -32 ) ( ( 0.0078125 0 15 ) ( 0 0.0078125 0 ) ) evil8_base/e8base_blue 0 0 0
	( 128 640 -32 ) ( 128 640 224 ) ( 256 640 -32 ) ( ( 0.0078125 0 0 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( 96 768 -32 ) ( 96 768 0 ) ( 128 640 0 ) ( ( 0.0078125 0 1 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	}
	}
	// brush 6
	{
	brushDef
	{
	( 768 544 32 ) ( 768 416 32 ) ( 640 384 0 ) ( ( 0.0078125 0 4 ) ( 0 0.0078125 0 ) ) evil8_base/e8base_blue 0 0 0
	( 768 544 0 ) ( 768 416 0 ) ( 768 416 32 ) ( ( 0.0078125 0 11 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( 768 416 0 ) ( 768 416 -32 ) ( 640 384 -32 ) ( ( 0.0078125 0 13.7873210907 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( 768 416 0 ) ( 768 544 0 ) ( 640 384 -32 ) ( ( 0.0078125 0 10 ) ( 0 0.0078125 0 ) ) evil8_base/e8base_blue 0 0 0
	( 640 512 -32 ) ( 640 512 224 ) ( 640 384 -32 ) ( ( 0.0078125 0 5 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( 768 544 -32 ) ( 768 544 0 ) ( 640 512 0 ) ( ( 0.0078125 0 2.2126789093 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	}
	}
	// brush 7
	{
	brushDef
	{
	( 224 -128 32 ) ( 96 -128 32 ) ( 128 0 0 ) ( ( 0.0078125 0 4 ) ( 0 -0.0078125 9.8507118225 ) ) evil8_base/e8base_blue 0 0 0
	( 224 -128 0 ) ( 96 -128 0 ) ( 96 -128 32 ) ( ( -0.0078125 0 0 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( 256 0 -32 ) ( 224 -128 -32 ) ( 224 -128 0 ) ( ( -0.0078125 0 3.8507113457 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( 96 -128 0 ) ( 224 -128 0 ) ( 256 0 -32 ) ( ( 0.0078125 0 10 ) ( 0 -0.0078125 15.8507118225 ) ) evil8_base/e8base_blue 0 0 0
	( 256 0 -32 ) ( 128 0 224 ) ( 128 0 -32 ) ( ( -0.0078125 0 0 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( 96 -128 32 ) ( 96 -128 0 ) ( 128 0 0 ) ( ( -0.0078125 0 12.1492881775 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	}
	}
	// brush 8
	{
	brushDef
	{
	( 544 -128 32 ) ( 416 -128 32 ) ( 384 0 0 ) ( ( 0.0078125 0 4 ) ( 0 0.0078125 11.1492881775 ) ) evil8_base/e8base_blue 0 0 0
	( 544 -128 0 ) ( 416 -128 0 ) ( 416 -128 32 ) ( ( 0.0078125 0 11 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( 416 -128 0 ) ( 416 -128 -32 ) ( 384 0 -32 ) ( ( 0.0078125 0 2.6380345821 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( 416 -128 0 ) ( 544 -128 0 ) ( 384 0 -32 ) ( ( 0.0078125 0 10 ) ( 0 0.0078125 11.1492881775 ) ) evil8_base/e8base_blue 0 0 0
	( 512 0 -32 ) ( 512 0 224 ) ( 384 0 -32 ) ( ( 0.0078125 0 5 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	( 544 -128 -32 ) ( 544 -128 0 ) ( 512 0 0 ) ( ( 0.0078125 0 13.3619661331 ) ( 0 0.0078125 1.75 ) ) evil8_base/e8base_blue 0 0 0
	}
	}
};

my $entities = q{
	// entity 1
	{
	"classname" "trigger_push"
	"target" "FIELD+1-2"
	"height" "768"
	// brush 0
	{
	brushDef
	{
	( 544 -128 36 ) ( 416 -128 36 ) ( 384 0 4 ) ( ( 0.03125 0 16 ) ( 0 0.03125 44.6274719238 ) ) common/trigger 0 0 0
	( 544 -128 4 ) ( 416 -128 4 ) ( 416 -128 36 ) ( ( 0.03125 0 44 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 416 -128 4 ) ( 416 -128 -28 ) ( 384 0 -28 ) ( ( 0.03125 0 10.5521383286 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 512 0 -28 ) ( 512 0 228 ) ( 384 0 -28 ) ( ( 0.03125 0 20 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 544 -128 -28 ) ( 544 -128 4 ) ( 512 0 4 ) ( ( 0.03125 0 53.4478645325 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 384 0 0 ) ( 416 -128 32 ) ( 544 -128 32 ) ( ( 0.03125 0 16 ) ( 0 0.03125 44.59715271 ) ) common/trigger 0 0 0
	}
	}
	}
	// entity 2
	{
	"classname" "trigger_push"
	"target" "FIELD-1-2"
	"height" "768"
	// brush 0
	{
	brushDef
	{
	( 224 -128 36 ) ( 96 -128 36 ) ( 128 0 4 ) ( ( 0.03125 0 16 ) ( 0 -0.03125 39.3725280762 ) ) common/trigger 0 0 0
	( 224 -128 4 ) ( 96 -128 4 ) ( 96 -128 36 ) ( ( -0.03125 0 0 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 256 0 -28 ) ( 224 -128 -28 ) ( 224 -128 4 ) ( ( -0.03125 0 15.4028453827 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 256 0 -28 ) ( 128 0 228 ) ( 128 0 -28 ) ( ( -0.03125 0 0 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 96 -128 36 ) ( 96 -128 4 ) ( 128 0 4 ) ( ( -0.03125 0 48.59715271 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 128 0 0 ) ( 96 -128 32 ) ( 224 -128 32 ) ( ( 0.03125 0 16 ) ( 0 -0.03125 39.40284729 ) ) common/trigger 0 0 0
	}
	}
	}
	// entity 3
	{
	"classname" "trigger_push"
	"target" "FIELD-2-1"
	"height" "768"
	// brush 0
	{
	brushDef
	{
	( -128 96 36 ) ( -128 224 36 ) ( 0 256 4 ) ( ( 0.03125 0 0 ) ( 0 0.03125 0.0303169526 ) ) common/trigger 0 0 0
	( -128 96 4 ) ( -128 224 4 ) ( -128 224 36 ) ( ( 0.03125 0 0 ) ( 0 0.03125 0.125 ) ) common/trigger 0 0 0
	( -128 224 4 ) ( -128 224 -28 ) ( 0 256 -28 ) ( ( 0.03125 0 0 ) ( 0 0.03125 0.125 ) ) common/trigger 0 0 0
	( 0 128 -28 ) ( 0 128 228 ) ( 0 256 -28 ) ( ( 0.03125 0 0 ) ( 0 0.03125 0.125 ) ) common/trigger 0 0 0
	( -128 96 -28 ) ( -128 96 4 ) ( 0 128 4 ) ( ( 0.03125 0 0 ) ( 0 0.03125 0.125 ) ) common/trigger 0 0 0
	( 0 256 0 ) ( -128 224 32 ) ( -128 96 32 ) ( ( 0.03125 0 -0 ) ( -0 0.03125 0 ) ) common/trigger 0 0 0
	}
	}
	}
	// entity 4
	{
	"classname" "trigger_push"
	"target" "FIELD-2+1"
	"height" "768"
	// brush 0
	{
	brushDef
	{
	( -128 416 36 ) ( -128 544 36 ) ( 0 512 4 ) ( ( 0.03125 0 60 ) ( 0 -0.03125 39.3725280762 ) ) common/trigger 0 0 0
	( -128 416 4 ) ( -128 544 4 ) ( -128 544 36 ) ( ( -0.03125 0 44 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 0 384 -28 ) ( -128 416 -28 ) ( -128 416 4 ) ( ( -0.03125 0 10.5521345139 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 0 384 -28 ) ( 0 512 228 ) ( 0 512 -28 ) ( ( -0.03125 0 20 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( -128 544 36 ) ( -128 544 4 ) ( 0 512 4 ) ( ( -0.03125 0 53.4478645325 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 0 512 0 ) ( -128 544 32 ) ( -128 416 32 ) ( ( 0.03125 0 60 ) ( 0 -0.03125 39.40284729 ) ) common/trigger 0 0 0
	}
	}
	}
	// entity 5
	{
	"classname" "trigger_push"
	"target" "FIELD-1+2"
	"height" "768"
	// brush 0
	{
	brushDef
	{
	( 96 768 36 ) ( 224 768 36 ) ( 256 640 4 ) ( ( 0.03125 0 60 ) ( 0 0.03125 0.0303169526 ) ) common/trigger 0 0 0
	( 96 768 4 ) ( 224 768 4 ) ( 224 768 36 ) ( ( 0.03125 0 0 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 224 768 4 ) ( 224 768 -28 ) ( 256 640 -28 ) ( ( 0.03125 0 60 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 128 640 -28 ) ( 128 640 228 ) ( 256 640 -28 ) ( ( 0.03125 0 0 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 96 768 -28 ) ( 96 768 4 ) ( 128 640 4 ) ( ( 0.03125 0 4 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 256 640 0 ) ( 224 768 32 ) ( 96 768 32 ) ( ( 0.03125 0 60 ) ( 0 0.03125 0 ) ) common/trigger 0 0 0
	}
	}
	}
	// entity 6
	{
	"classname" "trigger_push"
	"target" "FIELD+1+2"
	"height" "768"
	// brush 0
	{
	brushDef
	{
	( 416 768 36 ) ( 544 768 36 ) ( 512 640 4 ) ( ( 0.03125 0 60 ) ( 0 -0.03125 19.9696846008 ) ) common/trigger 0 0 0
	( 416 768 4 ) ( 544 768 4 ) ( 544 768 36 ) ( ( -0.03125 0 44 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 384 640 -28 ) ( 416 768 -28 ) ( 416 768 4 ) ( ( -0.03125 0 55.1492881775 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 384 640 -28 ) ( 512 640 228 ) ( 512 640 -28 ) ( ( -0.03125 0 20 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 544 768 36 ) ( 544 768 4 ) ( 512 640 4 ) ( ( -0.03125 0 8.8507127762 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 512 640 0 ) ( 544 768 32 ) ( 416 768 32 ) ( ( 0.03125 0 60 ) ( 0 -0.03125 20 ) ) common/trigger 0 0 0
	}
	}
	}
	// entity 7
	{
	"classname" "trigger_push"
	"target" "FIELD+2+1"
	"height" "768"
	// brush 0
	{
	brushDef
	{
	( 768 544 36 ) ( 768 416 36 ) ( 640 384 4 ) ( ( 0.03125 0 16 ) ( 0 0.03125 0.0303169526 ) ) common/trigger 0 0 0
	( 768 544 4 ) ( 768 416 4 ) ( 768 416 36 ) ( ( 0.03125 0 44 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 768 416 4 ) ( 768 416 -28 ) ( 640 384 -28 ) ( ( 0.03125 0 55.1492843628 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 640 512 -28 ) ( 640 512 228 ) ( 640 384 -28 ) ( ( 0.03125 0 20 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 768 544 -28 ) ( 768 544 4 ) ( 640 512 4 ) ( ( 0.03125 0 8.8507156372 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 640 384 0 ) ( 768 416 32 ) ( 768 544 32 ) ( ( 0.03125 0 16 ) ( 0 0.03125 0 ) ) common/trigger 0 0 0
	}
	}
	}
	// entity 8
	{
	"classname" "trigger_push"
	"target" "FIELD+2-1"
	"height" "768"
	// brush 0
	{
	brushDef
	{
	( 768 224 36 ) ( 768 96 36 ) ( 640 128 4 ) ( ( 0.03125 0 16 ) ( 0 -0.03125 19.9696826935 ) ) common/trigger 0 0 0
	( 768 224 4 ) ( 768 96 4 ) ( 768 96 36 ) ( ( -0.03125 0 0 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 640 256 -28 ) ( 768 224 -28 ) ( 768 224 4 ) ( ( -0.03125 0 60 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 640 256 -28 ) ( 640 128 228 ) ( 640 128 -28 ) ( ( -0.03125 0 0 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 768 96 36 ) ( 768 96 4 ) ( 640 128 4 ) ( ( -0.03125 0 4 ) ( 0 0.03125 7.125 ) ) common/trigger 0 0 0
	( 640 128 0 ) ( 768 96 32 ) ( 768 224 32 ) ( ( 0.03125 0 16 ) ( 0 -0.03125 19.9999980927 ) ) common/trigger 0 0 0
	}
	}
	}
	// entity 9
	{
	"classname" "target_position"
	"origin" "320 320 8"
	"targetname" "FIELD"
	}
};

sub Translate($$$)
{
	my ($text, $x, $y) = @_;
	my $dx = $x * 1280;
	my $dy = $y * 1280;
	my $num = qr{[-+]?\d+};
	for(split /\s*\n\s*/, $text)
	{
		s{^"origin" "($num) ($num) ($num)"$}{
			sprintf '"origin" "%f %f %f"', $1 + $dx, $2 + $dy, $3;
		}se;
		s{^\( ($num) ($num) ($num) \) \( ($num) ($num) ($num) \) \( ($num) ($num) ($num) \)}{
			sprintf '( %f %f %f ) ( %f %f %f ) ( %f %f %f )', $1 + $dx, $2 + $dy, $3, $4 + $dx, $5 + $dy, $6, $7 + $dx, $8 + $dy, $9;
		}se;
		s{FIELD(?:([-+]$num)([-+]$num))?}{
			sprintf 'Field%c%c', 65 + $x + $1, 49 + $y + $2
		}se;
		s{(red|blue)}{
			$1 eq "red" ? "blue" : "red"
		}gse if ($x ^ $y) & 1;
		print "$_\n";
	}
}

my $row;
my $col;

print <<'EOF';
{
"classname" "worldspawn"
EOF
for $row(0..3)
{
	for $col(0..3)
	{
		Translate $brushes, $col, $row;
	}
}
print <<'EOF';
}
EOF
for $row(0..3)
{
	for $col(0..3)
	{
		Translate $entities, $col, $row;
	}
}
