<?php
// +-------------------------------+
// |   DreamStats 6.1 Revolution   |
// |  Copyright 2007  q6 Networks  |
// |   http://www.mnprojects.net   |
// +-------------------------------+

// Configuration
$flag_extension = "gif";

///////////////////////////////////////////
// -- Country Flag
///////////////////////////////////////////

if(!empty($settings['country']))
{
    if(file_exists("images/flags"))
    {
        $countryflag_path = "images/flags/" . $settings['country'] . "." . $flag_extension;

        if(file_exists($countryflag_path))
        {
            $countryflag = ' <img id="flag" src="'.$countryflag_path.'">';
        }
    }
}

///////////////////////////////////////////
// -- Players / Slots
///////////////////////////////////////////

$players_slash = "/";
$players_number = $players;
$slots = (output('sv_maxclients')-output('sv_privateclients'));

if($players >= $slots)
{
    $players = '<font class="dsr-full_lag">' . $players . '/' . $slots . '</font>';
}
else
{
    $players = '<font class="dsr-normal">' . $players . '/' . $slots . '</font>';
}

///////////////////////////////////////////
// -- Players Percentage
///////////////////////////////////////////

$players_percent = ($players_number / $slots) * 100;
$players_percent = explode(".", $players_percent);
$players_percent = $players_percent[0];

///////////////////////////////////////////
// -- Maps Folder
///////////////////////////////////////////

switch (output("gamename"))
{
    case 'Call of Duty':         $mapsfolder = "callofduty_maps";  break;
    case 'CoD:United Offensive': $mapsfolder = "callofduty_maps";  break;
    case 'Call of Duty 2':       $mapsfolder = "callofduty2_maps"; break;
    case 'Call of Duty 4':       $mapsfolder = "callofduty4_maps"; break;
}

///////////////////////////////////////////
// -- Generate Map Path
///////////////////////////////////////////

$map_path = "images/".$mapsfolder."/".output('mapname').".".$settings['imgformat'];

list($img_width, $img_height, $img_type, $img_attr) = @getimagesize($map_path);

if(!file_exists($map_path))
{
    $map_path = "images/unknown_map.jpg";
    $img_height = 144;
}

///////////////////////////////////////////
// -- Map Image Alignment
///////////////////////////////////////////

if($settings['mapimage'] == "Normal")
{
    $map_image_align = "";
    $map_image_align_tbl = "";
}
elseif($settings['mapimage'] == "Fill 100%")
{
    $map_image_align = ' width="100%" height="'.$img_height.'"';
    $map_image_align_tbl = "";
}
elseif($settings['mapimage'] == "Left")
{
    $map_image_align_tbl = ' align="left"';
    $map_image_alignl = "";
}
elseif($settings['mapimage'] == "Center")
{
    $map_image_align_tbl = ' align="center"';
    $map_image_align = "";
}
elseif($settings['mapimage'] == "Right")
{
    $map_image_align_tbl = ' align="right"';
    $map_image_align = "";
}

///////////////////////////////////////////
// -- Colorize Names
///////////////////////////////////////////

function colored($color)
{
  global $settings;

    if($settings['usecolors'] == "yes")
    {
        $color = str_replace('^1', "<font color=\"" . $settings['c1'] .  "\">", $color);
        $color = str_replace("^2", "<font color=\"" . $settings['c2'] .  "\">", $color);
        $color = str_replace("^3", "<font color=\"" . $settings['c3'] .  "\">", $color);
        $color = str_replace("^4", "<font color=\"" . $settings['c4'] .  "\">", $color);
        $color = str_replace("^5", "<font color=\"" . $settings['c5'] .  "\">", $color);
        $color = str_replace("^6", "<font color=\"" . $settings['c6'] .  "\">", $color);
        $color = str_replace("^7", "<font color=\"" . $settings['c7'] .  "\">", $color);
        $color = str_replace("^8", "<font color=\"" . $settings['c8'] .  "\">", $color);
        $color = str_replace("^9", "<font color=\"" . $settings['c9'] .  "\">", $color);
        $color = str_replace("^0", "<font color=\"" . $settings['c0'] .  "\">", $color);

        return $color . "</font>";
    }
    else
    {
        $color = str_replace(array("^1", "^2", "^3", "^4", "^5", "^6", "^7", "^8", "^9", "^0"), "", $color);

        return $color;
    }
}

///////////////////////////////////////////
// -- Colorize Pings
///////////////////////////////////////////

function colorizeping($color)
{
  global $settings;

    if($settings['usepingcolors'] == "yes")
    {
        if($color >= $settings['pingcolorsmin'])
        {
            $color_final = "<font class=\"dsr-medlag\">" . $color . "</font>";
        }

        if($color == 999)
        {
            $color_final = "<font class=\"dsr-full_lag\">" . $color . "</font>";
        }

        if($color < $settings['pingcolorsmin'])
        {
            $color_final = $color;
        }

        return $color_final;
    }
    else
    {
        return $color;
    }
}

///////////////////////////////////////////
// -- Tooltip
///////////////////////////////////////////

function t($text)
{
    return 'onmouseover="tooltip(\''.$text.'\');" onmouseout="exit();" style="cursor: pointer;"';
}

///////////////////////////////////////////
// -- Gametypes Recognition
///////////////////////////////////////////

switch (output("g_gametype"))
{
    // Default & Custom gametypes

    case 'sd'   : $gametype = "Search & Destroy";              break;
    case 'ctf'  : $gametype = "Capture the Flag";              break;
    case 'hq'   : $gametype = "Headquarters";                  break;
    case 'koth' : $gametype = "Headquarters";                  break;
    case 'dm'   : $gametype = "Deathmatch";                    break; // Free for all in cod4, specified below
    case 'tdm'  : $gametype = "Team Deathmatch";               break;
    case 'war'  : $gametype = "Team Deathmatch";               break;
    case 're'   : $gametype = "Retrieval";                     break;
    case 'bel'  : $gametype = "Behind Enemy Lines";            break;
    case 'htf'  : $gametype = "Hold The Flag";                 break;
    case 'cnq'  : $gametype = "Conquest";                      break;
    case 'bas'  : $gametype = "Base Assault";                  break;
    case 'dom'  : $gametype = "Domination";                    break;
    case 'rsd'  : $gametype = "Reinforced Search and Destroy"; break;
    case 'Mc_DM': $gametype = "Merciless Deathmatch";          break;
    case 'Mc_TD': $gametype = "Merciless Team Deathmatch";     break;
    case 'Mc_RE': $gametype = "Merciless Retrieval";           break;
    case 'Mc_SE': $gametype = "Merciless Search and Destroy";  break;
    case 'Mc_HQ': $gametype = "Merciless Headquarters";        break;
    case 'sdm'  : $gametype = "Speed Deathmatch";              break;
    case 'hob'  : $gametype = "Heat of Battle";                break;
    case 'asn'  : $gametype = "Assassin";                      break;
    case 'cti'  : $gametype = "Capture The Item";              break;
    case 'sab'  : $gametype = "Sabotage";                      break;

    default: $gametype = output("g_gametype"); break;
}

if($gametype == "Deathmatch")
{
    if(output("gamename") == "Call of Duty 4")
    {
        $gametype = "Free for All";
    }
}

///////////////////////////////////////////
// -- More Server Information
///////////////////////////////////////////

if(output("sv_pure") == 1)
{
    $extrainfo = $lang['pure'] . '<br>';
}
else
{
    $extrainfo = $lang['notpure'] . '<br>';
}

if(is_numeric(output("sv_punkbuster")))
{
    if(output("sv_punkbuster") == 0)
    {
        $extrainfo .= $lang['punkbusteroff'] . '<br>';
    }
    else
    {
        $extrainfo .= $lang['punkbusteron'] . '<br>';
    }
}

if(is_numeric(output("sv_maxPing")))
{
    if(output("sv_maxPing") == 0)
    {
        $extrainfo .= $lang['maxping'] . ' <b>' . $lang['unlimited'] . '</b><br>';
    }
    else
    {
        $extrainfo .= $lang['maxping'] . ' <b>' . output("sv_maxPing") . '</b><br>';
    }
}

if(is_numeric(output("sv_minPing")))
{
    $extrainfo .= $lang['minping'] . ' <b>' . output("sv_minPing") . '</b><br>';
}

if(is_numeric(output("sv_maxRate")))
{
    if(output("sv_maxRate") == 0)
    {
        $extrainfo .= $lang['maxrate'] . ' <b>' . $lang['unlimited'] . '</b><br>';
    }
    else
    {
        $extrainfo .= $lang['maxrate'] . ' <b>' . output("sv_maxRate") . '</b><br>';
    }
}

if(is_numeric(output("pswrd")))
{
    if(output("pswrd") == 0)
    {
        $extrainfo .= $lang['nopassword'] . '<br>';
    }
    else
    {
        $extrainfo .= $lang['password'] . '<br>';
    }
}

$extrainfo .= $lang['running'] . ' <b>' . output("gamename") . '</b> ' . $lang['version'] . ' <b>' . output("shortversion") . '</b><br>';

if(is_numeric(output("scr_killcam")))
{
    if(output("scr_killcam") == 0)
    {
        $extrainfo .= $lang['killcamoff'] . '<br>';
    }
    else
    {
        $extrainfo .= $lang['killcamon'] . '<br>';
    }
}

if(is_numeric(output("sv_voice")))
{
    if(output("sv_voice") == 0)
    {
        $extrainfo .= $lang['voiceoff'] . '<br>';
    }
    else
    {
        $extrainfo .= $lang['voiceon'] . '<br>';
    }
}

?>
