'This file will generate a character for DTNC and save the data to
'a text file. The Visual Basic Scripting runtime 5.5 is required to
'execute this script. It comes with Internet Explorer 5.0 or you can 
'get the runtime from Miscrosoft at:
'http://www.microsoft.com/msdownload/vbscript/scripting.asp


Const ForWriting = 2
Dim cChar 'Character info

Randomize
Set cChar = New ChClass 'Get a character object.

'Make sure we have a file name.
cChar.OpenDTNCFile 'Open the putput file.
cChar.GenChar   'Generate the basic attributes.
cChar.WriteChar 'Output the data.


'***** Definitions *******

'The Character info.
Class ChClass
  Dim fso   'File System Object
  Dim ts    'The file text stream
  Dim CFile 'The output file name.
  Dim Name
  Dim Background
  Dim Initiative
  Dim Exp
  Dim Credits
  Dim Strength
  Dim Endurance
  Dim Agility
  Dim Dexterity
  Dim Intelligence
  Dim Wisdom
  Dim Interpersonal
  Dim Intuition
  Dim Learning
  Dim Psi
  Dim Sight
  Dim Hearing
  Dim HP
  Dim CHI

  Private Sub Class_Initialize()
     Set fso = CreateObject("Scripting.FileSystemObject")
     CFile = InputBox("Enter output file name:","File Name","")
  End Sub

  
  'Return a number from low to high inclusive.
  Private Function Roll (Low, High)
    Roll = Int((High - Low + 1) * Rnd + Low)
  End Function

  Public Sub GenChar()
    cChar.Name = InputBox("Enter Character Name:","Character Name","")
    cChar.Background = "Adept"
    cChar.Initiative = Roll(1,100)
    cChar.Exp = Roll(1,100) * 100
    cChar.Credits = Roll(1,100) * 100
    cChar.Strength = Roll(1,100)
    cChar.Endurance = Roll(1,100)
    cChar.Agility = Roll(1,100)
    cChar.Dexterity = Roll(1,100)
    cChar.Intelligence = Roll(1,100)
    cChar.Wisdom = Roll(1,100)
    cChar.Interpersonal = Roll(1,100)
    cChar.Intuition = Roll(1,100)
    cChar.Learning = Roll(1,100)
    cChar.Psi = Roll(1,100)
    cChar.Sight = Roll(1,100)
    cChar.Hearing = Roll(1,100)
    cChar.HP = cChar.Strength + cChar.Endurance
    cChar.CHI = cChar.Psi + cChar.Endurance
  End Sub

  Public Sub WriteChar()
    Const LS = 50

    ts.Writeline String(LS, "-")
    ts.WriteLine "DTNC Character Generator"
    ts.WriteLine "Copyright (c) 2001 by Richard D. Clark"
    ts.Writeline String(LS, "-")

    ts.WriteLine "Name: " & cChar.Name
    ts.WriteLine "Background: " & cChar.Background
    ts.WriteLine "Initiative: " & cChar.Initiative
    ts.Writeline String(LS, "-")
    ts.Write "Exp: " & cChar.Exp & "  "
    ts.WriteLine "Credits: " & cChar.Credits

    ts.Writeline String(LS, "-")
    ts.WriteLine "Attributes"
    ts.Writeline String(LS, "-")

    ts.Write "STR: " & cChar.Strength & "  "
    ts.Write "END: " & cChar.Endurance & "  "
    ts.Write "AGL: " & cChar.Agility & "  "
    ts.Write "DEX: " & cChar.Dexterity & "  "
    ts.Write "INT: " &  cChar.Intelligence & "  "
    ts.WriteLine "WIS: " &  cChar.Wisdom
    ts.Write "IP: " &  cChar.Interpersonal & "  "
    ts.Write "INT: " & cChar.Intuition & "  "
    ts.Write "LRN: " &  cChar.Learning & "  "
    ts.Write "PSI: " &  cChar.Psi & "  "
    ts.Write "SIG: " &  cChar.Sight & "  "
    ts.WriteLine "HER: " &  cChar.Hearing
    ts.Write "HP: " & cChar.HP & "  "
    ts.WriteLine "CHI: " & cChar.CHI & "  "
  End Sub

  Public Function OpenDTNCFile()
    Set ts = fso.OpenTextFile(CFile, ForWriting, True)
  End Function

End Class


