/*
** QGL_WIN.C
**
** This file implements the operating system binding of GL to QGL function
** pointers.  When doing a port of Quake2 you must implement the following
** two functions:
**
** QGL_Init() - loads libraries, assigns function pointers, etc.
** QGL_Shutdown() - unloads libraries, NULLs function pointers
*/
#include "qgl.h"
#include <float.h>

HMODULE g_hGLDLL;
HMODULE g_hGLUDLL;

#	pragma warning (disable : 4113 4133 4047 )

int   ( WINAPI * qwglChoosePixelFormat )(HDC, CONST PIXELFORMATDESCRIPTOR *);
int   ( WINAPI * qwglDescribePixelFormat) (HDC, int, UINT, LPPIXELFORMATDESCRIPTOR);
int   ( WINAPI * qwglGetPixelFormat)(HDC);
BOOL  ( WINAPI * qwglSetPixelFormat)(HDC, int, CONST PIXELFORMATDESCRIPTOR *);
BOOL  ( WINAPI * qwglSwapBuffers)(HDC);

BOOL  ( WINAPI * qwglCopyContext)(HGLRC, HGLRC, UINT);
HGLRC ( WINAPI * qwglCreateContext)(HDC);
HGLRC ( WINAPI * qwglCreateLayerContext)(HDC, int);
BOOL  ( WINAPI * qwglDeleteContext)(HGLRC);
HGLRC ( WINAPI * qwglGetCurrentContext)(VOID);
HDC   ( WINAPI * qwglGetCurrentDC)(VOID);
PROC  ( WINAPI * qwglGetProcAddress)(LPCSTR);
BOOL  ( WINAPI * qwglMakeCurrent)(HDC, HGLRC);
BOOL  ( WINAPI * qwglShareLists)(HGLRC, HGLRC);
BOOL  ( WINAPI * qwglUseFontBitmaps)(HDC, DWORD, DWORD, DWORD);

BOOL  ( WINAPI * qwglUseFontOutlines)(HDC, DWORD, DWORD, DWORD, FLOAT,
                                           FLOAT, int, LPGLYPHMETRICSFLOAT);

BOOL ( WINAPI * qwglDescribeLayerPlane)(HDC, int, int, UINT,
                                            LPLAYERPLANEDESCRIPTOR);
int  ( WINAPI * qwglSetLayerPaletteEntries)(HDC, int, int, int,
                                                CONST COLORREF *);
int  ( WINAPI * qwglGetLayerPaletteEntries)(HDC, int, int, int,
                                                COLORREF *);
BOOL ( WINAPI * qwglRealizeLayerPalette)(HDC, int, BOOL);
BOOL ( WINAPI * qwglSwapLayerBuffers)(HDC, UINT);

void ( APIENTRY * qglAccum )(GLenum op, GLfloat value);
void ( APIENTRY * qglAlphaFunc )(GLenum func, GLclampf ref);
GLboolean ( APIENTRY * qglAreTexturesResident )(GLsizei n, const GLuint *textures, GLboolean *residences);
void ( APIENTRY * qglArrayElement )(GLint i);
void ( APIENTRY * qglBegin )(GLenum mode);
void ( APIENTRY * qglBindTexture )(GLenum target, GLuint texture);
void ( APIENTRY * qglBitmap )(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap);
void ( APIENTRY * qglBlendFunc )(GLenum sfactor, GLenum dfactor);
void ( APIENTRY * qglCallList )(GLuint list);
void ( APIENTRY * qglCallLists )(GLsizei n, GLenum type, const GLvoid *lists);
void ( APIENTRY * qglClear )(GLbitfield mask);
void ( APIENTRY * qglClearAccum )(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
void ( APIENTRY * qglClearColor )(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
void ( APIENTRY * qglClearDepth )(GLclampd depth);
void ( APIENTRY * qglClearIndex )(GLfloat c);
void ( APIENTRY * qglClearStencil )(GLint s);
void ( APIENTRY * qglClipPlane )(GLenum plane, const GLdouble *equation);
void ( APIENTRY * qglColor3b )(GLbyte red, GLbyte green, GLbyte blue);
void ( APIENTRY * qglColor3bv )(const GLbyte *v);
void ( APIENTRY * qglColor3d )(GLdouble red, GLdouble green, GLdouble blue);
void ( APIENTRY * qglColor3dv )(const GLdouble *v);
void ( APIENTRY * qglColor3f )(GLfloat red, GLfloat green, GLfloat blue);
void ( APIENTRY * qglColor3fv )(const GLfloat *v);
void ( APIENTRY * qglColor3i )(GLint red, GLint green, GLint blue);
void ( APIENTRY * qglColor3iv )(const GLint *v);
void ( APIENTRY * qglColor3s )(GLshort red, GLshort green, GLshort blue);
void ( APIENTRY * qglColor3sv )(const GLshort *v);
void ( APIENTRY * qglColor3ub )(GLubyte red, GLubyte green, GLubyte blue);
void ( APIENTRY * qglColor3ubv )(const GLubyte *v);
void ( APIENTRY * qglColor3ui )(GLuint red, GLuint green, GLuint blue);
void ( APIENTRY * qglColor3uiv )(const GLuint *v);
void ( APIENTRY * qglColor3us )(GLushort red, GLushort green, GLushort blue);
void ( APIENTRY * qglColor3usv )(const GLushort *v);
void ( APIENTRY * qglColor4b )(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha);
void ( APIENTRY * qglColor4bv )(const GLbyte *v);
void ( APIENTRY * qglColor4d )(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha);
void ( APIENTRY * qglColor4dv )(const GLdouble *v);
void ( APIENTRY * qglColor4f )(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
void ( APIENTRY * qglColor4fv )(const GLfloat *v);
void ( APIENTRY * qglColor4i )(GLint red, GLint green, GLint blue, GLint alpha);
void ( APIENTRY * qglColor4iv )(const GLint *v);
void ( APIENTRY * qglColor4s )(GLshort red, GLshort green, GLshort blue, GLshort alpha);
void ( APIENTRY * qglColor4sv )(const GLshort *v);
void ( APIENTRY * qglColor4ub )(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha);
void ( APIENTRY * qglColor4ubv )(const GLubyte *v);
void ( APIENTRY * qglColor4ui )(GLuint red, GLuint green, GLuint blue, GLuint alpha);
void ( APIENTRY * qglColor4uiv )(const GLuint *v);
void ( APIENTRY * qglColor4us )(GLushort red, GLushort green, GLushort blue, GLushort alpha);
void ( APIENTRY * qglColor4usv )(const GLushort *v);
void ( APIENTRY * qglColorMask )(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
void ( APIENTRY * qglColorMaterial )(GLenum face, GLenum mode);
void ( APIENTRY * qglColorPointer )(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void ( APIENTRY * qglCopyPixels )(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type);
void ( APIENTRY * qglCopyTexImage1D )(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border);
void ( APIENTRY * qglCopyTexImage2D )(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
void ( APIENTRY * qglCopyTexSubImage1D )(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
void ( APIENTRY * qglCopyTexSubImage2D )(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
void ( APIENTRY * qglCullFace )(GLenum mode);
void ( APIENTRY * qglDeleteLists )(GLuint list, GLsizei range);
void ( APIENTRY * qglDeleteTextures )(GLsizei n, const GLuint *textures);
void ( APIENTRY * qglDepthFunc )(GLenum func);
void ( APIENTRY * qglDepthMask )(GLboolean flag);
void ( APIENTRY * qglDepthRange )(GLclampd zNear, GLclampd zFar);
void ( APIENTRY * qglDisable )(GLenum cap);
void ( APIENTRY * qglDisableClientState )(GLenum array);
void ( APIENTRY * qglDrawArrays )(GLenum mode, GLint first, GLsizei count);
void ( APIENTRY * qglDrawBuffer )(GLenum mode);
void ( APIENTRY * qglDrawElements )(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices);
void ( APIENTRY * qglDrawPixels )(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
void ( APIENTRY * qglEdgeFlag )(GLboolean flag);
void ( APIENTRY * qglEdgeFlagPointer )(GLsizei stride, const GLvoid *pointer);
void ( APIENTRY * qglEdgeFlagv )(const GLboolean *flag);
void ( APIENTRY * qglEnable )(GLenum cap);
void ( APIENTRY * qglEnableClientState )(GLenum array);
void ( APIENTRY * qglEnd )(void);
void ( APIENTRY * qglEndList )(void);
void ( APIENTRY * qglEvalCoord1d )(GLdouble u);
void ( APIENTRY * qglEvalCoord1dv )(const GLdouble *u);
void ( APIENTRY * qglEvalCoord1f )(GLfloat u);
void ( APIENTRY * qglEvalCoord1fv )(const GLfloat *u);
void ( APIENTRY * qglEvalCoord2d )(GLdouble u, GLdouble v);
void ( APIENTRY * qglEvalCoord2dv )(const GLdouble *u);
void ( APIENTRY * qglEvalCoord2f )(GLfloat u, GLfloat v);
void ( APIENTRY * qglEvalCoord2fv )(const GLfloat *u);
void ( APIENTRY * qglEvalMesh1 )(GLenum mode, GLint i1, GLint i2);
void ( APIENTRY * qglEvalMesh2 )(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2);
void ( APIENTRY * qglEvalPoint1 )(GLint i);
void ( APIENTRY * qglEvalPoint2 )(GLint i, GLint j);
void ( APIENTRY * qglFeedbackBuffer )(GLsizei size, GLenum type, GLfloat *buffer);
void ( APIENTRY * qglFinish )(void);
void ( APIENTRY * qglFlush )(void);
void ( APIENTRY * qglFogf )(GLenum pname, GLfloat param);
void ( APIENTRY * qglFogfv )(GLenum pname, const GLfloat *params);
void ( APIENTRY * qglFogi )(GLenum pname, GLint param);
void ( APIENTRY * qglFogiv )(GLenum pname, const GLint *params);
void ( APIENTRY * qglFrontFace )(GLenum mode);
void ( APIENTRY * qglFrustum )(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
GLuint ( APIENTRY * qglGenLists )(GLsizei range);
void ( APIENTRY * qglGenTextures )(GLsizei n, GLuint *textures);
void ( APIENTRY * qglGetBooleanv )(GLenum pname, GLboolean *params);
void ( APIENTRY * qglGetClipPlane )(GLenum plane, GLdouble *equation);
void ( APIENTRY * qglGetDoublev )(GLenum pname, GLdouble *params);
GLenum ( APIENTRY * qglGetError )(void);
void ( APIENTRY * qglGetFloatv )(GLenum pname, GLfloat *params);
void ( APIENTRY * qglGetIntegerv )(GLenum pname, GLint *params);
void ( APIENTRY * qglGetLightfv )(GLenum light, GLenum pname, GLfloat *params);
void ( APIENTRY * qglGetLightiv )(GLenum light, GLenum pname, GLint *params);
void ( APIENTRY * qglGetMapdv )(GLenum target, GLenum query, GLdouble *v);
void ( APIENTRY * qglGetMapfv )(GLenum target, GLenum query, GLfloat *v);
void ( APIENTRY * qglGetMapiv )(GLenum target, GLenum query, GLint *v);
void ( APIENTRY * qglGetMaterialfv )(GLenum face, GLenum pname, GLfloat *params);
void ( APIENTRY * qglGetMaterialiv )(GLenum face, GLenum pname, GLint *params);
void ( APIENTRY * qglGetPixelMapfv )(GLenum map, GLfloat *values);
void ( APIENTRY * qglGetPixelMapuiv )(GLenum map, GLuint *values);
void ( APIENTRY * qglGetPixelMapusv )(GLenum map, GLushort *values);
void ( APIENTRY * qglGetPointerv )(GLenum pname, GLvoid* *params);
void ( APIENTRY * qglGetPolygonStipple )(GLubyte *mask);
const GLubyte * ( APIENTRY * qglGetString )(GLenum name);
void ( APIENTRY * qglGetTexEnvfv )(GLenum target, GLenum pname, GLfloat *params);
void ( APIENTRY * qglGetTexEnviv )(GLenum target, GLenum pname, GLint *params);
void ( APIENTRY * qglGetTexGendv )(GLenum coord, GLenum pname, GLdouble *params);
void ( APIENTRY * qglGetTexGenfv )(GLenum coord, GLenum pname, GLfloat *params);
void ( APIENTRY * qglGetTexGeniv )(GLenum coord, GLenum pname, GLint *params);
void ( APIENTRY * qglGetTexImage )(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
void ( APIENTRY * qglGetTexLevelParameterfv )(GLenum target, GLint level, GLenum pname, GLfloat *params);
void ( APIENTRY * qglGetTexLevelParameteriv )(GLenum target, GLint level, GLenum pname, GLint *params);
void ( APIENTRY * qglGetTexParameterfv )(GLenum target, GLenum pname, GLfloat *params);
void ( APIENTRY * qglGetTexParameteriv )(GLenum target, GLenum pname, GLint *params);
void ( APIENTRY * qglHint )(GLenum target, GLenum mode);
void ( APIENTRY * qglIndexMask )(GLuint mask);
void ( APIENTRY * qglIndexPointer )(GLenum type, GLsizei stride, const GLvoid *pointer);
void ( APIENTRY * qglIndexd )(GLdouble c);
void ( APIENTRY * qglIndexdv )(const GLdouble *c);
void ( APIENTRY * qglIndexf )(GLfloat c);
void ( APIENTRY * qglIndexfv )(const GLfloat *c);
void ( APIENTRY * qglIndexi )(GLint c);
void ( APIENTRY * qglIndexiv )(const GLint *c);
void ( APIENTRY * qglIndexs )(GLshort c);
void ( APIENTRY * qglIndexsv )(const GLshort *c);
void ( APIENTRY * qglIndexub )(GLubyte c);
void ( APIENTRY * qglIndexubv )(const GLubyte *c);
void ( APIENTRY * qglInitNames )(void);
void ( APIENTRY * qglInterleavedArrays )(GLenum format, GLsizei stride, const GLvoid *pointer);
GLboolean ( APIENTRY * qglIsEnabled )(GLenum cap);
GLboolean ( APIENTRY * qglIsList )(GLuint list);
GLboolean ( APIENTRY * qglIsTexture )(GLuint texture);
void ( APIENTRY * qglLightModelf )(GLenum pname, GLfloat param);
void ( APIENTRY * qglLightModelfv )(GLenum pname, const GLfloat *params);
void ( APIENTRY * qglLightModeli )(GLenum pname, GLint param);
void ( APIENTRY * qglLightModeliv )(GLenum pname, const GLint *params);
void ( APIENTRY * qglLightf )(GLenum light, GLenum pname, GLfloat param);
void ( APIENTRY * qglLightfv )(GLenum light, GLenum pname, const GLfloat *params);
void ( APIENTRY * qglLighti )(GLenum light, GLenum pname, GLint param);
void ( APIENTRY * qglLightiv )(GLenum light, GLenum pname, const GLint *params);
void ( APIENTRY * qglLineStipple )(GLint factor, GLushort pattern);
void ( APIENTRY * qglLineWidth )(GLfloat width);
void ( APIENTRY * qglListBase )(GLuint base);
void ( APIENTRY * qglLoadIdentity )(void);
void ( APIENTRY * qglLoadMatrixd )(const GLdouble *m);
void ( APIENTRY * qglLoadMatrixf )(const GLfloat *m);
void ( APIENTRY * qglLoadName )(GLuint name);
void ( APIENTRY * qglLogicOp )(GLenum opcode);
void ( APIENTRY * qglMap1d )(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points);
void ( APIENTRY * qglMap1f )(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points);
void ( APIENTRY * qglMap2d )(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points);
void ( APIENTRY * qglMap2f )(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points);
void ( APIENTRY * qglMapGrid1d )(GLint un, GLdouble u1, GLdouble u2);
void ( APIENTRY * qglMapGrid1f )(GLint un, GLfloat u1, GLfloat u2);
void ( APIENTRY * qglMapGrid2d )(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2);
void ( APIENTRY * qglMapGrid2f )(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2);
void ( APIENTRY * qglMaterialf )(GLenum face, GLenum pname, GLfloat param);
void ( APIENTRY * qglMaterialfv )(GLenum face, GLenum pname, const GLfloat *params);
void ( APIENTRY * qglMateriali )(GLenum face, GLenum pname, GLint param);
void ( APIENTRY * qglMaterialiv )(GLenum face, GLenum pname, const GLint *params);
void ( APIENTRY * qglMatrixMode )(GLenum mode);
void ( APIENTRY * qglMultMatrixd )(const GLdouble *m);
void ( APIENTRY * qglMultMatrixf )(const GLfloat *m);
void ( APIENTRY * qglNewList )(GLuint list, GLenum mode);
void ( APIENTRY * qglNormal3b )(GLbyte nx, GLbyte ny, GLbyte nz);
void ( APIENTRY * qglNormal3bv )(const GLbyte *v);
void ( APIENTRY * qglNormal3d )(GLdouble nx, GLdouble ny, GLdouble nz);
void ( APIENTRY * qglNormal3dv )(const GLdouble *v);
void ( APIENTRY * qglNormal3f )(GLfloat nx, GLfloat ny, GLfloat nz);
void ( APIENTRY * qglNormal3fv )(const GLfloat *v);
void ( APIENTRY * qglNormal3i )(GLint nx, GLint ny, GLint nz);
void ( APIENTRY * qglNormal3iv )(const GLint *v);
void ( APIENTRY * qglNormal3s )(GLshort nx, GLshort ny, GLshort nz);
void ( APIENTRY * qglNormal3sv )(const GLshort *v);
void ( APIENTRY * qglNormalPointer )(GLenum type, GLsizei stride, const GLvoid *pointer);
void ( APIENTRY * qglOrtho )(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
void ( APIENTRY * qglPassThrough )(GLfloat token);
void ( APIENTRY * qglPixelMapfv )(GLenum map, GLsizei mapsize, const GLfloat *values);
void ( APIENTRY * qglPixelMapuiv )(GLenum map, GLsizei mapsize, const GLuint *values);
void ( APIENTRY * qglPixelMapusv )(GLenum map, GLsizei mapsize, const GLushort *values);
void ( APIENTRY * qglPixelStoref )(GLenum pname, GLfloat param);
void ( APIENTRY * qglPixelStorei )(GLenum pname, GLint param);
void ( APIENTRY * qglPixelTransferf )(GLenum pname, GLfloat param);
void ( APIENTRY * qglPixelTransferi )(GLenum pname, GLint param);
void ( APIENTRY * qglPixelZoom )(GLfloat xfactor, GLfloat yfactor);
void ( APIENTRY * qglPointSize )(GLfloat size);
void ( APIENTRY * qglPolygonMode )(GLenum face, GLenum mode);
void ( APIENTRY * qglPolygonOffset )(GLfloat factor, GLfloat units);
void ( APIENTRY * qglPolygonStipple )(const GLubyte *mask);
void ( APIENTRY * qglPopAttrib )(void);
void ( APIENTRY * qglPopClientAttrib )(void);
void ( APIENTRY * qglPopMatrix )(void);
void ( APIENTRY * qglPopName )(void);
void ( APIENTRY * qglPrioritizeTextures )(GLsizei n, const GLuint *textures, const GLclampf *priorities);
void ( APIENTRY * qglPushAttrib )(GLbitfield mask);
void ( APIENTRY * qglPushClientAttrib )(GLbitfield mask);
void ( APIENTRY * qglPushMatrix )(void);
void ( APIENTRY * qglPushName )(GLuint name);
void ( APIENTRY * qglRasterPos2d )(GLdouble x, GLdouble y);
void ( APIENTRY * qglRasterPos2dv )(const GLdouble *v);
void ( APIENTRY * qglRasterPos2f )(GLfloat x, GLfloat y);
void ( APIENTRY * qglRasterPos2fv )(const GLfloat *v);
void ( APIENTRY * qglRasterPos2i )(GLint x, GLint y);
void ( APIENTRY * qglRasterPos2iv )(const GLint *v);
void ( APIENTRY * qglRasterPos2s )(GLshort x, GLshort y);
void ( APIENTRY * qglRasterPos2sv )(const GLshort *v);
void ( APIENTRY * qglRasterPos3d )(GLdouble x, GLdouble y, GLdouble z);
void ( APIENTRY * qglRasterPos3dv )(const GLdouble *v);
void ( APIENTRY * qglRasterPos3f )(GLfloat x, GLfloat y, GLfloat z);
void ( APIENTRY * qglRasterPos3fv )(const GLfloat *v);
void ( APIENTRY * qglRasterPos3i )(GLint x, GLint y, GLint z);
void ( APIENTRY * qglRasterPos3iv )(const GLint *v);
void ( APIENTRY * qglRasterPos3s )(GLshort x, GLshort y, GLshort z);
void ( APIENTRY * qglRasterPos3sv )(const GLshort *v);
void ( APIENTRY * qglRasterPos4d )(GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void ( APIENTRY * qglRasterPos4dv )(const GLdouble *v);
void ( APIENTRY * qglRasterPos4f )(GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void ( APIENTRY * qglRasterPos4fv )(const GLfloat *v);
void ( APIENTRY * qglRasterPos4i )(GLint x, GLint y, GLint z, GLint w);
void ( APIENTRY * qglRasterPos4iv )(const GLint *v);
void ( APIENTRY * qglRasterPos4s )(GLshort x, GLshort y, GLshort z, GLshort w);
void ( APIENTRY * qglRasterPos4sv )(const GLshort *v);
void ( APIENTRY * qglReadBuffer )(GLenum mode);
void ( APIENTRY * qglReadPixels )(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
void ( APIENTRY * qglRectd )(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2);
void ( APIENTRY * qglRectdv )(const GLdouble *v1, const GLdouble *v2);
void ( APIENTRY * qglRectf )(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2);
void ( APIENTRY * qglRectfv )(const GLfloat *v1, const GLfloat *v2);
void ( APIENTRY * qglRecti )(GLint x1, GLint y1, GLint x2, GLint y2);
void ( APIENTRY * qglRectiv )(const GLint *v1, const GLint *v2);
void ( APIENTRY * qglRects )(GLshort x1, GLshort y1, GLshort x2, GLshort y2);
void ( APIENTRY * qglRectsv )(const GLshort *v1, const GLshort *v2);
GLint ( APIENTRY * qglRenderMode )(GLenum mode);
void ( APIENTRY * qglRotated )(GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
void ( APIENTRY * qglRotatef )(GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
void ( APIENTRY * qglScaled )(GLdouble x, GLdouble y, GLdouble z);
void ( APIENTRY * qglScalef )(GLfloat x, GLfloat y, GLfloat z);
void ( APIENTRY * qglScissor )(GLint x, GLint y, GLsizei width, GLsizei height);
void ( APIENTRY * qglSelectBuffer )(GLsizei size, GLuint *buffer);
void ( APIENTRY * qglShadeModel )(GLenum mode);
void ( APIENTRY * qglStencilFunc )(GLenum func, GLint ref, GLuint mask);
void ( APIENTRY * qglStencilMask )(GLuint mask);
void ( APIENTRY * qglStencilOp )(GLenum fail, GLenum zfail, GLenum zpass);
void ( APIENTRY * qglTexCoord1d )(GLdouble s);
void ( APIENTRY * qglTexCoord1dv )(const GLdouble *v);
void ( APIENTRY * qglTexCoord1f )(GLfloat s);
void ( APIENTRY * qglTexCoord1fv )(const GLfloat *v);
void ( APIENTRY * qglTexCoord1i )(GLint s);
void ( APIENTRY * qglTexCoord1iv )(const GLint *v);
void ( APIENTRY * qglTexCoord1s )(GLshort s);
void ( APIENTRY * qglTexCoord1sv )(const GLshort *v);
void ( APIENTRY * qglTexCoord2d )(GLdouble s, GLdouble t);
void ( APIENTRY * qglTexCoord2dv )(const GLdouble *v);
void ( APIENTRY * qglTexCoord2f )(GLfloat s, GLfloat t);
void ( APIENTRY * qglTexCoord2fv )(const GLfloat *v);
void ( APIENTRY * qglTexCoord2i )(GLint s, GLint t);
void ( APIENTRY * qglTexCoord2iv )(const GLint *v);
void ( APIENTRY * qglTexCoord2s )(GLshort s, GLshort t);
void ( APIENTRY * qglTexCoord2sv )(const GLshort *v);
void ( APIENTRY * qglTexCoord3d )(GLdouble s, GLdouble t, GLdouble r);
void ( APIENTRY * qglTexCoord3dv )(const GLdouble *v);
void ( APIENTRY * qglTexCoord3f )(GLfloat s, GLfloat t, GLfloat r);
void ( APIENTRY * qglTexCoord3fv )(const GLfloat *v);
void ( APIENTRY * qglTexCoord3i )(GLint s, GLint t, GLint r);
void ( APIENTRY * qglTexCoord3iv )(const GLint *v);
void ( APIENTRY * qglTexCoord3s )(GLshort s, GLshort t, GLshort r);
void ( APIENTRY * qglTexCoord3sv )(const GLshort *v);
void ( APIENTRY * qglTexCoord4d )(GLdouble s, GLdouble t, GLdouble r, GLdouble q);
void ( APIENTRY * qglTexCoord4dv )(const GLdouble *v);
void ( APIENTRY * qglTexCoord4f )(GLfloat s, GLfloat t, GLfloat r, GLfloat q);
void ( APIENTRY * qglTexCoord4fv )(const GLfloat *v);
void ( APIENTRY * qglTexCoord4i )(GLint s, GLint t, GLint r, GLint q);
void ( APIENTRY * qglTexCoord4iv )(const GLint *v);
void ( APIENTRY * qglTexCoord4s )(GLshort s, GLshort t, GLshort r, GLshort q);
void ( APIENTRY * qglTexCoord4sv )(const GLshort *v);
void ( APIENTRY * qglTexCoordPointer )(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void ( APIENTRY * qglTexEnvf )(GLenum target, GLenum pname, GLfloat param);
void ( APIENTRY * qglTexEnvfv )(GLenum target, GLenum pname, const GLfloat *params);
void ( APIENTRY * qglTexEnvi )(GLenum target, GLenum pname, GLint param);
void ( APIENTRY * qglTexEnviv )(GLenum target, GLenum pname, const GLint *params);
void ( APIENTRY * qglTexGend )(GLenum coord, GLenum pname, GLdouble param);
void ( APIENTRY * qglTexGendv )(GLenum coord, GLenum pname, const GLdouble *params);
void ( APIENTRY * qglTexGenf )(GLenum coord, GLenum pname, GLfloat param);
void ( APIENTRY * qglTexGenfv )(GLenum coord, GLenum pname, const GLfloat *params);
void ( APIENTRY * qglTexGeni )(GLenum coord, GLenum pname, GLint param);
void ( APIENTRY * qglTexGeniv )(GLenum coord, GLenum pname, const GLint *params);
void ( APIENTRY * qglTexImage1D )(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
void ( APIENTRY * qglTexImage2D )(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
void ( APIENTRY * qglTexParameterf )(GLenum target, GLenum pname, GLfloat param);
void ( APIENTRY * qglTexParameterfv )(GLenum target, GLenum pname, const GLfloat *params);
void ( APIENTRY * qglTexParameteri )(GLenum target, GLenum pname, GLint param);
void ( APIENTRY * qglTexParameteriv )(GLenum target, GLenum pname, const GLint *params);
void ( APIENTRY * qglTexSubImage1D )(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
void ( APIENTRY * qglTexSubImage2D )(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
void ( APIENTRY * qglTranslated )(GLdouble x, GLdouble y, GLdouble z);
void ( APIENTRY * qglTranslatef )(GLfloat x, GLfloat y, GLfloat z);
void ( APIENTRY * qglVertex2d )(GLdouble x, GLdouble y);
void ( APIENTRY * qglVertex2dv )(const GLdouble *v);
void ( APIENTRY * qglVertex2f )(GLfloat x, GLfloat y);
void ( APIENTRY * qglVertex2fv )(const GLfloat *v);
void ( APIENTRY * qglVertex2i )(GLint x, GLint y);
void ( APIENTRY * qglVertex2iv )(const GLint *v);
void ( APIENTRY * qglVertex2s )(GLshort x, GLshort y);
void ( APIENTRY * qglVertex2sv )(const GLshort *v);
void ( APIENTRY * qglVertex3d )(GLdouble x, GLdouble y, GLdouble z);
void ( APIENTRY * qglVertex3dv )(const GLdouble *v);
void ( APIENTRY * qglVertex3f )(GLfloat x, GLfloat y, GLfloat z);
void ( APIENTRY * qglVertex3fv )(const GLfloat *v);
void ( APIENTRY * qglVertex3i )(GLint x, GLint y, GLint z);
void ( APIENTRY * qglVertex3iv )(const GLint *v);
void ( APIENTRY * qglVertex3s )(GLshort x, GLshort y, GLshort z);
void ( APIENTRY * qglVertex3sv )(const GLshort *v);
void ( APIENTRY * qglVertex4d )(GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void ( APIENTRY * qglVertex4dv )(const GLdouble *v);
void ( APIENTRY * qglVertex4f )(GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void ( APIENTRY * qglVertex4fv )(const GLfloat *v);
void ( APIENTRY * qglVertex4i )(GLint x, GLint y, GLint z, GLint w);
void ( APIENTRY * qglVertex4iv )(const GLint *v);
void ( APIENTRY * qglVertex4s )(GLshort x, GLshort y, GLshort z, GLshort w);
void ( APIENTRY * qglVertex4sv )(const GLshort *v);
void ( APIENTRY * qglVertexPointer )(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void ( APIENTRY * qglViewport )(GLint x, GLint y, GLsizei width, GLsizei height);

BOOL ( WINAPI * qwglSwapIntervalEXT)( int interval );
BOOL ( WINAPI * qwglGetDeviceGammaRampEXT)( unsigned char *, unsigned char *, unsigned char * );
BOOL ( WINAPI * qwglSetDeviceGammaRampEXT)( const unsigned char *, const unsigned char *, const unsigned char * );
void ( APIENTRY * qglPointParameterfEXT)( GLenum param, GLfloat value );
void ( APIENTRY * qglPointParameterfvEXT)( GLenum param, const GLfloat *value );
void ( APIENTRY * qglColorTableEXT)( int, int, int, int, int, const void * );
void ( APIENTRY * qglSelectTextureSGIS)( GLenum );
void ( APIENTRY * qglMTexCoord2fSGIS)( GLenum, GLfloat, GLfloat );


// glu stuff
void (APIENTRY * qgluPerspective) (GLdouble fovy, GLdouble aspect, GLdouble zNear, GLdouble zFar);
int  (APIENTRY * qgluBuild2DMipmaps) (GLenum target, GLint components, GLint width, GLint height, GLenum format, GLenum      type, const void  *data);
// added for plugins
void (APIENTRY * qgluLookAt)(
  GLdouble eyex,
  GLdouble eyey,
  GLdouble eyez,
  GLdouble centerx,
  GLdouble centery,
  GLdouble centerz,
  GLdouble upx,
  GLdouble upy,
  GLdouble upz);


/*
** QGL_Shutdown
**
** Unloads the specified DLL then nulls out all the proc pointers.
*/
void QGL_Shutdown()
{
	if (g_hGLDLL)
	{
    FreeLibrary(g_hGLDLL);
    g_hGLDLL = NULL;
	}
	if (g_hGLUDLL)
	{
    FreeLibrary(g_hGLUDLL);
    g_hGLUDLL = NULL;
	}


	qglAccum                     = NULL;
	qglAlphaFunc                 = NULL;
	qglAreTexturesResident       = NULL;
	qglArrayElement              = NULL;
	qglBegin                     = NULL;
	qglBindTexture               = NULL;
	qglBitmap                    = NULL;
	qglBlendFunc                 = NULL;
	qglCallList                  = NULL;
	qglCallLists                 = NULL;
	qglClear                     = NULL;
	qglClearAccum                = NULL;
	qglClearColor                = NULL;
	qglClearDepth                = NULL;
	qglClearIndex                = NULL;
	qglClearStencil              = NULL;
	qglClipPlane                 = NULL;
	qglColor3b                   = NULL;
	qglColor3bv                  = NULL;
	qglColor3d                   = NULL;
	qglColor3dv                  = NULL;
	qglColor3f                   = NULL;
	qglColor3fv                  = NULL;
	qglColor3i                   = NULL;
	qglColor3iv                  = NULL;
	qglColor3s                   = NULL;
	qglColor3sv                  = NULL;
	qglColor3ub                  = NULL;
	qglColor3ubv                 = NULL;
	qglColor3ui                  = NULL;
	qglColor3uiv                 = NULL;
	qglColor3us                  = NULL;
	qglColor3usv                 = NULL;
	qglColor4b                   = NULL;
	qglColor4bv                  = NULL;
	qglColor4d                   = NULL;
	qglColor4dv                  = NULL;
	qglColor4f                   = NULL;
	qglColor4fv                  = NULL;
	qglColor4i                   = NULL;
	qglColor4iv                  = NULL;
	qglColor4s                   = NULL;
	qglColor4sv                  = NULL;
	qglColor4ub                  = NULL;
	qglColor4ubv                 = NULL;
	qglColor4ui                  = NULL;
	qglColor4uiv                 = NULL;
	qglColor4us                  = NULL;
	qglColor4usv                 = NULL;
	qglColorMask                 = NULL;
	qglColorMaterial             = NULL;
	qglColorPointer              = NULL;
	qglCopyPixels                = NULL;
	qglCopyTexImage1D            = NULL;
	qglCopyTexImage2D            = NULL;
	qglCopyTexSubImage1D         = NULL;
	qglCopyTexSubImage2D         = NULL;
	qglCullFace                  = NULL;
	qglDeleteLists               = NULL;
	qglDeleteTextures            = NULL;
	qglDepthFunc                 = NULL;
	qglDepthMask                 = NULL;
	qglDepthRange                = NULL;
	qglDisable                   = NULL;
	qglDisableClientState        = NULL;
	qglDrawArrays                = NULL;
	qglDrawBuffer                = NULL;
	qglDrawElements              = NULL;
	qglDrawPixels                = NULL;
	qglEdgeFlag                  = NULL;
	qglEdgeFlagPointer           = NULL;
	qglEdgeFlagv                 = NULL;
	qglEnable                    = NULL;
	qglEnableClientState         = NULL;
	qglEnd                       = NULL;
	qglEndList                   = NULL;
	qglEvalCoord1d               = NULL;
	qglEvalCoord1dv              = NULL;
	qglEvalCoord1f               = NULL;
	qglEvalCoord1fv              = NULL;
	qglEvalCoord2d               = NULL;
	qglEvalCoord2dv              = NULL;
	qglEvalCoord2f               = NULL;
	qglEvalCoord2fv              = NULL;
	qglEvalMesh1                 = NULL;
	qglEvalMesh2                 = NULL;
	qglEvalPoint1                = NULL;
	qglEvalPoint2                = NULL;
	qglFeedbackBuffer            = NULL;
	qglFinish                    = NULL;
	qglFlush                     = NULL;
	qglFogf                      = NULL;
	qglFogfv                     = NULL;
	qglFogi                      = NULL;
	qglFogiv                     = NULL;
	qglFrontFace                 = NULL;
	qglFrustum                   = NULL;
	qglGenLists                  = NULL;
	qglGenTextures               = NULL;
	qglGetBooleanv               = NULL;
	qglGetClipPlane              = NULL;
	qglGetDoublev                = NULL;
	qglGetError                  = NULL;
	qglGetFloatv                 = NULL;
	qglGetIntegerv               = NULL;
	qglGetLightfv                = NULL;
	qglGetLightiv                = NULL;
	qglGetMapdv                  = NULL;
	qglGetMapfv                  = NULL;
	qglGetMapiv                  = NULL;
	qglGetMaterialfv             = NULL;
	qglGetMaterialiv             = NULL;
	qglGetPixelMapfv             = NULL;
	qglGetPixelMapuiv            = NULL;
	qglGetPixelMapusv            = NULL;
	qglGetPointerv               = NULL;
	qglGetPolygonStipple         = NULL;
	qglGetString                 = NULL;
	qglGetTexEnvfv               = NULL;
	qglGetTexEnviv               = NULL;
	qglGetTexGendv               = NULL;
	qglGetTexGenfv               = NULL;
	qglGetTexGeniv               = NULL;
	qglGetTexImage               = NULL;
	qglGetTexLevelParameterfv    = NULL;
	qglGetTexLevelParameteriv    = NULL;
	qglGetTexParameterfv         = NULL;
	qglGetTexParameteriv         = NULL;
	qglHint                      = NULL;
	qglIndexMask                 = NULL;
	qglIndexPointer              = NULL;
	qglIndexd                    = NULL;
	qglIndexdv                   = NULL;
	qglIndexf                    = NULL;
	qglIndexfv                   = NULL;
	qglIndexi                    = NULL;
	qglIndexiv                   = NULL;
	qglIndexs                    = NULL;
	qglIndexsv                   = NULL;
	qglIndexub                   = NULL;
	qglIndexubv                  = NULL;
	qglInitNames                 = NULL;
	qglInterleavedArrays         = NULL;
	qglIsEnabled                 = NULL;
	qglIsList                    = NULL;
	qglIsTexture                 = NULL;
	qglLightModelf               = NULL;
	qglLightModelfv              = NULL;
	qglLightModeli               = NULL;
	qglLightModeliv              = NULL;
	qglLightf                    = NULL;
	qglLightfv                   = NULL;
	qglLighti                    = NULL;
	qglLightiv                   = NULL;
	qglLineStipple               = NULL;
	qglLineWidth                 = NULL;
	qglListBase                  = NULL;
	qglLoadIdentity              = NULL;
	qglLoadMatrixd               = NULL;
	qglLoadMatrixf               = NULL;
	qglLoadName                  = NULL;
	qglLogicOp                   = NULL;
	qglMap1d                     = NULL;
	qglMap1f                     = NULL;
	qglMap2d                     = NULL;
	qglMap2f                     = NULL;
	qglMapGrid1d                 = NULL;
	qglMapGrid1f                 = NULL;
	qglMapGrid2d                 = NULL;
	qglMapGrid2f                 = NULL;
	qglMaterialf                 = NULL;
	qglMaterialfv                = NULL;
	qglMateriali                 = NULL;
	qglMaterialiv                = NULL;
	qglMatrixMode                = NULL;
	qglMultMatrixd               = NULL;
	qglMultMatrixf               = NULL;
	qglNewList                   = NULL;
	qglNormal3b                  = NULL;
	qglNormal3bv                 = NULL;
	qglNormal3d                  = NULL;
	qglNormal3dv                 = NULL;
	qglNormal3f                  = NULL;
	qglNormal3fv                 = NULL;
	qglNormal3i                  = NULL;
	qglNormal3iv                 = NULL;
	qglNormal3s                  = NULL;
	qglNormal3sv                 = NULL;
	qglNormalPointer             = NULL;
	qglOrtho                     = NULL;
	qglPassThrough               = NULL;
	qglPixelMapfv                = NULL;
	qglPixelMapuiv               = NULL;
	qglPixelMapusv               = NULL;
	qglPixelStoref               = NULL;
	qglPixelStorei               = NULL;
	qglPixelTransferf            = NULL;
	qglPixelTransferi            = NULL;
	qglPixelZoom                 = NULL;
	qglPointSize                 = NULL;
	qglPolygonMode               = NULL;
	qglPolygonOffset             = NULL;
	qglPolygonStipple            = NULL;
	qglPopAttrib                 = NULL;
	qglPopClientAttrib           = NULL;
	qglPopMatrix                 = NULL;
	qglPopName                   = NULL;
	qglPrioritizeTextures        = NULL;
	qglPushAttrib                = NULL;
	qglPushClientAttrib          = NULL;
	qglPushMatrix                = NULL;
	qglPushName                  = NULL;
	qglRasterPos2d               = NULL;
	qglRasterPos2dv              = NULL;
	qglRasterPos2f               = NULL;
	qglRasterPos2fv              = NULL;
	qglRasterPos2i               = NULL;
	qglRasterPos2iv              = NULL;
	qglRasterPos2s               = NULL;
	qglRasterPos2sv              = NULL;
	qglRasterPos3d               = NULL;
	qglRasterPos3dv              = NULL;
	qglRasterPos3f               = NULL;
	qglRasterPos3fv              = NULL;
	qglRasterPos3i               = NULL;
	qglRasterPos3iv              = NULL;
	qglRasterPos3s               = NULL;
	qglRasterPos3sv              = NULL;
	qglRasterPos4d               = NULL;
	qglRasterPos4dv              = NULL;
	qglRasterPos4f               = NULL;
	qglRasterPos4fv              = NULL;
	qglRasterPos4i               = NULL;
	qglRasterPos4iv              = NULL;
	qglRasterPos4s               = NULL;
	qglRasterPos4sv              = NULL;
	qglReadBuffer                = NULL;
	qglReadPixels                = NULL;
	qglRectd                     = NULL;
	qglRectdv                    = NULL;
	qglRectf                     = NULL;
	qglRectfv                    = NULL;
	qglRecti                     = NULL;
	qglRectiv                    = NULL;
	qglRects                     = NULL;
	qglRectsv                    = NULL;
	qglRenderMode                = NULL;
	qglRotated                   = NULL;
	qglRotatef                   = NULL;
	qglScaled                    = NULL;
	qglScalef                    = NULL;
	qglScissor                   = NULL;
	qglSelectBuffer              = NULL;
	qglShadeModel                = NULL;
	qglStencilFunc               = NULL;
	qglStencilMask               = NULL;
	qglStencilOp                 = NULL;
	qglTexCoord1d                = NULL;
	qglTexCoord1dv               = NULL;
	qglTexCoord1f                = NULL;
	qglTexCoord1fv               = NULL;
	qglTexCoord1i                = NULL;
	qglTexCoord1iv               = NULL;
	qglTexCoord1s                = NULL;
	qglTexCoord1sv               = NULL;
	qglTexCoord2d                = NULL;
	qglTexCoord2dv               = NULL;
	qglTexCoord2f                = NULL;
	qglTexCoord2fv               = NULL;
	qglTexCoord2i                = NULL;
	qglTexCoord2iv               = NULL;
	qglTexCoord2s                = NULL;
	qglTexCoord2sv               = NULL;
	qglTexCoord3d                = NULL;
	qglTexCoord3dv               = NULL;
	qglTexCoord3f                = NULL;
	qglTexCoord3fv               = NULL;
	qglTexCoord3i                = NULL;
	qglTexCoord3iv               = NULL;
	qglTexCoord3s                = NULL;
	qglTexCoord3sv               = NULL;
	qglTexCoord4d                = NULL;
	qglTexCoord4dv               = NULL;
	qglTexCoord4f                = NULL;
	qglTexCoord4fv               = NULL;
	qglTexCoord4i                = NULL;
	qglTexCoord4iv               = NULL;
	qglTexCoord4s                = NULL;
	qglTexCoord4sv               = NULL;
	qglTexCoordPointer           = NULL;
	qglTexEnvf                   = NULL;
	qglTexEnvfv                  = NULL;
	qglTexEnvi                   = NULL;
	qglTexEnviv                  = NULL;
	qglTexGend                   = NULL;
	qglTexGendv                  = NULL;
	qglTexGenf                   = NULL;
	qglTexGenfv                  = NULL;
	qglTexGeni                   = NULL;
	qglTexGeniv                  = NULL;
	qglTexImage1D                = NULL;
	qglTexImage2D                = NULL;
	qglTexParameterf             = NULL;
	qglTexParameterfv            = NULL;
	qglTexParameteri             = NULL;
	qglTexParameteriv            = NULL;
	qglTexSubImage1D             = NULL;
	qglTexSubImage2D             = NULL;
	qglTranslated                = NULL;
	qglTranslatef                = NULL;
	qglVertex2d                  = NULL;
	qglVertex2dv                 = NULL;
	qglVertex2f                  = NULL;
	qglVertex2fv                 = NULL;
	qglVertex2i                  = NULL;
	qglVertex2iv                 = NULL;
	qglVertex2s                  = NULL;
	qglVertex2sv                 = NULL;
	qglVertex3d                  = NULL;
	qglVertex3dv                 = NULL;
	qglVertex3f                  = NULL;
	qglVertex3fv                 = NULL;
	qglVertex3i                  = NULL;
	qglVertex3iv                 = NULL;
	qglVertex3s                  = NULL;
	qglVertex3sv                 = NULL;
	qglVertex4d                  = NULL;
	qglVertex4dv                 = NULL;
	qglVertex4f                  = NULL;
	qglVertex4fv                 = NULL;
	qglVertex4i                  = NULL;
	qglVertex4iv                 = NULL;
	qglVertex4s                  = NULL;
	qglVertex4sv                 = NULL;
	qglVertexPointer             = NULL;
	qglViewport                  = NULL;

	qwglCopyContext              = NULL;
	qwglCreateContext            = NULL;
	qwglCreateLayerContext       = NULL;
	qwglDeleteContext            = NULL;
	qwglDescribeLayerPlane       = NULL;
	qwglGetCurrentContext        = NULL;
	qwglGetCurrentDC             = NULL;
	qwglGetLayerPaletteEntries   = NULL;
	qwglGetProcAddress           = NULL;
	qwglMakeCurrent              = NULL;
	qwglRealizeLayerPalette      = NULL;
	qwglSetLayerPaletteEntries   = NULL;
	qwglShareLists               = NULL;
	qwglSwapLayerBuffers         = NULL;
	qwglUseFontBitmaps           = NULL;
	qwglUseFontOutlines          = NULL;

	qwglChoosePixelFormat        = NULL;
	qwglDescribePixelFormat      = NULL;
	qwglGetPixelFormat           = NULL;
	qwglSetPixelFormat           = NULL;
	qwglSwapBuffers              = NULL;

	qwglSwapIntervalEXT	= NULL;

	qwglGetDeviceGammaRampEXT = NULL;
	qwglSetDeviceGammaRampEXT = NULL;

  qgluPerspective = NULL;
  qgluBuild2DMipmaps = NULL;

  qgluLookAt = NULL;
}

#	define GPA(h, a ) GetProcAddress( h, a )

/*
** QGL_Init
**
** This is responsible for binding our qgl function pointers to 
** the appropriate GL stuff.  In Windows this means doing a 
** LoadLibrary and a bunch of calls to GetProcAddress.  On other
** operating systems we need to do the right thing, whatever that
** might be.
** 
*/
int QGL_Init(const char *dllname, const char* pGluName )
{

  g_hGLDLL = LoadLibrary(dllname);
  if (g_hGLDLL == NULL)
  {
    return 0;
  }

  g_hGLUDLL = LoadLibrary(pGluName);
  if (g_hGLUDLL == NULL)
  {
    FreeLibrary(g_hGLDLL);
    g_hGLDLL = NULL;
    return 0;
  }


  qgluPerspective              = GPA(g_hGLUDLL, "gluPerspective");
  qgluBuild2DMipmaps           = GPA(g_hGLUDLL, "gluBuild2DMipmaps");
	// added for plugins
	qgluLookAt                   = GPA(g_hGLUDLL, "gluLookAt" );

	qglAccum                     = GPA(g_hGLDLL, "glAccum" );
	qglAlphaFunc                 = GPA(g_hGLDLL, "glAlphaFunc" );
	qglAreTexturesResident       = GPA(g_hGLDLL, "glAreTexturesResident" );
	qglArrayElement              = GPA(g_hGLDLL, "glArrayElement" );
	qglBegin                     = GPA(g_hGLDLL, "glBegin" );
	qglBindTexture               = GPA(g_hGLDLL, "glBindTexture" );
	qglBitmap                    = GPA(g_hGLDLL, "glBitmap" );
	qglBlendFunc                 = GPA(g_hGLDLL, "glBlendFunc" );
	qglCallList                  = GPA(g_hGLDLL, "glCallList" );
	qglCallLists                 = GPA(g_hGLDLL, "glCallLists" );
	qglClear                     = GPA(g_hGLDLL, "glClear" );
	qglClearAccum                = GPA(g_hGLDLL, "glClearAccum" );
	qglClearColor                = GPA(g_hGLDLL, "glClearColor" );
	qglClearDepth                = GPA(g_hGLDLL, "glClearDepth" );
	qglClearIndex                = GPA(g_hGLDLL, "glClearIndex" );
	qglClearStencil              = GPA(g_hGLDLL, "glClearStencil" );
	qglClipPlane                 = GPA(g_hGLDLL, "glClipPlane" );
	qglColor3b                   = GPA(g_hGLDLL, "glColor3b" );
	qglColor3bv                  = GPA(g_hGLDLL, "glColor3bv" );
	qglColor3d                   = GPA(g_hGLDLL, "glColor3d" );
	qglColor3dv                  = GPA(g_hGLDLL, "glColor3dv" );
	qglColor3f                   = GPA(g_hGLDLL, "glColor3f" );
	qglColor3fv                  = GPA(g_hGLDLL, "glColor3fv" );
	qglColor3i                   = GPA(g_hGLDLL, "glColor3i" );
	qglColor3iv                  = GPA(g_hGLDLL, "glColor3iv" );
	qglColor3s                   = GPA(g_hGLDLL, "glColor3s" );
	qglColor3sv                  = GPA(g_hGLDLL, "glColor3sv" );
	qglColor3ub                  = GPA(g_hGLDLL, "glColor3ub" );
	qglColor3ubv                 = GPA(g_hGLDLL, "glColor3ubv" );
	qglColor3ui                  = GPA(g_hGLDLL, "glColor3ui" );
	qglColor3uiv                 = GPA(g_hGLDLL, "glColor3uiv" );
	qglColor3us                  = GPA(g_hGLDLL, "glColor3us" );
	qglColor3usv                 = GPA(g_hGLDLL, "glColor3usv" );
	qglColor4b                   = GPA(g_hGLDLL, "glColor4b" );
	qglColor4bv                  = GPA(g_hGLDLL, "glColor4bv" );
	qglColor4d                   = GPA(g_hGLDLL, "glColor4d" );
	qglColor4dv                  = GPA(g_hGLDLL, "glColor4dv" );
	qglColor4f                   = GPA(g_hGLDLL, "glColor4f" );
	qglColor4fv                  = GPA(g_hGLDLL, "glColor4fv" );
	qglColor4i                   = GPA(g_hGLDLL, "glColor4i" );
	qglColor4iv                  = GPA(g_hGLDLL, "glColor4iv" );
	qglColor4s                   = GPA(g_hGLDLL, "glColor4s" );
	qglColor4sv                  = GPA(g_hGLDLL, "glColor4sv" );
	qglColor4ub                  = GPA(g_hGLDLL, "glColor4ub" );
	qglColor4ubv                 = GPA(g_hGLDLL, "glColor4ubv" );
	qglColor4ui                  = GPA(g_hGLDLL, "glColor4ui" );
	qglColor4uiv                 = GPA(g_hGLDLL, "glColor4uiv" );
	qglColor4us                  = GPA(g_hGLDLL, "glColor4us" );
	qglColor4usv                 = GPA(g_hGLDLL, "glColor4usv" );
	qglColorMask                 = GPA(g_hGLDLL, "glColorMask" );
	qglColorMaterial             = GPA(g_hGLDLL, "glColorMaterial" );
	qglColorPointer              = GPA(g_hGLDLL, "glColorPointer" );
	qglCopyPixels                = GPA(g_hGLDLL, "glCopyPixels" );
	qglCopyTexImage1D            = GPA(g_hGLDLL, "glCopyTexImage1D" );
	qglCopyTexImage2D            = GPA(g_hGLDLL, "glCopyTexImage2D" );
	qglCopyTexSubImage1D         = GPA(g_hGLDLL, "glCopyTexSubImage1D" );
	qglCopyTexSubImage2D         = GPA(g_hGLDLL, "glCopyTexSubImage2D" );
	qglCullFace                  = GPA(g_hGLDLL, "glCullFace" );
	qglDeleteLists               = GPA(g_hGLDLL, "glDeleteLists" );
	qglDeleteTextures            = GPA(g_hGLDLL, "glDeleteTextures" );
	qglDepthFunc                 = GPA(g_hGLDLL, "glDepthFunc" );
	qglDepthMask                 = GPA(g_hGLDLL, "glDepthMask" );
	qglDepthRange                = GPA(g_hGLDLL, "glDepthRange" );
	qglDisable                   = GPA(g_hGLDLL, "glDisable" );
	qglDisableClientState        = GPA(g_hGLDLL, "glDisableClientState" );
	qglDrawArrays                = GPA(g_hGLDLL, "glDrawArrays" );
	qglDrawBuffer                = GPA(g_hGLDLL, "glDrawBuffer" );
	qglDrawElements              = GPA(g_hGLDLL, "glDrawElements" );
	qglDrawPixels                = GPA(g_hGLDLL, "glDrawPixels" );
	qglEdgeFlag                  = GPA(g_hGLDLL, "glEdgeFlag" );
	qglEdgeFlagPointer           = GPA(g_hGLDLL, "glEdgeFlagPointer" );
	qglEdgeFlagv                 = GPA(g_hGLDLL, "glEdgeFlagv" );
	qglEnable                    = GPA(g_hGLDLL, "glEnable" );
	qglEnableClientState         = GPA(g_hGLDLL, "glEnableClientState" );
	qglEnd                       = GPA(g_hGLDLL, "glEnd" );
	qglEndList                   = GPA(g_hGLDLL, "glEndList" );
	qglEvalCoord1d				       = GPA(g_hGLDLL, "glEvalCoord1d" );
	qglEvalCoord1dv              = GPA(g_hGLDLL, "glEvalCoord1dv" );
	qglEvalCoord1f               = GPA(g_hGLDLL, "glEvalCoord1f" );
	qglEvalCoord1fv              = GPA(g_hGLDLL, "glEvalCoord1fv" );
	qglEvalCoord2d               = GPA(g_hGLDLL, "glEvalCoord2d" );
	qglEvalCoord2dv              = GPA(g_hGLDLL, "glEvalCoord2dv" );
	qglEvalCoord2f               = GPA(g_hGLDLL, "glEvalCoord2f" );
	qglEvalCoord2fv              = GPA(g_hGLDLL, "glEvalCoord2fv" );
	qglEvalMesh1                 = GPA(g_hGLDLL, "glEvalMesh1" );
	qglEvalMesh2                 = GPA(g_hGLDLL, "glEvalMesh2" );
	qglEvalPoint1                = GPA(g_hGLDLL, "glEvalPoint1" );
	qglEvalPoint2                = GPA(g_hGLDLL, "glEvalPoint2" );
	qglFeedbackBuffer            = GPA(g_hGLDLL, "glFeedbackBuffer" );
	qglFinish                    = GPA(g_hGLDLL, "glFinish" );
	qglFlush                     = GPA(g_hGLDLL, "glFlush" );
	qglFogf                      = GPA(g_hGLDLL, "glFogf" );
	qglFogfv                     = GPA(g_hGLDLL, "glFogfv" );
	qglFogi                      = GPA(g_hGLDLL, "glFogi" );
	qglFogiv                     = GPA(g_hGLDLL, "glFogiv" );
	qglFrontFace                 = GPA(g_hGLDLL, "glFrontFace" );
	qglFrustum                   = GPA(g_hGLDLL, "glFrustum" );
	qglGenLists                  = GPA(g_hGLDLL, "glGenLists" );
	qglGenTextures               = GPA(g_hGLDLL, "glGenTextures" );
	qglGetBooleanv               = GPA(g_hGLDLL, "glGetBooleanv" );
	qglGetClipPlane              = GPA(g_hGLDLL, "glGetClipPlane" );
	qglGetDoublev                = GPA(g_hGLDLL, "glGetDoublev" );
	qglGetError                  = GPA(g_hGLDLL, "glGetError" );
	qglGetFloatv                 = GPA(g_hGLDLL, "glGetFloatv" );
	qglGetIntegerv               = GPA(g_hGLDLL, "glGetIntegerv" );
	qglGetLightfv                = GPA(g_hGLDLL, "glGetLightfv" );
	qglGetLightiv                = GPA(g_hGLDLL, "glGetLightiv" );
	qglGetMapdv                  = GPA(g_hGLDLL, "glGetMapdv" );
	qglGetMapfv                  = GPA(g_hGLDLL, "glGetMapfv" );
	qglGetMapiv                  = GPA(g_hGLDLL, "glGetMapiv" );
	qglGetMaterialfv             = GPA(g_hGLDLL, "glGetMaterialfv" );
	qglGetMaterialiv             = GPA(g_hGLDLL, "glGetMaterialiv" );
	qglGetPixelMapfv             = GPA(g_hGLDLL, "glGetPixelMapfv" );
	qglGetPixelMapuiv            = GPA(g_hGLDLL, "glGetPixelMapuiv" );
	qglGetPixelMapusv            = GPA(g_hGLDLL, "glGetPixelMapusv" );
	qglGetPointerv               = GPA(g_hGLDLL, "glGetPointerv" );
	qglGetPolygonStipple         = GPA(g_hGLDLL, "glGetPolygonStipple" );
	qglGetString                 = GPA(g_hGLDLL, "glGetString" );
	qglGetTexEnvfv               = GPA(g_hGLDLL, "glGetTexEnvfv" );
	qglGetTexEnviv               = GPA(g_hGLDLL, "glGetTexEnviv" );
	qglGetTexGendv               = GPA(g_hGLDLL, "glGetTexGendv" );
	qglGetTexGenfv               = GPA(g_hGLDLL, "glGetTexGenfv" );
	qglGetTexGeniv               = GPA(g_hGLDLL, "glGetTexGeniv" );
	qglGetTexImage               = GPA(g_hGLDLL, "glGetTexImage" );
	qglGetTexLevelParameterfv    = GPA(g_hGLDLL, "glGetLevelParameterfv" );
	qglGetTexLevelParameteriv    = GPA(g_hGLDLL, "glGetLevelParameteriv" );
	qglGetTexParameterfv         = GPA(g_hGLDLL, "glGetTexParameterfv" );
	qglGetTexParameteriv         = GPA(g_hGLDLL, "glGetTexParameteriv" );
	qglHint                      = GPA(g_hGLDLL, "glHint" );
	qglIndexMask                 = GPA(g_hGLDLL, "glIndexMask" );
	qglIndexPointer              = GPA(g_hGLDLL, "glIndexPointer" );
	qglIndexd                    = GPA(g_hGLDLL, "glIndexd" );
	qglIndexdv                   = GPA(g_hGLDLL, "glIndexdv" );
	qglIndexf                    = GPA(g_hGLDLL, "glIndexf" );
	qglIndexfv                   = GPA(g_hGLDLL, "glIndexfv" );
	qglIndexi                    = GPA(g_hGLDLL, "glIndexi" );
	qglIndexiv                   = GPA(g_hGLDLL, "glIndexiv" );
	qglIndexs                    = GPA(g_hGLDLL, "glIndexs" );
	qglIndexsv                   = GPA(g_hGLDLL, "glIndexsv" );
	qglIndexub                   = GPA(g_hGLDLL, "glIndexub" );
	qglIndexubv                  = GPA(g_hGLDLL, "glIndexubv" );
	qglInitNames                 = GPA(g_hGLDLL, "glInitNames" );
	qglInterleavedArrays         = GPA(g_hGLDLL, "glInterleavedArrays" );
	qglIsEnabled                 = GPA(g_hGLDLL, "glIsEnabled" );
	qglIsList                    = GPA(g_hGLDLL, "glIsList" );
	qglIsTexture                 = GPA(g_hGLDLL, "glIsTexture" );
	qglLightModelf               = GPA(g_hGLDLL, "glLightModelf" );
	qglLightModelfv              = GPA(g_hGLDLL, "glLightModelfv" );
	qglLightModeli               = GPA(g_hGLDLL, "glLightModeli" );
	qglLightModeliv              = GPA(g_hGLDLL, "glLightModeliv" );
	qglLightf                    = GPA(g_hGLDLL, "glLightf" );
	qglLightfv                   = GPA(g_hGLDLL, "glLightfv" );
	qglLighti                    = GPA(g_hGLDLL, "glLighti" );
	qglLightiv                   = GPA(g_hGLDLL, "glLightiv" );
	qglLineStipple               = GPA(g_hGLDLL, "glLineStipple" );
	qglLineWidth                 = GPA(g_hGLDLL, "glLineWidth" );
	qglListBase                  = GPA(g_hGLDLL, "glListBase" );
	qglLoadIdentity              = GPA(g_hGLDLL, "glLoadIdentity" );
	qglLoadMatrixd               = GPA(g_hGLDLL, "glLoadMatrixd" );
	qglLoadMatrixf               = GPA(g_hGLDLL, "glLoadMatrixf" );
	qglLoadName                  = GPA(g_hGLDLL, "glLoadName" );
	qglLogicOp                   = GPA(g_hGLDLL, "glLogicOp" );
	qglMap1d                     = GPA(g_hGLDLL, "glMap1d" );
	qglMap1f                     = GPA(g_hGLDLL, "glMap1f" );
	qglMap2d                     = GPA(g_hGLDLL, "glMap2d" );
	qglMap2f                     = GPA(g_hGLDLL, "glMap2f" );
	qglMapGrid1d                 = GPA(g_hGLDLL, "glMapGrid1d" );
	qglMapGrid1f                 = GPA(g_hGLDLL, "glMapGrid1f" );
	qglMapGrid2d                 = GPA(g_hGLDLL, "glMapGrid2d" );
	qglMapGrid2f                 = GPA(g_hGLDLL, "glMapGrid2f" );
	qglMaterialf                 = GPA(g_hGLDLL, "glMaterialf" );
	qglMaterialfv                = GPA(g_hGLDLL, "glMaterialfv" );
	qglMateriali                 = GPA(g_hGLDLL, "glMateriali" );
	qglMaterialiv                = GPA(g_hGLDLL, "glMaterialiv" );
	qglMatrixMode                = GPA(g_hGLDLL, "glMatrixMode" );
	qglMultMatrixd               = GPA(g_hGLDLL, "glMultMatrixd" );
	qglMultMatrixf               = GPA(g_hGLDLL, "glMultMatrixf" );
	qglNewList                   = GPA(g_hGLDLL, "glNewList" );
	qglNormal3b                  = GPA(g_hGLDLL, "glNormal3b" );
	qglNormal3bv                 = GPA(g_hGLDLL, "glNormal3bv" );
	qglNormal3d                  = GPA(g_hGLDLL, "glNormal3d" );
	qglNormal3dv                 = GPA(g_hGLDLL, "glNormal3dv" );
	qglNormal3f                  = GPA(g_hGLDLL, "glNormal3f" );
	qglNormal3fv                 = GPA(g_hGLDLL, "glNormal3fv" );
	qglNormal3i                  = GPA(g_hGLDLL, "glNormal3i" );
	qglNormal3iv                 = GPA(g_hGLDLL, "glNormal3iv" );
	qglNormal3s                  = GPA(g_hGLDLL, "glNormal3s" );
	qglNormal3sv                 = GPA(g_hGLDLL, "glNormal3sv" );
	qglNormalPointer             = GPA(g_hGLDLL, "glNormalPointer" );
	qglOrtho                     = GPA(g_hGLDLL, "glOrtho" );
	qglPassThrough               = GPA(g_hGLDLL, "glPassThrough" );
	qglPixelMapfv                = GPA(g_hGLDLL, "glPixelMapfv" );
	qglPixelMapuiv               = GPA(g_hGLDLL, "glPixelMapuiv" );
	qglPixelMapusv               = GPA(g_hGLDLL, "glPixelMapusv" );
	qglPixelStoref               = GPA(g_hGLDLL, "glPixelStoref" );
	qglPixelStorei               = GPA(g_hGLDLL, "glPixelStorei" );
	qglPixelTransferf            = GPA(g_hGLDLL, "glPixelTransferf" );
	qglPixelTransferi            = GPA(g_hGLDLL, "glPixelTransferi" );
	qglPixelZoom                 = GPA(g_hGLDLL, "glPixelZoom" );
	qglPointSize                 = GPA(g_hGLDLL, "glPointSize" );
	qglPolygonMode               = GPA(g_hGLDLL, "glPolygonMode" );
	qglPolygonOffset             = GPA(g_hGLDLL, "glPolygonOffset" );
	qglPolygonStipple            = GPA(g_hGLDLL, "glPolygonStipple" );
	qglPopAttrib                 = GPA(g_hGLDLL, "glPopAttrib" );
	qglPopClientAttrib           = GPA(g_hGLDLL, "glPopClientAttrib" );
	qglPopMatrix                 = GPA(g_hGLDLL, "glPopMatrix" );
	qglPopName                   = GPA(g_hGLDLL, "glPopName" );
	qglPrioritizeTextures        = GPA(g_hGLDLL, "glPrioritizeTextures" );
	qglPushAttrib                = GPA(g_hGLDLL, "glPushAttrib" );
	qglPushClientAttrib          = GPA(g_hGLDLL, "glPushClientAttrib" );
	qglPushMatrix                = GPA(g_hGLDLL, "glPushMatrix" );
	qglPushName                  = GPA(g_hGLDLL, "glPushName" );
	qglRasterPos2d               = GPA(g_hGLDLL, "glRasterPos2d" );
	qglRasterPos2dv              = GPA(g_hGLDLL, "glRasterPos2dv" );
	qglRasterPos2f               = GPA(g_hGLDLL, "glRasterPos2f" );
	qglRasterPos2fv              = GPA(g_hGLDLL, "glRasterPos2fv" );
	qglRasterPos2i               = GPA(g_hGLDLL, "glRasterPos2i" );
	qglRasterPos2iv              = GPA(g_hGLDLL, "glRasterPos2iv" );
	qglRasterPos2s               = GPA(g_hGLDLL, "glRasterPos2s" );
	qglRasterPos2sv              = GPA(g_hGLDLL, "glRasterPos2sv" );
	qglRasterPos3d               = GPA(g_hGLDLL, "glRasterPos3d" );
	qglRasterPos3dv              = GPA(g_hGLDLL, "glRasterPos3dv" );
	qglRasterPos3f               = GPA(g_hGLDLL, "glRasterPos3f" );
	qglRasterPos3fv              = GPA(g_hGLDLL, "glRasterPos3fv" );
	qglRasterPos3i               = GPA(g_hGLDLL, "glRasterPos3i" );
	qglRasterPos3iv              = GPA(g_hGLDLL, "glRasterPos3iv" );
	qglRasterPos3s               = GPA(g_hGLDLL, "glRasterPos3s" );
	qglRasterPos3sv              = GPA(g_hGLDLL, "glRasterPos3sv" );
	qglRasterPos4d               = GPA(g_hGLDLL, "glRasterPos4d" );
	qglRasterPos4dv              = GPA(g_hGLDLL, "glRasterPos4dv" );
	qglRasterPos4f               = GPA(g_hGLDLL, "glRasterPos4f" );
	qglRasterPos4fv              = GPA(g_hGLDLL, "glRasterPos4fv" );
	qglRasterPos4i               = GPA(g_hGLDLL, "glRasterPos4i" );
	qglRasterPos4iv              = GPA(g_hGLDLL, "glRasterPos4iv" );
	qglRasterPos4s               = GPA(g_hGLDLL, "glRasterPos4s" );
	qglRasterPos4sv              = GPA(g_hGLDLL, "glRasterPos4sv" );
	qglReadBuffer                = GPA(g_hGLDLL, "glReadBuffer" );
	qglReadPixels                = GPA(g_hGLDLL, "glReadPixels" );
	qglRectd                     = GPA(g_hGLDLL, "glRectd" );
	qglRectdv                    = GPA(g_hGLDLL, "glRectdv" );
	qglRectf                     = GPA(g_hGLDLL, "glRectf" );
	qglRectfv                    = GPA(g_hGLDLL, "glRectfv" );
	qglRecti                     = GPA(g_hGLDLL, "glRecti" );
	qglRectiv                    = GPA(g_hGLDLL, "glRectiv" );
	qglRects                     = GPA(g_hGLDLL, "glRects" );
	qglRectsv                    = GPA(g_hGLDLL, "glRectsv" );
	qglRenderMode                = GPA(g_hGLDLL, "glRenderMode" );
	qglRotated                   = GPA(g_hGLDLL, "glRotated" );
	qglRotatef                   = GPA(g_hGLDLL, "glRotatef" );
	qglScaled                    = GPA(g_hGLDLL, "glScaled" );
	qglScalef                    = GPA(g_hGLDLL, "glScalef" );
	qglScissor                   = GPA(g_hGLDLL, "glScissor" );
	qglSelectBuffer              = GPA(g_hGLDLL, "glSelectBuffer" );
	qglShadeModel                = GPA(g_hGLDLL, "glShadeModel" );
	qglStencilFunc               = GPA(g_hGLDLL, "glStencilFunc" );
	qglStencilMask               = GPA(g_hGLDLL, "glStencilMask" );
	qglStencilOp                 = GPA(g_hGLDLL, "glStencilOp" );
	qglTexCoord1d                = GPA(g_hGLDLL, "glTexCoord1d" );
	qglTexCoord1dv               = GPA(g_hGLDLL, "glTexCoord1dv" );
	qglTexCoord1f                = GPA(g_hGLDLL, "glTexCoord1f" );
	qglTexCoord1fv               = GPA(g_hGLDLL, "glTexCoord1fv" );
	qglTexCoord1i                = GPA(g_hGLDLL, "glTexCoord1i" );
	qglTexCoord1iv               = GPA(g_hGLDLL, "glTexCoord1iv" );
	qglTexCoord1s                = GPA(g_hGLDLL, "glTexCoord1s" );
	qglTexCoord1sv               = GPA(g_hGLDLL, "glTexCoord1sv" );
	qglTexCoord2d                = GPA(g_hGLDLL, "glTexCoord2d" );
	qglTexCoord2dv               = GPA(g_hGLDLL, "glTexCoord2dv" );
	qglTexCoord2f                = GPA(g_hGLDLL, "glTexCoord2f" );
	qglTexCoord2fv               = GPA(g_hGLDLL, "glTexCoord2fv" );
	qglTexCoord2i                = GPA(g_hGLDLL, "glTexCoord2i" );
	qglTexCoord2iv               = GPA(g_hGLDLL, "glTexCoord2iv" );
	qglTexCoord2s                = GPA(g_hGLDLL, "glTexCoord2s" );
	qglTexCoord2sv               = GPA(g_hGLDLL, "glTexCoord2sv" );
	qglTexCoord3d                = GPA(g_hGLDLL, "glTexCoord3d" );
	qglTexCoord3dv               = GPA(g_hGLDLL, "glTexCoord3dv" );
	qglTexCoord3f                = GPA(g_hGLDLL, "glTexCoord3f" );
	qglTexCoord3fv               = GPA(g_hGLDLL, "glTexCoord3fv" );
	qglTexCoord3i                = GPA(g_hGLDLL, "glTexCoord3i" );
	qglTexCoord3iv               = GPA(g_hGLDLL, "glTexCoord3iv" );
	qglTexCoord3s                = GPA(g_hGLDLL, "glTexCoord3s" );
	qglTexCoord3sv               = GPA(g_hGLDLL, "glTexCoord3sv" );
	qglTexCoord4d                = GPA(g_hGLDLL, "glTexCoord4d" );
	qglTexCoord4dv               = GPA(g_hGLDLL, "glTexCoord4dv" );
	qglTexCoord4f                = GPA(g_hGLDLL, "glTexCoord4f" );
	qglTexCoord4fv               = GPA(g_hGLDLL, "glTexCoord4fv" );
	qglTexCoord4i                = GPA(g_hGLDLL, "glTexCoord4i" );
	qglTexCoord4iv               = GPA(g_hGLDLL, "glTexCoord4iv" );
	qglTexCoord4s                = GPA(g_hGLDLL, "glTexCoord4s" );
	qglTexCoord4sv               = GPA(g_hGLDLL, "glTexCoord4sv" );
	qglTexCoordPointer           = GPA(g_hGLDLL, "glTexCoordPointer" );
	qglTexEnvf                   = GPA(g_hGLDLL, "glTexEnvf" );
	qglTexEnvfv                  = GPA(g_hGLDLL, "glTexEnvfv" );
	qglTexEnvi                   = GPA(g_hGLDLL, "glTexEnvi" );
	qglTexEnviv                  = GPA(g_hGLDLL, "glTexEnviv" );
	qglTexGend                   = GPA(g_hGLDLL, "glTexGend" );
	qglTexGendv                  = GPA(g_hGLDLL, "glTexGendv" );
	qglTexGenf                   = GPA(g_hGLDLL, "glTexGenf" );
	qglTexGenfv                  = GPA(g_hGLDLL, "glTexGenfv" );
	qglTexGeni                   = GPA(g_hGLDLL, "glTexGeni" );
	qglTexGeniv                  = GPA(g_hGLDLL, "glTexGeniv" );
	qglTexImage1D                = GPA(g_hGLDLL, "glTexImage1D" );
	qglTexImage2D                = GPA(g_hGLDLL, "glTexImage2D" );
	qglTexParameterf             = GPA(g_hGLDLL, "glTexParameterf" );
	qglTexParameterfv            = GPA(g_hGLDLL, "glTexParameterfv" );
	qglTexParameteri             = GPA(g_hGLDLL, "glTexParameteri" );
	qglTexParameteriv            = GPA(g_hGLDLL, "glTexParameteriv" );
	qglTexSubImage1D             = GPA(g_hGLDLL, "glTexSubImage1D" );
	qglTexSubImage2D             = GPA(g_hGLDLL, "glTexSubImage2D" );
	qglTranslated                = GPA(g_hGLDLL, "glTranslated" );
	qglTranslatef                = GPA(g_hGLDLL, "glTranslatef" );
	qglVertex2d                  = GPA(g_hGLDLL, "glVertex2d" );
	qglVertex2dv                 = GPA(g_hGLDLL, "glVertex2dv" );
	qglVertex2f                  = GPA(g_hGLDLL, "glVertex2f" );
	qglVertex2fv                 = GPA(g_hGLDLL, "glVertex2fv" );
	qglVertex2i                  = GPA(g_hGLDLL, "glVertex2i" );
	qglVertex2iv                 = GPA(g_hGLDLL, "glVertex2iv" );
	qglVertex2s                  = GPA(g_hGLDLL, "glVertex2s" );
	qglVertex2sv                 = GPA(g_hGLDLL, "glVertex2sv" );
	qglVertex3d                  = GPA(g_hGLDLL, "glVertex3d" );
	qglVertex3dv                 = GPA(g_hGLDLL, "glVertex3dv" );
	qglVertex3f                  = GPA(g_hGLDLL, "glVertex3f" );
	qglVertex3fv                 = GPA(g_hGLDLL, "glVertex3fv" );
	qglVertex3i                  = GPA(g_hGLDLL, "glVertex3i" );
	qglVertex3iv                 = GPA(g_hGLDLL, "glVertex3iv" );
	qglVertex3s                  = GPA(g_hGLDLL, "glVertex3s" );
	qglVertex3sv                 = GPA(g_hGLDLL, "glVertex3sv" );
	qglVertex4d                  = GPA(g_hGLDLL, "glVertex4d" );
	qglVertex4dv                 = GPA(g_hGLDLL, "glVertex4dv" );
	qglVertex4f                  = GPA(g_hGLDLL, "glVertex4f" );
	qglVertex4fv                 = GPA(g_hGLDLL, "glVertex4fv" );
	qglVertex4i                  = GPA(g_hGLDLL, "glVertex4i" );
	qglVertex4iv                 = GPA(g_hGLDLL, "glVertex4iv" );
	qglVertex4s                  = GPA(g_hGLDLL, "glVertex4s" );
	qglVertex4sv                 = GPA(g_hGLDLL, "glVertex4sv" );
	qglVertexPointer             = GPA(g_hGLDLL, "glVertexPointer" );
	qglViewport                  = GPA(g_hGLDLL, "glViewport" );

	qwglCopyContext              = GPA(g_hGLDLL, "wglCopyContext" );
	qwglCreateContext            = GPA(g_hGLDLL, "wglCreateContext" );
	qwglCreateLayerContext       = GPA(g_hGLDLL, "wglCreateLayerContext" );
	qwglDeleteContext            = GPA(g_hGLDLL, "wglDeleteContext" );
	qwglDescribeLayerPlane       = GPA(g_hGLDLL, "wglDescribeLayerPlane" );
	qwglGetCurrentContext        = GPA(g_hGLDLL, "wglGetCurrentContext" );
	qwglGetCurrentDC             = GPA(g_hGLDLL, "wglGetCurrentDC" );
	qwglGetLayerPaletteEntries   = GPA(g_hGLDLL, "wglGetLayerPaletteEntries" );
	qwglGetProcAddress           = GPA(g_hGLDLL, "wglGetProcAddress" );
	qwglMakeCurrent              = GPA(g_hGLDLL, "wglMakeCurrent" );
	qwglRealizeLayerPalette      = GPA(g_hGLDLL, "wglRealizeLayerPalette" );
	qwglSetLayerPaletteEntries   = GPA(g_hGLDLL, "wglSetLayerPaletteEntries" );
	qwglShareLists               = GPA(g_hGLDLL, "wglShareLists" );
	qwglSwapLayerBuffers         = GPA(g_hGLDLL, "wglSwapLayerBuffers" );
	qwglUseFontBitmaps           = GPA(g_hGLDLL, "wglUseFontBitmapsA" );
	qwglUseFontOutlines          = GPA(g_hGLDLL, "wglUseFontOutlinesA" );

	qwglChoosePixelFormat        = GPA(g_hGLDLL, "wglChoosePixelFormat" );
	qwglDescribePixelFormat      = GPA(g_hGLDLL, "wglDescribePixelFormat" );
	qwglGetPixelFormat           = GPA(g_hGLDLL, "wglGetPixelFormat" );
	qwglSetPixelFormat           = GPA(g_hGLDLL, "wglSetPixelFormat" );
	qwglSwapBuffers              = GPA(g_hGLDLL, "wglSwapBuffers" );

	qwglSwapIntervalEXT = 0;
	qglPointParameterfEXT = 0;
	qglPointParameterfvEXT = 0;
	qglColorTableEXT = 0;
	qglSelectTextureSGIS = 0;
	qglMTexCoord2fSGIS = 0;

	return 1;
}

#pragma warning (default : 4113 4133 4047 )



