/********************** accursed.c ********************************
*
* This program installs the sprites of ACCURSED.WAD after checking
* that all required files are present in the install directory.
* It installs the sprites using DEUSF.	If the sprites have been
* previously installed, (this is determined by the presence of the
* DEUSF output, "ACCUR_FX.WAD") the install portion is disabled.
*
* In both cases, the program launches DOOM ][ with the required
* command line to invoke the ACCURSED extensions.
*
* This program was compiled and linked to require a H/W FPU to be present.
*
* If you should encounter any problems with the installation, this
* source is provided to facilitate debugging.
*
* Please enjoy The ACCURSED, and direct comments to me at:
* jmartin@soundcom.net
*
* Sincerely,
*
* -Jeff.
*
********************************************************************/

/* include some ms C header files		     */

#include <stdio.h>
#include <dos.h>
#include <errno.h>
#include <graph.h>

/* some global varibles */

int counter,

    last_int_var;

char stdout_buf[80],
     stderr_buf[80],

     last_char_var;

/***************************** main ************************************/

void main()

{

      build_banner();		/* build_banner only returns here if
				   file "ACCUR_FX.WAD" is not present
				   in the current directory, implying
				   that the installation is required.
				*/

      verify_distribution();	/* check for required files, install	*/
      install_sprites();	/* the sprites, then start The ACCURSED */
      spawn_accursed();
      shut_down();		/* restore the text screen first	*/


}/*********************** end of main ******************************/


/********************** build_banner *******************************
*
*  builds a text window using ms-dos C runtime library routines.
*
*  checks if installation is neccessary by confirming the existence
*  of file 'ACCUR_FX.WAD' in the current directory. If this is
*  required, the routine returns to the main loop where installation
*  occurs.  If 'ACCUR_FX.WAD' is present in the current directory,
*  the routine calls 'spawn_accursed'.
*
********************************************************************/

build_banner()

{
      text_box(20,5,60,15,1,11);
      _settextposition(5,27);
      sprintf(stdout_buf," The ACCURSED for DOOM ][ ");
      _outtext(stdout_buf);
      _settextcolor( 7 );

      _settextwindow(6,22,14,58);
      sprintf(stdout_buf,"\n");
      _outtext(stdout_buf);

sprintf(stdout_buf,"Checking for prior installations..\n");
_outtext(stdout_buf);

if( access("ACCUR_FX.WAD",0) )
      {
       sprintf(stdout_buf,"Can't find ACCUR_FX.WAD in current \n");
       _outtext(stdout_buf);

       sprintf(stdout_buf,"directory.  Attempting installation..\n");
      _outtext(stdout_buf);

       return(1);
      }

sprintf(stdout_buf,"\nACCUR_FX.WAD in current directory.\n");
_outtext(stdout_buf);

sprintf(stdout_buf,"\nAttempting to start the ACCURSED...\n");
_outtext(stdout_buf);

spawn_accursed();

shut_down();

}/********************* end of build_banner **************************/


/********************* verify_distribution ***************************
*
* checks to see if files in distrubution are present in current
* directory, displays an error specifing what file is missing if
* any and exits.
*
*********************************************************************/

verify_distribution()
{

check_file("ACCURSED.WAD");

check_file("ASPRITES.WAD");

check_file("DEUSF.EXE");

check_file("DOOM2.EXE");

check_file("DOOM2.WAD");

return(1);

}/******************* end of verify_distribution *********************/


/************************  check_file ********************************
*
* checks for the presence of the named file, displays an error and
* exits if absent.
*
*********************************************************************/

check_file( file_name )

char file_name[80];

{

if( access(file_name,0) )
      {
	switch(errno)
	{
	case ENOENT:
	    {
	      sprintf(stderr_buf,
	      "   !! Can't find %s \n      in the current directory !!",
	      file_name);
	      report_error();
	      break;
	    }

	 default:
	    {
	      sprintf(stderr_buf,
	      "   !! DOS error %d while \n      accessing %s !!",errno,
	      file_name);
	      report_error();
	      break;
	    }

	 } /* end switch */

       } /* end access if */

return(1);
}/************************* end of check_file *************************/


/************************ install_sprites **************************
*
* installs sprites using deusf
*
*******************************************************************/

install_sprites()

{
/* verfiy enough space for sprites install ( at least 4.5 meg ) */

CHECK_SPACE();

sprintf(stdout_buf,
"DeuSF V3.1 Copyright (c)1994 Olivier Montanuy (montanuy@dmi.ens.fr)");
_outtext(stdout_buf);

sprintf(stdout_buf,
"\n\nThis is likely to take a few seconds.\n");
_outtext(stdout_buf);

sprintf(stdout_buf,
"Installing SPRITES, patience please..");
_outtext(stdout_buf);

system("deusf -sprite -add asprites.wad ACCUR_fx.wad > NULL ");

sprintf(stdout_buf,"\nAddition of sprites & flats complete.\n\n");
_outtext(stdout_buf);

sprintf(stdout_buf,"To play ACCURSED in the future,\n");
_outtext(stdout_buf);

sprintf(stdout_buf,"simply run this program - ACCURSED.\n\n");
_outtext(stdout_buf);

sprintf(stdout_buf,"Press almost any key to try it !!");
_outtext(stdout_buf);

getch();

return(1);
}/************************** end of install_sprites() ***************/


/******************** spawn_accursed *****************************
*
* launches DOOM ][ with the appropriate command line in order
* to modify game play to conform to ACCURSED protocols.
*
******************************************************************/

spawn_accursed()

{     check_file("DOOM2.EXE");
      check_file("DOOM2.WAD");
      check_file("ACCUR_FX.WAD");
      check_file("ACCURSED.WAD");

      _settextwindow(1,1,25,80);
      _settextposition(21,1);

      _settextcolor( 7 );
      _setbkcolor( 0 );

system("DOOM2 -FILE ACCUR_FX.WAD ACCURSED.WAD");

shut_down();

}/************************* end of spawn_accursed ****************/


/**************************** CHECK_SPACE **********************************
*
* calculates the number of free bytes on the current drive and reports
* an error before exiting if that value is less than 5 meg.
*
***************************************************************************/

CHECK_SPACE(outfile_arg)

{
    struct diskfree_t drvinfo;

    unsigned drive;
    long space;

   sprintf(stdout_buf,"Checking for enough disk space to \n");
   _outtext(stdout_buf);

   sprintf(stdout_buf,"complete the installation.\n");
   _outtext(stdout_buf);

/* get the current drive */

    _dos_getdrive( &drive );

/* calculate available free space from _dos_getdiskfree info		*/

    _dos_getdiskfree( drive, &drvinfo );

    space = (long)drvinfo.avail_clusters * drvinfo.sectors_per_cluster *
	    drvinfo.bytes_per_sector;

   sprintf(stdout_buf,"Current drive has %ld free.\n\n",space);
   _outtext(stdout_buf);

   if( space < 4500000.00 )
      {
      sprintf(stderr_buf,"    !! FREE DISK SPACE < 4.5 MEG !!");
      report_error();
      }

return(1);

}/******************** END OF CHECK_SPACE **********************************/


/************************ report_error *********************************
*
* displays an error msg then exits
*
************************************************************************/

report_error()

{
      _settextwindow(1,1,25,80);
      text_box(20,17,60,21,4,15);

      _settextcolor( 0x1f );
      _settextposition(17,32);
      sprintf(stdout_buf," The problem is: ");
      _outtext(stdout_buf);
      _settextcolor( 15 );

      _settextwindow(18,21,20,59);

      _outtext(stderr_buf);

      shut_down();

}/*********************** end of report_error *****************/


/*********************** shut_down ***************************
*
* exits the program after restoring the text screen
*
*************************************************************/

shut_down()

{
      _settextwindow(1,1,25,80);
      _settextposition(24,10);

      _settextcolor( 7 );
      _setbkcolor( 0 );
      printf("The ACCURSED for DOOM ][ exiting.....\n");

exit(0);

}/******************** end of shut_down ************************/


/******************************* text_box ********************************
*   draws a box on the text screen starting at the upper left row/column
*   and ending at the lower right row/column specified.  Also sets
*   the fg/bg text colors provided.
**************************************************************************/

text_box(ulx,uly,lrx,lry,bg,fg)
   int ulx,uly,lrx,lry,bg,fg;

{

int hor,vert,loopy, minor_loop;

/* go to upper left of box  */

    _settextposition(uly,ulx);

/* set background and foreground video	*/

_setbkcolor( bg );
_settextcolor( fg );

/* draw an upper left corner there */

   sprintf(stdout_buf,"\xC9");
   _outtext(stdout_buf);

/* figure out how far to go across and draw horizontal line that long */

  hor = lrx - ulx;
  for ( loopy=1; loopy<=hor; loopy++)
       {
	sprintf(stdout_buf,"\xCD");
	_outtext(stdout_buf);

       }

/* put an upper right corner there. */

	sprintf(stdout_buf,"\xBB");
	_outtext(stdout_buf);

/* figure out how far to go down and draw vertical lines that long */

  vert = (lry - uly);
  hor = lrx - ulx;

  for (loopy=1; loopy<=vert; loopy++)
      {
	uly++;
	_settextposition(uly,ulx);
	sprintf(stdout_buf,"\xBA");
	_outtext(stdout_buf);

	for( minor_loop=1; minor_loop <= hor; minor_loop++ )
	    {
	     sprintf(stdout_buf," ");
	     _outtext(stdout_buf);
	    }

	_settextposition(uly,lrx + 1);
	sprintf(stdout_buf,"\xBA");
	_outtext(stdout_buf);
      }

/* draw a lower left corner, a hor line and then a lower right corner */

      _settextposition(uly,ulx);
      uly++;

      sprintf(stdout_buf,"\xC8");
      _outtext(stdout_buf);

      for ( loopy=1; loopy<=hor; loopy++)
	   {
	    sprintf(stdout_buf,"\xCD");
	    _outtext(stdout_buf);
	   }

	  sprintf(stdout_buf,"\xBC");
	  _outtext(stdout_buf);

return(1);

}/************************** END OF text_box *****************************/
