#ifndef __GLBSP_LEVEL_H__
#define __GLBSP_LEVEL_H__

#include "structs.h"
#include "wad.h"


struct node_s;
struct sector_s;
struct superblock_s;
typedef struct wall_tip_s
{
  struct wall_tip_s *next;
  struct wall_tip_s *prev;
  angle_g angle;
  struct sector_s *left;
  struct sector_s *right;
}
wall_tip_t;


typedef struct vertex_s
{
  float_g x, y;
  int index;
  int ref_count;
  struct vertex_s *equiv;
  wall_tip_t *tip_set;
  struct vertex_s *normal_dup;
}
vertex_t;


typedef struct sector_s
{
  int index;
  int coalesce;
  int ref_count;
  int floor_h, ceil_h;
  char floor_tex[8];
  char ceil_tex[8];
  int light;
  int special;
  int tag;
  int rej_group;
  struct sector_s *rej_next;
  struct sector_s *rej_prev;
}
sector_t;


typedef struct sidedef_s
{
  sector_t *sector;
  int x_offset, y_offset;
  char upper_tex[8];
  char lower_tex[8];
  char mid_tex[8];
  int index;
  int ref_count;
  struct sidedef_s *equiv;
  int on_special;
}
sidedef_t;


typedef struct linedef_s
{
  struct linedef_s *next;

  vertex_t *start;
  vertex_t *end;

  sidedef_t *right;
  sidedef_t *left;
  int two_sided;
  int is_precious;
  int zero_len;
  int flags;
  int type;
  int tag;
  int index;
}
linedef_t;


typedef struct seg_s
{
  struct seg_s *next;

  vertex_t *start;
  vertex_t *end;
  linedef_t *linedef;
  sector_t *sector;
  int side;
  int index;
  int degenerate;
  struct superblock_s *block;
  float_g psx, psy;
  float_g pex, pey;
  float_g pdx, pdy;

  float_g p_length;
  float_g p_angle;
  float_g p_para;
  float_g p_perp;
  linedef_t *source_line;
}
seg_t;

typedef struct subsec_s
{
  seg_t *seg_list;
  int seg_count;
  int index;
  float_g mid_x;
  float_g mid_y;
}
subsec_t;


typedef struct bbox_s
{
  int minx, miny;
  int maxx, maxy;
}
bbox_t;


typedef struct child_s
{
  struct node_s *node;
  subsec_t *subsec;
  bbox_t bounds;
}
child_t;

typedef struct node_s
{
  int x, y;
  int dx, dy;
  child_t r;
  child_t l;
  int index;
}
node_t;


typedef struct superblock_s
{
  struct superblock_s *parent;
  int x1, y1;
  int x2, y2;
  struct superblock_s *subs[2];

  int real_num;
  seg_t *segs;
}
superblock_t;

#define SUPER_IS_LEAF(s)  \
    ((s)->x2-(s)->x1 <= 256 && (s)->y2-(s)->y1 <= 256)


extern int num_vertices;
extern int num_linedefs;
extern int num_sidedefs;
extern int num_sectors;
extern int num_segs;
extern int num_subsecs;
extern int num_nodes;
extern int num_normal_vert;
extern int num_complete_seg;

vertex_t *NewVertex(void);
linedef_t *NewLinedef(void);
sidedef_t *NewSidedef(void);
sector_t *NewSector(void);
seg_t *NewSeg(void);
subsec_t *NewSubsec(void);
node_t *NewNode(void);
vertex_t *LookupVertex(int index);
linedef_t *LookupLinedef(int index);
sidedef_t *LookupSidedef(int index);
sector_t *LookupSector(int index);
seg_t *LookupSeg(int index);
subsec_t *LookupSubsec(int index);
node_t *LookupNode(int index);
vertex_t *NewVertexFromSplitSeg(seg_t *seg, float_g x, float_g y);
vertex_t *NewVertexDegenerate(vertex_t *start, vertex_t *end);

#endif