#ifndef __GLBSP_WAD_H__
#define __GLBSP_WAD_H__

#include "structs.h"
#include "system.h"


struct lump_s;

typedef struct wad_s
{
  enum { IWAD, PWAD } kind;
  int num_entries, dir_start;
  struct lump_s *dir_head, *dir_tail, *current_level;
  const char ** level_names;
  int num_level_names;
}
wad_t;

typedef struct lump_s
{
  struct lump_s *next;
  struct lump_s *prev;
  char *name;
  int start;
  int new_start;
  int length;
  int space;
  int flags;
  void *data;
  struct lump_s *level_list, *level_buddy;
}
lump_t;

#define LUMP_IS_LEVEL     0x0001
#define LUMP_COPY_ME      0x0004
#define LUMP_IGNORE_ME    0x0008
#define LUMP_READ_ME      0x0100

int CheckExtension(const char *filename, const char *ext);
char *ReplaceExtension(const char *filename, const char *ext);
glbsp_ret_e ReadWadFile(const char *filename);
glbsp_ret_e WriteWadFile(const char *filename);
void CloseWads(void);
int CountLevels(void);
int FindNextLevel(void);
const char *GetLevelName(void);
lump_t *FindLevelLump(const char *name);
int CheckLevelLumpZero(lump_t *lump);
lump_t *CreateLevelLump(const char *name);
lump_t *CreateGLLump(const char *name);
void AppendLevelLump(lump_t *lump, void *data, int length);

#ifdef CPU_BIG_ENDIAN

#define UINT16(x)  \
  ( ((uint16_g)(x) >> 8) | ((uint16_g)(x) << 8) )

#define UINT32(x)  \
  ( ((uint32_g)(x) >> 24) | (((uint32_g)(x) >> 8) & 0xff00) |  \
    (((uint32_g)(x) << 8) & 0xff0000) | ((uint32_g)(x) << 24) )

#else
#define UINT16(x)  ((uint16_g) (x))
#define UINT32(x)  ((uint32_g) (x))
#endif

#define UINT8(x)   ((uint8_g) (x))
#define SINT8(x)   ((sint8_g) (x))

#define SINT16(x)  ((sint16_g) UINT16(x))
#define SINT32(x)  ((sint32_g) UINT32(x))

#endif