// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// Copyright(C) 2002 James Haley
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//--------------------------------------------------------------------------
//
// DESCRIPTION:
//	Heretic game strings
//
//-----------------------------------------------------------------------------

#ifndef __DHTICSTR_H__
#define __DHTICSTR_H__

// episode end texts

#define H1TEXT \
   "with the destruction of the iron\n"\
   "liches and their minions, the last\n"\
   "of the undead are cleared from this\n"\
   "plane of existence.\n\n"\
   "those creatures had to come from\n"\
   "somewhere, though, and you have the\n"\
   "sneaky suspicion that the fiery\n"\
   "portal of hell's maw opens onto\n"\
   "their home dimension.\n\n"\
   "to make sure that more undead\n"\
   "(or even worse things) don't come\n"\
   "through, you'll have to seal hell's\n"\
   "maw from the other side. of course\n"\
   "this means you may get stuck in a\n"\
   "very unfriendly world, but no one\n"\
   "ever said being a Heretic was easy!"

#define H2TEXT \
   "the mighty maulotaurs have proved\n"\
   "to be no match for you, and as\n"\
   "their steaming corpses slide to the\n"\
   "ground you feel a sense of grim\n"\
   "satisfaction that they have been\n"\
   "destroyed.\n\n"\
   "the gateways which they guarded\n"\
   "have opened, revealing what you\n"\
   "hope is the way home. but as you\n"\
   "step through, mocking laughter\n"\
   "rings in your ears.\n\n"\
   "was some other force controlling\n"\
   "the maulotaurs? could there be even\n"\
   "more horrific beings through this\n"\
   "gate? the sweep of a crystal dome\n"\
   "overhead where the sky should be is\n"\
   "certainly not a good sign...."

#define H3TEXT \
   "the death of d'sparil has loosed\n"\
   "the magical bonds holding his\n"\
   "creatures on this plane, their\n"\
   "dying screams overwhelming his own\n"\
   "cries of agony.\n\n"\
   "your oath of vengeance fulfilled,\n"\
   "you enter the portal to your own\n"\
   "world, mere moments before the dome\n"\
   "shatters into a million pieces.\n\n"\
   "but if d'sparil's power is broken\n"\
   "forever, why don't you feel safe?\n"\
   "was it that last shout just before\n"\
   "his death, the one that sounded\n"\
   "like a curse? or a summoning? you\n"\
   "can't really be sure, but it might\n"\
   "just have been a scream.\n\n"\
   "then again, what about the other\n"\
   "serpent riders?"

#define H4TEXT \
   "you thought you would return to your\n"\
   "own world after d'sparil died, but\n"\
   "his final act banished you to his\n"\
   "own plane. here you entered the\n"\
   "shattered remnants of lands\n"\
   "conquered by d'sparil. you defeated\n"\
   "the last guardians of these lands,\n"\
   "but now you stand before the gates\n"\
   "to d'sparil's stronghold. until this\n"\
   "moment you had no doubts about your\n"\
   "ability to face anything you might\n"\
   "encounter, but beyond this portal\n"\
   "lies the very heart of the evil\n"\
   "which invaded your world. d'sparil\n"\
   "might be dead, but the pit where he\n"\
   "was spawned remains. now you must\n"\
   "enter that pit in the hopes of\n"\
   "finding a way out. and somewhere,\n"\
   "in the darkest corner of d'sparil's\n"\
   "demesne, his personal bodyguards\n"\
   "await your arrival ..."

#define H5TEXT \
   "as the final maulotaur bellows his\n"\
   "death-agony, you realize that you\n"\
   "have never come so close to your own\n"\
   "destruction. not even the fight with\n"\
   "d'sparil and his disciples had been\n"\
   "this desperate. grimly you stare at\n"\
   "the gates which open before you,\n"\
   "wondering if they lead home, or if\n"\
   "they open onto some undreamed-of\n"\
   "horror. you find yourself wondering\n"\
   "if you have the strength to go on,\n"\
   "if nothing but death and pain await\n"\
   "you. but what else can you do, if\n"\
   "the will to fight is gone? can you\n"\
   "force yourself to continue in the\n"\
   "face of such despair? do you have\n"\
   "the courage? you find, in the end,\n"\
   "that it is not within you to\n"\
   "surrender without a fight. eyes\n"\
   "wide, you go to meet your fate."

// automap level names

// episode 1 - the city of the damned
#define HHUSTR_E1M1 "E1M1:  THE DOCKS"
#define HHUSTR_E1M2 "E1M2:  THE DUNGEONS"
#define HHUSTR_E1M3 "E1M3:  THE GATEHOUSE"
#define HHUSTR_E1M4 "E1M4:  THE GUARD TOWER"
#define HHUSTR_E1M5 "E1M5:  THE CITADEL"
#define HHUSTR_E1M6 "E1M6:  THE CATHEDRAL"
#define HHUSTR_E1M7 "E1M7:  THE CRYPTS"
#define HHUSTR_E1M8 "E1M8:  HELL'S MAW"
#define HHUSTR_E1M9 "E1M9:  THE GRAVEYARD"

// episode 2 - hell's maw
#define HHUSTR_E2M1 "E2M1:  THE CRATER"
#define HHUSTR_E2M2 "E2M2:  THE LAVA PITS"
#define HHUSTR_E2M3 "E2M3:  THE RIVER OF FIRE"
#define HHUSTR_E2M4 "E2M4:  THE ICE GROTTO"
#define HHUSTR_E2M5 "E2M5:  THE CATACOMBS"
#define HHUSTR_E2M6 "E2M6:  THE LABYRINTH"
#define HHUSTR_E2M7 "E2M7:  THE GREAT HALL"
#define HHUSTR_E2M8 "E2M8:  THE PORTALS OF CHAOS"
#define HHUSTR_E2M9 "E2M9:  THE GLACIER"

// episode 3 - the dome of d'sparil
#define HHUSTR_E3M1 "E3M1:  THE STOREHOUSE"
#define HHUSTR_E3M2 "E3M2:  THE CESSPOOL"
#define HHUSTR_E3M3 "E3M3:  THE CONFLUENCE"
#define HHUSTR_E3M4 "E3M4:  THE AZURE FORTRESS"
#define HHUSTR_E3M5 "E3M5:  THE OPHIDIAN LAIR"
#define HHUSTR_E3M6 "E3M6:  THE HALLS OF FEAR"
#define HHUSTR_E3M7 "E3M7:  THE CHASM"
#define HHUSTR_E3M8 "E3M8:  D'SPARIL'S KEEP"
#define HHUSTR_E3M9 "E3M9:  THE AQUIFER"

// episode 4: the ossuary
#define HHUSTR_E4M1 "E4M1:  CATAFALQUE"
#define HHUSTR_E4M2 "E4M2:  BLOCKHOUSE"
#define HHUSTR_E4M3 "E4M3:  AMBULATORY"
#define HHUSTR_E4M4 "E4M4:  SEPULCHER"
#define HHUSTR_E4M5 "E4M5:  GREAT STAIR"
#define HHUSTR_E4M6 "E4M6:  HALLS OF THE APOSTATE"
#define HHUSTR_E4M7 "E4M7:  RAMPARTS OF PERDITION"
#define HHUSTR_E4M8 "E4M8:  SHATTERED BRIDGE"
#define HHUSTR_E4M9 "E4M9:  MAUSOLEUM"

// episode 5: the stagnant demesne
#define HHUSTR_E5M1 "E5M1:  OCHRE CLIFFS"
#define HHUSTR_E5M2 "E5M2:  RAPIDS"
#define HHUSTR_E5M3 "E5M3:  QUAY"
#define HHUSTR_E5M4 "E5M4:  COURTYARD"
#define HHUSTR_E5M5 "E5M5:  HYDRATYR"
#define HHUSTR_E5M6 "E5M6:  COLONNADE"
#define HHUSTR_E5M7 "E5M7:  FOETID MANSE"
#define HHUSTR_E5M8 "E5M8:  FIELD OF JUDGEMENT"
#define HHUSTR_E5M9 "E5M9:  SKEIN OF D'SPARIL"

// haleyjd: note: not externalized (use s_QUITMSG)
#define HTICQUITMSG "ARE YOU SURE YOU WANT TO QUIT?"

// item messages
#define HGOTBLUEKEY         "BLUE KEY"
#define HGOTYELLOWKEY       "YELLOW KEY"
#define HGOTGREENKEY        "GREEN KEY"
#define HITEMHEALTH         "CRYSTAL VIAL"
#define HITEMBAGOFHOLDING   "BAG OF HOLDING"
#define HITEMSHIELD1        "SILVER SHIELD"
#define HITEMSHIELD2        "ENCHANTED SHIELD"
#define HITEMSUPERMAP       "MAP SCROLL"
#define HAMMOGOLDWAND1      "WAND CRYSTAL"
#define HAMMOGOLDWAND2      "CRYSTAL GEODE"
#define HAMMOMACE1          "MACE SPHERES"
#define HAMMOMACE2          "PILE OF MACE SPHERES"
#define HAMMOCROSSBOW1      "ETHEREAL ARROWS"
#define HAMMOCROSSBOW2      "QUIVER OF ETHEREAL ARROWS"
#define HAMMOBLASTER1       "CLAW ORB"
#define HAMMOBLASTER2       "ENERGY ORB"
#define HAMMOSKULLROD1      "LESSER RUNES"
#define HAMMOSKULLROD2      "GREATER RUNES"
#define HAMMOPHOENIXROD1    "FLAME ORB"
#define HAMMOPHOENIXROD2    "INFERNO ORB"


// key messages
#define HPD_GREENO "You need a green key to activate this object"
#define HPD_GREENK "You need a green key to open this door"

#endif

// EOF
