/*
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation. NO WARRANTY.
*/

#include "doomstat.h"
#include "st_stuff.h"
#include "r_main.h"
#include "p_setup.h"
#include "p_maputl.h"
#include "w_wad.h"
#include "v_video.h"
#include "p_spec.h"
#include "am_map.h"
#include "d_deh.h"

int LongDiv(long long a,long long b)
{ return (abs(a)>>14) >= abs(b)? ((a^b)>>31)^MAXINT:((a<<16)/b); }

extern int  key_map;
#define NC 0
#define BC 247
#define FB 0
#define INITSCALEMTOF (.2*FRACUNIT)
#define F_PANINC  4
#define M_ZOOMIN   ((int) (1.02*FRACUNIT))
#define M_ZOOMOUT  ((int) (FRACUNIT/1.02))
#define FTOM(x) (long long)x*scale_ftom
#define MTOF(x) ((long long)((long long)(x)*scale_mtof)>>32)
#define CXMTOF(x)  (f_x + MTOF((x)-m_x))
#define CYMTOF(y)  (f_y + (f_h - MTOF((y)-m_y)))

typedef struct
{
  int x, y;
} fpoint_t;

typedef struct
{
  fpoint_t a, b;
} fline_t;

typedef struct
{
  mpoint_t a, b;
} mline_t;

typedef struct
{
  int slp, islp;
} islope_t;

#define R ((8*PLAYERRADIUS)/7)
mline_t player_arrow[] =
{
  { { -R+R/8, 0 }, { R, 0 } },
  { { R, 0 }, { R-R/2, R/4 } },
  { { R, 0 }, { R-R/2, -R/4 } },
  { { -R+R/8, 0 }, { -R-R/8, R/4 } },
  { { -R+R/8, 0 }, { -R-R/8, -R/4 } },
  { { -R+3*R/8, 0 }, { -R+R/8, R/4 } },
  { { -R+3*R/8, 0 }, { -R+R/8, -R/4 } }
};
#undef R
#define NUMPLYRLINES (sizeof(player_arrow)/sizeof(mline_t))

#define R ((8*PLAYERRADIUS)/7)
mline_t cheat_player_arrow[] =
{
  { { -R+R/8, 0 }, { R, 0 } },
  { { R, 0 }, { R-R/2, R/4 } },
  { { R, 0 }, { R-R/2, -R/4 } },
  { { -R+R/8, 0 }, { -R-R/8, R/4 } },
  { { -R+R/8, 0 }, { -R-R/8, -R/4 } },
  { { -R+3*R/8, 0 }, { -R+R/8, R/4 } },
  { { -R+3*R/8, 0 }, { -R+R/8, -R/4 } },
  { { -R/10-R/6, R/4}, {-R/10-R/6, -R/4} },
  { { -R/10-R/6, -R/4}, {-R/10-R/6-R/8, -R/4} },
  { { -R/10-R/6-R/8, -R/4}, {-R/10-R/6-R/8, -R/8} },
  { { -R/10, R/4}, {-R/10, -R/4}},
  { { -R/10, R/4}, {-R/10+R/8, R/4}},
  { { -R/10+R/4, R/4}, {-R/10+R/4, -R/4}},
  { { -R/10+R/4, R/4}, {-R/10+R/4+R/8, R/4}},
};
#undef R
#define NUMCHEATPLYRLINES (sizeof(cheat_player_arrow)/sizeof(mline_t))

#define R (FRACUNIT)
mline_t triangle_guy[] =
{
  { { -.867*R, -.5*R }, { .867*R, -.5*R } },
  { { .867*R, -.5*R } , { 0, R } },
  { { 0, R }, { -.867*R, -.5*R } }
};
#undef R
#define NUMTRIANGLEGUYLINES (sizeof(triangle_guy)/sizeof(mline_t))

#define R (FRACUNIT)
mline_t cross_mark[] =
{
  { { -R, 0 }, { R, 0} },
  { { 0, -R }, { 0, R } },
};
#undef R
#define NUMCROSSMARKLINES (sizeof(cross_mark)/sizeof(mline_t))

#define R (FRACUNIT)
mline_t thintriangle_guy[] =
{
  { { -.5*R, -.7*R }, { R, 0 } },
  { { R, 0 }, { -.5*R, .7*R } },
  { { -.5*R, .7*R }, { -.5*R, -.7*R } }
};
#undef R
#define NUMTHINTRIANGLEGUYLINES (sizeof(thintriangle_guy)/sizeof(mline_t))

int ddt_cheating=0,automap_grid=0;
boolean automapactive=0;
static int f_x,f_y,f_w,f_h;
static byte* fb;
static mpoint_t m_paninc;
static int mtof_zoommul,ftom_zoommul;
static long long m_x,m_y,m_x2,m_y2,m_w,m_h;
static long long min_x,min_y,max_x,max_y,max_w,max_h,min_w,min_h;
static int min_scale_mtof,max_scale_mtof;
static long long old_m_w,old_m_h,old_m_x,old_m_y;
static mpoint_t f_oldloc;
static int scale_mtof=INITSCALEMTOF,scale_ftom;
static player_t *plr;
static patch_t *marknums[10];
mpoint_t *markpoints=NULL;
int markpointnum=0,markpointnum_max=0,followplayer=1;
static boolean stopped=1;

void AM_getIslope(mline_t*ml,islope_t*is)
{
  int dx, dy;
  dy = ml->a.y - ml->b.y;
  dx = ml->b.x - ml->a.x;
  if (!dy)
    is->islp = (dx<0?-MAXINT:MAXINT);
  else
    is->islp = FixedDiv(dx, dy);
  if (!dx)
    is->slp = (dy<0?-MAXINT:MAXINT);
  else
    is->slp = FixedDiv(dy, dx);
}

void AM_activateNewScale(void)
{
  m_x += m_w/2;
  m_y += m_h/2;
  m_w = FTOM(f_w);
  m_h = FTOM(f_h);
  m_x -= m_w/2;
  m_y -= m_h/2;
  m_x2 = m_x + m_w;
  m_y2 = m_y + m_h;
}

void AM_saveScaleAndLoc(void)
{
  old_m_x = m_x;
  old_m_y = m_y;
  old_m_w = m_w;
  old_m_h = m_h;
}

void AM_restoreScaleAndLoc(void)
{
  m_w = old_m_w;
  m_h = old_m_h;
  if (!followplayer)
  {
    m_x = old_m_x;
    m_y = old_m_y;
  }
  else
  {
    m_x = plr->mo->x - m_w/2;
    m_y = plr->mo->y - m_h/2;
  }
  m_x2 = m_x + m_w;
  m_y2 = m_y + m_h;

  scale_mtof = FixedDiv(f_w<<FRACBITS, m_w);
  scale_ftom = FixedDiv(FRACUNIT, scale_mtof);
}

void AM_addMark(void)
{
  if (markpointnum >= markpointnum_max)
    markpoints = realloc(markpoints,
                        (markpointnum_max = markpointnum_max ? 
                         markpointnum_max*2 : 16) * sizeof(*markpoints));

  markpoints[markpointnum].x = m_x + m_w/2;
  markpoints[markpointnum].y = m_y + m_h/2;
  markpointnum++;
}

void AM_findMinMaxBoundaries(void)
{
  int i, a, b;

  min_x = min_y =  MAXINT;
  max_x = max_y = -MAXINT;

  for (i=0;i<numvertexes;i++)
  {
    if (vertexes[i].x < min_x)
      min_x = vertexes[i].x;
    else if (vertexes[i].x > max_x)
      max_x = vertexes[i].x;

    if (vertexes[i].y < min_y)
      min_y = vertexes[i].y;
    else if (vertexes[i].y > max_y)
      max_y = vertexes[i].y;
  }

  max_w = max_x - min_x;
  max_h = max_y - min_y;

  min_w = 2*PLAYERRADIUS;
  min_h = 2*PLAYERRADIUS;

  a = LongDiv(f_w<<FRACBITS, max_w);
  b = LongDiv(f_h<<FRACBITS, max_h);

  min_scale_mtof = a < b ? a : b;
  max_scale_mtof = FixedDiv(f_h<<FRACBITS, 2*PLAYERRADIUS);
}

void AM_changeWindowLoc(void)
{
  if (m_paninc.x || m_paninc.y)
  {
    followplayer = 0;
    f_oldloc.x = MAXINT;
  }

  m_x += m_paninc.x;
  m_y += m_paninc.y;

  if (m_x + m_w/2 > max_x)
    m_x = max_x - m_w/2;
  else if (m_x + m_w/2 < min_x)
    m_x = min_x - m_w/2;

  if (m_y + m_h/2 > max_y)
    m_y = max_y - m_h/2;
  else if (m_y + m_h/2 < min_y)
    m_y = min_y - m_h/2;

  m_x2 = m_x + m_w;
  m_y2 = m_y + m_h;
}

void AM_initVariables(void)
{
  int pnum;
  static event_t st_notify = { ev_keyup, AM_MSGENTERED };

  automapactive = true;
  fb = screens[0];

  f_oldloc.x = MAXINT;
  m_paninc.x = m_paninc.y = 0;
  ftom_zoommul = FRACUNIT;
  mtof_zoommul = FRACUNIT;

  m_w = FTOM(f_w);
  m_h = FTOM(f_h);

  if (!playeringame[pnum = consoleplayer])
  for (pnum=0;pnum<MAXPLAYERS;pnum++)
    if (playeringame[pnum])
  break;

  plr = &players[pnum];
  m_x = plr->mo->x - m_w/2;
  m_y = plr->mo->y - m_h/2;
  AM_changeWindowLoc();

  old_m_x = m_x;
  old_m_y = m_y;
  old_m_w = m_w;
  old_m_h = m_h;

  ST_Responder(&st_notify);
}

void AM_loadPics(void)
{
  int i;
  char namebuf[9];

  for (i=0;i<10;i++)
  {
    sprintf(namebuf, "AMMNUM%d", i);
    marknums[i] = W_CacheLumpName(namebuf, PU_STATIC);
  }
}

void AM_unloadPics(void)
{
  int i;

  for (i=0;i<10;i++)
    Z_ChangeTag(marknums[i], PU_CACHE);
}

void AM_clearMarks(void)
{
  markpointnum = 0;
}

void AM_LevelInit(void)
{
  f_x = f_y = 0;

  f_w = (SCREENWIDTH);
  f_h = (SCREENHEIGHT-ST_HEIGHT);

  AM_findMinMaxBoundaries();
  scale_mtof = FixedDiv(min_scale_mtof, (int) (0.7*FRACUNIT));
  if (scale_mtof > max_scale_mtof)
    scale_mtof = min_scale_mtof;
  scale_ftom = FixedDiv(FRACUNIT, scale_mtof);
}

void AM_Stop (void)
{
  static event_t st_notify = { 0, ev_keyup, AM_MSGEXITED };

  AM_unloadPics();
  automapactive = false;
  ST_Responder(&st_notify);
  stopped = true;
}

void AM_Start()
{
  static int lastlevel = -1, lastepisode = -1;

  if (!stopped)
    AM_Stop();
  stopped = false;
  if (lastlevel != gamemap || lastepisode != gameepisode)
  {
    AM_LevelInit();
    lastlevel = gamemap;
    lastepisode = gameepisode;
  }
  AM_initVariables();
  AM_loadPics();
}

void AM_minOutWindowScale()
{
  scale_mtof = min_scale_mtof;
  scale_ftom = FixedDiv(FRACUNIT, scale_mtof);
  AM_activateNewScale();
}

void AM_maxOutWindowScale(void)
{
  scale_mtof = max_scale_mtof;
  scale_ftom = FixedDiv(FRACUNIT, scale_mtof);
  AM_activateNewScale();
}

boolean AM_Responder(event_t* ev)
{
  int rc=0, ch;
  static int cheatstate=0, bigstate=0;
  static char buffer[20];

  if (!automapactive)
  {
    if (ev->type == ev_keydown && ev->data1 == key_map)
    {
      AM_Start ();
      viewactive = false;
      rc = true;
    }
  }
  else if (ev->type == ev_keydown)
  {
    rc = true;
    ch = ev->data1;                                             
    if (ch == KEYD_RIGHTARROW)                                 
      if (!followplayer)
        m_paninc.x = FTOM(F_PANINC);
      else
        rc = false;
    else if (ch == KEYD_LEFTARROW)
      if (!followplayer)
          m_paninc.x = -FTOM(F_PANINC);
      else
          rc = false;
    else if (ch == KEYD_UPARROW)
      if (!followplayer)
          m_paninc.y = FTOM(F_PANINC);
      else
          rc = false;
    else if (ch == KEYD_DOWNARROW)
      if (!followplayer)
          m_paninc.y = -FTOM(F_PANINC);
      else
          rc = false;
    else if (ch == '-')
    {
      mtof_zoommul = M_ZOOMOUT;
      ftom_zoommul = M_ZOOMIN;
    }
    else if (ch == '=')
    {
      mtof_zoommul = M_ZOOMIN;
      ftom_zoommul = M_ZOOMOUT;
    }
    else if (ch == key_map)
    {
      bigstate = 0;
      viewactive = true;
      AM_Stop ();
    }
    else if (ch == '0')
    {
      bigstate = !bigstate;
      if (bigstate)
      {
        AM_saveScaleAndLoc();
        AM_minOutWindowScale();
      }
      else
        AM_restoreScaleAndLoc();
    }
    else if (ch == 'f')
    {
      followplayer = !followplayer;
      f_oldloc.x = MAXINT;
      plr->message = followplayer ? s_AMSTR_FOLLOWON : s_AMSTR_FOLLOWOFF;  
    }
    else if (ch == 'g')
    {
      automap_grid = !automap_grid;
      plr->message = automap_grid ? s_AMSTR_GRIDON : s_AMSTR_GRIDOFF;  
    }
    else if (ch == 'm')
    {  
      sprintf(buffer, "%s %d", s_AMSTR_MARKEDSPOT, markpointnum);  
      plr->message = buffer;
      AM_addMark();
    }
    else if (ch == 'c')
    {
      AM_clearMarks();
      plr->message = s_AMSTR_MARKSCLEARED;
    }
    else
    {
      cheatstate=0;
      rc = false;
    }
  }
  else if (ev->type == ev_keyup)
  {
    rc = false;
    ch = ev->data1;
    if (ch == KEYD_RIGHTARROW)
    {
      if (!followplayer)
          m_paninc.x = 0;
    }
    else if (ch == KEYD_LEFTARROW)
    {
      if (!followplayer)
          m_paninc.x = 0;
    }
    else if (ch == KEYD_UPARROW)
    {
      if (!followplayer)
          m_paninc.y = 0;
    }
    else if (ch == KEYD_DOWNARROW)
    {
      if (!followplayer)
          m_paninc.y = 0;
    }
    else if ((ch == '-') || (ch == '='))
    {
      mtof_zoommul = FRACUNIT;
      ftom_zoommul = FRACUNIT;
    }
  }
  return rc;
}

void AM_changeWindowScale(void)
{
  scale_mtof = FixedMul(scale_mtof, mtof_zoommul);
  scale_ftom = FixedDiv(FRACUNIT, scale_mtof);

  if (scale_mtof < min_scale_mtof)
    AM_minOutWindowScale();
  else if (scale_mtof > max_scale_mtof)
    AM_maxOutWindowScale();
  else
    AM_activateNewScale();
}

void AM_doFollowPlayer(void)
{
  if (f_oldloc.x != plr->mo->x || f_oldloc.y != plr->mo->y)
  {
    m_x = FTOM(MTOF(plr->mo->x)) - m_w/2;
    m_y = FTOM(MTOF(plr->mo->y)) - m_h/2;
    m_x2 = m_x + m_w;
    m_y2 = m_y + m_h;
    f_oldloc.x = plr->mo->x;
    f_oldloc.y = plr->mo->y;
  }
}

void AM_Coordinates(const mobj_t *mo, int *x, int *y, int *z)
{
  *z = followplayer ? *x = mo->x, *y = mo->y, mo->z :
    R_PointInSubsector(*x = m_x+m_w/2, *y = m_y+m_h/2)->sector->floorheight;
}

void AM_Ticker (void)
{
  if (!automapactive)
    return;

  if (followplayer)
    AM_doFollowPlayer();

  if (ftom_zoommul != FRACUNIT)
    AM_changeWindowScale();

  if (m_paninc.x || m_paninc.y)
    AM_changeWindowLoc();
}

void AM_clearFB(int color)
{
  memset(fb, color, f_w*f_h);
}

boolean AM_clipMline(mline_t*ml,fline_t*fl)
{
  enum
  {
    LEFT    =1,
    RIGHT   =2,
    BOTTOM  =4,
    TOP     =8
  };
  register int outcode1 = 0;
  register int outcode2 = 0;
  register int outside;
  fpoint_t tmp;
  int dx,dy;
    
#define DOOUTCODE(oc, mx, my) \
  (oc) = 0; \
  if ((my) < 0) (oc) |= TOP; \
  else if ((my) >= f_h) (oc) |= BOTTOM; \
  if ((mx) < 0) (oc) |= LEFT; \
  else if ((mx) >= f_w) (oc) |= RIGHT;

  if (ml->a.y > m_y2)
  outcode1 = TOP;
  else if (ml->a.y < m_y)
  outcode1 = BOTTOM;

  if (ml->b.y > m_y2)
  outcode2 = TOP;
  else if (ml->b.y < m_y)
  outcode2 = BOTTOM;

  if (outcode1 & outcode2)
  return false;

  if (ml->a.x < m_x)
  outcode1 |= LEFT;
  else if (ml->a.x > m_x2)
  outcode1 |= RIGHT;

  if (ml->b.x < m_x)
  outcode2 |= LEFT;
  else if (ml->b.x > m_x2)
  outcode2 |= RIGHT;

  if (outcode1 & outcode2)
  return false;

  fl->a.x = CXMTOF(ml->a.x);
  fl->a.y = CYMTOF(ml->a.y);
  fl->b.x = CXMTOF(ml->b.x);
  fl->b.y = CYMTOF(ml->b.y);

  DOOUTCODE(outcode1, fl->a.x, fl->a.y);
  DOOUTCODE(outcode2, fl->b.x, fl->b.y);

  if (outcode1 & outcode2)
  return false;

  while (outcode1 | outcode2)
  {
    if (outcode1)
      outside = outcode1;
    else
      outside = outcode2;
    if (outside & TOP)
    {
      dy = fl->a.y - fl->b.y;
      dx = fl->b.x - fl->a.x;
      tmp.x = fl->a.x + (dx*(fl->a.y))/dy;
      tmp.y = 0;
    }
    else if (outside & BOTTOM)
    {
      dy = fl->a.y - fl->b.y;
      dx = fl->b.x - fl->a.x;
      tmp.x = fl->a.x + (dx*(fl->a.y-f_h))/dy;
      tmp.y = f_h-1;
    }
    else if (outside & RIGHT)
    {
      dy = fl->b.y - fl->a.y;
      dx = fl->b.x - fl->a.x;
      tmp.y = fl->a.y + (dy*(f_w-1 - fl->a.x))/dx;
      tmp.x = f_w-1;
    }
    else if (outside & LEFT)
    {
      dy = fl->b.y - fl->a.y;
      dx = fl->b.x - fl->a.x;
      tmp.y = fl->a.y + (dy*(-fl->a.x))/dx;
      tmp.x = 0;
    }

    if (outside == outcode1)
    {
      fl->a = tmp;
      DOOUTCODE(outcode1, fl->a.x, fl->a.y);
    }
    else
    {
      fl->b = tmp;
      DOOUTCODE(outcode2, fl->b.x, fl->b.y);
    }

    if (outcode1 & outcode2)
      return false;
  }

  return true;
}
#undef DOOUTCODE

void AM_drawFline(fline_t*fl,int color)
{
  register int x;
  register int y;
  register int dx;
  register int dy;
  register int sx;
  register int sy;
  register int ax;
  register int ay;
  register int d;

#define PUTDOT(xx,yy,cc) fb[(yy)*f_w+(xx)]=(cc)

  dx = fl->b.x - fl->a.x;
  ax = 2 * (dx<0 ? -dx : dx);
  sx = dx<0 ? -1 : 1;

  dy = fl->b.y - fl->a.y;
  ay = 2 * (dy<0 ? -dy : dy);
  sy = dy<0 ? -1 : 1;

  x = fl->a.x;
  y = fl->a.y;

  if (ax > ay)
  {
    d = ay - ax/2;
    while (1)
    {
      PUTDOT(x,y,color);
      if (x == fl->b.x) return;
      if (d>=0)
      {
        y += sy;
        d -= ax;
      }
      x += sx;
      d += ay;
    }
  }
  else
  {
    d = ax - ay/2;
    while (1)
    {
      PUTDOT(x, y, color);
      if (y == fl->b.y) return;
      if (d >= 0)
      {
        x += sx;
        d -= ay;
      }
      y += sy;
      d += ax;
    }
  }
}

void AM_drawMline(mline_t*ml,int color)
{
  static fline_t fl;

  if (color==-1) return;
  if (color==247) color=0;
  if (AM_clipMline(ml, &fl)) AM_drawFline(&fl, color);
}

void AM_drawGrid(int color)
{
  long x,y,start,end;
  mline_t ml;

  start = m_x;
  if ((start-bmaporgx)%(MAPBLOCKUNITS<<FRACBITS))
    start += (MAPBLOCKUNITS<<FRACBITS)
      - ((start-bmaporgx)%(MAPBLOCKUNITS<<FRACBITS));
  end = m_x + m_w;

  ml.a.y = m_y;
  ml.b.y = m_y+m_h;
  for (x=start; x<end; x+=(MAPBLOCKUNITS<<FRACBITS))
  {
    ml.a.x = x;
    ml.b.x = x;
    AM_drawMline(&ml, color);
  }

  start = m_y;
  if ((start-bmaporgy)%(MAPBLOCKUNITS<<FRACBITS))
    start += (MAPBLOCKUNITS<<FRACBITS)
      - ((start-bmaporgy)%(MAPBLOCKUNITS<<FRACBITS));
  end = m_y + m_h;

  ml.a.x = m_x;
  ml.b.x = m_x + m_w;
  for (y=start; y<end; y+=(MAPBLOCKUNITS<<FRACBITS))
  {
    ml.a.y = y;
    ml.b.y = y;
    AM_drawMline(&ml, color);
  }
}

void AM_drawWalls(void)
{
  int i;
  static mline_t l;

  for (i=0;i<numlines;i++)
  {
    l.a.x = lines[i].v1->x;
    l.a.y = lines[i].v1->y;
    l.b.x = lines[i].v2->x;
    l.b.y = lines[i].v2->y;
    if (ddt_cheating || (lines[i].flags & ML_MAPPED))
    {
      if ((lines[i].flags & ML_DONTDRAW) && !ddt_cheating) continue;
      if (!lines[i].backsector) AM_drawMline(&l, 176);
      else
      {
       if(lines[i].special == 39 || lines[i].special == 97 ||
         lines[i].special == 125 || lines[i].special == 126)
       AM_drawMline(&l, 119);
       else if
       (lines[i].backsector->floorheight==lines[i].backsector->ceilingheight ||
       lines[i].frontsector->floorheight==lines[i].frontsector->ceilingheight)
       AM_drawMline(&l, 193);
       else if (lines[i].backsector->floorheight !=
		lines[i].frontsector->floorheight ||
		lines[i].backsector->ceilingheight !=
                lines[i].frontsector->ceilingheight)
       AM_drawMline(&l, 231);
       else if (ddt_cheating) AM_drawMline(&l, 88);
      }
    }
    else if (plr->powers[pw_allmap])
    { if (!(lines[i].flags & ML_DONTDRAW)) AM_drawMline(&l, 104); }
  }
}

void AM_rotate(int*x,int*y,angle_t a)
{
  int tmpx;

  tmpx = FixedMul(*x,finecosine[a>>ANGLETOFINESHIFT])
  - FixedMul(*y,finesine[a>>ANGLETOFINESHIFT]);
  *y = FixedMul(*x,finesine[a>>ANGLETOFINESHIFT])
  + FixedMul(*y,finecosine[a>>ANGLETOFINESHIFT]);
  *x = tmpx;
}

void AM_drawLineCharacter(mline_t* lineguy,int lineguylines,int scale,
angle_t angle,int color,int x,int y)
{
  int i;
  mline_t l;

  for (i=0;i<lineguylines;i++)
  {
    l.a.x = lineguy[i].a.x;
    l.a.y = lineguy[i].a.y;

    if (scale)
    {
      l.a.x = FixedMul(scale, l.a.x);
      l.a.y = FixedMul(scale, l.a.y);
    }

    if (angle) AM_rotate(&l.a.x, &l.a.y, angle);
    l.a.x += x;
    l.a.y += y;
    l.b.x = lineguy[i].b.x;
    l.b.y = lineguy[i].b.y;

    if (scale)
    {
      l.b.x = FixedMul(scale, l.b.x);
      l.b.y = FixedMul(scale, l.b.y);
    }

    if (angle) AM_rotate(&l.b.x, &l.b.y, angle);
    l.b.x += x;
    l.b.y += y;
    AM_drawMline(&l, color);
  }
}

void AM_drawPlayers(void)
{
  int i,their_color=-1,color;
  player_t* p;

  if (!netgame)
  {
    if (ddt_cheating)
    AM_drawLineCharacter(cheat_player_arrow,NUMCHEATPLYRLINES,0,
    plr->mo->angle,208,plr->mo->x,plr->mo->y); 
    else
    AM_drawLineCharacter(player_arrow,NUMPLYRLINES,0,plr->mo->angle,208,
    plr->mo->x,plr->mo->y);        
    return;
  }

  for (i=0;i<MAXPLAYERS;i++)
  {
    their_color++;
    p = &players[i];

    if ((deathmatch&&!demoplayback)&&p!=plr)
      continue;
    if (!playeringame[i])
      continue;

if (p->powers[pw_invisibility])
color = 246;
else
color = !their_color ? 112 : their_color==1 ? 88 : their_color==2 ? 64:176;

 AM_drawLineCharacter(player_arrow,NUMPLYRLINES,0,p->mo->angle,color,
 p->mo->x,p->mo->y);
  }
}

void AM_drawThings(int colors,int colorrange)
{
  int   i;
  mobj_t* t;

  for (i=0;i<numsectors;i++)
  {
    t = sectors[i].thinglist;
    while (t)
    {
        switch(t->info->doomednum)
        {
          case 38: case 13:
            AM_drawLineCharacter
            (cross_mark,NUMCROSSMARKLINES,16<<FRACBITS,
             t->angle,175,t->x,t->y);
            t = t->snext;
            continue;
          case 39: case 6:
            AM_drawLineCharacter
            (cross_mark,NUMCROSSMARKLINES,16<<FRACBITS,
             t->angle,231,t->x,t->y);
            t = t->snext;
            continue;
          case 40: case 5:
            AM_drawLineCharacter
            (cross_mark,NUMCROSSMARKLINES,16<<FRACBITS,
             t->angle,204,t->x,t->y);
            t = t->snext;
            continue;
          default:
            break;
        }
      
      AM_drawLineCharacter
      (thintriangle_guy,NUMTHINTRIANGLEGUYLINES,16<<FRACBITS,
       t->angle,t->flags & MF_FRIEND && !t->player ? 252 : 112,t->x,t->y);
      t = t->snext;
    }
  }
}

void AM_drawMarks(void)
{
  int i;
  for (i=0;i<markpointnum;i++)
    if (markpoints[i].x != -1)
      {
        int w=5, h=6;
	int fx=CXMTOF(markpoints[i].x), fy=CYMTOF(markpoints[i].y);
	int j=i;
	do
	  {
	    int d = j % 10;
	    if (d==1) fx += 1;
	    if (fx >= f_x && fx < f_w - w && fy >= f_y && fy < f_h - h)
              V_DrawPatch(fx, fy, FB, marknums[d],0);
            fx -= w - 1; j /= 10;
	  }
	while (j>0);
      }
}

void AM_Drawer (void)
{
  if (!automapactive) return;
  AM_clearFB(247);
  if (automap_grid)
    AM_drawGrid(104);
  AM_drawWalls();
  AM_drawPlayers();
  if (ddt_cheating==2)
    AM_drawThings(112, 0);
  fb[(f_w*(f_h+1))/2]=208;
  AM_drawMarks();
}