/*
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation. NO WARRANTY.
*/

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "doomdef.h"
#include "doomstat.h"
#include "d_englsh.h"
#include "sounds.h"
#include "z_zone.h"
#include "w_wad.h"
#include "v_video.h"
#include "doomtype.h"
#include "d_event.h"
#include "m_misc.h"
#include "m_menu.h"
#include "i_system.h"
#include "g_game.h"
#include "wi_stuff.h"
#include "st_stuff.h"
#include "am_map.h"
#include "p_setup.h"
#include "r_draw.h"
#include "r_main.h"
#include "d_deh.h"
int myargc; char **myargv;
int M_CheckParm(const char *check) { int i;
 for (i=1; i<myargc; i++) if (!strcasecmp(check, myargv[i]))
 return i; return 0; }

char *wad_files[2],*deh_files[2];
void D_ProcessPreincludes(char*p)
{ int i; char *s;
  for (i=0;i<2;i++) {
  if (p==".deh")s=deh_files[i]; else s=wad_files[i];
  if (s) { while (isspace(*s)) s++;
  if (*s) { char file[PATH_MAX+1];
  AddDefaultExtension(strcpy(file, s), p);
  if (!access(file, R_OK)) { if(p==".deh")
  ProcessDehFile(file,0); else D_AddFile(file); } else
  printf("\nWarn: cannot open %s\n", file); } } }
}

char **wadfiles;
boolean devparm;
boolean clnomonsters,clrespawnparm,clfastparm;
boolean nomonsters,respawnparm,fastparm;
boolean singletics = 0;
boolean nosfxparm,nomusicparm;
GameMode_t gamemode = indetermined;
GameMission_t gamemission = doom;
boolean modifiedgame;
int compatibility, default_compatibility;
int comp[COMP_TOTAL], default_comp[COMP_TOTAL];
int demo_version;
int allow_pushers,default_allow_pushers;
int variable_friction,default_variable_friction;
int monsters_remember,default_monsters_remember;
int monster_infighting,default_monster_infighting;
int monster_friction,default_monster_friction;
int monster_backing, default_monster_backing;
int monster_avoid_hazards, default_monster_avoid_hazards;
int monkeys, default_monkeys;
extern boolean inhelpscreens;
skill_t startskill;
int     startepisode;
int     startmap;
boolean autostart;
boolean advancedemo;
extern boolean timingdemo, singledemo, demoplayback, fastdemo;
char wadfile[PATH_MAX+1],mapdir[PATH_MAX+1];
char basedefault[PATH_MAX+1],baseiwad[PATH_MAX+1],basesavegame[PATH_MAX+1];

const char *const standard_iwads[]=
{
  "/Robocop.wad",
  "/doom2.wad",
  "/plutonia.wad",
  "/tnt.wad",
  "/doom.wad",
  "/doom1.wad",
};
static const int nstandard_iwads = sizeof standard_iwads/sizeof*standard_iwads;

event_t events[MAXEVENTS];
int eventhead, eventtail;

void D_PostEvent(event_t *ev)
{
  events[eventhead++] = *ev;
  eventhead &= MAXEVENTS-1;
}

void D_ProcessEvents (void)
{
  if (gamemode != commercial || W_CheckNumForName("map01") >= 0)
    for (; eventtail != eventhead; eventtail = (eventtail+1) & (MAXEVENTS-1))
      if (!M_Responder(events+eventtail))
        G_Responder(events+eventtail);
}

gamestate_t    wipegamestate = GS_DEMOSCREEN;
extern boolean setsizeneeded;
extern int     showMessages;
void           R_ExecuteSetViewSize(void);

void D_Display (void)
{
  static boolean viewactivestate = false;
  static boolean menuactivestate = false;
  static boolean inhelpscreensstate = false;
  static boolean fullscreen = false;
  static gamestate_t oldgamestate = -1;
  static int borderdrawcount;
  int wipestart;
  boolean done, wipe, redrawsbar;

  if (nodrawers) return;
  redrawsbar = false;
  if (setsizeneeded) {
      R_ExecuteSetViewSize();
      oldgamestate = -1;
      borderdrawcount = 3; }

  if ((wipe = gamestate != wipegamestate))
    wipe_StartScreen();

  if (gamestate == GS_LEVEL && gametic)
    HU_Erase();

  switch (gamestate)
    {
    case GS_LEVEL:
      if (!gametic)
        break;
      if (automapactive)
        AM_Drawer();
      if (wipe || (scaledviewheight != 200 && fullscreen)
          || (inhelpscreensstate && !inhelpscreens))
        redrawsbar = true;
      ST_Drawer(scaledviewheight == 200, redrawsbar );
      fullscreen = scaledviewheight == 200;
      break;
    case GS_INTERMISSION:
      WI_Drawer();
      break;
    case GS_FINALE:
      F_Drawer();
      break;
    case GS_DEMOSCREEN:
      D_PageDrawer();
      break;
    }

  if (gamestate == GS_LEVEL && !automapactive && gametic)
    R_RenderPlayerView (&players[displayplayer]);

  if (gamestate == GS_LEVEL && gametic)
    HU_Drawer ();

  if (gamestate != oldgamestate && gamestate != GS_LEVEL)
    I_SetPalette (W_CacheLumpName ("PLAYPAL",PU_CACHE));

  if (gamestate == GS_LEVEL && oldgamestate != GS_LEVEL)
    {
      viewactivestate = false;
      R_FillBackScreen ();
    }

  if (gamestate == GS_LEVEL && !automapactive && scaledviewwidth != 320)
    {
      if (menuactive || menuactivestate || !viewactivestate)
        borderdrawcount = 3;
      if (borderdrawcount)
        {
          R_DrawViewBorder ();
          borderdrawcount--;
        }
    }

  menuactivestate = menuactive;
  viewactivestate = viewactive;
  inhelpscreensstate = inhelpscreens;
  oldgamestate = wipegamestate = gamestate;

  if (paused)
    {
      int y = 4;
      if (!automapactive) y += viewwindowy;
      V_DrawPatch(viewwindowx+(scaledviewwidth-68)/2,
      y,0,W_CacheLumpName ("M_PAUSE", PU_CACHE),0);
    }
  M_Drawer();
  NetUpdate();
  if (!wipe)
    {
      I_FinishUpdate ();
      return;
    }
  wipe_EndScreen(0, 0, SCREENWIDTH, SCREENHEIGHT);
  wipestart = I_GetTime () - 1;
  do
    {
      int nowtime, tics;
      do
        {
          nowtime = I_GetTime();
          tics = nowtime - wipestart;
        }
      while (!tics);
      wipestart = nowtime;
      done = wipe_ScreenWipe(tics);
      M_Drawer();
      I_FinishUpdate();
    }
  while (!done);
}

static int demosequence;
static int pagetic;
static char *pagename;

void D_PageTicker()
{
  if (!singledemo && --pagetic < 0)
    D_AdvanceDemo();
}

D_PageDrawer()
{
  int l;
  if ((l=W_CheckNumForName(pagename))!=-1)
    {
      byte *t = W_CacheLumpNum(l, PU_CACHE);
      size_t s = W_LumpLength(l);
      unsigned c = 0;
      while (s--)
	c = c*3 + t[s];
      V_DrawPatch(0,0,0,(patch_t*)t,0);
    }
  else
    M_DrawCredits();
}

D_AdvanceDemo ()
{
  advancedemo = true;
}

static void D_SetPageName(char *name)
{
  pagename = name;
}

static void D_DrawTitle1(char *name)
{
  S_StartMusic(mus_intro);
  pagetic = 170;
  D_SetPageName(name);
}

static void D_DrawTitle2(char *name)
{
  S_StartMusic(mus_dm2ttl);
  D_SetPageName(name);
}

static struct 
{
  void (*func)(char *);
  char *name;
} const demostates[][4] =
  {
   {
   {D_DrawTitle1, "TITLEPIC"},
   {D_DrawTitle1, "TITLEPIC"},
   {D_DrawTitle2, "TITLEPIC"},
   {D_DrawTitle1, "TITLEPIC"},
   },
   {
   {G_DeferedPlayDemo, "demo1"},
   {G_DeferedPlayDemo, "demo1"},
   {G_DeferedPlayDemo, "demo1"},
   {G_DeferedPlayDemo, "demo1"},
   },
   {
   {D_SetPageName, "HELP2"},
   {D_SetPageName, "CREDIT"},
   {D_SetPageName, "CREDIT"},
   {D_SetPageName, "CREDIT"},
   },
   {
   {G_DeferedPlayDemo, "demo2"},
   {G_DeferedPlayDemo, "demo2"},
   {G_DeferedPlayDemo, "demo2"},
   {G_DeferedPlayDemo, "demo2"},
   },
   {
   {D_SetPageName, "HELP2"},
   {D_DrawTitle1, "TITLEPIC"},
   {D_DrawTitle2, "TITLEPIC"},
   {D_DrawTitle1, "TITLEPIC"},
   },
   {
   {G_DeferedPlayDemo, "demo3"},
   {G_DeferedPlayDemo, "demo3"},
   {G_DeferedPlayDemo, "demo3"},
   {G_DeferedPlayDemo, "demo3"},
   },
   {
   {0},
   {0},
   {0},
   {D_SetPageName, "CREDIT"},
   },
   {
   {0},
   {0},
   {0},
   {G_DeferedPlayDemo, "demo4"},
   },
{{0},{0},{0},{0},}
  };

void D_DoAdvanceDemo()
{
  players[consoleplayer].playerstate = PST_LIVE;
  advancedemo = usergame = paused = false;
  gameaction = ga_nothing;

  pagetic = TICRATE * 11;
  gamestate = GS_DEMOSCREEN;

  if (!demostates[++demosequence][gamemode].func)
    demosequence = 0;
  demostates[demosequence][gamemode].func
    (demostates[demosequence][gamemode].name);
}

void D_StartTitle ()
{
  gameaction = ga_nothing;
  demosequence = -1;
  D_AdvanceDemo();
}

static char title[128];

D_AddFile(char *file)
{
  static int numwadfiles, numwadfiles_alloc;

  if (numwadfiles >= numwadfiles_alloc)
    wadfiles = realloc(wadfiles, (numwadfiles_alloc = numwadfiles_alloc ?
                                  numwadfiles_alloc * 2 : 8)*sizeof*wadfiles);
  wadfiles[numwadfiles++] = !file ? NULL : strdup(file);
}

char *D_DoomExeDir()
{
  static char *base;
  if (!base)
    {
      size_t len = strlen(*myargv);
      char *p = (base = malloc(len+1)) + len;
      strcpy(base,*myargv);
      while (p > base && *p!='/' && *p!='\\')
        *p--=0;
    }
  return base;
}

char *D_DoomExeName(void)
{
  static char *name;
  if (!name)
    {
      char *p = *myargv + strlen(*myargv);
      int i = 0;
      while (p > *myargv && p[-1] != '/' && p[-1] != '\\' && p[-1] != ':')
        p--;
      while (p[i] && p[i] != '.')
        i++;
      strncpy(name = malloc(i+1), p, i)[i] = 0;
    }
  return name;
}

void CheckIWAD(const char *iwadname, GameMode_t *gmode, GameMission_t *gmission)
{
  FILE *fp = fopen(iwadname, "rb");
  int ud, rg, sw, cm, sc, tnt, plut;
  filelump_t lump;
  wadinfo_t header;
  const char *n = lump.name;

  if (!fp)
    I_Error("Ne pouvez ouvrir IWAD: %s\n",iwadname);

  if (fread(&header, 1, sizeof header, fp) != sizeof header ||
      header.identification[1] != 'W' ||
      header.identification[2] != 'A' || header.identification[3] != 'D')
    I_Error("IWAD tag ne valide: %s\n",iwadname);

  fseek(fp, LONG(header.infotableofs), SEEK_SET);

  for (ud=rg=sw=cm=sc=tnt=plut=0, header.numlumps = LONG(header.numlumps);
       header.numlumps && fread(&lump, sizeof lump, 1, fp); header.numlumps--)
    *n=='E' && n[2]=='M' && !n[4] ?
      n[1]=='4' ? ++ud : n[1]!='1' ? rg += n[1]=='3' || n[1]=='2' : ++sw :
    *n=='M' && n[1]=='A' && n[2]=='P' && !n[5] ?
      ++cm, sc += n[3]=='3' && (n[4]=='1' || n[4]=='2') :
    *n=='C' && n[1]=='A' && n[2]=='V' && !n[7] ? ++tnt :
    *n=='M' && n[1]=='C' && !n[3] && ++plut;

  fclose(fp);

  *gmission = doom;
  *gmode =
    cm >= 30 ? (*gmission = tnt >= 4 ? pack_tnt :
                plut >= 8 ? pack_plut : doom2, commercial) :
    ud >= 9 ? retail :
    rg >= 18 ? registered :
    sw >= 9 ? shareware : commercial;
}

void WadFileStatus(char *filename)
{
  int i=strlen(filename);
  if (i>=4)
  if(strnicmp(filename+i-4,".wad",4))
  strcat(filename,".wad");
}

char *FindIWADFile(void)
{
  static char iwad[PATH_MAX+1];
  int i,j;
  *iwad = 0;
  if ((i = M_CheckParm("-iwad")) && i < myargc-1)
    {
      NormalizeSlashes(strcpy(baseiwad,myargv[i+1]));
      WadFileStatus(strcpy(iwad,baseiwad));
          return iwad;
    }
  for (j=0; j<2; j++)
    {
      strcpy(iwad, j ? D_DoomExeDir() : ".");
      NormalizeSlashes(iwad);
        for (i=0;i<nstandard_iwads;i++)
          {
            int n = strlen(iwad);
            strcat(iwad,standard_iwads[i]);
            WadFileStatus(iwad);
            if(fopen(iwad, "rb")) return iwad;
            iwad[n] = 0;
          }
    }
  *iwad = 0;
  return iwad;
}

void IdentifyVersion (void)
{
  char *iwad;
  sprintf(basedefault,"%s/%s.cfg", D_DoomExeDir(), D_DoomExeName());
  strcpy(basesavegame,"."); iwad = FindIWADFile();
  if (iwad && *iwad) { CheckIWAD(iwad, &gamemode, &gamemission);
  D_AddFile(iwad); } else I_Error("IWAD ne finde");
}

void D_ProcessDehCommandLine(void)
{
  int p = M_CheckParm ("-deh");
  if (p) { char file[PATH_MAX+1];
  AddDefaultExtension(strcpy(file, myargv[p+1]), ".deh");
  if (access(file, F_OK))
  I_Error("Ne pouvez encounter .deh file %s", myargv[p+1]);
  ProcessDehFile(file, 0);
  }
}

void D_ProcessDehInWad(int i)
{
  if (i>=0) { D_ProcessDehInWad(lumpinfo[i].next);
  if (!strncasecmp(lumpinfo[i].name, "dehacked", 8) &&
  lumpinfo[i].namespace == ns_global) ProcessDehFile(NULL, i); }
}

#define D_ProcessDehInWads() D_ProcessDehInWad(lumpinfo[W_LumpNameHash \
("dehacked") % (unsigned) numlumps].index);
void D_DoomMain(void)
{
  int p, slot; char file[PATH_MAX+1];
  IdentifyVersion();
  modifiedgame = false;
  D_ProcessDehCommandLine();
  nomonsters = clnomonsters = M_CheckParm ("-nomonsters");
  respawnparm = clrespawnparm = M_CheckParm ("-respawn");
  fastparm = clfastparm = M_CheckParm ("-fast");
  devparm = M_CheckParm ("-devparm");
  if (M_CheckParm ("-altdeath")) deathmatch = 2;
  else if (M_CheckParm ("-deathmatch")) deathmatch = 1;
  switch (gamemode) {
    case retail:
      sprintf (title,"                         "
      "The Ultimate DOOM Startup v%i.%02i                        ",
      VERSION/100,VERSION%100); break;
    case shareware:
      sprintf (title,"                         "
      "DOOM Shareware Startup v%i.%02i                           ",
      VERSION/100,VERSION%100); break;
    case registered:
      sprintf (title,"                       "
      "DOOM Registered Startup v%i.%02i                            ",
      VERSION/100,VERSION%100); break;
    case commercial:
      switch (gamemission) {
        case pack_plut:
          sprintf (title,"                   "
          "DOOM 2: Plutonia Experiment v%i.%02i                            ",
          VERSION/100,VERSION%100); break;
        case pack_tnt:
          sprintf (title,"                     "
          "DOOM 2: TNT - Evilution v%i.%02i                              ",
          VERSION/100,VERSION%100); break;
        default:
          sprintf (title,"                         "
          "DOOM 2: Hell on Earth v%i.%02i                            ",
          VERSION/100,VERSION%100); break;
        }
    }
  clrscr();
  textattr(0x78);
  cprintf("%s", title);
  printf("\nMerci beaucoup a mon SEIGNEUR et SAUVEUR Jesus Christ\n");
  if (devparm) printf(D_DEVSTR);
  if (M_CheckParm("-cdrom"))
    {
      printf(D_CDROM); mkdir("c:/doomdata",0);
      sprintf(basedefault, "c:/doomdata/%s.cfg", D_DoomExeName());
    }
  if ((p=M_CheckParm ("-turbo")))
    {
      int scale = 200;
      extern int forwardmove[2];
      extern int sidemove[2];
      if (p<myargc-1) scale = atoi(myargv[p+1]);
      if (scale < 10) scale = 10;
      if (scale > 400) scale = 400;
      printf ("turbo scale: %i%%\n",scale);
      forwardmove[0] = forwardmove[0]*scale/100;
      forwardmove[1] = forwardmove[1]*scale/100;
      sidemove[0] = sidemove[0]*scale/100;
      sidemove[1] = sidemove[1]*scale/100;
    }
  if ((p = M_CheckParm ("-file")))
    {
      boolean file = modifiedgame = true;
      while (++p < myargc) if (*myargv[p] == '-')
      file = !strcasecmp(myargv[p],"-file");
      else if (file) D_AddFile(myargv[p]);
    }

  if (!(p = M_CheckParm("-playdemo")) || p >= myargc-1)
    if ((p = M_CheckParm ("-fastdemo")) && p < myargc-1)
    fastdemo = true; else p = M_CheckParm ("-timedemo");
  if (p && p < myargc-1)
    {
      strcpy(file,myargv[p+1]);
      AddDefaultExtension(file,".lmp");
      D_AddFile(file);
      printf("Playing demo %s\n",file);
    }
  startskill = 3;
  startepisode = 1;
  startmap = 1;
  autostart = false;
  if ((p = M_CheckParm ("-skill")) && p < myargc-1)
    {
      startskill = myargv[p+1][0]-'1';
      autostart = true;
    }
  if ((p = M_CheckParm ("-episode")) && p < myargc-1)
    {
      startepisode = myargv[p+1][0]-'0';
      startmap = 1;
      autostart = true;
    }
  if ((p = M_CheckParm ("-timer")) && p < myargc-1 && deathmatch)
    {
      int time = atoi(myargv[p+1]);
      printf("Niveaux terminerei %d minute%s.\n", time, time>1 ? "s" : "");
    }
  if ((p = M_CheckParm ("-warp")) && p < myargc-1)
    if (gamemode == commercial)
      {
        startmap = atoi(myargv[p+1]);
        autostart = true;
      }
    else
    if (p < myargc-2)
      {
        startepisode = atoi(myargv[++p]);
        startmap = atoi(myargv[p+1]);
        autostart = true;
      }
  {
    int nosound = M_CheckParm("-nosound");
    nomusicparm = nosound || M_CheckParm("-nomusic");
    nosfxparm   = nosound || M_CheckParm("-nosfx");
  }
  nodrawers = M_CheckParm ("-nodraw");
  noblit = M_CheckParm ("-noblit");

  printf("M_LoadDefaults: charge config de systeme\n");
  M_LoadDefaults();
  G_ReloadDefaults();
  printf("V_Init: commence toile\n");
  V_Init();
  D_ProcessPreincludes(".wad");
  D_AddFile(NULL);
  printf("W_Init: Init WADs\n");
  W_InitMultipleFiles(wadfiles);
  printf("\n");
  D_ProcessDehInWads();
  D_ProcessPreincludes(".deh");
  if (modifiedgame&&gamemode==shareware)
      I_Error("\nvous ne pouvez -file avec le shareware version. Register!");
  V_InitColorTranslation();
  printf("M_Init: commence info\n");
  M_Init();
  printf("R_Init: commence DOOM refresh daemon - ");
  R_Init();
  printf("\nP_Init: commence Playloop etat\n");
  P_Init();
  printf("I_Init: commence machine etat\n");
  I_Init();
  printf("D_CheckNetGame: commence network game status\n");
  D_CheckNetGame();
  printf("S_Init: commence son\n");
  S_Init(snd_SfxVolume, snd_MusicVolume);
  printf("HU_Init: commence heads up toile\n");
  HU_Init();
  printf("ST_Init: commence status barre");
  ST_Init();
  idmusnum = -1;
      slot = M_CheckParm("-loadgame");
      if ((p = M_CheckParm("-record")) && ++p < myargc)
	{
	  autostart = true;
	  G_RecordDemo(myargv[p]);
	}
  if ((p = M_CheckParm ("-fastdemo")) && ++p < myargc)
    {
      fastdemo = true;
      timingdemo = true;
      G_DeferedPlayDemo(myargv[p]);
      singledemo = true;
    }
  else
    if ((p = M_CheckParm("-timedemo")) && ++p < myargc)
      {
	singletics = true;
        timingdemo = true;
	G_DeferedPlayDemo(myargv[p]);
        singledemo = true;
      }
    else
      if ((p = M_CheckParm("-playdemo")) && ++p < myargc)
	{
	  G_DeferedPlayDemo(myargv[p]);
          singledemo = true;
	}
  if (slot && ++slot < myargc)
    {
      slot = atoi(myargv[slot]);
      G_SaveGameName(file, slot);
      G_LoadGame(file, slot, true);
    }
  else
    if (!singledemo)
      if (autostart || netgame)
	{
	  G_InitNew(startskill, startepisode, startmap);
	  if (demorecording)
	    G_BeginRecording();
	}
      else
        D_StartTitle();
  I_InitGraphics();
  atexit(D_QuitNetGame);
  for (;;)
    {
      I_StartFrame ();
      if (singletics)
        {
          I_StartTic ();
          D_ProcessEvents ();
          G_BuildTiccmd (&netcmds[consoleplayer][maketic%BACKUPTICS]);
          if (advancedemo)
            D_DoAdvanceDemo ();
          M_Ticker ();
          G_Ticker ();
          gametic++;
          maketic++;
        }
      else
        TryRunTics ();
      S_UpdateSounds(players[displayplayer].mo);
      D_Display();
    }
}
int main(int argc, char **argv) { myargc = argc; myargv = argv; Z_Init(); atexit(I_Quit); D_DoomMain(); }