#ifndef __D_PLAYER__
#define __D_PLAYER__

#include "doomdef.h"
#include "p_mobj.h"
#include "d_ticcmd.h"
#include "m_fixed.h"
#include "tables.h"
#include "info.h"
typedef struct {
 ammotype_t  ammo;
 int upstate;
 int downstate;
 int readystate;
 int atkstate;
 int flashstate;
} weaponinfo_t;
extern  weaponinfo_t weaponinfo[NUMWEAPONS];

#define FF_FULLBRIGHT   0x8000
#define FF_FRAMEMASK    0x7fff
typedef enum
{ ps_weapon, ps_flash, NUMPSPRITES
} psprnum_t;
typedef struct
{ state_t *state; int tics; fixed_t sx; fixed_t sy;
} pspdef_t;
extern int weapon_preferences[2][NUMWEAPONS+1];

typedef enum { PST_LIVE, PST_DEAD, PST_REBORN } playerstate_t;

typedef enum
{
CF_NOCLIP   = 1,
CF_GODMODE  = 2,
CF_INFINITE = 4,
CF_JET      = 8
} cheat_t;

typedef struct player_s
{
  mobj_t*             mo;
  playerstate_t       playerstate;
  ticcmd_t            cmd;

  fixed_t             viewz;
  fixed_t             viewheight;
  fixed_t             deltaviewheight;
  fixed_t             bob;    
  fixed_t            momx, momy;

  int                 health; 
  int                 armorpoints;
  int                 armortype;      
  int                 powers[NUMPOWERS];
  boolean             cards[NUMCARDS];
  boolean             backpack;
  int                 frags[MAXPLAYERS];
  weapontype_t        readyweapon;
  weapontype_t        pendingweapon;
  boolean             weaponowned[NUMWEAPONS];
  int                 ammo[NUMAMMO];
  int                 maxammo[NUMAMMO];
  int                 attackdown;
  int                 usedown;
  int                 cheats;         
  int                 refire;         
  int                 killcount;
  int                 itemcount;
  int                 secretcount;
  char*               message;        
  int                 damagecount;
  int                 bonuscount;
  mobj_t*             attacker;
  int                 extralight;
  int                 fixedcolormap;
  int                 colormap;       
  pspdef_t            psprites[NUMPSPRITES];
  boolean             didsecret;      
  int                 jumpdelay;
} player_t;

typedef struct
{
  boolean     in;
  int         skills;
  int         sitems;
  int         ssecret;
  int         stime; 
  int         frags[4];
  int         score;  
} wbplayerstruct_t;

typedef struct
{
  int         epsd;
  boolean     didsecret;
  int   last;
  int   next;   
  int   maxkills;
  int   maxitems;
  int   maxsecret;
  int   maxfrags;
  int   partime;
  int   pnum;   
  wbplayerstruct_t    plyr[MAXPLAYERS];
} wbstartstruct_t;

#endif