/*
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation. NO WARRANTY.
*/

#include <time.h>
#include <stdarg.h>
#include <stddef.h>
#include "doomstat.h"
#include "doomtype.h"
#include "d_event.h"
#include "m_argv.h"
#include "m_misc.h"
#include "m_menu.h"
#include "m_random.h"
#include "p_setup.h"
#include "p_tick.h"
#include "wi_stuff.h"
#include "st_stuff.h"
#include "w_wad.h"
#include "r_main.h"
#include "r_draw.h"
#include "p_map.h"
#include "d_englsh.h"
#include "sounds.h"
#include "r_data.h"
#include "d_deh.h"
#include "p_inter.h"
#include "g_game.h"

#define SAVEGAMESIZE  0x20000
#define SAVESTRINGSIZE  24

size_t savegamesize = SAVEGAMESIZE;
char demoname[PATH_MAX];
boolean  netdemo;
byte  *demobuffer;
size_t   maxdemosize;
byte     *demo_p;
short    consistancy[MAXPLAYERS][BACKUPTICS];

gameaction_t    gameaction;
gamestate_t     gamestate;
skill_t         gameskill;
boolean         respawnmonsters;
int             gameepisode;
int             gamemap;
boolean         paused;
boolean         sendpause;
boolean         sendsave;
boolean         usergame;
boolean         timingdemo;
boolean         fastdemo;
boolean         nodrawers;
boolean         noblit;
int             starttime;
boolean         viewactive;
boolean         deathmatch;
boolean         netgame;
boolean         playeringame[MAXPLAYERS];
player_t        players[MAXPLAYERS];
int             consoleplayer;
int             displayplayer;
int             gametic;
int             levelstarttic;
int             basetic;
int             totalkills, totalitems, totalsecret;
boolean         demorecording;
boolean         demoplayback;
boolean         singledemo;
wbstartstruct_t wminfo;
byte            *savebuffer;
int             autorun = false;

int     key_jump;
int     key_right;
int     key_left;
int     key_up;
int     key_down;
int     key_strafeleft;
int     key_straferight;
int     key_fire;
int     key_use;
int     key_strafe;
int     key_speed;
int     key_autorun;
int     key_reverse;
int     key_map;
int     destination_keys[MAXPLAYERS];

int     mousebfire;
int     mousebstrafe;
int     mousebforward;
int     joybfire;
int     joybstrafe;
int     joybuse;
int     joybspeed;

#define MAXPLMOVE   (forwardmove[1])
#define TURBOTHRESHOLD  0x32
#define SLOWTURNTICS  6
#define QUICKREVERSE 32768
#define NUMKEYS   256

int forwardmove[2] = {0x19, 0x32};
int sidemove[2]    = {0x18, 0x28};
int angleturn[3]   = {640, 1280, 320};

boolean gamekeydown[NUMKEYS];
int     turnheld;

boolean mousearray[4];
boolean *mousebuttons = &mousearray[1];

int   mousex,mousey;

int   joyxmove,joyymove;
boolean joyarray[5];
boolean *joybuttons = &joyarray[1];

int   savegameslot;
char  savedescription[32];

extern skill_t startskill;
int    bodyqueslot, bodyquesize;
void   *statcopy;

void G_BuildTiccmd(ticcmd_t* cmd)
{
  boolean strafe;
  int speed;
  int tspeed;
  int forward;
  int side;
  int newweapon;
  ticcmd_t *base;

  base = I_BaseTiccmd();
  memcpy(cmd, base, sizeof *cmd);

  cmd->consistancy = consistancy[consoleplayer][maketic%BACKUPTICS];

  strafe = gamekeydown[key_strafe] || mousebuttons[mousebstrafe]
    || joybuttons[joybstrafe];
  speed = autorun || gamekeydown[key_speed] || joybuttons[joybspeed];

  forward = side = 0;

  if (joyxmove < 0 || joyxmove > 0 ||
      gamekeydown[key_right] || gamekeydown[key_left])
    turnheld += 1;
  else
    turnheld = 0;

  if (turnheld < SLOWTURNTICS)
    tspeed = 2;
  else
    tspeed = speed;

  if (gamekeydown[key_reverse])
    {
      cmd->angleturn += QUICKREVERSE;
      gamekeydown[key_reverse] = false;
    }

  if (strafe)
    {
      if (gamekeydown[key_right])
        side += sidemove[speed];
      if (gamekeydown[key_left])
        side -= sidemove[speed];
      if (joyxmove > 0)
        side += sidemove[speed];
      if (joyxmove < 0)
        side -= sidemove[speed];
    }
  else
    {
      if (gamekeydown[key_right])
        cmd->angleturn -= angleturn[tspeed];
      if (gamekeydown[key_left])
        cmd->angleturn += angleturn[tspeed];
      if (joyxmove > 0)
        cmd->angleturn -= angleturn[tspeed];
      if (joyxmove < 0)
        cmd->angleturn += angleturn[tspeed];
    }

  if (gamekeydown[key_up])
    forward += forwardmove[speed];
  if (gamekeydown[key_down])
    forward -= forwardmove[speed];
  if (joyymove < 0)
    forward += forwardmove[speed];
  if (joyymove > 0)
    forward -= forwardmove[speed];
  if (gamekeydown[key_straferight])
    side += sidemove[speed];
  if (gamekeydown[key_strafeleft])
    side -= sidemove[speed];

  if (gamekeydown[key_fire] || mousebuttons[mousebfire] ||
      joybuttons[joybfire])
    cmd->buttons |= BT_ATTACK;

  if (gamekeydown[key_use] || joybuttons[joybuse])
    {
      cmd->buttons |= BT_USE;
    }
    if (gamekeydown[key_jump])
      cmd->buttons2 |= BT2_JUMP;

  if (!demo_compatibility && players[consoleplayer].attackdown &&
       !P_CheckAmmo(&players[consoleplayer]))
    newweapon = P_SwitchWeapon(&players[consoleplayer]);
  else
    { 
      newweapon =
        gamekeydown['1'] ? wp_fist :
        gamekeydown['2'] ? wp_pistol :
        gamekeydown['3'] ? wp_shotgun :
        gamekeydown['4'] ? wp_chaingun :
        gamekeydown['5'] ? wp_missile :
        gamekeydown['6'] && gamemode != shareware ? wp_plasma :
        gamekeydown['7'] && gamemode != shareware ? wp_bfg :
        gamekeydown['8'] ? wp_chainsaw :
        gamekeydown['9'] && gamemode == commercial ? wp_supershotgun :
        wp_nochange;

        {
          const player_t *player = &players[consoleplayer];

          if (newweapon==wp_fist && player->weaponowned[wp_chainsaw] &&
              player->readyweapon!=wp_chainsaw &&
              (player->readyweapon==wp_fist ||
               !player->powers[pw_strength] ||
               P_WeaponPreferred(wp_chainsaw, wp_fist)))
            newweapon = wp_chainsaw;

          if (newweapon == wp_shotgun && gamemode == commercial &&
              player->weaponowned[wp_supershotgun] &&
              (!player->weaponowned[wp_shotgun] ||
               player->readyweapon == wp_shotgun ||
               (player->readyweapon != wp_supershotgun &&
                P_WeaponPreferred(wp_supershotgun, wp_shotgun))))
            newweapon = wp_supershotgun;
        }
    }

  if (newweapon != wp_nochange)
    {
      cmd->buttons |= BT_CHANGE;
      cmd->buttons |= newweapon<<BT_WEAPONSHIFT;
    }

  if (mousebuttons[mousebforward])
    forward += forwardmove[speed];

  if (mousebuttons[mousebforward])
    cmd->buttons |= BT_USE;

  if (mousebuttons[mousebstrafe] || joybuttons[joybstrafe])
    cmd->buttons |= BT_USE;

  forward += mousey;
  if (strafe)
    side += mousex*2;
  else
    cmd->angleturn -= mousex*0x8;

  mousex = mousey = 0;

  if (forward > MAXPLMOVE)
    forward = MAXPLMOVE;
  else if (forward < -MAXPLMOVE)
    forward = -MAXPLMOVE;
  if (side > MAXPLMOVE)
    side = MAXPLMOVE;
  else if (side < -MAXPLMOVE)
    side = -MAXPLMOVE;
  
  cmd->forwardmove += forward;
  cmd->sidemove += side;

  if (sendpause)
    {
      sendpause = false;
      cmd->buttons = BT_SPECIAL | BTS_PAUSE;
    }

  if (sendsave && !demoplayback)
    {
      sendsave = false;
      cmd->buttons = BT_SPECIAL | BTS_SAVEGAME | (savegameslot<<BTS_SAVESHIFT);
    }
}

extern gamestate_t wipegamestate;
extern int skytexture;

void G_DoLoadLevel(void)
{
  int i;

  skyflatnum = R_FlatNumForName ("F_SKY1");
  if (gamemode == commercial)
    {
      skytexture = R_TextureNumForName ("SKY3");
      if (gamemap < 12)
        skytexture = R_TextureNumForName ("SKY1");
      else
        if (gamemap < 21)
          skytexture = R_TextureNumForName ("SKY2");
    }
  else
    switch (gameepisode)
      {
      case 1:
        skytexture = R_TextureNumForName ("SKY1");
        break;
      case 2:
        skytexture = R_TextureNumForName ("SKY2");
        break;
      case 3:
        skytexture = R_TextureNumForName ("SKY3");
        break;
      case 4:
        skytexture = R_TextureNumForName ("SKY4");
        break;
      }

  levelstarttic = gametic;

  if (!demo_compatibility && demo_version < 203)
    basetic = gametic;

  if (wipegamestate == GS_LEVEL)
    wipegamestate = -1;

  gamestate = GS_LEVEL;

  for (i=0 ; i<MAXPLAYERS ; i++)
    {
      if (playeringame[i] && players[i].playerstate == PST_DEAD)
        players[i].playerstate = PST_REBORN;
      memset (players[i].frags,0,sizeof(players[i].frags));
    }

   {
    extern msecnode_t *headsecnode;
    headsecnode = NULL;
   }

  P_SetupLevel (gameepisode, gamemap, 0, gameskill);
  displayplayer = consoleplayer;
  gameaction = ga_nothing;
  Z_CheckHeap();

  memset (gamekeydown, 0, sizeof(gamekeydown));
  joyxmove = joyymove = 0;
  mousex = mousey = 0;
  sendpause = sendsave = paused = false;
  memset (mousebuttons, 0, sizeof(mousebuttons));
  memset (joybuttons, 0, sizeof(joybuttons));

  ST_Start();
  HU_Start();

  if (timingdemo)
    {
      static int first=1;
      if (first)
        {
          starttime = I_GetTime_RealTime();
          first=0;
        }
    }
}

boolean G_Responder(event_t* ev)
{
  if (ev->data1 == KEYD_F12 && netgame && (demoplayback || !deathmatch) &&
      gamestate == GS_LEVEL)
    {
      if (ev->type == ev_keyup)
        gamekeydown[KEYD_F12] = false;
      if (ev->type == ev_keydown && !gamekeydown[KEYD_F12])
	{
          gamekeydown[KEYD_F12] = true;
          do
	    if (++displayplayer >= MAXPLAYERS)
	      displayplayer = 0;
	  while (!playeringame[displayplayer] && displayplayer!=consoleplayer);

          ST_Start();
	  HU_Start();
	  S_UpdateSounds(players[displayplayer].mo);
	}
      return true;
    }

  if (gamestate == GS_LEVEL && (HU_Responder(ev) ||
                                ST_Responder(ev) ||
                                AM_Responder(ev)))
    return true;

  if (gameaction == ga_nothing && (demoplayback || gamestate == GS_DEMOSCREEN))
    {
      if (ev->type == ev_keydown && ev->data1 == KEYD_PAUSE)
	{
	  if (paused ^= 2)
	    S_PauseSound();
	  else
	    S_ResumeSound();
	  return true;
	}

      return gamestate == GS_DEMOSCREEN &&
	!(paused & 2) && !automapactive &&
	((ev->type == ev_keydown) ||
	 (ev->type == ev_mouse && ev->data1) ||
	 (ev->type == ev_joystick && ev->data1)) ?
	M_StartControlPanel(), true : false;
    }

  if (gamestate == GS_FINALE && F_Responder(ev))
    return true;

  switch (ev->type)
    {
    case ev_keydown:
      if (ev->data1 == KEYD_PAUSE)
	sendpause = true;
      else
	if (ev->data1 <NUMKEYS)
	  gamekeydown[ev->data1] = true;
      return true;

    case ev_keyup:
      if (ev->data1 <NUMKEYS)
        gamekeydown[ev->data1] = false;
      return false;

    case ev_mouse:
      mousebuttons[0] = ev->data1 & 1;
      mousebuttons[1] = ev->data1 & 2;
      mousebuttons[2] = ev->data1 & 4;
      mousex = ev->data2*mouseSensitivity_horiz;
      mousey = ev->data3*mouseSensitivity_vert;
      return true;

    case ev_joystick:
      joybuttons[0] = ev->data1 & 1;
      joybuttons[1] = ev->data1 & 2;
      joybuttons[2] = ev->data1 & 4;
      joybuttons[3] = ev->data1 & 8;
      joyxmove = ev->data2;
      joyymove = ev->data3;
      return true;

    default:
      break;
    }
  return false;
}

#define DEMOMARKER    0x80

void G_ReadDemoTiccmd(ticcmd_t *cmd)
{
  if (*demo_p == DEMOMARKER)
    G_CheckDemoStatus();
  else
    {
      cmd->forwardmove = ((signed char)*demo_p++);
      cmd->sidemove = ((signed char)*demo_p++);
      cmd->angleturn = ((unsigned char)*demo_p++)<<8;
      cmd->buttons = (unsigned char)*demo_p++;
      if (demo_version > 203)
        cmd->buttons2 = (unsigned char)*demo_p++;

      if (demoplayback && 
	  cmd->buttons & BT_SPECIAL &&
	  cmd->buttons & BTS_SAVEGAME)
	{
	  cmd->buttons &= ~BTS_SAVEGAME;
	}
    }
}

void G_WriteDemoTiccmd(ticcmd_t* cmd)
{
  ptrdiff_t position = demo_p - demobuffer;

  demo_p[0] = cmd->forwardmove;
  demo_p[1] = cmd->sidemove;
  demo_p[2] = (cmd->angleturn+128)>>8;
  demo_p[3] = cmd->buttons;
  demo_p[4] = cmd->buttons2;

  if (position+16 > maxdemosize)
    {
      maxdemosize += 128*1024;
      demobuffer = realloc(demobuffer,maxdemosize);
      demo_p = position + demobuffer;
    }

  G_ReadDemoTiccmd (cmd);
}

boolean secretexit;

void G_ExitLevel(void)
{
  secretexit = false;
  gameaction = ga_completed;
}

void G_SecretExitLevel(void)
{
  secretexit = true;
  gameaction = ga_completed;
}

void G_PlayerFinishLevel(int player)
{
  player_t *p = &players[player];
  memset(p->powers, 0, sizeof p->powers);
  memset(p->cards, 0, sizeof p->cards);
  p->mo->flags &= ~MF_SHADOW;
  p->extralight = 0;
  p->fixedcolormap = 0;
  p->damagecount = 0;
  p->bonuscount = 0;
}

void G_DoCompleted(void)
{
  int i;

  gameaction = ga_nothing;

  for (i=0; i<MAXPLAYERS; i++)
    if (playeringame[i])
      G_PlayerFinishLevel(i);

  if (automapactive)
    AM_Stop();

  if (gamemode != commercial)
    switch(gamemap)
      {
      case 8:
        gameaction = ga_victory;
        return;
      case 9:
        for (i=0 ; i<MAXPLAYERS ; i++)
          players[i].didsecret = true;
        break;
      }

  wminfo.didsecret = players[consoleplayer].didsecret;
  wminfo.epsd = gameepisode -1;
  wminfo.last = gamemap -1;

  if (gamemode == commercial)
    {
      if (secretexit)
        switch(gamemap)
          {
          case 15:
            wminfo.next = 30; break;
          case 31:
            wminfo.next = 31; break;
          }
      else
        switch(gamemap)
          {
          case 31:
          case 32:
            wminfo.next = 15; break;
          default:
            wminfo.next = gamemap;
          }
    }
  else
    {
      if (secretexit)
        wminfo.next = 8;
      else
        if (gamemap == 9)
          {
            switch (gameepisode)
              {
              case 1:
                wminfo.next = 3;
                break;
              case 2:
                wminfo.next = 5;
                break;
              case 3:
                wminfo.next = 6;
                break;
              case 4:
                wminfo.next = 2;
                break;
              }
          }
        else
          wminfo.next = gamemap;
    }

  wminfo.maxkills = totalkills;
  wminfo.maxitems = totalitems;
  wminfo.maxsecret = totalsecret;
  wminfo.maxfrags = 0;

  if ( gamemode == commercial )
    wminfo.partime = TICRATE*cpars[gamemap-1];
  else
    wminfo.partime = TICRATE*pars[gameepisode][gamemap];

  wminfo.pnum = consoleplayer;

  for (i=0 ; i<MAXPLAYERS ; i++)
    {
      wminfo.plyr[i].in = playeringame[i];
      wminfo.plyr[i].skills = players[i].killcount;
      wminfo.plyr[i].sitems = players[i].itemcount;
      wminfo.plyr[i].ssecret = players[i].secretcount;
      wminfo.plyr[i].stime = leveltime;
      memcpy (wminfo.plyr[i].frags, players[i].frags,
              sizeof(wminfo.plyr[i].frags));
    }

  gamestate = GS_INTERMISSION;
  viewactive = false;
  automapactive = false;

  WI_Start (&wminfo);
}

void G_DoWorldDone(void)
{
  idmusnum = -1;
  gamestate = GS_LEVEL;
  gamemap = wminfo.next+1;
  G_DoLoadLevel();
  gameaction = ga_nothing;
  viewactive = true;
  AM_clearMarks();
}

#define MIN_MAXPLAYERS 32

char *defdemoname;

void G_DoPlayDemo(void)
{
  skill_t skill;
  int i, episode, map;
  char basename[9];
  int demover;
  byte *option_p = NULL;

  if (gameaction != ga_loadgame)
    basetic = gametic;

  ExtractFileBase(defdemoname,basename);

  demobuffer = demo_p = W_CacheLumpName (basename, PU_STATIC);

  demo_version =
  demover = *demo_p++;

  if (demover < 200)
    {
      compatibility = true;
      memset(comp, 0xff, sizeof comp);

      variable_friction = 0;
      allow_pushers = 0;
      monster_infighting = 1;
      monster_backing = 0;
      monster_avoid_hazards = 0;
      monster_friction = 0;
      monkeys = 0;

      if ((skill=demover) >= 100)
        {
          skill = *demo_p++;
          episode = *demo_p++;
          map = *demo_p++;
          deathmatch = *demo_p++;
          respawnparm = *demo_p++;
          fastparm = *demo_p++;
          nomonsters = *demo_p++;
          consoleplayer = *demo_p++;
        }
      else
        {
          episode = *demo_p++;
          map = *demo_p++;
          deathmatch = respawnparm = fastparm =
            nomonsters = consoleplayer = 0;
        }
    }
  else
    {
      demo_p += 6;
      compatibility = *demo_p++;
      skill = *demo_p++;
      episode = *demo_p++;
      map = *demo_p++;
      deathmatch = *demo_p++;
      consoleplayer = *demo_p++;

      if (demover >= 203)
	option_p = demo_p;

      demo_p = G_ReadOptions(demo_p);

      if (demover == 200)
        demo_p += 256-GAME_OPTION_SIZE;
    }

  if (demo_compatibility)
    {
      for (i=0; i<4; i++)
        playeringame[i] = *demo_p++;
      for (;i < MAXPLAYERS; i++)
        playeringame[i] = 0;
    }
  else
    {
      for (i=0 ; i < MAXPLAYERS; i++)
        playeringame[i] = *demo_p++;
      demo_p += MIN_MAXPLAYERS - MAXPLAYERS;
    }

  if (playeringame[1])
    netgame = netdemo = true;

  if (gameaction != ga_loadgame)
    {
      G_InitNew(skill, episode, map);
      if (option_p)
	G_ReadOptions(option_p);
    }
  usergame = false;
  demoplayback = true;
  gameaction = ga_nothing;
}

#define VERSIONSIZE   16
#define VERSIONID "CDoom %d"
char savename[PATH_MAX+1];

boolean command_loadgame = false;

void G_LoadGame(char *name, int slot, boolean command)
{
  strcpy(savename, name);
  savegameslot = slot;
  gameaction = ga_loadgame;
  command_loadgame = command;
}

void G_SaveGame(int slot, char *description)
{
  savegameslot = slot;
  strcpy(savedescription, description);
  sendsave = true;
}
byte *save_p;
void CheckSaveGame(size_t size)
{
  size_t pos = save_p - savebuffer;
  size += 1024;
  if (pos+size > savegamesize)
    save_p = (savebuffer = realloc(savebuffer,
           savegamesize += (size+1023) & ~1023)) + pos;
}

void G_SaveGameName(char *name, int slot)
{
  if (M_CheckParm("-cdrom"))
    sprintf(name, "c:/doomdata/%.4ssav%d.dsg", D_DoomExeName(), slot);
  else
    sprintf(name, "./%.4ssav%d.dsg", D_DoomExeName(), slot);
}

unsigned long G_Signature(void)
{
  unsigned long s = 0;
  int lump, i;
  char name[9];
  
  if (gamemode == commercial)
    sprintf(name, "map%02d", gamemap);
  else
    sprintf(name, "E%dM%d", gameepisode, gamemap);

  lump = W_CheckNumForName(name);

  if (lump != -1 && (i = lump+10) < numlumps)
    do
      s = s*2+W_LumpLength(i);
    while (--i > lump);

  return s;
}
char **wadfiles;
void G_DoSaveGame(void)
{
  char name[PATH_MAX+1];
  char name2[VERSIONSIZE];
  char *description;
  int  length, i;

  G_SaveGameName(name,savegameslot);

  description = savedescription;

  save_p = savebuffer = malloc(savegamesize);

  CheckSaveGame(SAVESTRINGSIZE+VERSIONSIZE+sizeof(unsigned long));
  memcpy (save_p, description, SAVESTRINGSIZE);
  save_p += SAVESTRINGSIZE;
  memset (name2,0,sizeof(name2));
  sprintf (name2,VERSIONID,VERSION);
  memcpy (save_p, name2, VERSIONSIZE);
  save_p += VERSIONSIZE;
  *save_p++ = compatibility;
  *save_p++ = gameskill;
  *save_p++ = gameepisode;
  *save_p++ = gamemap;

  {
    unsigned long checksum = G_Signature();
    memcpy(save_p, &checksum, sizeof checksum);
    save_p += sizeof checksum;
  }

  {
    char **w = wadfiles;
    for (*save_p = 0; *w; w++)
      {
        CheckSaveGame(strlen(*w)+2);
        strcat(strcat(save_p, *w), "\n");
      }
    save_p += strlen(save_p)+1;
  }

  CheckSaveGame(GAME_OPTION_SIZE+MIN_MAXPLAYERS+10);

  for (i=0 ; i<MAXPLAYERS ; i++)
    *save_p++ = playeringame[i];

  for (;i<MIN_MAXPLAYERS;i++)
    *save_p++ = 0;

  *save_p++ = idmusnum;

  save_p = G_WriteOptions(save_p);

  memcpy(save_p, &leveltime, sizeof save_p);
  save_p += sizeof save_p;

  *save_p++ = (gametic-basetic) & 255;

  Z_CheckHeap();
  P_ArchivePlayers();
  Z_CheckHeap();
  P_ArchiveWorld();
  Z_CheckHeap();
  P_ArchiveThinkers();
  Z_CheckHeap();
  P_ArchiveSpecials();
  P_ArchiveRNG();
  Z_CheckHeap();
  P_ArchiveMap();

  *save_p++ = 0xe6;

  length = save_p - savebuffer;

  Z_CheckHeap();

  players[consoleplayer].message = !M_WriteFile(name, savebuffer, length)? 
  "Can't save game" :s_GGSAVED;

  free(savebuffer);
  savebuffer = save_p = NULL;

  gameaction = ga_nothing;
  savedescription[0] = 0;
}

void G_DoLoadGame(void)
{
  int  length, i;
  char vcheck[VERSIONSIZE];
  unsigned long checksum;

  gameaction = ga_nothing;
  length = M_ReadFile(savename, &savebuffer);
  save_p = savebuffer + SAVESTRINGSIZE;
  sprintf (vcheck,VERSIONID,VERSION);

  if (strncmp(save_p, vcheck, VERSIONSIZE))
      return;

  save_p += VERSIONSIZE;

  compatibility = *save_p++;
  demo_version = VERSION;

  gameskill = *save_p++;
  gameepisode = *save_p++;
  gamemap = *save_p++;

  checksum = G_Signature();

  save_p += sizeof checksum;
  while (*save_p++);

  for (i=0 ; i<MAXPLAYERS ; i++)
    playeringame[i] = *save_p++;
  save_p += MIN_MAXPLAYERS-MAXPLAYERS;

  idmusnum = *(signed char *) save_p++;
  G_ReadOptions(save_p);
  G_InitNew(gameskill, gameepisode, gamemap);

  save_p = G_ReadOptions(save_p);

  memcpy(&leveltime, save_p, sizeof save_p);
  save_p += sizeof save_p;
  basetic = gametic - (int) *save_p++;
  P_UnArchivePlayers();
  P_UnArchiveWorld();
  P_UnArchiveThinkers();
  P_UnArchiveSpecials();
  P_UnArchiveRNG();
  P_UnArchiveMap();

  if (*save_p != 0xe6)
    I_Error ("mauvais sauvejeux");

  Z_Free(savebuffer);
  if (setsizeneeded)
    R_ExecuteSetViewSize();
  R_FillBackScreen();
  Z_CheckHeap();
  if (!command_loadgame)
    singledemo = false;
  else
    if (singledemo)
      {
        gameaction = ga_loadgame;
        G_DoPlayDemo();
      }
    else
      if (demorecording)
        G_BeginRecording();
}

void G_Ticker(void)
{
  int i;
  for (i=0 ; i<MAXPLAYERS ; i++)
    if (playeringame[i] && players[i].playerstate == PST_REBORN)
      G_DoReborn (i);
  while (gameaction != ga_nothing)
    switch (gameaction)
      {
      case ga_loadlevel:
	G_DoLoadLevel();
	break;
      case ga_newgame:
	G_DoNewGame();
	break;
      case ga_loadgame:
	G_DoLoadGame();
	break;
      case ga_savegame:
	G_DoSaveGame();
	break;
      case ga_playdemo:
	G_DoPlayDemo();
	break;
      case ga_completed:
	G_DoCompleted();
	break;
      case ga_victory:
	F_StartFinale();
	break;
      case ga_worlddone:
	G_DoWorldDone();
	break;
      case ga_screenshot:
	M_ScreenShot();
	gameaction = ga_nothing;
	break;
      default:
	gameaction = ga_nothing;
	break;
    }

  if (demoplayback && sendsave)
    {
      sendsave = false;
      G_DoSaveGame();
    }
  if (paused & 2 || (!demoplayback && menuactive && !netgame))
    basetic++;
  else
    {
      int buf = (gametic)%BACKUPTICS;

      for (i=0 ; i<MAXPLAYERS ; i++)
	{
	  if (playeringame[i])
	    {
	      ticcmd_t *cmd = &players[i].cmd;

	      memcpy(cmd, &netcmds[i][buf], sizeof *cmd);

	      if (demoplayback)
		G_ReadDemoTiccmd(cmd);

	      if (demorecording)
		G_WriteDemoTiccmd(cmd);

              if (cmd->forwardmove > TURBOTHRESHOLD &&
		  !(gametic&31) && ((gametic>>5)&3) == i )
		{
		  extern char *player_names[];
                  dprintf("%s est turbo!",player_names[i]);
		}

	      if (netgame && !netdemo && !(gametic%1) )
		{
		  if (gametic > BACKUPTICS
		      && consistancy[i][buf] != cmd->consistancy)
		    I_Error ("consistense fail (%i should be %i)",
			     cmd->consistancy, consistancy[i][buf]);
		  if (players[i].mo)
		    consistancy[i][buf] = players[i].mo->x;
		  else
                    consistancy[i][buf] = 0;
		}
	    }
	}

      for (i=0; i<MAXPLAYERS; i++)
	if (playeringame[i] && players[i].cmd.buttons & BT_SPECIAL)
	  {
	    if (players[i].cmd.buttons & BTS_PAUSE)
	      if ((paused ^= 1))
		S_PauseSound();
	      else
		S_ResumeSound();
	
	    if (players[i].cmd.buttons & BTS_SAVEGAME)
	      {
		if (!savedescription[0])
		  strcpy(savedescription, "NET GAME");
		savegameslot =
		  (players[i].cmd.buttons & BTS_SAVEMASK)>>BTS_SAVESHIFT;
		gameaction = ga_savegame;
	      }
	  }
    }

  gamestate == GS_LEVEL ? P_Ticker(), ST_Ticker(), AM_Ticker(), HU_Ticker() :
    paused & 2 ? (void) 0 :
      gamestate == GS_INTERMISSION ? WI_Ticker() :
	gamestate == GS_FINALE ? F_Ticker() :
	  gamestate == GS_DEMOSCREEN ? D_PageTicker() : (void) 0;
}

void G_PlayerReborn(int player)
{
  player_t *p;
  int i;
  int frags[MAXPLAYERS];
  int killcount;
  int itemcount;
  int secretcount;

  memcpy (frags, players[player].frags, sizeof frags);
  killcount = players[player].killcount;
  itemcount = players[player].itemcount;
  secretcount = players[player].secretcount;

  p = &players[player];

  {
    int cheats = p->cheats;
    memset (p, 0, sizeof(*p));
    p->cheats = cheats;
  }

  memcpy(players[player].frags, frags, sizeof(players[player].frags));
  players[player].killcount = killcount;
  players[player].itemcount = itemcount;
  players[player].secretcount = secretcount;

  p->usedown = p->attackdown = true;
  p->playerstate = PST_LIVE;
  p->health = initial_health;
  p->readyweapon = p->pendingweapon = wp_pistol;
  p->weaponowned[wp_fist] = true;
  p->weaponowned[wp_pistol] = true;
  p->ammo[am_clip] = initial_bullets;
  for (i=0 ; i<NUMAMMO ; i++)
    p->maxammo[i] = maxammo[i];
}

void P_SpawnPlayer(mapthing_t *mthing);

boolean G_CheckSpot(int playernum, mapthing_t *mthing)
{
  int     x,y;
  subsector_t *ss;
  unsigned    an;
  mobj_t      *mo;
  int         i;

  if (!players[playernum].mo)
    {
      for (i=0 ; i<playernum ; i++)
        if (players[i].mo->x == mthing->x << FRACBITS
            && players[i].mo->y == mthing->y << FRACBITS)
          return false;
      return true;
    }

  x = mthing->x << FRACBITS;
  y = mthing->y << FRACBITS;

  players[playernum].mo->flags |=  MF_SOLID;
  i = P_CheckPosition(players[playernum].mo, x, y);
  players[playernum].mo->flags &= ~MF_SOLID;
  if (!i)
    return false;

  if (bodyquesize > 0)
    {
      mobj_t **bodyque;
      static size_t queuesize;
      if (queuesize < bodyquesize)
	{
	  bodyque = realloc(bodyque, bodyquesize*sizeof*bodyque);
	  memset(bodyque+queuesize, 0, 
		 (bodyquesize-queuesize)*sizeof*bodyque);
	  queuesize = bodyquesize;
	}
      if (bodyqueslot >= bodyquesize) 
	P_RemoveMobj(bodyque[bodyqueslot % bodyquesize]); 
      bodyque[bodyqueslot++ % bodyquesize] = players[playernum].mo; 
    }
  else
    if (!bodyquesize)
      P_RemoveMobj(players[playernum].mo);

  ss = R_PointInSubsector (x,y);
  an = ( ANG45 * (mthing->angle/45) ) >> ANGLETOFINESHIFT;

  mo = P_SpawnMobj(x+20*finecosine[an], y+20*finesine[an],
                   ss->sector->floorheight, MT_TFOG);

  if (players[consoleplayer].viewz != 1)
    S_StartSound(mo, sfx_telept);

  return true;
}

void G_DeathMatchSpawnPlayer(int playernum)
{
  int j, selections = deathmatch_p - deathmatchstarts;

  if (selections < MAXPLAYERS)
    I_Error("Seul %i deathmatch poins, %d besoin", selections, MAXPLAYERS);

  for (j=0 ; j<20 ; j++)
    {
      int i = P_Random(pr_dmspawn) % selections;
      if (G_CheckSpot(playernum, &deathmatchstarts[i]) )
        {
          deathmatchstarts[i].type = playernum+1;
          P_SpawnPlayer (&deathmatchstarts[i]);
          return;
        }
    }
  P_SpawnPlayer (&playerstarts[playernum]);
}

void G_DoReborn(int playernum)
{
  if (!netgame)
    gameaction = ga_loadlevel;
  else
    {
      int i;
      players[playernum].mo->player = NULL;
      if (deathmatch)
        {
          G_DeathMatchSpawnPlayer (playernum);
          return;
        }

      if (G_CheckSpot (playernum, &playerstarts[playernum]) )
        {
          P_SpawnPlayer (&playerstarts[playernum]);
          return;
        }
      for (i=0 ; i<MAXPLAYERS ; i++)
        {
          if (G_CheckSpot (playernum, &playerstarts[i]) )
            {
              playerstarts[i].type = playernum+1;
              P_SpawnPlayer (&playerstarts[i]);
              playerstarts[i].type = i+1;
              return;
            }
        }
      P_SpawnPlayer (&playerstarts[playernum]);
    }
}

void G_ScreenShot(void)
{
  gameaction = ga_screenshot;
}

int pars[4][10] = {
  {0},
  {0,30,75,120,90,165,180,180,30,165},
  {0,90,90,90,120,90,360,240,30,170},
  {0,90,45,90,150,90,90,165,30,135}
};

int cpars[32] = {
  30,90,120,120,90,150,120,120,270,90,
  210,150,150,150,210,150,420,150,210,150,
  240,150,180,150,150,300,330,420,300,180,
  120,30
};

void G_WorldDone(void)
{
  gameaction = ga_worlddone;

  if (secretexit)
    players[consoleplayer].didsecret = true;

  if (gamemode == commercial)
    {
      switch (gamemap)
        {
        case 15:
        case 31:
          if (!secretexit)
            break;
        case 6:
        case 11:
        case 20:
        case 30:
          F_StartFinale();
          break;
        }
    }
}

skill_t d_skill;
int     d_episode;
int     d_map;

void G_DeferedInitNew(skill_t skill, int episode, int map)
{
  d_skill = skill;
  d_episode = episode;
  d_map = map;
  gameaction = ga_newgame;
}
boolean clnomonsters,clrespawnparm,clfastparm;
void G_ReloadDefaults(void)
{
  variable_friction = allow_pushers = 1;
  monsters_remember = default_monsters_remember;
  monster_infighting = default_monster_infighting;
  monster_backing = default_monster_backing;
  monster_avoid_hazards = default_monster_avoid_hazards;
  monster_friction = default_monster_friction;
  monkeys = default_monkeys;
  respawnparm = clrespawnparm;
  fastparm = clfastparm;
  nomonsters = clnomonsters;
  demoplayback = 0;
  singledemo = 0;
  netdemo = 0;
  memset(playeringame+1, 0, sizeof(*playeringame)*(MAXPLAYERS-1));
  consoleplayer = 0;
  compatibility = false;
  memcpy(comp, default_comp, sizeof comp);
  demo_version = VERSION;
}

void G_DoNewGame (void)
{
  G_ReloadDefaults();
  netgame = false;
  deathmatch = false;
  basetic = gametic;
  G_InitNew(d_skill, d_episode, d_map);
  gameaction = ga_nothing;
}

void G_SetFastParms(int fast_pending)
{
  int fast = 0;
  int i;

  if (fast != fast_pending)
    if ((fast = fast_pending))
      {
        for (i=S_SARG_RUN1; i<=S_SARG_PAIN2; i++)
          if (states[i].tics != 1 || demo_compatibility)
            states[i].tics >>= 1;
        mobjinfo[MT_BRUISERSHOT].speed = 20*FRACUNIT;
        mobjinfo[MT_HEADSHOT].speed = 20*FRACUNIT;
        mobjinfo[MT_TROOPSHOT].speed = 20*FRACUNIT;
      }
    else
      {
        for (i=S_SARG_RUN1; i<=S_SARG_PAIN2; i++)
          states[i].tics <<= 1;
        mobjinfo[MT_BRUISERSHOT].speed = 15*FRACUNIT;
        mobjinfo[MT_HEADSHOT].speed = 10*FRACUNIT;
        mobjinfo[MT_TROOPSHOT].speed = 10*FRACUNIT;
      }
}

void G_InitNew(skill_t skill, int episode, int map)
{
  int i;

  if (paused)
    {
      paused = false;
      S_ResumeSound();
    }

  if (skill > sk_nightmare)
    skill = sk_nightmare;

  if (episode < 1)
    episode = 1;

  if (gamemode == retail)
    {
      if (episode > 4)
        episode = 4;
    }
  else
    if (gamemode == shareware)
      {
        if (episode > 1)
          episode = 1;
      }
    else
      if (episode > 3)
        episode = 3;

  if (map < 1)
    map = 1;
  if (map > 9 && gamemode != commercial)
    map = 9;

  G_SetFastParms(fastparm || skill == sk_nightmare);

  M_ClearRandom();

  respawnmonsters = skill == sk_nightmare || respawnparm;

  for (i=0 ; i<MAXPLAYERS ; i++)
    players[i].playerstate = PST_REBORN;

  usergame = true;
  paused = false;
  demoplayback = false;
  automapactive = false;
  viewactive = true;
  gameepisode = episode;
  gamemap = map;
  gameskill = skill;
  AM_clearMarks();
  G_DoLoadLevel();
}

void G_RecordDemo(char *name)
{
  int i;

  usergame = false;
  AddDefaultExtension(strcpy(demoname, name), ".lmp");
  i = M_CheckParm ("-maxdemo");
  if (i && i<myargc-1)
    maxdemosize = atoi(myargv[i+1])*1024;
  if (maxdemosize < 0x20000)
    maxdemosize = 0x20000;
  demobuffer = malloc(maxdemosize);
  demorecording = true;
}

byte *G_WriteOptions(byte *demo_p)
{
  byte *target = demo_p + GAME_OPTION_SIZE;

  *demo_p++ = monsters_remember;
  *demo_p++ = variable_friction;
  *demo_p++ = 0;
  *demo_p++ = allow_pushers;
  *demo_p++ = 0;
  *demo_p++ = 0;
  *demo_p++ = respawnparm;
  *demo_p++ = fastparm;
  *demo_p++ = nomonsters;
  *demo_p++ = 1;
  *demo_p++ = (rngseed >> 24) & 0xff;
  *demo_p++ = (rngseed >> 16) & 0xff;
  *demo_p++ = (rngseed >>  8) & 0xff;
  *demo_p++ =  rngseed        & 0xff;
  *demo_p++ = monster_infighting;
  *demo_p++ = 0;
  *demo_p++ = 0;
  *demo_p++ = 0;
  *demo_p++ = 0;
  *demo_p++ = 0;
  *demo_p++ = monster_backing;
  *demo_p++ = monster_avoid_hazards;
  *demo_p++ = monster_friction;
  *demo_p++ = 0;
  *demo_p++ = 0;
  *demo_p++ = monkeys;

  {
    int i;
    for (i=0; i < COMP_TOTAL; i++)
      *demo_p++ = comp[i] != 0;
  }
  *demo_p++ = use_true3d;
  while (demo_p < target)
    *demo_p++ = 0;

  if (demo_p != target)
    I_Error("G_WriteOptions: GAME_OPTION_SIZE plus petit");

  return target;
}

byte *G_ReadOptions(byte *demo_p)
{
  byte *target = demo_p + GAME_OPTION_SIZE;
  monsters_remember = *demo_p++;
  variable_friction = *demo_p;
  demo_p += 2;
  allow_pushers = *demo_p;
  demo_p += 3;
  respawnparm = *demo_p++;
  fastparm = *demo_p++;
  nomonsters = *demo_p++;
  demo_p++;
  rngseed  = *demo_p++ & 0xff;
  rngseed <<= 8;
  rngseed += *demo_p++ & 0xff;
  rngseed <<= 8;
  rngseed += *demo_p++ & 0xff;
  rngseed <<= 8;
  rngseed += *demo_p++ & 0xff;
  if (demo_version >= 203)
    {
      monster_infighting = *demo_p++;
      demo_p += 5;
      monster_backing = *demo_p++;
      monster_avoid_hazards = *demo_p++;
      monster_friction = *demo_p++;
      demo_p += 2;
      monkeys = *demo_p++;
      {
	int i;
	for (i=0; i < COMP_TOTAL; i++)
	  comp[i] = *demo_p++;
      }
      if (demo_version >= 205)
      use_true3d = *demo_p++;
    }
  else
    {
      int i;
      for (i=0; i < COMP_TOTAL; i++)
	comp[i] = compatibility;
      monster_infighting = 1;
      monster_backing = 0;      
      monster_avoid_hazards = 0;
      monster_friction = 0;
      monkeys = 0;
    }
  return target;
}

void G_BeginRecording(void)
{
  int i;
  demo_p = demobuffer;
  *demo_p++ = VERSION;
  *demo_p++ = 'C';
  *demo_p++ = 'D';
  *demo_p++ = 'O';
  *demo_p++ = 'O';
  *demo_p++ = 'M';
  *demo_p++ = 'C';
  *demo_p++ = compatibility;
  demo_version = VERSION;
  *demo_p++ = gameskill;
  *demo_p++ = gameepisode;
  *demo_p++ = gamemap;
  *demo_p++ = deathmatch;
  *demo_p++ = consoleplayer;
  demo_p = G_WriteOptions(demo_p);
  for (i=0 ; i<MAXPLAYERS ; i++)
    *demo_p++ = playeringame[i];
  for (; i<MIN_MAXPLAYERS; i++)
    *demo_p++ = 0;
}

void G_DeferedPlayDemo(char* name)
{
  defdemoname = name;
  gameaction = ga_playdemo;
}

boolean G_CheckDemoStatus(void)
{
  if (demorecording)
    {
      demorecording = false;
      *demo_p++ = DEMOMARKER;

      if (!M_WriteFile(demoname, demobuffer, demo_p - demobuffer))
        I_Error("Erre enregistrement demo %s", demoname);

      free(demobuffer);
      demobuffer = NULL;
      I_Error("Demo %s enregistre",demoname);
      return false;
    }

  if (timingdemo)
    {
      int endtime = I_GetTime_RealTime();
      unsigned realtics = endtime-starttime;
      I_Error ("Timed %d gametics in %d realtics = %d quadres pour segon",
               (unsigned) gametic,realtics,
               (unsigned) gametic * TICRATE / realtics);
    }

  if (demoplayback)
    {
      if (singledemo)
        exit(0);

      Z_ChangeTag(demobuffer, PU_CACHE);
      G_ReloadDefaults();
      netgame = false;
      deathmatch = false;
      D_AdvanceDemo();
      return true;
    }
  return false;
}

void dprintf(const char *s, ...)
{ char msg[1024];
  va_list v; va_start(v,s); vsprintf(msg,s,v); va_end(v);
  players[consoleplayer].message = msg;
}