/*
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation. NO WARRANTY.
*/

#include "doomstat.h"
#include "d_event.h"
#include "st_stuff.h"
#include "w_wad.h"
#include "d_englsh.h"
#include "sounds.h"
#include "d_deh.h"
#include "r_draw.h"
#include "doomdef.h"
#include "doomstat.h"
#include "v_video.h"
#include "r_main.h"
#include "r_defs.h"

typedef struct { int x, y; patch_t** f; int sc; char *cr; int linelen;
char l[320]; int len; int needsupdate; } hu_textline_t;
typedef struct { hu_textline_t l; int cl; boolean* on;
boolean laston; } hu_stext_t;
#define noterased viewwindowx
extern boolean automapactive;
void HUlib_clearTextLine(hu_textline_t* t)
{
 t->linelen = 0; t->len = 0;
 t->l[0] = 0; t->needsupdate = true;
}
void HUlib_initTextLine(hu_textline_t*t,int x,int y,patch_t **f,int sc,char*cr)
{ t->x = x; t->y = y; t->f = f; t->sc = sc; t->cr = cr;
HUlib_clearTextLine(t); }

boolean HUlib_addCharToTextLine(hu_textline_t *t, char ch)
{
 if (t->linelen == 80) return false;
 else { t->linelen++;
 if (ch == '\n') t->linelen=0; t->l[t->len++] = ch;
 t->l[t->len] = 0; t->needsupdate = 4; return true; }
}

boolean HUlib_delCharFromTextLine(hu_textline_t* t)
{
 return t->len ? t->l[--t->len] = 0, t->needsupdate = 4, 1:0;
}

void HUlib_drawTextLine(hu_textline_t *l, boolean drawcursor)
{
  int i, x = l->x, y = l->y;
  unsigned char c;
  for (i = 0; i < l->len; i++) {
  c = toupper(l->l[i]);
  if (c=='\n') x = 0, y += 8; else
  if (c=='\t') x = x - x%80 + 80; else
  if (c == '\x1b') {
  if (++i < l->len && l->l[i] >= '0' && l->l[i] <= '9')
  l->cr = colrngs[l->l[i]-'0']; } else
  if (c != ' ' && c >= l->sc && c <= 127) {
  int w = SHORT(l->f[c - l->sc]->width);
  if (x+w > SCREENWIDTH) break; V_DrawPatch(x,y,0,l->f[c - l->sc],0);
  x += w; } else if ((x+=4) >= SCREENWIDTH) break; }
  if (drawcursor && x + SHORT(l->f['_' - l->sc]->width) <= SCREENWIDTH)
  V_DrawPatch(x,y,0,l->f['_' - l->sc],0);
}

void HUlib_eraseTextLine(hu_textline_t* l)
{
 int x = viewwindowx, y = viewwindowy; 
 int viewwindowx = x, viewwindowy = y;
 if (!automapactive && viewwindowx && l->needsupdate)
   {
     int yoffset, lh = SHORT(l->f[0]->height) + 1;
     for (y=l->y,yoffset=y*SCREENWIDTH ; y<l->y+lh ; y++,yoffset+=SCREENWIDTH)
     if (y < viewwindowy || y >= viewwindowy + scaledviewheight)
     R_VideoErase(yoffset, SCREENWIDTH);
     else { R_VideoErase(yoffset, viewwindowx);
     R_VideoErase(yoffset + viewwindowx + scaledviewwidth, viewwindowx); }
   } if (l->needsupdate) l->needsupdate--;
}

void HUlib_initSText(hu_stext_t *s, int x, int y, int h, patch_t **font,
                     int startchar, char *cr, boolean *on)
{
  s->on = on; s->laston = true;
  s->cl = 0; HUlib_initTextLine(&s->l, x, y,font, startchar, cr);
}

void HUlib_addLineToSText(hu_stext_t* s)
{ HUlib_clearTextLine(&s->l); s->l.needsupdate = 4; }

void HUlib_addMessageToSText(hu_stext_t *s, char *prefix, char *msg)
{
 HUlib_addLineToSText(s);
 if (prefix) HUlib_addCharToTextLine(&s->l, *prefix);
 while (*msg) HUlib_addCharToTextLine(&s->l, *msg++);
}

void HUlib_drawSText(hu_stext_t* s)
{
 if (*s->on) HUlib_drawTextLine(&s->l, false);
}

void HUlib_eraseSText(hu_stext_t* s)
{
 if (s->laston && !*s->on) s->l.needsupdate = 4;
 HUlib_eraseTextLine(&s->l); s->laston = *s->on;
}

#define HU_TITLE  (*mapnames[(gameepisode-1)*9+gamemap-1])
#define HU_TITLE2 (*mapnames2[gamemap-1])
#define HU_TITLEY (ST_Y - 1 - SHORT(hu_font[0]->height)) 

#define HU_COORDX 250
#define HU_COORDX_Y 1
#define HU_COORDY_Y 12
#define HU_COORDZ_Y 23
#define HU_INPUTY (SHORT(hu_font[0]->height) +1)

#define HU_FONTSTART  '!'
#define HU_FONTEND    127
#define HU_FONTSIZE   (128 - '!')

#define key_alt   key_strafe
#define key_shift key_speed
extern int  key_shift;
extern int  key_alt;
extern int  destination_keys[MAXPLAYERS];

char* player_names[] =
{
  HUSTR_PLRGREEN,
  HUSTR_PLRINDIGO,
  HUSTR_PLRBROWN,
  HUSTR_PLRRED
};

int plyrcoltran[MAXPLAYERS]={6,6,6,6};

char chat_char;
player_t*  plr;

patch_t* hu_font[HU_FONTSIZE];
patch_t* hu_fontk[HU_FONTSIZE];
patch_t* hu_msgbg[9];

hu_textline_t  w_title;
hu_stext_t     w_message;
hu_stext_t     w_chat;
hu_stext_t     w_inputbuffer[MAXPLAYERS];
hu_textline_t  w_coordx;
hu_textline_t  w_coordy;
hu_textline_t  w_coordz;

boolean    always_off = false;
boolean    message_on;
boolean    message_list_on;
boolean    has_message;
boolean    reviewing_message;
boolean    message_dontdamnme;
boolean    message_nottobedamned;
int        message_counter;
int        message_list_counter;

extern int        showMessages;
extern boolean    automapactive;
boolean    headsupactive = false;

char hud_coordstrx[32];
char hud_coordstry[32];
char hud_coordstrz[32];

extern char **mapnames[];
extern char **mapnames2[];

void HU_Init(void)
{
  int  i, j;
  char buffer[9];
  j = HU_FONTSTART;
  for (i=0;i<HU_FONTSIZE;i++,j++)
    {
      if ('0'<=j && j<='9')
        {
          sprintf(buffer, "STCFN%.3d",j);
          hu_font[i] = (patch_t *) W_CacheLumpName(buffer, PU_STATIC);
        }
      else
        if ('A'<=j && j<='Z')
          {
            sprintf(buffer, "STCFN%.3d",j);
            hu_font[i] = (patch_t *) W_CacheLumpName(buffer, PU_STATIC);
          }
        else
          if (j=='-')
            {
              hu_font[i] = (patch_t *) W_CacheLumpName("STCFN045", PU_STATIC);
            }
          else
            if (j=='/')
              {
                hu_font[i] = (patch_t *) W_CacheLumpName("STCFN047", PU_STATIC);
              }
            else
              if (j==':')
                {
                  hu_font[i] = (patch_t *) W_CacheLumpName("STCFN058", PU_STATIC);
                }
              else
                if (j=='[')
                  {
                    hu_font[i] = (patch_t *) W_CacheLumpName("STCFN091", PU_STATIC);
                  }
                else
                  if (j==']')
                    {
                      hu_font[i] = (patch_t *) W_CacheLumpName("STCFN093", PU_STATIC);
                    }
                  else
                    if (j<96)
                      {
                        sprintf(buffer, "STCFN%.3d",j);
                        hu_font[i] = (patch_t *) W_CacheLumpName(buffer, PU_STATIC);
                      }
                      else
                        hu_font[i] = hu_font[0];
    }
  hu_fontk[0] = (patch_t *) W_CacheLumpName("STKEYS0", PU_STATIC);
  hu_fontk[1] = (patch_t *) W_CacheLumpName("STKEYS1", PU_STATIC);
  hu_fontk[2] = (patch_t *) W_CacheLumpName("STKEYS2", PU_STATIC);
  hu_fontk[3] = (patch_t *) W_CacheLumpName("STKEYS3", PU_STATIC);
  hu_fontk[4] = (patch_t *) W_CacheLumpName("STKEYS4", PU_STATIC);
  hu_fontk[5] = (patch_t *) W_CacheLumpName("STKEYS5", PU_STATIC);
}

void HU_Stop(void)
{ headsupactive = false; }

void HU_Start(void)
{
  char* s;
  if (headsupactive) HU_Stop();
  plr = &players[displayplayer];
  message_on = 0;
  message_dontdamnme = 0;
  message_nottobedamned = 0;
  reviewing_message = message_list_on = 0;
  message_counter = message_list_counter = 0;
  HUlib_initSText(&w_message,0,0,1,hu_font,HU_FONTSTART,NULL,&message_on);
  HUlib_initTextLine(&w_title,0,HU_TITLEY,hu_font,HU_FONTSTART,NULL);
  s = gamemode != commercial ? HU_TITLE : HU_TITLE2;
  while (*s)
    HUlib_addCharToTextLine(&w_title, *s++);
  HUlib_initTextLine(&w_coordx, HU_COORDX, HU_COORDX_Y, hu_font,
                     HU_FONTSTART, NULL);
  HUlib_initTextLine(&w_coordy, HU_COORDX, HU_COORDY_Y, hu_font,
                     HU_FONTSTART, NULL);
  HUlib_initTextLine(&w_coordz, HU_COORDX, HU_COORDZ_Y, hu_font,
                     HU_FONTSTART, NULL);
  sprintf(hud_coordstrx,"X: %-5d",0);
  s = hud_coordstrx;
  while (*s)
    HUlib_addCharToTextLine(&w_coordx, *s++);
  sprintf(hud_coordstry,"Y: %-5d",0);
  s = hud_coordstry;
  while (*s)
    HUlib_addCharToTextLine(&w_coordy, *s++);
  sprintf(hud_coordstrz,"Z: %-5d",0);
  s = hud_coordstrz;
  headsupactive = true;
}

void HU_Erase(void)
{ HUlib_eraseSText(&w_message); HUlib_eraseTextLine(&w_title); }

void HU_Drawer(void)
{
  char *s;
  player_t *plr = &players[displayplayer];
  if (automapactive)
    {
      int x,y,z;
      HUlib_drawTextLine(&w_title, false);
      AM_Coordinates(plr->mo, &x, &y, &z);
      sprintf(hud_coordstrx,"X: %-5d", x>>FRACBITS);
      HUlib_clearTextLine(&w_coordx);
      s = hud_coordstrx;
      while (*s)
        HUlib_addCharToTextLine(&w_coordx, *s++);
      HUlib_drawTextLine(&w_coordx, false);
      sprintf(hud_coordstry,"Y: %-5d", y>>FRACBITS);
      HUlib_clearTextLine(&w_coordy);
      s = hud_coordstry;
      while (*s)
        HUlib_addCharToTextLine(&w_coordy, *s++);
      HUlib_drawTextLine(&w_coordy, false);

      sprintf(hud_coordstrz,"Z: %-5d", z>>FRACBITS);
      HUlib_clearTextLine(&w_coordz);
      s = hud_coordstrz;
      while (*s)
        HUlib_addCharToTextLine(&w_coordz, *s++);
      HUlib_drawTextLine(&w_coordz, false);
    }
  if (scaledviewheight < 200) HU_Erase(); 
  HUlib_drawSText(&w_message);
}

void HU_Ticker(void)
{
  if (message_list_counter && !--message_list_counter)
  reviewing_message = message_list_on = 0;
  if (message_counter && !--message_counter)
    reviewing_message = message_on = message_nottobedamned = 0;
  if ((showMessages || message_dontdamnme) && plr->message &&
      (!message_nottobedamned || message_dontdamnme))
    {
      HUlib_addMessageToSText(&w_message, 0, plr->message);
      plr->message = 0;
      message_on = 1;
      message_counter = 140;
      has_message = 1;
      message_nottobedamned = message_dontdamnme;
      message_dontdamnme = 0;
    }
}

boolean HU_Responder(event_t *ev)
{
  boolean eatkey = false;
  boolean shiftdown = false;
  int i,numplayers;

  numplayers = 0;
  for (i=0 ; i<MAXPLAYERS ; i++)
    numplayers += playeringame[i];

  if (ev->data1 == key_shift)
    {
      shiftdown = ev->type == ev_keydown;
      return false;
    }

  if (ev->type != ev_keydown)
    return false;

      if (ev->data1 == KEYD_ENTER)
        {
	  if (has_message)
	    {
              if (message_on && reviewing_message)
                  {
		    if (gametic && gamestate == GS_LEVEL)
                      HU_Erase();
		    message_list_on = false;
		  }

		  message_counter = 140;
		  reviewing_message = message_on = true;
	    }
          eatkey = true;
        } 
  return eatkey;
}