/*
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation. NO WARRANTY.
*/

#include "doomstat.h"
#include "m_argv.h"
#include "g_game.h"
#include "m_menu.h"
#include "am_map.h"
#include "w_wad.h"
#include "i_system.h"
#include "v_video.h"
#include "st_stuff.h"
#include "d_englsh.h"
#include "m_misc.h"
#include "sounds.h"

#include <unistd.h>

int driver;
int usemouse,usejoystick,screenshot_pcx;
extern int mousebfire,mousebstrafe,mousebforward;
extern int joybfire,joybstrafe,joybuse,joybspeed;
extern int viewwidth,viewheight;
extern int mouseSensitivity_horiz,mouseSensitivity_vert;
extern int tran_filter_pct,screenblocks,showMessages;

extern char *wad_files[], *deh_files[];

default_t defaults[] = {
 { "mus_card", &driver, NULL, 0, {0,4} },
 { "true3d", &use_true3d, NULL, 1, {0,1} },
 { "tran_filter_pct", &tran_filter_pct, NULL, 100, {0,100} },
 { "monsters_remember", &default_monsters_remember, &monsters_remember,
 1, {0,1} },
 { "monster_infighting", &default_monster_infighting, &monster_infighting,
 1, {0,1} },
 { "monster_backing", &default_monster_backing, &monster_backing,
 0, {0,1} },
 { "monster_avoid_hazards",
 &default_monster_avoid_hazards, &monster_avoid_hazards, 1, {0,1} },
 { "monkeys", &default_monkeys, &monkeys, 0, {0,1} },
 { "monster_friction", &default_monster_friction, &monster_friction,
 1, {0,1} },
 { "mouse_sens_horiz", &mouseSensitivity_horiz, NULL, 9, {0,9} },
 { "mouse_sens_vert", &mouseSensitivity_vert, NULL, 9, {0,9} },
 { "sfx_volume", &snd_SfxVolume, NULL, 4, {0,15} },
 { "music_volume", &snd_MusicVolume, NULL, 8, {0,15} },
 { "show_messages", &showMessages, NULL, 1, {0,1} },
 { "autorun", &autorun, NULL, 0, {0,1} },
 { "screenblocks", &screenblocks, NULL, 10, {3,11} },
 { "usegamma", &usegamma, NULL, 3, {0,4} },
 { "comp_zombie", &default_comp[comp_zombie], &comp[comp_zombie], 1, {0,1} },
 { "comp_infcheat", &default_comp[comp_infcheat], &comp[comp_infcheat],
 0, {0,1} },
 { "comp_stairs", &default_comp[comp_stairs], &comp[comp_stairs], 0, {0,1} },
 { "comp_telefrag", &default_comp[comp_telefrag], &comp[comp_telefrag],
 0, {0,1} },
 { "comp_dropoff", &default_comp[comp_dropoff], &comp[comp_dropoff],
 1, {0,1} },
 { "comp_falloff", &default_comp[comp_falloff], &comp[comp_falloff],
 1, {0,1} },
 { "comp_staylift", &default_comp[comp_staylift], &comp[comp_staylift],
 0, {0,1} },
 { "comp_doorstuck", &default_comp[comp_doorstuck], &comp[comp_doorstuck],
 0, {0,1} },
 { "comp_pursuit", &default_comp[comp_pursuit], &comp[comp_pursuit],
 1, {0,1} },
 { "comp_vile", &default_comp[comp_vile], &comp[comp_vile], 0, {0,1} },
 { "comp_pain", &default_comp[comp_pain], &comp[comp_pain], 1, {0,1} },
 { "comp_skull", &default_comp[comp_skull], &comp[comp_skull], 0, {0,1} },
 { "comp_doorlight", &default_comp[comp_doorlight], &comp[comp_doorlight],
 0, {0,1} },
 { "comp_skymap", &default_comp[comp_skymap], &comp[comp_skymap], 1, {0,1} },
 { "comp_floors", &default_comp[comp_floors], &comp[comp_floors], 0, {0,1} },
 { "comp_model", &default_comp[comp_model], &comp[comp_model], 0, {0,1} },
 { "comp_zerotags", &default_comp[comp_zerotags], &comp[comp_zerotags],
 0, {0,1} },
 { "wad_1", (int*)&wad_files[0], NULL, (int)"", {0}, string },
 { "wad_2", (int*)&wad_files[1], NULL, (int)"", {0}, string },
 { "deh_1", (int*)&deh_files[0], NULL, (int)"", {0}, string },
 { "deh_2", (int*)&deh_files[1], NULL, (int)"", {0}, string },
 { "key_jump", &key_jump, NULL, '/', {0,255} },
 { "key_right", &key_right, NULL, KEYD_RIGHTARROW, {0,255} },
 { "key_left", &key_left, NULL, KEYD_LEFTARROW, {0,255} },
 { "key_up", &key_up, NULL, KEYD_UPARROW, {0,255} },
 { "key_down", &key_down, NULL, KEYD_DOWNARROW, {0,255} },
 { "key_strafeleft", &key_strafeleft, NULL, ',', {0,255} },
 { "key_straferight", &key_straferight, NULL, '.', {0,255} },
 { "key_fire", &key_fire, NULL, KEYD_RCTRL, {0,255} },
 { "key_use", &key_use, NULL, ' ', {0,255} },
 { "key_strafe", &key_strafe, NULL, KEYD_RALT, {0,255} },
 { "key_speed", &key_speed, NULL, KEYD_RSHIFT, {0,255} },
 { "key_autorun", &key_autorun, NULL, KEYD_CAPSLOCK, {0,255} },
 { "key_map", &key_map, NULL, KEYD_TAB, {0,255} },
 { "key_reverse", &key_reverse, NULL, 'x', {0,255} },
 { "screenshot_pcx", &screenshot_pcx, NULL, 0, {0,1} },
 { "use_mouse", &usemouse, NULL, 0, {0,1} },
 { "mouseb_fire", &mousebfire, NULL, 0, {-1,2} },
 { "mouseb_strafe", &mousebstrafe, NULL, 1, {-1,2} },
 { "mouseb_forward", &mousebforward, NULL, 2, {-1,2} },
 { "use_joystick", &usejoystick, NULL, 0, {0,1} },
 { "joyb_fire", &joybfire, NULL, 0, {0,999} },
 { "joyb_strafe", &joybstrafe, NULL, 1, {0,999} },
 { "joyb_speed", &joybspeed, NULL, 2, {0,999} },
 { "joyb_use", &joybuse, NULL, 3, {0,999} },
 {NULL}
};

static char *defaultfile;

#define NUMDEFAULTS ((unsigned)(sizeof defaults / sizeof *defaults - 1))

static unsigned default_hash(const char *name)
{
 unsigned hash = 0;
 while (*name)
 hash = hash*2 + toupper(*name++);
 return hash % NUMDEFAULTS;
}

default_t *M_LookupDefault(const char *name)
{
 static int hash_init;
 register default_t *dp;

 if (!hash_init)
 for (hash_init = 1, dp = defaults; dp->name; dp++)
 {
 unsigned h = default_hash(dp->name);
 dp->next = defaults[h].first;
 defaults[h].first = dp;
 }

 for (dp = defaults[default_hash(name)].first;
 dp && strcasecmp(name, dp->name); dp = dp->next);

 return dp;
}

void M_SaveDefaults (void)
{
 char tmpfile[PATH_MAX+1];
 register default_t *dp;
 int line, blanks, value;
 FILE *f;

 sprintf(tmpfile, "%s/%.8s.cfg", D_DoomExeDir(), D_DoomExeName());

 if (!(f = fopen(tmpfile, "w")))
 return;

 for (blanks = 1, line = 0, dp = defaults; ; dp++, blanks = 0)
 {
 if (!dp->name)
 break;

 value = dp->modified ? dp->orig_default : (int) *dp->location;

 if (!dp->isstr ? fprintf(f, "%s %i\n", dp->name,
 strncmp(dp->name, "key_", 4) ? value :
 I_DoomCode2ScanCode(value)) == EOF :
 fprintf(f,"%s \"%s\"\n", dp->name, (char *) value) == EOF)
 return;
 }

 fclose(f);
}

boolean M_ParseOption(const char *p)
{
 char name[80], strparm[100];
 default_t *dp;
 int parm;
 while (isspace(*p)) p++;
 if (sscanf(p, "%79s %99[^\n]", name, strparm) != 2 || !isalnum(*name) ||
 !(dp = M_LookupDefault(name)) || (*strparm == '"') == !dp->isstr)
 return 1;
 if (dp->isstr) { int len = strlen(strparm)-1;
 while (isspace(strparm[len])) len--;
 if (strparm[len] == '"') len--; strparm[len+1] = 0;
 free(*(char **) dp->location);
 *(char **) dp->location = strdup(strparm+1);
 if (dp->current) { free(*(char **) dp->current);
 *(char **) dp->current = strdup(strparm+1); }
 } else { if (sscanf(strparm, "%i", &parm) != 1) return 1;
 if (!strncmp(name, "key_", 4))	parm = I_ScanCode2DoomCode(parm);
 if ((dp->limit.min == 999 || dp->limit.min <= parm) &&
 (dp->limit.max == 999 || dp->limit.max >= parm)) {
 *dp->location = parm; } }
 return 0;
}

void M_LoadDefaults (void)
{
 register default_t *dp;
 int i;
 FILE *f;

 for (dp = defaults; dp->name; dp++)
 *dp->location =
 dp->isstr ? (int) strdup((char *) dp->defaultvalue) : dp->defaultvalue;

 if (!defaultfile)
 if ((i = M_CheckParm("-config")) && i < myargc-1)
 printf(" default file: %s\n", defaultfile = strdup(myargv[i+1]));
 else
 defaultfile = strdup(basedefault);

 if (f = fopen(defaultfile, "r"))
 {
 char s[256];
 while (fgets(s, sizeof s, f))
 M_ParseOption(s);
 fclose (f);
 }

}

boolean M_WriteFile(char const *name, void *source, int length)
{
 FILE *fp;
 if (!(fp = fopen(name, "wb")))
 return 0;
 I_BeginRead();
 length = fwrite(source, 1, length, fp) == length;
 fclose(fp);
 if (!length)
 remove(name);
 return length;
}

int M_ReadFile(char const *name, byte **buffer)
{
 FILE *fp;
 if ((fp = fopen(name, "rb")))
 {
 size_t length;
 fseek(fp, 0, SEEK_END);
 length = ftell(fp);
 fseek(fp, 0, SEEK_SET);
 *buffer = Z_Malloc(length, PU_STATIC, 0);
 if (fread(*buffer, 1, length, fp) == length)
 {
 fclose(fp);
 return length;
 }
 fclose(fp);
 }
 I_Error("Ne pouvez lire archive %s", name);
 return 0;
}

typedef struct
{
 char manufacturer;
 char version;
 char encoding;
 char bits_per_pixel;

 unsigned short xmin;
 unsigned short ymin;
 unsigned short xmax;
 unsigned short ymax;

 unsigned short hres;
 unsigned short vres;

 unsigned char palette[48];

 char reserved;
 char color_planes;
 unsigned short bytes_per_line;
 unsigned short palette_type;

 char filler[58];
 unsigned char data;
} pcx_t;

boolean WritePCXfile(char *filename, byte *data, int width,
 int height, byte *palette)
{
 int i;
 int length;
 pcx_t* pcx;
 byte* pack;
 boolean success;

 pcx = Z_Malloc(width*height*2+1000, PU_STATIC, NULL);

 pcx->manufacturer = 0x0a;
 pcx->version = 5;
 pcx->encoding = 1;
 pcx->bits_per_pixel = 8;
 pcx->xmin = 0;
 pcx->ymin = 0;
 pcx->xmax = SHORT(width-1);
 pcx->ymax = SHORT(height-1);
 pcx->hres = SHORT(width);
 pcx->vres = SHORT(height);
 memset (pcx->palette,0,sizeof(pcx->palette));
 pcx->color_planes = 1;
 pcx->bytes_per_line = SHORT(width);
 pcx->palette_type = SHORT(2);
 memset (pcx->filler,0,sizeof(pcx->filler));

 pack = &pcx->data;

 for (i = 0 ; i < width*height ; i++)
 if ( (*data & 0xc0) != 0xc0)
 *pack++ = *data++;
 else
 {
 *pack++ = 0xc1;
 *pack++ = *data++;
 }
 *pack++ = 0x0c;
 for (i = 0 ; i < 768 ; i++)
 *pack++ = gammatable[usegamma][*palette++];
 length = pack - (byte *)pcx;
 success = M_WriteFile (filename, pcx, length);
 Z_Free (pcx);
 return success;
}

#define BI_RGB 0L

typedef unsigned short uint_t;
typedef unsigned long dword_t;
typedef long long_t;
typedef unsigned char ubyte_t;

typedef struct tagBITMAPFILEHEADER
{
 uint_t bfType;
 dword_t bfSize;
 uint_t bfReserved1;
 uint_t bfReserved2;
 dword_t bfOffBits;
} __attribute__ ((packed)) BITMAPFILEHEADER;

typedef struct tagBITMAPINFOHEADER
{
 dword_t biSize;
 long_t biWidth;
 long_t biHeight;
 uint_t biPlanes;
 uint_t biBitCount;
 dword_t biCompression;
 dword_t biSizeImage;
 long_t biXPelsPerMeter;
 long_t biYPelsPerMeter;
 dword_t biClrUsed;
 dword_t biClrImportant;
} __attribute__ ((packed)) BITMAPINFOHEADER;

#define SafeWrite(data,size,number,st) do { \
 if (fwrite(data,size,number,st) < (number)) \
 return fclose(st), false; } while(0)

boolean WriteBMPfile(char *filename, byte *data, int width,
 int height, byte *palette)
{
 int i,wid;
 BITMAPFILEHEADER bmfh;
 BITMAPINFOHEADER bmih;
 int fhsiz,ihsiz;
 FILE *st;
 char zero=0;
 ubyte_t c;

 fhsiz = sizeof(BITMAPFILEHEADER);
 ihsiz = sizeof(BITMAPINFOHEADER);
 wid = 4*((width+3)/4);
 bmfh.bfType = SHORT(19778);
 bmfh.bfSize = LONG(fhsiz+ihsiz+256L*4+width*height);
 bmfh.bfReserved1 = SHORT(0);
 bmfh.bfReserved2 = SHORT(0);
 bmfh.bfOffBits = LONG(fhsiz+ihsiz+256L*4);

 bmih.biSize = LONG(ihsiz);
 bmih.biWidth = LONG(width);
 bmih.biHeight = LONG(height);
 bmih.biPlanes = SHORT(1);
 bmih.biBitCount = SHORT(8);
 bmih.biCompression = LONG(BI_RGB);
 bmih.biSizeImage = LONG(wid*height);
 bmih.biXPelsPerMeter = LONG(0);
 bmih.biYPelsPerMeter = LONG(0);
 bmih.biClrUsed = LONG(256);
 bmih.biClrImportant = LONG(256);

 st = fopen(filename,"wb");
 if (st!=NULL)
 {
 SafeWrite(&bmfh.bfType,sizeof(bmfh.bfType),1,st);
 SafeWrite(&bmfh.bfSize,sizeof(bmfh.bfSize),1,st);
 SafeWrite(&bmfh.bfReserved1,sizeof(bmfh.bfReserved1),1,st);
 SafeWrite(&bmfh.bfReserved2,sizeof(bmfh.bfReserved2),1,st);
 SafeWrite(&bmfh.bfOffBits,sizeof(bmfh.bfOffBits),1,st);
 SafeWrite(&bmih.biSize,sizeof(bmih.biSize),1,st);
 SafeWrite(&bmih.biWidth,sizeof(bmih.biWidth),1,st);
 SafeWrite(&bmih.biHeight,sizeof(bmih.biHeight),1,st);
 SafeWrite(&bmih.biPlanes,sizeof(bmih.biPlanes),1,st);
 SafeWrite(&bmih.biBitCount,sizeof(bmih.biBitCount),1,st);
 SafeWrite(&bmih.biCompression,sizeof(bmih.biCompression),1,st);
 SafeWrite(&bmih.biSizeImage,sizeof(bmih.biSizeImage),1,st);
 SafeWrite(&bmih.biXPelsPerMeter,sizeof(bmih.biXPelsPerMeter),1,st);
 SafeWrite(&bmih.biYPelsPerMeter,sizeof(bmih.biYPelsPerMeter),1,st);
 SafeWrite(&bmih.biClrUsed,sizeof(bmih.biClrUsed),1,st);
 SafeWrite(&bmih.biClrImportant,sizeof(bmih.biClrImportant),1,st);
 for (i=0;i<768;i+=3)
 {
 c=gammatable[usegamma][palette[i+2]];
 SafeWrite(&c,sizeof(char),1,st);
 c=gammatable[usegamma][palette[i+1]];
 SafeWrite(&c,sizeof(char),1,st);
 c=gammatable[usegamma][palette[i+0]];
 SafeWrite(&c,sizeof(char),1,st);
 SafeWrite(&zero,sizeof(char),1,st);
 }
 for (i = 0 ; i < height ; i++)
 SafeWrite(data+(height-1-i)*width,sizeof(byte),wid,st);
 fclose(st);
 }
 return true;
}

void M_ScreenShot (void)
{
 boolean success = false;
 if (!access(".",2))
 {
 static int shot;
 char lbmname[PATH_MAX+1];
 int tries = 10000;
 do
 sprintf(lbmname,
 screenshot_pcx ? "doom%02d.pcx" : "doom%02d.bmp", shot++);
 while (!access(lbmname,0) && --tries);
 if (tries)
 {
 byte *pal = W_CacheLumpName ("PLAYPAL", PU_STATIC);
 byte *linear = screens[2];
 I_ReadScreen(linear);
 if (!(success = (screenshot_pcx ? WritePCXfile : WriteBMPfile)
 (lbmname,linear, SCREENWIDTH, SCREENHEIGHT,pal)))
 remove(lbmname);
 Z_ChangeTag(pal, PU_CACHE);
 }
 }
 I_BeginRead();
 players[consoleplayer].message = "screen shot";
 S_StartSound(NULL, gamemode==commercial ? sfx_radio : sfx_tink);
}