/*
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation. NO WARRANTY.
*/

#include "doomstat.h"
#include "r_main.h"
#include "r_plane.h"
#include "r_bsp.h"
#include "r_draw.h"
#include "m_bbox.h"
#include "v_video.h"
#include "tables.h"

#define FIELDOFVIEW 2048
int pspritescale,pspriteiscale,viewangleoffset,validcount=1;
short screenheightarray[320];
lighttable_t *fixedcolormap;
int      centerx, centery;
fixed_t  centerxfrac, centeryfrac;
fixed_t  projection;
fixed_t  viewx, viewy, viewz;
angle_t  viewangle;
fixed_t  viewcos, viewsin;
player_t *viewplayer;
extern lighttable_t **walllights;

angle_t clipangle,tantoangle[SLOPERANGE+1];
int finesine[5*FINEANGLES/4];
int finetangent[FINEANGLES/2];
int viewangletox[FINEANGLES/2];
angle_t xtoviewangle[321];

int numcolormaps;
lighttable_t *(*c_scalelight)[LIGHTLEVELS][MAXLIGHTSCALE];
lighttable_t *(*c_zlight)[LIGHTLEVELS][MAXLIGHTZ];
lighttable_t *(*scalelight)[MAXLIGHTSCALE];
lighttable_t *(*zlight)[MAXLIGHTZ];
lighttable_t *fullcolormap;
lighttable_t **colormaps;
int extralight;
void (*colfunc)(void) = R_DrawColumn;
short SHORT(short x)
{ return (((unsigned char*)&x)[1]<<8)+((unsigned char*)&x)[0]; }
long LONG(long x)
{ return (((unsigned char*)&x)[3]<<24)+(((unsigned char*)&x)[2]<<16)+
(((unsigned char*)&x)[1]<<8)+((unsigned char*)&x)[0]; }
int FixedMul(int a,int b)
{ return ((long long)a*b>>16); }
int FixedDiv(int a,int b)
{ return (abs(a)>>14)>=abs(b)?((a^b)>>31)^0x7fffffff:
 (((long long)a<<16)/b); }
int SlopeDiv(unsigned num, unsigned den)
{ unsigned ans;
if (den < 512) return SLOPERANGE;
ans=(num<<3)/(den>>8);
return ans<=SLOPERANGE? ans: SLOPERANGE;
}
int *finecosine = &finesine[FINEANGLES/4];
int abs(x) {int _t =(x),_s=_t>>(8*sizeof _t-1); return(_t^_s)-_s;}
int R_PointOnSide(fixed_t x, fixed_t y, node_t *node)
{
  if (!node->dx)
    return x <= node->x ? node->dy > 0 : node->dy < 0;

  if (!node->dy)
    return y <= node->y ? node->dx < 0 : node->dx > 0;
        
  x -= node->x;
  y -= node->y;

  if ((node->dy ^ node->dx ^ x ^ y) < 0)
    return (node->dy ^ x) < 0;
  return FixedMul(y, node->dx>>FRACBITS) >= FixedMul(node->dy>>FRACBITS, x);
}

int R_PointOnSegSide(fixed_t x, fixed_t y, seg_t *line)
{
  fixed_t lx = line->v1->x;
  fixed_t ly = line->v1->y;
  fixed_t ldx = line->v2->x - lx;
  fixed_t ldy = line->v2->y - ly;

  if (!ldx)
    return x <= lx ? ldy > 0 : ldy < 0;

  if (!ldy)
    return y <= ly ? ldx < 0 : ldx > 0;
  
  x -= lx;
  y -= ly;

  if ((ldy ^ ldx ^ x ^ y) < 0)
    return (ldy ^ x) < 0;
  return FixedMul(y, ldx>>FRACBITS) >= FixedMul(ldy>>FRACBITS, x);
}

angle_t R_PointToAngle(long long x, long long y)
{       
  return (y -= viewy, (x -= viewx) || y) ?
    x >= 0 ?
      y >= 0 ? 
        (x > y) ? tantoangle[SlopeDiv(y,x)] :
                ANG90-tantoangle[SlopeDiv(x,y)] :
        x > (y = -y) ? -tantoangle[SlopeDiv(y,x)] :
                       ANG270+tantoangle[SlopeDiv(x,y)] :
      y >= 0 ? (x = -x) > y ? ANG180-tantoangle[SlopeDiv(y,x)] :
                            ANG90 + tantoangle[SlopeDiv(x,y)] :
        (x = -x) > (y = -y) ? ANG180+tantoangle[SlopeDiv(y,x)] :
                              ANG270-tantoangle[SlopeDiv(x,y)] :
    0;
}

angle_t R_PointToAngle2(fixed_t viewx, fixed_t viewy, fixed_t x, fixed_t y)
{       
  return (y -= viewy, (x -= viewx) || y) ?
    x >= 0 ?
      y >= 0 ? 
        (x > y) ? tantoangle[SlopeDiv(y,x)] : 
                ANG90-1-tantoangle[SlopeDiv(x,y)] :
        x > (y = -y) ? -tantoangle[SlopeDiv(y,x)] :
                       ANG270+tantoangle[SlopeDiv(x,y)] :
      y >= 0 ? (x = -x) > y ? ANG180-1-tantoangle[SlopeDiv(y,x)] :
                            ANG90 + tantoangle[SlopeDiv(x,y)] :
        (x = -x) > (y = -y) ? ANG180+tantoangle[ SlopeDiv(y,x)] :
                              ANG270-1-tantoangle[SlopeDiv(x,y)] :
    0;
}

fixed_t R_ScaleFromGlobalAngle(angle_t visangle)
{
  int den = FixedMul(rw_distance, finecosine[(visangle-viewangle)
  >>ANGLETOFINESHIFT]);
  int num = FixedMul(projection, finecosine[(visangle-rw_normalangle)
  >>ANGLETOFINESHIFT]);
  return den > num>>16 ? (num = FixedDiv(num, den)) > 64*FRACUNIT ?
    64*FRACUNIT : num < 256 ? 256 : num : 64*FRACUNIT;
}

static void R_InitTextureMapping (void)
{
  register int i,x;
  fixed_t focallength;

  focallength = FixedDiv(centerxfrac, finetangent[FINEANGLES/4+FIELDOFVIEW/2]);
        
  for (i=FINEANGLES/2-1; i>-1; i--)
    {
      int t;
      if (finetangent[i] > FRACUNIT*2)
        t = 0;
      else
        if (finetangent[i] < -FRACUNIT*2)
          t = viewwidth;
      else
        {
          t = FixedMul(finetangent[i], focallength);
          t = (centerxfrac - t + FRACUNIT-1) >> FRACBITS;
          if (t < -1)
            t = 0;
          else
            if (t > viewwidth+1)
              t = viewwidth;
        }
      viewangletox[i] = t;
    }
    
  for (x=viewwidth; x>=0; x--)
    {
      for (i=0; viewangletox[i] > x; i++);
      xtoviewangle[x] = (i<<ANGLETOFINESHIFT)-ANG90;
    }
    
  clipangle = xtoviewangle[0];
}

#define DISTMAP 2

void R_InitLightTables (void)
{
  int i;

  c_zlight = malloc(sizeof(*c_zlight) * numcolormaps);
  c_scalelight = malloc(sizeof(*c_scalelight) * numcolormaps);

  for (i=LIGHTLEVELS-1; i>-1; i--)
    {
      int j, startmap = ((LIGHTLEVELS-1-i)*2)*NUMCOLORMAPS/LIGHTLEVELS;
      for (j=MAXLIGHTZ-1; j>-1; j--)
        {
          int scale = FixedDiv ((SCREENWIDTH/2*FRACUNIT), (j+1)<<LIGHTZSHIFT);
          int t, level = startmap - (scale >>= LIGHTSCALESHIFT)/DISTMAP;

          if (level < 0)
            level = 0;
          else
            if (level >= NUMCOLORMAPS)
              level = NUMCOLORMAPS-1;

          level *= 256;
          for (t=numcolormaps-1; t>-1; t--)
            c_zlight[t][i][j] = colormaps[t] + level;
        }
    }
}

boolean setsizeneeded;
int     setblocks;

void R_SetViewSize(int blocks)
{
  setsizeneeded = true;
  setblocks = blocks;
}

void R_ExecuteSetViewSize (void)
{
  int i;

  setsizeneeded = false;

  if (setblocks == 11)
    {
      scaledviewwidth = SCREENWIDTH;
      scaledviewheight = SCREENHEIGHT;
    }
  else
    {
      scaledviewwidth = setblocks*32;
      scaledviewheight = (setblocks*168/10) & ~7;
    }

  viewwidth = scaledviewwidth;
  viewheight = scaledviewheight;

  centery = viewheight/2;
  centerx = viewwidth/2;
  centerxfrac = centerx<<FRACBITS;
  centeryfrac = centery<<FRACBITS;
  projection = centerxfrac;

  R_InitBuffer(scaledviewwidth, scaledviewheight);
        
  R_InitTextureMapping();

  pspritescale = FixedDiv(viewwidth, SCREENWIDTH);
  pspriteiscale= FixedDiv(SCREENWIDTH, viewwidth);

  for (i=viewwidth-1; i>-1; i--)
    screenheightarray[i] = viewheight;

  for (i=viewheight-1; i>-1; i--)
    {
      fixed_t dy = abs(((i-viewheight/2)<<FRACBITS)+FRACUNIT/2);
      yslope[i] = FixedDiv(viewwidth*(FRACUNIT/2), dy);
    }
        
  for (i=viewwidth-1; i>-1; i--)
    {
      fixed_t cosadj = abs(finecosine[xtoviewangle[i]>>ANGLETOFINESHIFT]);
      distscale[i] = FixedDiv(FRACUNIT,cosadj);
    }

  for (i=LIGHTLEVELS-1; i>-1; i--)
    {
      int j, startmap = ((LIGHTLEVELS-1-i)*2)*NUMCOLORMAPS/LIGHTLEVELS;
      for (j=MAXLIGHTSCALE-1; j>-1; j--)
        {
          int t, level = startmap - j*SCREENWIDTH/scaledviewwidth/DISTMAP;
            
          if (level < 0)
            level = 0;

          if (level >= NUMCOLORMAPS)
            level = NUMCOLORMAPS-1;

          level *= 256;

          for (t=numcolormaps-1; t>-1; t--)
            c_scalelight[t][i][j] = colormaps[t] + level;
        }
    }
}

extern int screenblocks;
int skyflatnum,skytexture;

R_InitTables()
{
    int	i;
    long t;
    float f,a;
    for (i=0 ; i<=SLOPERANGE ; i++)
    {
	f = atan( (float)i/SLOPERANGE )/6.283185314;
	t = 0xffffffff*f;
	tantoangle[i] = t;
    }
    for (i=0 ; i<FINEANGLES/2 ; i++)
    {
	a = (i-FINEANGLES/4+0.5)*6.283185314/FINEANGLES;
	t = FRACUNIT*tan (a);
	finetangent[i] = t;
    }
    for (i=0 ; i<5*FINEANGLES/4 ; i++)
    {
	a = (i+0.5)*6.283185314/FINEANGLES;
	t = FRACUNIT*sin (a);
	finesine[i] = t;
    }
}

void R_Init (void)
{
  R_InitData();
  printf("\nR_InitData\n");
  R_InitTables();
  R_SetViewSize(screenblocks);
  printf("R_InitPlanes\n");
  R_InitLightTables();
  printf("R_InitLightTables\n");
  R_InitTranslationTables();
  printf("R_InitTranslationsTables\n");
}

subsector_t *R_PointInSubsector(fixed_t x, fixed_t y)
{
  int nodenum = numnodes-1;
  while (!(nodenum & NF_SUBSECTOR))
    nodenum = nodes[nodenum].children[R_PointOnSide(x, y, nodes+nodenum)];
  return &subsectors[nodenum & ~NF_SUBSECTOR];
}

void R_SetupFrame (player_t *player)
{               
  int i, cm;
    
  viewplayer = player;
  viewx = player->mo->x;
  viewy = player->mo->y;
  viewangle = player->mo->angle;
  extralight = player->extralight;

  viewz = player->viewz;
    
  viewsin = finesine[viewangle>>ANGLETOFINESHIFT];
  viewcos = finecosine[viewangle>>ANGLETOFINESHIFT];

  if (player->mo->subsector->sector->heightsec != -1)
    {
      const sector_t *s = player->mo->subsector->sector->heightsec + sectors;
      cm = viewz < s->floorheight ? s->bottommap : viewz > s->ceilingheight ?
        s->topmap : s->midmap;
      if (cm < 0 || cm > numcolormaps)
        cm = 0;
    }
  else
    cm = 0;

  fullcolormap = colormaps[cm];
  zlight = c_zlight[cm];
  scalelight = c_scalelight[cm];

  if (player->fixedcolormap)
    {
      static lighttable_t *scalelightfixed[MAXLIGHTSCALE];

      fixedcolormap = fullcolormap
        + player->fixedcolormap*256*sizeof(lighttable_t);
        
      walllights = scalelightfixed;

      for (i=0 ; i<MAXLIGHTSCALE ; i++)
        scalelightfixed[i] = fixedcolormap;
    }
  else
    fixedcolormap = 0;

  validcount++;
}

void R_RenderPlayerView (player_t* player)
{       
  R_SetupFrame (player);
  R_ClearClipSegs ();
  R_ClearDrawSegs ();
  R_ClearPlanes ();
  R_ClearSprites ();
  R_RenderBSPNode (numnodes-1);
  R_DrawPlanes ();
  R_DrawMasked ();
}