#ifndef __W_WAD__
#define __W_WAD__

typedef struct
{
  char identification[4];
  int  numlumps;
  int  infotableofs;
} wadinfo_t;

typedef struct
{
  int  filepos;
  int  size;
  char name[8];
} filelump_t;

typedef struct
{
  char  name[8];
  int   size;
  const void *data;
  int index, next;
  enum {
    ns_global=0,
    ns_sprites,
    ns_flats,
    ns_colormaps
  } namespace;

  int handle;
  int position;
} lumpinfo_t;

extern const size_t num_predefined_lumps;
extern const lumpinfo_t predefined_lumps[];
extern void       **lumpcache;
extern lumpinfo_t *lumpinfo;
extern int        numlumps;
void W_InitMultipleFiles(char *const*filenames);

#define W_CheckNumForName(name) (W_CheckNumForName)(name, ns_global)
int     (W_CheckNumForName)(const char* name, int);
int     W_GetNumForName (const char* name);
int     W_LumpLength (int lump);
void    W_ReadLump (int lump, void *dest);
void*   W_CacheLumpNum (int lump, int tag);

#define W_CacheLumpName(name,tag) W_CacheLumpNum (W_GetNumForName(name),(tag))

char *AddDefaultExtension(char *, const char *);
void ExtractFileBase(const char *, char *);
unsigned W_LumpNameHash(const char *s);

#endif