// Emacs style mode select   -*- C++ -*-
//-----------------------------------------------------------------------------
//
// $Id
//
//  Copyright (C) 2004 Carlos Guariglia
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
//  02111-1307, USA.
//
//-----------------------------------------------------------------------------

#include "z_zone.h"

#include "doomstat.h"
#include "i_system.h"
#include "d_event.h"
#include "d_net.h"
#include "m_argv.h"
#include <go32.h>
#include <dpmi.h>

int real_doomcom;
void    NetSend (void);
boolean NetListen (void);

void (*netget) (void);
void (*netsend) (void);

void PacketSend (void)
{
  __dpmi_regs r;
  movedata(_my_ds(), (int) doomcom, _dos_ds, real_doomcom, sizeof(*doomcom));
  __dpmi_int(doomcom->intnum,&r);
  movedata(_dos_ds, real_doomcom, _my_ds(), (int) doomcom, sizeof(*doomcom));
}

void PacketGet (void)
{
  __dpmi_regs r;
  movedata(_my_ds(), (int) doomcom, _dos_ds, real_doomcom, sizeof(*doomcom));
  __dpmi_int(doomcom->intnum,&r);
  movedata(_dos_ds, real_doomcom, _my_ds(), (int) doomcom, sizeof(*doomcom));
}

void I_InitNetwork (void)
{
  int i,j;
      
  i = M_CheckParm ("-net");
  if (!i)
  {
    // single player game
    doomcom = (doomcom_t*)malloc (sizeof (*doomcom) );
    memset (doomcom, 0, sizeof(*doomcom) );

    netgame = false;
    doomcom->id = DOOMCOM_ID;
    doomcom->numplayers = doomcom->numnodes = 1;
    doomcom->deathmatch = false;
    doomcom->consoleplayer = 0;
    doomcom->extratics=0;
    doomcom->ticdup=1;
    return;
  }

  doomcom = (doomcom_t *) malloc(sizeof(*doomcom));
  real_doomcom = atoi(myargv[i+1]);
  movedata(_dos_ds, real_doomcom, _my_ds(), (int) doomcom, sizeof(*doomcom));

  doomcom->ticdup=1;
  if (M_CheckParm ("-extratic"))
    doomcom-> extratics = 1;
  else
    doomcom-> extratics = 0;

  j = M_CheckParm ("-dup");
  if (j && j< myargc-1)
  {
    doomcom->ticdup = myargv[j+1][0]-'0';
    if (doomcom->ticdup < 1)
      doomcom->ticdup = 1;
    if (doomcom->ticdup > 9)
      doomcom->ticdup = 9;
  }
  else
    doomcom-> ticdup = 1;

  netsend = PacketSend;
  netget = PacketGet;
  netgame = true;    
}

void I_NetCmd (void)
{
  if (doomcom->command == CMD_SEND)
  netsend ();
  else if (doomcom->command == CMD_GET)
  netget ();
  else
  I_Error ("Bad net cmd: %i",doomcom->command);
}
