// Emacs style mode select   -*- C++ -*-
//-----------------------------------------------------------------------------
//
// $Id
//
//  Copyright (C) 2004 Carlos Guariglia
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
//  02111-1307, USA.
//
//-----------------------------------------------------------------------------

#include <stdio.h>
#include <stdarg.h>
#include <gppconio.h>
#include "i_system.h"
#include "doomstat.h"
#include "m_misc.h"
#include "g_game.h"
#include "w_wad.h"
#include "m_argv.h"

extern void (*key_callback)(int);

ticcmd_t *I_BaseTiccmd(void)
{
  static ticcmd_t emptycmd;
  return &emptycmd;
}

void I_WaitVBL(int count)
{
  delay(count*100/7);
}

static volatile int realtic;

void I_timer(void)
{
  realtic++;
}

int  I_GetTime_RealTime (void)
{
  return realtic;
}

int realtic_clock_rate = 100;
static I_GetTime_Scale = 1;
int I_GetTime_Scaled(void)
{
  return realtic * I_GetTime_Scale;
}

int (*I_GetTime)();

struct keyboard_queue_s keyboard_queue;

static void keyboard_handler(int scancode)
{
  keyboard_queue.queue[keyboard_queue.head++] = scancode;
  keyboard_queue.head &= KQSIZE-1;
}

int mousepresent;

void I_Shutdown(void)
{
  if (mousepresent!=-1)
    remove_mouse();
  remove_keyboard();
  remove_timer();
}
boolean nosfxparm;
void I_Init(void)
{
  int clock_rate = realtic_clock_rate, p;
  if ((p = M_CheckParm("-speed")) && p < myargc-1 &&
      (p = atoi(myargv[p+1])) >= 100 && p <= 9000)
    clock_rate = p;

  install_timer();
  install_int_ex(I_timer,(1193181L/TICRATE));

    if (clock_rate != 100)
      {
        I_GetTime_Scale = clock_rate/100;
        I_GetTime = I_GetTime_Scaled;
      }
    else
      I_GetTime = I_GetTime_RealTime;

  key_callback = keyboard_handler;

  install_keyboard();

  mousepresent=install_mouse();
  initialise_joystick();
  atexit(I_Shutdown);

  if (!nosfxparm) I_InitSound();
}

static char errmsg[1024];
void I_EndDoom(void)
{
  int lump;
  if (lumpinfo && (lump = W_CheckNumForName("ENDOOM")) != -1)
    {
      puttext(1, 1, 80, 25,W_CacheLumpNum(lump, 0));
      gotoxy(1,24);
    }
}
void I_Quit (void)
{
  if (demorecording)
    G_CheckDemoStatus();
  M_SaveDefaults ();

  if (*errmsg)
    puts(errmsg);
  else
    I_EndDoom();
  exit(-1);
}

void I_Error(const char *error, ...)
{
  if (!*errmsg)
    {
      va_list argptr;
      va_start(argptr,error);
      vsprintf(errmsg,error,argptr);
      va_end(argptr);
    }
  exit(-1);
}