#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <graphics.h>
#include <alloc.h>
#include <dos.h>

typedef struct Directory *DirPtr;
struct Directory
{
   long start, size;
   char name[8];
};

typedef struct WadInfo *WadPtr;
struct WadInfo
{
   WadPtr next;
   char *name;
   FILE *fileinfo;
   char type[4];
   long dirsize, dirstart;
   DirPtr directory;
};

typedef struct MasterDirectory *MDirPtr;
struct MasterDirectory
{
   MDirPtr next;
   WadPtr wad;
   struct Directory dir;
};

typedef struct SelectionList *SelPtr;
struct SelectionList
{
  SelPtr next;
  int objnum;
};

typedef struct
{
   char *long_name;
   enum
   {
      OPT_INTEGER,OPT_STRING,
      OPT_STRINGACC,OPT_STRINGLIST,OPT_END
   } opt_type;
   void *data_ptr;
} OptDesc;

#define OBJ_THING 1
#define OBJ_LINE 2
#define OBJ_SIDE 3
#define OBJ_VERTEX 4
#define OBJ_SECTOR 5

extern int FakeCursor,UseMouse;
extern char *MainWad;
extern WadPtr  WadList;
extern MDirPtr MasterDir;
extern int tempint,episode,mission,doom1;
extern float Scale;
extern int OrigX,OrigY,PointerX,PointerY,ScrMaxX,ScrMaxY,ScrCenterX,ScrCenterY;

void *Memory(unsigned);
void *ResizeMemory(void *, unsigned);
void BasicWadRead(WadPtr, void *, long);
void BasicWadSeek(WadPtr, long);
MDirPtr FindMasterDir(MDirPtr, char *);
void WriteBytes(FILE *, void *, long);
void CopyBytes(FILE *, FILE *, long);
void EditLevel(int);
void SelectLevel();
void EditorLoop();
void CenterCoords(int,int);
void GoToObject(int,int);
char *ThingName(int);
char *AngleName(int);
char *WhenName(int);
char *ObjectTypeName(int);
char *LineType(int);
char *LineFlagsName(int);
char *SectorType(int type);
SelPtr SelectObjectsInBox(int,int,int,int,int);
void DeleteObject(int,int);
void DeleteObjects(int, SelPtr *);
void DrawScreenMeter(int, int, int, int, float);

struct Thing
{
   int xpos, ypos, angle, type, when;
};
typedef struct Thing *TPtr;

struct Line
{
  int side1, side2, start, end, type, tag; char flags;
};
typedef struct Line *LDPtr;

struct Side
{
   int xoff, yoff;
   char tex1[8], tex2[8], tex3[8];
   int sector;
};
typedef struct Side *SDPtr;

struct Vertex
{
   int x, y;
};
typedef struct Vertex *VPtr;

typedef struct Seg *SEPtr;
struct Seg
{
   SEPtr next;
   int start, end;
   unsigned angle;
   int line, flip;
   unsigned dist;
};

typedef struct SSector *SSPtr;
struct SSector
{
   SSPtr next;
   int num, first;
};

typedef struct Node *NPtr;
struct Node
{
   int x,y,dx,dy,miny1,maxy1,minx1,maxx1,miny2,maxy2,minx2,maxx2,child1,child2;
   NPtr node1, node2;
   int num;
};

struct Sector
{
   int floorh, ceilh;
   char floort[8], ceilt[8];
   int light, special, tag;
};
typedef struct Sector *SPtr;

extern MDirPtr Level;
extern int NumThings,NumLines,NumSides,NumVertexes;
extern TPtr  Things; extern LDPtr Lines; extern SDPtr Sides; extern VPtr  Vertexes;
extern int NumSegs,NumSSectors,NumSectors,NumWTexture,NumFTexture;
extern SEPtr Segs, LastSeg; extern SSPtr SSectors, LastSSector;
extern SPtr Sectors; extern char  **WTexture, **FTexture;
extern int MapMaxX, MapMaxY, MapMinX, MapMinY;
extern int Changed,MapChanged;
extern char *MidTexture, *LowTexture, *UpTexture;
extern char *FloorTexture, *CeilTexture;
extern int  FloorHeight, CeilHeight;

#define PLAY1 1
#define PLAY2 2
#define PLAY3 3
#define PLAY4 4
#define DMATCH 11

#define BLUECARD 5
#define YELCARD 6
#define REDCARD 13
#define BLUESKULL 40
#define YELSKULL 39
#define REDSKULL 38
#define MEGASPH 83
#define ARMBONUS 2015
#define HLTBONUS 2014
#define GREENARM 2018
#define BLUEARM 2019
#define STIMPACK 2011
#define MEDKIT 2012
#define SOULSPH 2013
#define RADSUIT 2025
#define MAP 2026
#define INVIS 2024
#define BESERK 2023
#define INVULN 2022
#define LITEAMP 2045

#define SGUN 2001
#define CGUN 2002
#define LAUNC 2003
#define PLASMA 2004
#define SAW 2005
#define BFG 2006
#define AMMO 2007
#define AMMOBOX 2048
#define SHELLS 2008
#define SHELLBOX 2049
#define ROCKET 2010
#define ROCKETBOX 2046
#define CELL 2047
#define CELLPACK 17
#define BACKPACK 8
#define SSGUN 82

#define HUMAN 3004
#define SARGT 9
#define DUDE 65
#define IMP 3001
#define SKEL 66
#define DEMON 3002
#define BARON 3003
#define KNIGHT 69
#define SPECTR 58
#define CACO 3005
#define PAIN 71
#define LSOUL 3006
#define ARACHN 68
#define VILE 64
#define MANCUBUS 67
#define SS 84
#define SPIDER 7
#define CYBER 16

#define BARREL 2035
#define FUELCAN 70
#define GARFIELD 81
#define TECHCOL 48
#define TGREENCOL 30
#define TREDCOL 32
#define SGREENCOL 31
#define SREDCOL 33
#define COLHEART 36
#define COLSKULL 37
#define EYE 41
#define GREYTREE 43
#define STUB 47
#define TREE 54
#define KEEN 72

#define LAMP 2028
#define CANDLE 34
#define CANDELABR 35
#define TBLUETORCH 44
#define TGREENTORCH 45
#define TREDTORCH 46
#define SBLUETORCH 55
#define SGREENTORCH 56
#define SREDTORCH 57
#define TALLLAMP 85
#define TALLLAMP2 86

#define DEADPLAY 15
#define DEADHUMAN 18
#define DEADSARGT 19
#define DEADIMP 20
#define DEADDEM 21
#define DEADCACO  22
#define DEADLOST 23
#define DEADVILE1 73
#define DVILE2 74
#define DVILE3 75
#define DVILE4 76
#define DVILE5 77
#define DVILE6 78
#define BONES 10
#define BONES2 12
#define POOLBLOOD 24
#define SKULLPOLE 27
#define HEADSKEWER 28
#define PILESKULLS 29
#define IMPALEDBODY 25
#define IMPALEDBODY2 26
#define SKULLSFLAMES 42

#define SWAY 49
#define ARMSOUT 50
#define ONELEG 51
#define TORSO 52
#define LEG 53
#define SWAY2 63
#define ARMSOUT2 59
#define ONELEG2 61
#define TORSO2 60
#define LEG2 62

#define TELEPT 14
#define SPAWNSPOT 87
#define BOSS 88
#define SPAWNSRC 89