#include "deu.h"
#include <math.h>

void *Memory(unsigned size)
{
   void *ret;
   ret=malloc(size);
   if (!ret) ProgError("malloc fail");
   return ret;
}
void *ResizeMemory(void *old,unsigned size)
{
   void *ret;
   ret=realloc(old,size);
   if (!ret) ProgError("realloc fail");
   return ret;
}
union REGS regs; float Scale;
int OrigX,OrigY,PointerX,PointerY,ScrMaxX=640,ScrMaxY=480,ScrCenterX=320,ScrCenterY=240,UseMouse;

void CheckMouseDriver()
{
   regs.x.ax=0;
   int86(0x33,&regs, &regs);
   UseMouse=regs.x.ax==0xffff;
}
void ShowMousePointer(hide)
{
   if(!FakeCursor)regs.x.ax=1+hide, int86(0x33,&regs,&regs);
}
void GetMouseCoords(int *x, int *y, int *buttons)
{
   regs.x.ax=3;
   int86(0x33,&regs,&regs);
   if (x!=0L) *x=regs.x.cx;
   if (y!=0L) *y=regs.x.dx;
   if (buttons) *buttons=regs.x.bx;
}
void SetMouseCoords(int x, int y)
{
   regs.x.ax=4;
   regs.x.cx=(unsigned)x;
   regs.x.dx=(unsigned)y;
   int86(0x33,&regs,&regs);
}

void InitGfx()
{
 int gdriver=9, gmode=2;
 registerbgidriver(EGAVGA_driver);
 initgraph(&gdriver,&gmode,0L);
}

void DrawMapLine(int mapXstart, int mapYstart, int mapXend, int mapYend)
{ line(SCREENX(mapXstart), SCREENY(mapYstart), SCREENX(mapXend), SCREENY(mapYend)); }
void DrawMapCircle(int mapXcenter, int mapYcenter, int mapRadius)
{ circle(SCREENX(mapXcenter), SCREENY(mapYcenter), (int) (mapRadius*Scale)); }

void DrawMapVector(int mapXstart, int mapYstart, int mapXend, int mapYend)
{
   int scrXstart=SCREENX(mapXstart);
   int scrYstart=SCREENY(mapYstart);
   int scrXend=SCREENX(mapXend);
   int scrYend=SCREENY(mapYend);
   double r=hypot((double) (scrXstart-scrXend), (double) (scrYstart-scrYend));
   int scrXoff=(r>=1.0) ? (int) ((scrXstart-scrXend)*4/r*Scale) : 0;
   int scrYoff=(r>=1.0) ? (int) ((scrYstart-scrYend)*4/r*Scale) : 0;

   line(scrXstart, scrYstart, scrXend, scrYend);
   scrXstart=scrXend+2*scrXoff;
   scrYstart=scrYend+2*scrYoff;
   line(scrXstart-scrYoff, scrYstart+scrXoff, scrXend, scrYend);
   line(scrXstart+scrYoff, scrYstart-scrXoff, scrXend, scrYend);
}

void DrawMapArrow(int mapXstart, int mapYstart, unsigned angle)
{
   int mapXend=mapXstart+(int) (50*cos(angle/10430.37835));
   int mapYend=mapYstart+(int) (50*sin(angle/10430.37835));
DrawMapVector(mapXstart,mapYstart,mapXend,mapYend);
}

void DrawScreenLine(int Xstart, int Ystart, int Xend, int Yend) { line(Xstart, Ystart, Xend, Yend); }
void DrawScreenBox(int Xstart, int Ystart, int Xend, int Yend)
{ setfillstyle(1, getcolor()); bar(Xstart, Ystart, Xend, Yend); }

void DrawScreenBox3D(int Xstart, int Ystart, int Xend, int Yend)
{  ShowMousePointer(1);
   setcolor(DARKGRAY);
   setfillstyle(1,LIGHTGRAY);
   bar3d(Xstart,Ystart,Xend,Yend,0,0);
   if (Yend-Ystart>20)
   {
      line(Xstart+1, Yend-1, Xend-1, Yend-1);
      line(Xend-1, Ystart+1, Xend-1, Yend-1);
      setcolor(WHITE);
      line(Xstart+1, Ystart+1, Xstart+1, Yend-1);
      line(Xstart+1, Ystart+1, Xend-1, Ystart+1);
   }
   setcolor(WHITE);
   line(Xstart, Ystart, Xend, Ystart);
   line(Xstart, Ystart, Xstart, Yend);
   setcolor(BLACK);
}

void DrawScreenBoxHollow(int Xstart, int Ystart, int Xend, int Yend)
{
DrawScreenBox3D(Xend,Yend,Xstart,Ystart);
setfillstyle(1,BLACK);bar(Xend-1,Yend-1,Xstart+1,Ystart+1);
}

void DrawScreenMeter(int Xstart, int Ystart, int Xend, int Yend, float value)
{
   if (value<0.0)  value=0.0;   if (value>1.0)  value=1.0;
   setfillstyle(1, LIGHTGREEN);
   bar(Xstart+1, Ystart+1, Xstart+1+(int) ((Xend-Xstart-2)*value), Yend-1);
}

void DrawScreenText(int Xstart, int Ystart, char *msg, ...)
{
   static int lastX, lastY;
   char temp[120];
   va_list args;
   va_start(args, msg);
   vsprintf(temp, msg, args);
   va_end(args);
   if (Xstart<0)  Xstart=lastX;
   if (Ystart<0)  Ystart=lastY;
   outtextxy(Xstart, Ystart, temp);
   lastX=Xstart;
   lastY=Ystart+10;
}

void DrawPointer()
{
   int r;
   setwritemode(XOR_PUT); setcolor(WHITE);
   line(PointerX,PointerY,PointerX+7,PointerY+16);
   line(PointerX,PointerY,PointerX,PointerY+11);
   line(PointerX,PointerY,PointerX+8,PointerY+8);
   setwritemode(COPY_PUT);
}

unsigned ComputeAngle(int dx, int dy) { return (unsigned) (atan2((double) dy, (double) dx)*10430.37835+0.5); }
unsigned ComputeDist(int dx, int dy) { return (unsigned) (hypot((double) dx, (double) dy)+0.5); }

void InsertPolygonVertices(int centerx, int centery, int sides, int radius)
{
   int n;  for (n=0; n < sides; n++)
   InsertObject(OBJ_VERTEX, -1, centerx+(int) ((double) radius*cos(6.28*(double) n/(double) sides)), centery+(int) ((double) radius*sin(6.2832*(double) n/(double) sides)));
}
void RotateAndScaleCoords(int *x, int *y, double angle, double scale)
{
   double r, theta;
   r=hypot((double) *x, (double) *y);  theta=atan2((double) *y, (double) *x);
   *x=(int) (r*scale*cos(theta+angle)+0.5);  *y=(int) (r*scale*sin(theta+angle)+0.5);
}