#include "deu.h"

extern int CreateNodes(NPtr *, int *, SEPtr);
MDirPtr Level;
int NumThings=0,NumLines=0,NumSides=0,NumVertexes=0,NumSectors=0;
TPtr  Things; LDPtr Lines; SDPtr Sides; VPtr  Vertexes;
int NumSegs=0,NumSSectors=0,NumNodes=0,NumWTexture=0,NumFTexture=0;
SEPtr Segs=0L, LastSeg=0L; SSPtr SSectors=0L, LastSSector=0L;
SPtr Sectors=0L; NPtr Nodes=0L; char  **WTexture, **FTexture;
int MapMaxX=-32767, MapMaxY=-32767, MapMinX=32767, MapMinY=32767;
int Changed=0,MapChanged=0;

void ReadLevelData()
{
   MDirPtr dir;
   char name[7];
   int n, m, val, OldNumVertexes, *VertexUsed;

   if(doom1) sprintf(name, "E%dM%d", episode, mission);
   else sprintf(name, "MAP%d%d", episode, mission);
   Level=FindMasterDir(MasterDir, name);
   if (!Level) ProgError("Map not found");

   dir=FindMasterDir(Level, "VERTEXES");
   if (dir!=0L) OldNumVertexes=(int) (dir->dir.size/4L);
   else OldNumVertexes=0;
   if (OldNumVertexes>0)
   {
      VertexUsed=Memory(OldNumVertexes*sizeof(int));
      for (n=0; n<OldNumVertexes; n++)
         VertexUsed[n]=0;
   }

   dir=FindMasterDir(Level, "THINGS");
   if (dir!=0L) NumThings=(int) (dir->dir.size/10L);
   else NumThings=0;
   if (NumThings>0)
   {
      Things=Memory(NumThings*sizeof(struct Thing));
      BasicWadSeek(dir->wad, dir->dir.start);
      for (n=0; n<NumThings; n++)
      {
         BasicWadRead(dir->wad,&(Things[n].xpos), 2);
         BasicWadRead(dir->wad,&(Things[n].ypos), 2);
         BasicWadRead(dir->wad,&(Things[n].angle), 2);
         BasicWadRead(dir->wad,&(Things[n].type), 2);
         BasicWadRead(dir->wad,&(Things[n].when), 2);
      }
   }

   dir=FindMasterDir(Level, "LINEDEFS");
   if (dir!=0L) NumLines=(int) (dir->dir.size/14L);
   else NumLines=0;
   if (NumLines>0)
   {
      Lines=Memory(NumLines*sizeof(struct Line));
      BasicWadSeek(dir->wad, dir->dir.start);
      for (n=0; n<NumLines; n++)
      {
         BasicWadRead(dir->wad,&(Lines[n].start), 2);
         VertexUsed[Lines[n].start] =1;
         BasicWadRead(dir->wad,&(Lines[n].end), 2);
         VertexUsed[Lines[n].end] =1;
         BasicWadRead(dir->wad,&(Lines[n].flags), 1);
	BasicWadRead(dir->wad,&val,1);
         BasicWadRead(dir->wad,&(Lines[n].type), 2);
         BasicWadRead(dir->wad,&(Lines[n].tag), 2);
         BasicWadRead(dir->wad,&(Lines[n].side1), 2);
         BasicWadRead(dir->wad,&(Lines[n].side2), 2);
      }
   }

   dir=FindMasterDir(Level, "SIDEDEFS");
   if (dir!=0L) NumSides=(int) (dir->dir.size/30L);
   else NumSides=0;
   if (NumSides>0)
   {
      Sides=Memory(NumSides*sizeof(struct Side));
      BasicWadSeek(dir->wad, dir->dir.start);
      for (n=0; n<NumSides; n++)
      {
         BasicWadRead(dir->wad,&(Sides[n].xoff), 2);
         BasicWadRead(dir->wad,&(Sides[n].yoff), 2);
         BasicWadRead(dir->wad,&(Sides[n].tex1), 8);
         BasicWadRead(dir->wad,&(Sides[n].tex2), 8);
         BasicWadRead(dir->wad,&(Sides[n].tex3), 8);
         BasicWadRead(dir->wad,&(Sides[n].sector), 2);
      }
   }

   NumVertexes=0;
   for (n=0; n<OldNumVertexes; n++)
      if (VertexUsed[n]) NumVertexes++;
   if (NumVertexes>0)
   {
      Vertexes=Memory(NumVertexes*sizeof(struct Vertex));
      dir=FindMasterDir(Level, "VERTEXES");
      BasicWadSeek(dir->wad, dir->dir.start);
      MapMaxX=-32767; MapMaxY=-32767;
      MapMinX=32767; MapMinY=32767;
      m=0;
      for (n=0; n<OldNumVertexes; n++)
      {
         BasicWadRead(dir->wad,&val, 2);
         if (VertexUsed[n])
         {
            if (val<MapMinX) MapMinX=val;
            if (val>MapMaxX) MapMaxX=val;
            Vertexes[m].x=val;
         }
         BasicWadRead(dir->wad,&val, 2);
         if (VertexUsed[n])
         {
            if (val<MapMinY) MapMinY=val;
            if (val>MapMaxY) MapMaxY=val;
            Vertexes[m].y=val;
            m++;
         }
      }
   } free(VertexUsed);
   dir=FindMasterDir(Level, "SECTORS");
   if (dir!=0L) NumSectors=(int) (dir->dir.size/26L);
   else NumSectors=0;
   if (NumSectors>0)
   {
      Sectors=Memory(NumSectors*sizeof(struct Sector));
      BasicWadSeek(dir->wad, dir->dir.start);
      for (n=0; n<NumSectors; n++)
      {
         BasicWadRead(dir->wad,&(Sectors[n].floorh), 2);
         BasicWadRead(dir->wad,&(Sectors[n].ceilh), 2);
         BasicWadRead(dir->wad,&(Sectors[n].floort), 8);
         BasicWadRead(dir->wad,&(Sectors[n].ceilt), 8);
         BasicWadRead(dir->wad,&(Sectors[n].light), 2);
         BasicWadRead(dir->wad,&(Sectors[n].special), 2);
         BasicWadRead(dir->wad,&(Sectors[n].tag), 2);
      }
   }
}

void ForgetLevelData()
{
   free(Sectors),Sectors=0;
   free(Vertexes),Vertexes=0;
   free(Sides),Sides=0;
   free(Lines),Lines=0;
   free(Things),Things=0;
NumThings=0; NumVertexes=0; NumLines=0; NumSides=0; NumSectors=0;
}

void SaveNodes(FILE *file, NPtr node)
{
   if ((node->child1&0x8000)==0)
   {
      SaveNodes(file, node->node1);
      node->child1=node->node1->num;
   }
   if ((node->child2&0x8000)==0)
   {
      SaveNodes(file, node->node2);
      node->child2=node->node2->num;
   }
   WriteBytes(file,&(node->x), 2L);
   WriteBytes(file,&(node->y), 2L);
   WriteBytes(file,&(node->dx), 2L);
   WriteBytes(file,&(node->dy), 2L);
   WriteBytes(file,&(node->maxy1), 2L);
   WriteBytes(file,&(node->miny1), 2L);
   WriteBytes(file,&(node->minx1), 2L);
   WriteBytes(file,&(node->maxx1), 2L);
   WriteBytes(file,&(node->maxy2), 2L);
   WriteBytes(file,&(node->miny2), 2L);
   WriteBytes(file,&(node->minx2), 2L);
   WriteBytes(file,&(node->maxx2), 2L);
   WriteBytes(file,&(node->child1), 2L);
   WriteBytes(file,&(node->child2), 2L);
   node->num=NumNodes++;
}

extern int Node;
SEPtr seglist;
void AddSegLine(int n) {
if (seglist) { LastSeg->next=Memory(sizeof(struct Seg));
LastSeg=LastSeg->next; } else { seglist=Memory(sizeof(struct Seg));
LastSeg=seglist; } LastSeg->next=0L;
LastSeg->line=n; LastSeg->dist=0;
}
void SaveLevelData(char *outfile)
{
   FILE   *file;
   MDirPtr dir;
   int n, i, j,blockcount,result,*blockptr,newnodes,blocksize;
   void *data;
   long counter=11,size,dirstart,oldpos,rejectsize;

   if ((file=fopen(outfile, "wb"))==0L) ProgError("open error");
   WriteBytes(file, "IWAD", 4L);
   WriteBytes(file,&counter, 4L);
   WriteBytes(file,&counter, 4L);
   counter =12L;
   dir=Level->next;
   for (n=0; n<NumThings; n++)
   {
      WriteBytes(file,&(Things[n].xpos), 2L);
      WriteBytes(file,&(Things[n].ypos), 2L);
      WriteBytes(file,&(Things[n].angle), 2L);
      WriteBytes(file,&(Things[n].type), 2L);
      WriteBytes(file,&(Things[n].when), 2L);
      counter +=10L;
   }
   dir=dir->next;

   MapMaxX=-32767; MapMaxY=-32767;
   MapMinX=32767; MapMinY=32767;
   for (n=0; n<NumVertexes; n++)
   {
      if (Vertexes[n].x<MapMinX)
         MapMinX=Vertexes[n].x;
      if (Vertexes[n].x>MapMaxX)
         MapMaxX=Vertexes[n].x;
      if (Vertexes[n].y<MapMinY)
         MapMinY=Vertexes[n].y;
      if (Vertexes[n].y>MapMaxY)
         MapMaxY=Vertexes[n].y;
   }
   if (MapChanged&&Node)
   {
      cleardevice();
      DrawScreenBox3D(118, 100, 540, 155);
      setcolor(WHITE);
      DrawScreenText(125, 110, "Build NODES");
      DrawScreenBoxHollow(125, 128, 530, 148);
      seglist=0L;
      for (n=0; n<NumLines; n++)
      {
	if (Lines[n].side1>=0) {
	AddSegLine(n);
	LastSeg->start=Lines[n].start;
	LastSeg->end=Lines[n].end;
	LastSeg->angle=ComputeAngle(Vertexes[Lines[n].end].x-Vertexes[Lines[n].start].x,
	Vertexes[Lines[n].end].y-Vertexes[Lines[n].start].y);
	LastSeg->flip=0;
	}
	if (Lines[n].side2>=0) {
	AddSegLine(n);
	LastSeg->start=Lines[n].end;
	LastSeg->end=Lines[n].start;
	LastSeg->angle=ComputeAngle(Vertexes[Lines[n].start].x-Vertexes[Lines[n].end].x,
	Vertexes[Lines[n].start].y-Vertexes[Lines[n].end].y);
	LastSeg->flip =1;
	}
      }
      CreateNodes(&Nodes,&n, seglist);
      newnodes =1;
   }
   else
      newnodes=0;

   for (n=0; n<NumLines; n++)
   {
      WriteBytes(file,&(Lines[n].start), 2L);
      WriteBytes(file,&(Lines[n].end), 2L);
      WriteBytes(file,&(Lines[n].flags), 2L);
      WriteBytes(file,&(Lines[n].type), 2L);
      WriteBytes(file,&(Lines[n].tag), 2L);
      WriteBytes(file,&(Lines[n].side1), 2L);
      WriteBytes(file,&(Lines[n].side2), 2L);
      counter +=14L;
   }
   dir=dir->next;

   for (n=0; n<NumSides; n++)
   {
      WriteBytes(file,&(Sides[n].xoff), 2L);
      WriteBytes(file,&(Sides[n].yoff), 2L);
      WriteBytes(file,&(Sides[n].tex1), 8L);
      WriteBytes(file,&(Sides[n].tex2), 8L);
      WriteBytes(file,&(Sides[n].tex3), 8L);
      WriteBytes(file,&(Sides[n].sector), 2L);
      counter+=30L;
   }
   dir=dir->next;

      for (n=0; n<NumVertexes; n++)
      {
         WriteBytes(file,&(Vertexes[n].x), 2L);
         WriteBytes(file,&(Vertexes[n].y), 2L);
         counter+=4L;
      }
   dir=dir->next;

   if (newnodes)
   {
      SEPtr curse;
      SSPtr curss;

      curse=Segs;
      while (curse)
      {
         WriteBytes(file,&(curse->start), 2L);
         WriteBytes(file,&(curse->end), 2L);
         WriteBytes(file,&(curse->angle), 2L);
         WriteBytes(file,&(curse->line), 2L);
         WriteBytes(file,&(curse->flip), 2L);
         WriteBytes(file,&(curse->dist), 2L);
         curse=curse->next;
         counter +=12L;
      }
      Segs=0L;
      dir=dir->next;

      curss=SSectors;
      while (curss)
      {
         WriteBytes(file,&(curss->num), 2L);
         WriteBytes(file,&(curss->first), 2L);
         curss=curss->next;
         counter+=4L;
      }
      SSectors=0L;
      dir=dir->next;

      NumNodes=0;
      SaveNodes(file, Nodes);
      counter+=(long) NumNodes*28L;
      dir=dir->next;
      Nodes=0L;
   }
   else
   {
      for (n=0; n<3; n++)
      {
         size=dir->dir.size;
         counter+=size;
         BasicWadSeek(dir->wad, dir->dir.start);
         CopyBytes(file, dir->wad->fileinfo, size);
         dir=dir->next;
      }
   }

   for (n=0; n<NumSectors; n++)
   {
      WriteBytes(file,&(Sectors[n].floorh), 2L);
      WriteBytes(file,&(Sectors[n].ceilh), 2L);
      WriteBytes(file,&(Sectors[n].floort), 8L);
      WriteBytes(file,&(Sectors[n].ceilt), 8L);
      WriteBytes(file,&(Sectors[n].light), 2L);
      WriteBytes(file,&(Sectors[n].special), 2L);
      WriteBytes(file,&(Sectors[n].tag), 2L);
      counter+=26L;
   }
   dir=dir->next;

   if (newnodes)
   {
      rejectsize=((long) NumSectors*(long) NumSectors+7L)/8L;
      for (i=0; i<rejectsize; i++) { WriteBytes(file, 0xf, 1L);counter++; }
      dir=dir->next;
   }
   else
   {
      rejectsize=dir->dir.size;
      size=rejectsize;
      counter+=size;
      BasicWadSeek(dir->wad, dir->dir.start);
      CopyBytes(file, dir->wad->fileinfo, size);
      dir=dir->next;
   }

   if (newnodes)
   {
      int mminx, mminy, mnumx, mnumy;
      DrawScreenBox3D(118,260,540,315);
      setcolor(WHITE);
      DrawScreenText(125,270,"Build BLOCKMAP");
      DrawScreenBoxHollow(125, 288, 530, 308);
      mminx=(int) (MapMinX-1);
      WriteBytes(file,&mminx, 2L);
      mminy=(int) (MapMinY-1);
      WriteBytes(file,&mminy, 2L);
      mnumx=(MapMaxX-mminx)/128+2;
      WriteBytes(file,&mnumx, 2L);
      mnumy=(MapMaxY-mminy)/128+2;
      WriteBytes(file,&mnumy, 2L);
      counter+=8L;
      oldpos=ftell(file);
      blocksize=mnumx*mnumy*sizeof(int);
      blockptr=Memory(blocksize);
      WriteBytes(file, blockptr, blocksize);
      blocksize+=8L;
      counter+=blocksize-7L;
      blockcount=mnumx*mnumy+4;
      for (i=0; i<mnumy; i++)
      {
         DrawScreenMeter(125,288,530,308,(float)i/(float)mnumy);
         for (j=0; j<mnumx; j++)
         {
            blockptr[mnumx*i+j]=blockcount;
            n=0;
            WriteBytes(file,&n, 2L);
            counter+=2L;
            blocksize+=2L;
            blockcount++;
            for (n=0; n<NumLines; n++)
               if (IsLineInside(n, mminx+j*128, mminy+i*128, mminx+127+j*128, mminy+127+i*128))
               {
                  WriteBytes(file,&n, 2L);
                  counter+=2L;
                  blocksize+=2L;
                  blockcount++;
               }
            n=-1;
            WriteBytes(file,&n, 2L);
            counter+=2L;
            blocksize+=2L;
            blockcount++;
         }
      }
      size=ftell(file);
      fseek(file, oldpos, SEEK_SET);
      WriteBytes(file, blockptr, mnumx*mnumy*sizeof(int));
      fseek(file, size, SEEK_SET);
      if (FindMasterDir(dir, "COLORMAP"))
         counter--;
      free(blockptr);
   }
   else
   {
      blocksize=dir->dir.size;
      size=blocksize;
      counter+=size;
      BasicWadSeek(dir->wad, dir->dir.start);
      CopyBytes(file, dir->wad->fileinfo, size);
      dir=dir->next;
   }

   dirstart=counter;
   counter =12L;
   size=0L;
   dir=Level;
   WriteBytes(file,&counter, 4L);
   WriteBytes(file,&size, 4L);
   WriteBytes(file,&(dir->dir.name), 8L);
   dir=dir->next;

   size=(long) NumThings*10L;
   WriteBytes(file,&counter, 4L);
   WriteBytes(file,&size, 4L);
   WriteBytes(file, "THINGS\0\0", 8L);
   counter+=size;
   dir=dir->next;

   size=(long) NumLines*14L;
   WriteBytes(file,&counter, 4L);
   WriteBytes(file,&size, 4L);
   WriteBytes(file, "LINEDEFS", 8L);
   counter+=size;
   dir=dir->next;

   size=(long) NumSides*30L;
   WriteBytes(file,&counter, 4L);
   WriteBytes(file,&size, 4L);
   WriteBytes(file, "SIDEDEFS", 8L);
   counter+=size;
   dir=dir->next;

   size=(long) NumVertexes*4L;
   WriteBytes(file,&counter, 4L);
   WriteBytes(file,&size, 4L);
   WriteBytes(file, "VERTEXES", 8L);
   counter+=size;
   dir=dir->next;

   if (newnodes)
      size=(long) NumSegs*12L;
   else
      size=dir->dir.size;
   WriteBytes(file,&counter, 4L);
   WriteBytes(file,&size, 4L);
   WriteBytes(file, "SEGS\0\0\0\0", 8L);
   counter+=size;
   dir=dir->next;

   if (newnodes)
      size=(long) NumSSectors*4L;
   else
      size=dir->dir.size;
   WriteBytes(file,&counter, 4L);
   WriteBytes(file,&size, 4L);
   WriteBytes(file, "SSECTORS", 8L);
   counter+=size;
   dir=dir->next;

   if (newnodes)
      size=(long) NumNodes*28L;
   else
      size=dir->dir.size;
   WriteBytes(file,&counter, 4L);
   WriteBytes(file,&size, 4L);
   WriteBytes(file, "NODES\0\0\0", 8L);
   counter+=size;
   dir=dir->next;

   size=(long) NumSectors*26L;
   WriteBytes(file,&counter, 4L);
   WriteBytes(file,&size, 4L);
   WriteBytes(file, "SECTORS\0", 8L);
   counter+=size;
   dir=dir->next;

   size=rejectsize;
   WriteBytes(file,&counter, 4L);
   WriteBytes(file,&size, 4L);
   WriteBytes(file, "REJECT\0\0", 8L);
   counter+=size;
   dir=dir->next;

   size=blocksize;
   WriteBytes(file,&counter, 4L);
   WriteBytes(file,&size, 4L);
   WriteBytes(file, "BLOCKMAP", 8L);
   counter+=size;
   dir=dir->next;

   fseek(file, 8L, SEEK_SET);
   WriteBytes(file,&dirstart, 4L);
   fclose(file);

   NumSegs=0; NumSSectors=0;  NumNodes=0;
   Changed=0; MapChanged=0;
   OpenWad(outfile);
   CloseUnusedWads();
}

int SortTextures(const void *a, const void *b)
{
   return strcmp(*((char **)a), *((char **)b));
}

void ReadTextures()
{
   MDirPtr dir;
   long *offsets,val; int n;
   char *start="F_START",*end="F_END";
   if(FindMasterDir(MasterDir,start)==0L)
   start="FF_START",end="FF_END";
   dir=FindMasterDir(MasterDir, start);
   dir=dir->next;
   for (n=0; dir&& strcmp(dir->dir.name, end); n++)
      dir=dir->next;
   NumFTexture=n;
   dir=FindMasterDir(MasterDir, start);
   dir=dir->next;
   FTexture=Memory(NumFTexture*sizeof(char *));
   for (n=0; n<NumFTexture; n++)
   {
      FTexture[n]=Memory(9*sizeof(char));
      strncpy(FTexture[n], dir->dir.name, 8);
      FTexture[n][8]='\0';
      dir=dir->next;
   }
   qsort(FTexture, NumFTexture, sizeof(char *), SortTextures);

   dir=FindMasterDir(MasterDir, "TEXTURE1");
   BasicWadSeek(dir->wad, dir->dir.start);
   BasicWadRead(dir->wad,&val, 4);
   NumWTexture=(int) val+1;
   offsets=Memory(NumWTexture*sizeof(long));
   for (n =1; n<NumWTexture; n++)
      BasicWadRead(dir->wad,&(offsets[n]), 4);
   WTexture=Memory(NumWTexture*sizeof(char *));
   WTexture[0]=Memory(9*sizeof(char));
   strcpy(WTexture[0], "-");
   for (n =1; n<NumWTexture; n++)
   {
      WTexture[n]=Memory(9*sizeof(char));
      BasicWadSeek(dir->wad, dir->dir.start+offsets[n]);
      BasicWadRead(dir->wad, WTexture[n], 8);
      WTexture[n][8]='\0';
   }
   free(offsets);
   qsort(WTexture, NumWTexture, sizeof(char *), SortTextures);
}

void ForgetTextures()
{
 int n;
 for (n=0; n<NumWTexture; n++)
 free(WTexture[n]); NumWTexture=0;
 free(WTexture);
 for (n=0; n<NumFTexture; n++)
 free(FTexture[n]); NumFTexture=0;
 free(FTexture);
}