// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id:
//
//  Copyright (C) 2004 Carlos Guariglia
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
//  02111-1307, USA.
//
//
// DESCRIPTION:
//  Thing frame/state LUT,
//  generated by multigen utilitiy.
//  This one is the original DOOM version, preserved.
//
//-----------------------------------------------------------------------------

#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "doomdef.h"
#include "sounds.h"
#include "p_mobj.h"
#include "w_wad.h"
#include "info.h"

char *sprnames[NUMSPRITES] = {
"TROO","SHTG","PUNG","PISG","PISF","SHTF","SHT2","CHGG","CHGF","MISG",
"MISF","SAWG","PLSG","PLSF","BFGG","BFGF","BLUD","PUFF","BAL1","BAL2",
"PLSS","PLSE","MISL","BFS1","BFE1","BFE2","TFOG","IFOG","PLAY","POSS",
"SPOS","VILE","FIRE","FATB","FBXP","SKEL","MANF","FATT","CPOS","SARG",
"HEAD","BAL7","BOSS","BOS2","SKUL","SPID","BSPI","APLS","APBX","CYBR",
"PAIN","SSWV","KEEN","BBRN","BOSF","ARM1","ARM2","BAR1","BEXP","FCAN",
"BON1","BON2","BKEY","RKEY","YKEY","BSKU","RSKU","YSKU","STIM","MEDI",
"SOUL","PINV","PSTR","PINS","MEGA","SUIT","PMAP","PVIS","CLIP","AMMO",
"ROCK","BROK","CELL","CELP","SHEL","SBOX","BPAK","BFUG","MGUN","CSAW",
"LAUN","PLAS","SHOT","SGN2","COLU","SMT2","GOR1","POL2","POL5","POL4",
"POL3","POL1","POL6","GOR2","GOR3","GOR4","GOR5","SMIT","COL1","COL2",
"COL3","COL4","CAND","CBRA","COL6","TRE1","TRE2","ELEC","CEYE","FSKU",
"COL5","TBLU","TGRN","TRED","SMBT","SMGT","SMRT","HDB1","HDB2","HDB3",
"HDB4","HDB5","HDB6","POB1","POB2","BRS1","TLMP","TLP2"
};

void A_Light0();
void A_WeaponReady();
void A_Lower();
void A_Raise();
void A_Punch();
void A_ReFire();
void A_FirePistol();
void A_Light1();
void A_FireShotgun();
void A_Light2();
void A_FireShotgun2();
void A_CheckReload();
void A_OpenShotgun2();
void A_LoadShotgun2();
void A_CloseShotgun2();
void A_FireCGun();
void A_GunFlash();
void A_FireMissile();
void A_Saw();
void A_FirePlasma();
void A_BFGsound();
void A_FireBFG();
void A_BFGSpray();
void A_Explode();
void A_Pain();
void A_PlayerScream();
void A_Fall();
void A_Stop();
void A_XScream();
void A_Look();
void A_Chase();
void A_FaceTarget();
void A_PosAttack();
void A_Scream();
void A_SPosAttack();
void A_VileChase();
void A_VileStart();
void A_VileTarget();
void A_VileAttack();
void A_StartFire();
void A_Fire();
void A_FireCrackle();
void A_Tracer();
void A_SkelWhoosh();
void A_SkelFist();
void A_SkelMissile();
void A_FatRaise();
void A_FatAttack1();
void A_FatAttack2();
void A_FatAttack3();
void A_BossDeath();
void A_CPosAttack();
void A_CPosRefire();
void A_TroopAttack();
void A_SargAttack();
void A_HeadAttack();
void A_BruisAttack();
void A_SkullAttack();
void A_Metal();
void A_SpidRefire();
void A_BabyMetal();
void A_BspiAttack();
void A_Hoof();
void A_CyberAttack();
void A_PainAttack();
void A_PainDie();
void A_KeenDie();
void A_BrainPain();
void A_BrainScream();
void A_BrainDie();
void A_BrainAwake();
void A_BrainSpit();
void A_SpawnSound();
void A_SpawnFly();
void A_BrainExplode();

state_t states[NUMSTATES] = {
{SPR_TROO,0,-1,0,S_NULL},
{SPR_SHTG,4,0,A_Light0,S_NULL},
{SPR_PUNG,0,1,A_WeaponReady,S_PUNCH},
{SPR_PUNG,0,1,A_Lower,S_PUNCHDOWN},
{SPR_PUNG,0,1,A_Raise,S_PUNCHUP},
{SPR_PUNG,1,4,0,S_PUNCH2},
{SPR_PUNG,2,4,A_Punch,S_PUNCH3},
{SPR_PUNG,3,5,0,S_PUNCH4},
{SPR_PUNG,2,4,0,S_PUNCH5},
{SPR_PUNG,1,5,A_ReFire,S_PUNCH},
{SPR_PISG,0,1,A_WeaponReady,S_PISTOL},
{SPR_PISG,0,1,A_Lower,S_PISTOLDOWN},
{SPR_PISG,0,1,A_Raise,S_PISTOLUP},
{SPR_PISG,0,4,0,S_PISTOL2},
{SPR_PISG,1,6,A_FirePistol,S_PISTOL3},
{SPR_PISG,2,4,0,S_PISTOL4},
{SPR_PISG,1,5,A_ReFire,S_PISTOL},
{SPR_PISF,32768,7,A_Light1,S_LIGHTDONE},
{SPR_SHTG,0,1,A_WeaponReady,S_SGUN},
{SPR_SHTG,0,1,A_Lower,S_SGUNDOWN},
{SPR_SHTG,0,1,A_Raise,S_SGUNUP},
{SPR_SHTG,0,3,0,S_SGUN2},
{SPR_SHTG,0,7,A_FireShotgun,S_SGUN3},
{SPR_SHTG,1,5,0,S_SGUN4},
{SPR_SHTG,2,5,0,S_SGUN5},
{SPR_SHTG,3,4,0,S_SGUN6},
{SPR_SHTG,2,5,0,S_SGUN7},
{SPR_SHTG,1,5,0,S_SGUN8},
{SPR_SHTG,0,3,0,S_SGUN9},
{SPR_SHTG,0,7,A_ReFire,S_SGUN},
{SPR_SHTF,32768,4,A_Light1,S_SGUNFLASH2},
{SPR_SHTF,32769,3,A_Light2,S_LIGHTDONE},
{SPR_SHT2,0,1,A_WeaponReady,S_DSGUN},
{SPR_SHT2,0,1,A_Lower,S_DSGUNDOWN},
{SPR_SHT2,0,1,A_Raise,S_DSGUNUP},
{SPR_SHT2,0,3,0,S_DSGUN2},
{SPR_SHT2,32768,7,A_FireShotgun2,S_DSGUN3},
{SPR_SHT2,1,7,0,S_DSGUN4},
{SPR_SHT2,2,7,A_CheckReload,S_DSGUN5},
{SPR_SHT2,3,7,A_OpenShotgun2,S_DSGUN6},
{SPR_SHT2,4,7,0,S_DSGUN7},
{SPR_SHT2,5,7,A_LoadShotgun2,S_DSGUN8},
{SPR_SHT2,6,6,0,S_DSGUN9},
{SPR_SHT2,7,6,A_CloseShotgun2,S_DSGUN10},
{SPR_SHT2,0,5,A_ReFire,S_DSGUN},
{SPR_SHT2,1,7,0,S_DSNR2},
{SPR_SHT2,0,3,0,S_DSGUNDOWN},
{SPR_SHT2,32776,4,A_Light1,S_DSGUNFLASH2},
{SPR_SHT2,32777,4,A_Light2,S_LIGHTDONE},
{SPR_CHGG,0,1,A_WeaponReady,S_CHAIN},
{SPR_CHGG,0,1,A_Lower,S_CHAINDOWN},
{SPR_CHGG,0,1,A_Raise,S_CHAINUP},
{SPR_CHGG,0,4,A_FireCGun,S_CHAIN2},
{SPR_CHGG,1,4,A_FireCGun,S_CHAIN3},
{SPR_CHGG,1,0,A_ReFire,S_CHAIN},
{SPR_CHGF,32768,5,A_Light1,S_LIGHTDONE},
{SPR_CHGF,32769,5,A_Light2,S_LIGHTDONE},
{SPR_MISG,0,1,A_WeaponReady,S_MISSILE},
{SPR_MISG,0,1,A_Lower,S_MISSILEDOWN},
{SPR_MISG,0,1,A_Raise,S_MISSILEUP},
{SPR_MISG,1,8,A_GunFlash,S_MISSILE2},
{SPR_MISG,1,12,A_FireMissile,S_MISSILE3},
{SPR_MISG,1,0,A_ReFire,S_MISSILE},
{SPR_MISF,32768,3,A_Light1,S_MISSILEFLASH2},
{SPR_MISF,32769,4,0,S_MISSILEFLASH3},
{SPR_MISF,32770,4,A_Light2,S_MISSILEFLASH4},
{SPR_MISF,32771,4,A_Light2,S_LIGHTDONE},
{SPR_SAWG,2,4,A_WeaponReady,S_SAWB},
{SPR_SAWG,3,4,A_WeaponReady,S_SAW},
{SPR_SAWG,2,1,A_Lower,S_SAWDOWN},
{SPR_SAWG,2,1,A_Raise,S_SAWUP},
{SPR_SAWG,0,4,A_Saw,S_SAW2},
{SPR_SAWG,1,4,A_Saw,S_SAW3},
{SPR_SAWG,1,0,A_ReFire,S_SAW},
{SPR_PLSG,0,1,A_WeaponReady,S_PLASMA},
{SPR_PLSG,0,1,A_Lower,S_PLASMADOWN},
{SPR_PLSG,0,1,A_Raise,S_PLASMAUP},
{SPR_PLSG,0,3,A_FirePlasma,S_PLASMA2},
{SPR_PLSG,1,20,A_ReFire,S_PLASMA},
{SPR_PLSF,32768,4,A_Light1,S_LIGHTDONE},
{SPR_PLSF,32769,4,A_Light1,S_LIGHTDONE},
{SPR_BFGG,0,1,A_WeaponReady,S_BFG},
{SPR_BFGG,0,1,A_Lower,S_BFGDOWN},
{SPR_BFGG,0,1,A_Raise,S_BFGUP},
{SPR_BFGG,0,20,A_BFGsound,S_BFG2},
{SPR_BFGG,1,10,A_GunFlash,S_BFG3},
{SPR_BFGG,1,10,A_FireBFG,S_BFG4},
{SPR_BFGG,1,20,A_ReFire,S_BFG},
{SPR_BFGF,32768,11,A_Light1,S_BFGFLASH2},
{SPR_BFGF,32769,6,A_Light2,S_LIGHTDONE},
{SPR_BLUD,2,8,0,S_BLOOD2},
{SPR_BLUD,1,8,0,S_BLOOD3},
{SPR_BLUD,0,8,0,S_NULL},
{SPR_PUFF,32768,4,0,S_PUFF2},
{SPR_PUFF,1,4,0,S_PUFF3},
{SPR_PUFF,2,4,0,S_PUFF4},
{SPR_PUFF,3,4,0,S_NULL},
{SPR_BAL1,32768,4,0,S_TBALL2},
{SPR_BAL1,32769,4,0,S_TBALL1},
{SPR_BAL1,32770,6,0,S_TBALLX2},
{SPR_BAL1,32771,6,0,S_TBALLX3},
{SPR_BAL1,32772,6,0,S_NULL},
{SPR_BAL2,32768,4,0,S_RBALL2},
{SPR_BAL2,32769,4,0,S_RBALL1},
{SPR_BAL2,32770,6,0,S_RBALLX2},
{SPR_BAL2,32771,6,0,S_RBALLX3},
{SPR_BAL2,32772,6,0,S_NULL},
{SPR_PLSS,32768,6,0,S_PLASBALL2},
{SPR_PLSS,32769,6,0,S_PLASBALL},
{SPR_PLSE,32768,4,0,S_PLASEXP2},
{SPR_PLSE,32769,4,0,S_PLASEXP3},
{SPR_PLSE,32770,4,0,S_PLASEXP4},
{SPR_PLSE,32771,4,0,S_PLASEXP5},
{SPR_PLSE,32772,4,0,S_NULL},
{SPR_MISL,32768,1,0,S_ROCKET},
{SPR_BFS1,32768,4,0,S_BFGSHOT2},
{SPR_BFS1,32769,4,0,S_BFGSHOT},
{SPR_BFE1,32768,8,0,S_BFGLAND2},
{SPR_BFE1,32769,8,0,S_BFGLAND3},
{SPR_BFE1,32770,8,A_BFGSpray,S_BFGLAND4},
{SPR_BFE1,32771,8,0,S_BFGLAND5},
{SPR_BFE1,32772,8,0,S_BFGLAND6},
{SPR_BFE1,32773,8,0,S_NULL},
{SPR_BFE2,32768,8,0,S_BFGEXP2},
{SPR_BFE2,32769,8,0,S_BFGEXP3},
{SPR_BFE2,32770,8,0,S_BFGEXP4},
{SPR_BFE2,32771,8,0,S_NULL},
{SPR_MISL,32769,8,A_Explode,S_EXPLODE2},
{SPR_MISL,32770,6,0,S_EXPLODE3},
{SPR_MISL,32771,4,0,S_NULL},
{SPR_TFOG,32768,6,0,S_TFOG01},
{SPR_TFOG,32769,6,0,S_TFOG02},
{SPR_TFOG,32768,6,0,S_TFOG2},
{SPR_TFOG,32769,6,0,S_TFOG3},
{SPR_TFOG,32770,6,0,S_TFOG4},
{SPR_TFOG,32771,6,0,S_TFOG5},
{SPR_TFOG,32772,6,0,S_TFOG6},
{SPR_TFOG,32773,6,0,S_TFOG7},
{SPR_TFOG,32774,6,0,S_TFOG8},
{SPR_TFOG,32775,6,0,S_TFOG9},
{SPR_TFOG,32776,6,0,S_TFOG10},
{SPR_TFOG,32777,6,0,S_NULL},
{SPR_IFOG,32768,6,0,S_IFOG01},
{SPR_IFOG,32769,6,0,S_IFOG02},
{SPR_IFOG,32768,6,0,S_IFOG2},
{SPR_IFOG,32769,6,0,S_IFOG3},
{SPR_IFOG,32770,6,0,S_IFOG4},
{SPR_IFOG,32771,6,0,S_IFOG5},
{SPR_IFOG,32772,6,0,S_NULL},
{SPR_PLAY,0,-1,0,S_NULL},
{SPR_PLAY,0,4,0,S_PLAY_RUN2},
{SPR_PLAY,1,4,0,S_PLAY_RUN3},
{SPR_PLAY,2,4,0,S_PLAY_RUN4},
{SPR_PLAY,3,4,0,S_PLAY_RUN1},
{SPR_PLAY,4,12,0,S_PLAY},
{SPR_PLAY,32773,6,0,S_PLAY_ATK1},
{SPR_PLAY,6,4,0,S_PLAY_PAIN2},
{SPR_PLAY,6,4,A_Pain,S_PLAY},
{SPR_PLAY,7,10,0,S_PLAY_DIE2},
{SPR_PLAY,8,10,A_PlayerScream,S_PLAY_DIE3},
{SPR_PLAY,9,10,A_Fall,S_PLAY_DIE4},
{SPR_PLAY,10,10,0,S_PLAY_DIE5},
{SPR_PLAY,11,10,0,S_PLAY_DIE6},
{SPR_PLAY,12,10,0,S_PLAY_DIE7},
{SPR_PLAY,13,-1,0,S_NULL},
{SPR_PLAY,14,5,0,S_PLAY_XDIE2},
{SPR_PLAY,15,5,A_XScream,S_PLAY_XDIE3},
{SPR_PLAY,16,5,A_Fall,S_PLAY_XDIE4},
{SPR_PLAY,17,5,0,S_PLAY_XDIE5},
{SPR_PLAY,18,5,0,S_PLAY_XDIE6},
{SPR_PLAY,19,5,0,S_PLAY_XDIE7},
{SPR_PLAY,20,5,0,S_PLAY_XDIE8},
{SPR_PLAY,21,5,0,S_PLAY_XDIE9},
{SPR_PLAY,22,-1,0,S_NULL},
{SPR_POSS,0,10,A_Look,S_POSS_STND2},
{SPR_POSS,1,10,A_Look,S_POSS_STND},
{SPR_POSS,0,4,A_Chase,S_POSS_RUN2},
{SPR_POSS,0,4,A_Chase,S_POSS_RUN3},
{SPR_POSS,1,4,A_Chase,S_POSS_RUN4},
{SPR_POSS,1,4,A_Chase,S_POSS_RUN5},
{SPR_POSS,2,4,A_Chase,S_POSS_RUN6},
{SPR_POSS,2,4,A_Chase,S_POSS_RUN7},
{SPR_POSS,3,4,A_Chase,S_POSS_RUN8},
{SPR_POSS,3,4,A_Chase,S_POSS_RUN1},
{SPR_POSS,4,10,A_FaceTarget,S_POSS_ATK2},
{SPR_POSS,5,8,A_PosAttack,S_POSS_ATK3},
{SPR_POSS,4,8,0,S_POSS_RUN1},
{SPR_POSS,6,3,0,S_POSS_PAIN2},
{SPR_POSS,6,3,A_Pain,S_POSS_RUN1},
{SPR_POSS,7,5,0,S_POSS_DIE2},
{SPR_POSS,8,5,A_Scream,S_POSS_DIE3},
{SPR_POSS,9,5,A_Fall,S_POSS_DIE4},
{SPR_POSS,10,5,0,S_POSS_DIE5},
{SPR_POSS,11,-1,0,S_NULL},
{SPR_POSS,12,5,0,S_POSS_XDIE2},
{SPR_POSS,13,5,A_XScream,S_POSS_XDIE3},
{SPR_POSS,14,5,A_Fall,S_POSS_XDIE4},
{SPR_POSS,15,5,0,S_POSS_XDIE5},
{SPR_POSS,16,5,0,S_POSS_XDIE6},
{SPR_POSS,17,5,0,S_POSS_XDIE7},
{SPR_POSS,18,5,0,S_POSS_XDIE8},
{SPR_POSS,19,5,0,S_POSS_XDIE9},
{SPR_POSS,20,-1,0,S_NULL},
{SPR_POSS,10,5,0,S_POSS_RAISE2},
{SPR_POSS,9,5,0,S_POSS_RAISE3},
{SPR_POSS,8,5,0,S_POSS_RAISE4},
{SPR_POSS,7,5,0,S_POSS_RUN1},
{SPR_SPOS,0,10,A_Look,S_SPOS_STND2},
{SPR_SPOS,1,10,A_Look,S_SPOS_STND},
{SPR_SPOS,0,3,A_Chase,S_SPOS_RUN2},
{SPR_SPOS,0,3,A_Chase,S_SPOS_RUN3},
{SPR_SPOS,1,3,A_Chase,S_SPOS_RUN4},
{SPR_SPOS,1,3,A_Chase,S_SPOS_RUN5},
{SPR_SPOS,2,3,A_Chase,S_SPOS_RUN6},
{SPR_SPOS,2,3,A_Chase,S_SPOS_RUN7},
{SPR_SPOS,3,3,A_Chase,S_SPOS_RUN8},
{SPR_SPOS,3,3,A_Chase,S_SPOS_RUN1},
{SPR_SPOS,4,10,A_FaceTarget,S_SPOS_ATK2},
{SPR_SPOS,32773,10,A_SPosAttack,S_SPOS_ATK3},
{SPR_SPOS,4,10,0,S_SPOS_RUN1},
{SPR_SPOS,6,3,0,S_SPOS_PAIN2},
{SPR_SPOS,6,3,A_Pain,S_SPOS_RUN1},
{SPR_SPOS,7,5,0,S_SPOS_DIE2},
{SPR_SPOS,8,5,A_Scream,S_SPOS_DIE3},
{SPR_SPOS,9,5,A_Fall,S_SPOS_DIE4},
{SPR_SPOS,10,5,0,S_SPOS_DIE5},
{SPR_SPOS,11,-1,0,S_NULL},
{SPR_SPOS,12,5,0,S_SPOS_XDIE2},
{SPR_SPOS,13,5,A_XScream,S_SPOS_XDIE3},
{SPR_SPOS,14,5,A_Fall,S_SPOS_XDIE4},
{SPR_SPOS,15,5,0,S_SPOS_XDIE5},
{SPR_SPOS,16,5,0,S_SPOS_XDIE6},
{SPR_SPOS,17,5,0,S_SPOS_XDIE7},
{SPR_SPOS,18,5,0,S_SPOS_XDIE8},
{SPR_SPOS,19,5,0,S_SPOS_XDIE9},
{SPR_SPOS,20,-1,0,S_NULL},
{SPR_SPOS,11,5,0,S_SPOS_RAISE2},
{SPR_SPOS,10,5,0,S_SPOS_RAISE3},
{SPR_SPOS,9,5,0,S_SPOS_RAISE4},
{SPR_SPOS,8,5,0,S_SPOS_RAISE5},
{SPR_SPOS,7,5,0,S_SPOS_RUN1},
{SPR_VILE,0,10,A_Look,S_VILE_STND2},
{SPR_VILE,1,10,A_Look,S_VILE_STND},
{SPR_VILE,0,2,A_VileChase,S_VILE_RUN2},
{SPR_VILE,0,2,A_VileChase,S_VILE_RUN3},
{SPR_VILE,1,2,A_VileChase,S_VILE_RUN4},
{SPR_VILE,1,2,A_VileChase,S_VILE_RUN5},
{SPR_VILE,2,2,A_VileChase,S_VILE_RUN6},
{SPR_VILE,2,2,A_VileChase,S_VILE_RUN7},
{SPR_VILE,3,2,A_VileChase,S_VILE_RUN8},
{SPR_VILE,3,2,A_VileChase,S_VILE_RUN9},
{SPR_VILE,4,2,A_VileChase,S_VILE_RUN10},
{SPR_VILE,4,2,A_VileChase,S_VILE_RUN11},
{SPR_VILE,5,2,A_VileChase,S_VILE_RUN12},
{SPR_VILE,5,2,A_VileChase,S_VILE_RUN1},
{SPR_VILE,32774,0,A_VileStart,S_VILE_ATK2},
{SPR_VILE,32774,10,A_FaceTarget,S_VILE_ATK3},
{SPR_VILE,32775,8,A_VileTarget,S_VILE_ATK4},
{SPR_VILE,32776,8,A_FaceTarget,S_VILE_ATK5},
{SPR_VILE,32777,8,A_FaceTarget,S_VILE_ATK6},
{SPR_VILE,32778,8,A_FaceTarget,S_VILE_ATK7},
{SPR_VILE,32779,8,A_FaceTarget,S_VILE_ATK8},
{SPR_VILE,32780,8,A_FaceTarget,S_VILE_ATK9},
{SPR_VILE,32781,8,A_FaceTarget,S_VILE_ATK10},
{SPR_VILE,32782,8,A_VileAttack,S_VILE_ATK11},
{SPR_VILE,32783,20,0,S_VILE_RUN1},
{SPR_VILE,32794,10,0,S_VILE_HEAL2},
{SPR_VILE,32795,10,0,S_VILE_HEAL3},
{SPR_VILE,32796,10,0,S_VILE_RUN1},
{SPR_VILE,16,5,0,S_VILE_PAIN2},
{SPR_VILE,16,5,A_Pain,S_VILE_RUN1},
{SPR_VILE,16,7,0,S_VILE_DIE2},
{SPR_VILE,17,7,A_Scream,S_VILE_DIE3},
{SPR_VILE,18,7,A_Fall,S_VILE_DIE4},
{SPR_VILE,19,7,0,S_VILE_DIE5},
{SPR_VILE,20,7,0,S_VILE_DIE6},
{SPR_VILE,21,7,0,S_VILE_DIE7},
{SPR_VILE,22,7,0,S_VILE_DIE8},
{SPR_VILE,23,5,0,S_VILE_DIE9},
{SPR_VILE,24,5,0,S_VILE_DIE10},
{SPR_VILE,25,-1,0,S_NULL},
{SPR_FIRE,32768,2,A_StartFire,S_FIRE2},
{SPR_FIRE,32769,2,A_Fire,S_FIRE3},
{SPR_FIRE,32768,2,A_Fire,S_FIRE4},
{SPR_FIRE,32769,2,A_Fire,S_FIRE5},
{SPR_FIRE,32770,2,A_FireCrackle,S_FIRE6},
{SPR_FIRE,32769,2,A_Fire,S_FIRE7},
{SPR_FIRE,32770,2,A_Fire,S_FIRE8},
{SPR_FIRE,32769,2,A_Fire,S_FIRE9},
{SPR_FIRE,32770,2,A_Fire,S_FIRE10},
{SPR_FIRE,32771,2,A_Fire,S_FIRE11},
{SPR_FIRE,32770,2,A_Fire,S_FIRE12},
{SPR_FIRE,32771,2,A_Fire,S_FIRE13},
{SPR_FIRE,32770,2,A_Fire,S_FIRE14},
{SPR_FIRE,32771,2,A_Fire,S_FIRE15},
{SPR_FIRE,32772,2,A_Fire,S_FIRE16},
{SPR_FIRE,32771,2,A_Fire,S_FIRE17},
{SPR_FIRE,32772,2,A_Fire,S_FIRE18},
{SPR_FIRE,32771,2,A_Fire,S_FIRE19},
{SPR_FIRE,32772,2,A_FireCrackle,S_FIRE20},
{SPR_FIRE,32773,2,A_Fire,S_FIRE21},
{SPR_FIRE,32772,2,A_Fire,S_FIRE22},
{SPR_FIRE,32773,2,A_Fire,S_FIRE23},
{SPR_FIRE,32772,2,A_Fire,S_FIRE24},
{SPR_FIRE,32773,2,A_Fire,S_FIRE25},
{SPR_FIRE,32774,2,A_Fire,S_FIRE26},
{SPR_FIRE,32775,2,A_Fire,S_FIRE27},
{SPR_FIRE,32774,2,A_Fire,S_FIRE28},
{SPR_FIRE,32775,2,A_Fire,S_FIRE29},
{SPR_FIRE,32774,2,A_Fire,S_FIRE30},
{SPR_FIRE,32775,2,A_Fire,S_NULL},
{SPR_PUFF,1,4,0,S_SMOKE2},
{SPR_PUFF,2,4,0,S_SMOKE3},
{SPR_PUFF,1,4,0,S_SMOKE4},
{SPR_PUFF,2,4,0,S_SMOKE5},
{SPR_PUFF,3,4,0,S_NULL},
{SPR_FATB,32768,2,A_Tracer,S_TRACER2},
{SPR_FATB,32769,2,A_Tracer,S_TRACER},
{SPR_FBXP,32768,8,0,S_TRACEEXP2},
{SPR_FBXP,32769,6,0,S_TRACEEXP3},
{SPR_FBXP,32770,4,0,S_NULL},
{SPR_SKEL,0,10,A_Look,S_SKEL_STND2},
{SPR_SKEL,1,10,A_Look,S_SKEL_STND},
{SPR_SKEL,0,2,A_Chase,S_SKEL_RUN2},
{SPR_SKEL,0,2,A_Chase,S_SKEL_RUN3},
{SPR_SKEL,1,2,A_Chase,S_SKEL_RUN4},
{SPR_SKEL,1,2,A_Chase,S_SKEL_RUN5},
{SPR_SKEL,2,2,A_Chase,S_SKEL_RUN6},
{SPR_SKEL,2,2,A_Chase,S_SKEL_RUN7},
{SPR_SKEL,3,2,A_Chase,S_SKEL_RUN8},
{SPR_SKEL,3,2,A_Chase,S_SKEL_RUN9},
{SPR_SKEL,4,2,A_Chase,S_SKEL_RUN10},
{SPR_SKEL,4,2,A_Chase,S_SKEL_RUN11},
{SPR_SKEL,5,2,A_Chase,S_SKEL_RUN12},
{SPR_SKEL,5,2,A_Chase,S_SKEL_RUN1},
{SPR_SKEL,6,0,A_FaceTarget,S_SKEL_FIST2},
{SPR_SKEL,6,6,A_SkelWhoosh,S_SKEL_FIST3},
{SPR_SKEL,7,6,A_FaceTarget,S_SKEL_FIST4},
{SPR_SKEL,8,6,A_SkelFist,S_SKEL_RUN1},
{SPR_SKEL,32777,0,A_FaceTarget,S_SKEL_MISS2},
{SPR_SKEL,32777,10,A_FaceTarget,S_SKEL_MISS3},
{SPR_SKEL,10,10,A_SkelMissile,S_SKEL_MISS4},
{SPR_SKEL,10,10,A_FaceTarget,S_SKEL_RUN1},
{SPR_SKEL,11,5,0,S_SKEL_PAIN2},
{SPR_SKEL,11,5,A_Pain,S_SKEL_RUN1},
{SPR_SKEL,11,7,0,S_SKEL_DIE2},
{SPR_SKEL,12,7,0,S_SKEL_DIE3},
{SPR_SKEL,13,7,A_Scream,S_SKEL_DIE4},
{SPR_SKEL,14,7,A_Fall,S_SKEL_DIE5},
{SPR_SKEL,15,7,0,S_SKEL_DIE6},
{SPR_SKEL,16,-1,0,S_NULL},
{SPR_SKEL,16,5,0,S_SKEL_RAISE2},
{SPR_SKEL,15,5,0,S_SKEL_RAISE3},
{SPR_SKEL,14,5,0,S_SKEL_RAISE4},
{SPR_SKEL,13,5,0,S_SKEL_RAISE5},
{SPR_SKEL,12,5,0,S_SKEL_RAISE6},
{SPR_SKEL,11,5,0,S_SKEL_RUN1},
{SPR_MANF,32768,4,0,S_FATSHOT2},
{SPR_MANF,32769,4,0,S_FATSHOT1},
{SPR_MISL,32769,8,0,S_FATSHOTX2},
{SPR_MISL,32770,6,0,S_FATSHOTX3},
{SPR_MISL,32771,4,0,S_NULL},
{SPR_FATT,0,15,A_Look,S_FATT_STND2},
{SPR_FATT,1,15,A_Look,S_FATT_STND},
{SPR_FATT,0,4,A_Chase,S_FATT_RUN2},
{SPR_FATT,0,4,A_Chase,S_FATT_RUN3},
{SPR_FATT,1,4,A_Chase,S_FATT_RUN4},
{SPR_FATT,1,4,A_Chase,S_FATT_RUN5},
{SPR_FATT,2,4,A_Chase,S_FATT_RUN6},
{SPR_FATT,2,4,A_Chase,S_FATT_RUN7},
{SPR_FATT,3,4,A_Chase,S_FATT_RUN8},
{SPR_FATT,3,4,A_Chase,S_FATT_RUN9},
{SPR_FATT,4,4,A_Chase,S_FATT_RUN10},
{SPR_FATT,4,4,A_Chase,S_FATT_RUN11},
{SPR_FATT,5,4,A_Chase,S_FATT_RUN12},
{SPR_FATT,5,4,A_Chase,S_FATT_RUN1},
{SPR_FATT,6,20,A_FatRaise,S_FATT_ATK2},
{SPR_FATT,32775,10,A_FatAttack1,S_FATT_ATK3},
{SPR_FATT,8,5,A_FaceTarget,S_FATT_ATK4},
{SPR_FATT,6,5,A_FaceTarget,S_FATT_ATK5},
{SPR_FATT,32775,10,A_FatAttack2,S_FATT_ATK6},
{SPR_FATT,8,5,A_FaceTarget,S_FATT_ATK7},
{SPR_FATT,6,5,A_FaceTarget,S_FATT_ATK8},
{SPR_FATT,32775,10,A_FatAttack3,S_FATT_ATK9},
{SPR_FATT,8,5,A_FaceTarget,S_FATT_ATK10},
{SPR_FATT,6,5,A_FaceTarget,S_FATT_RUN1},
{SPR_FATT,9,3,0,S_FATT_PAIN2},
{SPR_FATT,9,3,A_Pain,S_FATT_RUN1},
{SPR_FATT,10,6,0,S_FATT_DIE2},
{SPR_FATT,11,6,A_Scream,S_FATT_DIE3},
{SPR_FATT,12,6,A_Fall,S_FATT_DIE4},
{SPR_FATT,13,6,0,S_FATT_DIE5},
{SPR_FATT,14,6,0,S_FATT_DIE6},
{SPR_FATT,15,6,0,S_FATT_DIE7},
{SPR_FATT,16,6,0,S_FATT_DIE8},
{SPR_FATT,17,6,0,S_FATT_DIE9},
{SPR_FATT,18,6,0,S_FATT_DIE10},
{SPR_FATT,19,-1,A_BossDeath,S_NULL},
{SPR_FATT,17,5,0,S_FATT_RAISE2},
{SPR_FATT,16,5,0,S_FATT_RAISE3},
{SPR_FATT,15,5,0,S_FATT_RAISE4},
{SPR_FATT,14,5,0,S_FATT_RAISE5},
{SPR_FATT,13,5,0,S_FATT_RAISE6},
{SPR_FATT,12,5,0,S_FATT_RAISE7},
{SPR_FATT,11,5,0,S_FATT_RAISE8},
{SPR_FATT,10,5,0,S_FATT_RUN1},
{SPR_CPOS,0,10,A_Look,S_CPOS_STND2},
{SPR_CPOS,1,10,A_Look,S_CPOS_STND},
{SPR_CPOS,0,3,A_Chase,S_CPOS_RUN2},
{SPR_CPOS,0,3,A_Chase,S_CPOS_RUN3},
{SPR_CPOS,1,3,A_Chase,S_CPOS_RUN4},
{SPR_CPOS,1,3,A_Chase,S_CPOS_RUN5},
{SPR_CPOS,2,3,A_Chase,S_CPOS_RUN6},
{SPR_CPOS,2,3,A_Chase,S_CPOS_RUN7},
{SPR_CPOS,3,3,A_Chase,S_CPOS_RUN8},
{SPR_CPOS,3,3,A_Chase,S_CPOS_RUN1},
{SPR_CPOS,4,10,A_FaceTarget,S_CPOS_ATK2},
{SPR_CPOS,32773,4,A_CPosAttack,S_CPOS_ATK3},
{SPR_CPOS,32772,4,A_CPosAttack,S_CPOS_ATK4},
{SPR_CPOS,5,1,A_CPosRefire,S_CPOS_ATK2},
{SPR_CPOS,6,3,0,S_CPOS_PAIN2},
{SPR_CPOS,6,3,A_Pain,S_CPOS_RUN1},
{SPR_CPOS,7,5,0,S_CPOS_DIE2},
{SPR_CPOS,8,5,A_Scream,S_CPOS_DIE3},
{SPR_CPOS,9,5,A_Fall,S_CPOS_DIE4},
{SPR_CPOS,10,5,0,S_CPOS_DIE5},
{SPR_CPOS,11,5,0,S_CPOS_DIE6},
{SPR_CPOS,12,5,0,S_CPOS_DIE7},
{SPR_CPOS,13,-1,0,S_NULL},
{SPR_CPOS,14,5,0,S_CPOS_XDIE2},
{SPR_CPOS,15,5,A_XScream,S_CPOS_XDIE3},
{SPR_CPOS,16,5,A_Fall,S_CPOS_XDIE4},
{SPR_CPOS,17,5,0,S_CPOS_XDIE5},
{SPR_CPOS,18,5,0,S_CPOS_XDIE6},
{SPR_CPOS,19,-1,0,S_NULL},
{SPR_CPOS,13,5,0,S_CPOS_RAISE2},
{SPR_CPOS,12,5,0,S_CPOS_RAISE3},
{SPR_CPOS,11,5,0,S_CPOS_RAISE4},
{SPR_CPOS,10,5,0,S_CPOS_RAISE5},
{SPR_CPOS,9,5,0,S_CPOS_RAISE6},
{SPR_CPOS,8,5,0,S_CPOS_RAISE7},
{SPR_CPOS,7,5,0,S_CPOS_RUN1},
{SPR_TROO,0,10,A_Look,S_TROO_STND2},
{SPR_TROO,1,10,A_Look,S_TROO_STND},
{SPR_TROO,0,3,A_Chase,S_TROO_RUN2},
{SPR_TROO,0,3,A_Chase,S_TROO_RUN3},
{SPR_TROO,1,3,A_Chase,S_TROO_RUN4},
{SPR_TROO,1,3,A_Chase,S_TROO_RUN5},
{SPR_TROO,2,3,A_Chase,S_TROO_RUN6},
{SPR_TROO,2,3,A_Chase,S_TROO_RUN7},
{SPR_TROO,3,3,A_Chase,S_TROO_RUN8},
{SPR_TROO,3,3,A_Chase,S_TROO_RUN1},
{SPR_TROO,4,8,A_FaceTarget,S_TROO_ATK2},
{SPR_TROO,5,8,A_FaceTarget,S_TROO_ATK3},
{SPR_TROO,6,6,A_TroopAttack,S_TROO_RUN1},
{SPR_TROO,7,2,0,S_TROO_PAIN2},
{SPR_TROO,7,2,A_Pain,S_TROO_RUN1},
{SPR_TROO,8,8,0,S_TROO_DIE2},
{SPR_TROO,9,8,A_Scream,S_TROO_DIE3},
{SPR_TROO,10,6,0,S_TROO_DIE4},
{SPR_TROO,11,6,A_Fall,S_TROO_DIE5},
{SPR_TROO,12,-1,0,S_NULL},
{SPR_TROO,13,5,0,S_TROO_XDIE2},
{SPR_TROO,14,5,A_XScream,S_TROO_XDIE3},
{SPR_TROO,15,5,0,S_TROO_XDIE4},
{SPR_TROO,16,5,A_Fall,S_TROO_XDIE5},
{SPR_TROO,17,5,0,S_TROO_XDIE6},
{SPR_TROO,18,5,0,S_TROO_XDIE7},
{SPR_TROO,19,5,0,S_TROO_XDIE8},
{SPR_TROO,20,-1,0,S_NULL},
{SPR_TROO,12,8,0,S_TROO_RAISE2},
{SPR_TROO,11,8,0,S_TROO_RAISE3},
{SPR_TROO,10,6,0,S_TROO_RAISE4},
{SPR_TROO,9,6,0,S_TROO_RAISE5},
{SPR_TROO,8,6,0,S_TROO_RUN1},
{SPR_SARG,0,10,A_Look,S_SARG_STND2},
{SPR_SARG,1,10,A_Look,S_SARG_STND},
{SPR_SARG,0,2,A_Chase,S_SARG_RUN2},
{SPR_SARG,0,2,A_Chase,S_SARG_RUN3},
{SPR_SARG,1,2,A_Chase,S_SARG_RUN4},
{SPR_SARG,1,2,A_Chase,S_SARG_RUN5},
{SPR_SARG,2,2,A_Chase,S_SARG_RUN6},
{SPR_SARG,2,2,A_Chase,S_SARG_RUN7},
{SPR_SARG,3,2,A_Chase,S_SARG_RUN8},
{SPR_SARG,3,2,A_Chase,S_SARG_RUN1},
{SPR_SARG,4,8,A_FaceTarget,S_SARG_ATK2},
{SPR_SARG,5,8,A_FaceTarget,S_SARG_ATK3},
{SPR_SARG,6,8,A_SargAttack,S_SARG_RUN1},
{SPR_SARG,7,2,0,S_SARG_PAIN2},
{SPR_SARG,7,2,A_Pain,S_SARG_RUN1},
{SPR_SARG,8,8,0,S_SARG_DIE2},
{SPR_SARG,9,8,A_Scream,S_SARG_DIE3},
{SPR_SARG,10,4,0,S_SARG_DIE4},
{SPR_SARG,11,4,A_Fall,S_SARG_DIE5},
{SPR_SARG,12,4,0,S_SARG_DIE6},
{SPR_SARG,13,-1,0,S_NULL},
{SPR_SARG,13,5,0,S_SARG_RAISE2},
{SPR_SARG,12,5,0,S_SARG_RAISE3},
{SPR_SARG,11,5,0,S_SARG_RAISE4},
{SPR_SARG,10,5,0,S_SARG_RAISE5},
{SPR_SARG,9,5,0,S_SARG_RAISE6},
{SPR_SARG,8,5,0,S_SARG_RUN1},
{SPR_HEAD,0,10,A_Look,S_HEAD_STND},
{SPR_HEAD,0,3,A_Chase,S_HEAD_RUN1},
{SPR_HEAD,1,5,A_FaceTarget,S_HEAD_ATK2},
{SPR_HEAD,2,5,A_FaceTarget,S_HEAD_ATK3},
{SPR_HEAD,32771,5,A_HeadAttack,S_HEAD_RUN1},
{SPR_HEAD,4,3,0,S_HEAD_PAIN2},
{SPR_HEAD,4,3,A_Pain,S_HEAD_PAIN3},
{SPR_HEAD,5,6,0,S_HEAD_RUN1},
{SPR_HEAD,6,8,0,S_HEAD_DIE2},
{SPR_HEAD,7,8,A_Scream,S_HEAD_DIE3},
{SPR_HEAD,8,8,0,S_HEAD_DIE4},
{SPR_HEAD,9,8,0,S_HEAD_DIE5},
{SPR_HEAD,10,8,A_Fall,S_HEAD_DIE6},
{SPR_HEAD,11,-1,0,S_NULL},
{SPR_HEAD,11,8,0,S_HEAD_RAISE2},
{SPR_HEAD,10,8,0,S_HEAD_RAISE3},
{SPR_HEAD,9,8,0,S_HEAD_RAISE4},
{SPR_HEAD,8,8,0,S_HEAD_RAISE5},
{SPR_HEAD,7,8,0,S_HEAD_RAISE6},
{SPR_HEAD,6,8,0,S_HEAD_RUN1},
{SPR_BAL7,32768,4,0,S_BRBALL2},
{SPR_BAL7,32769,4,0,S_BRBALL1},
{SPR_BAL7,32770,6,0,S_BRBALLX2},
{SPR_BAL7,32771,6,0,S_BRBALLX3},
{SPR_BAL7,32772,6,0,S_NULL},
{SPR_BOSS,0,10,A_Look,S_BOSS_STND2},
{SPR_BOSS,1,10,A_Look,S_BOSS_STND},
{SPR_BOSS,0,3,A_Chase,S_BOSS_RUN2},
{SPR_BOSS,0,3,A_Chase,S_BOSS_RUN3},
{SPR_BOSS,1,3,A_Chase,S_BOSS_RUN4},
{SPR_BOSS,1,3,A_Chase,S_BOSS_RUN5},
{SPR_BOSS,2,3,A_Chase,S_BOSS_RUN6},
{SPR_BOSS,2,3,A_Chase,S_BOSS_RUN7},
{SPR_BOSS,3,3,A_Chase,S_BOSS_RUN8},
{SPR_BOSS,3,3,A_Chase,S_BOSS_RUN1},
{SPR_BOSS,4,8,A_FaceTarget,S_BOSS_ATK2},
{SPR_BOSS,5,8,A_FaceTarget,S_BOSS_ATK3},
{SPR_BOSS,6,8,A_BruisAttack,S_BOSS_RUN1},
{SPR_BOSS,7,2,0,S_BOSS_PAIN2},
{SPR_BOSS,7,2,A_Pain,S_BOSS_RUN1},
{SPR_BOSS,8,8,0,S_BOSS_DIE2},
{SPR_BOSS,9,8,A_Scream,S_BOSS_DIE3},
{SPR_BOSS,10,8,0,S_BOSS_DIE4},
{SPR_BOSS,11,8,A_Fall,S_BOSS_DIE5},
{SPR_BOSS,12,8,0,S_BOSS_DIE6},
{SPR_BOSS,13,8,0,S_BOSS_DIE7},
{SPR_BOSS,14,-1,A_BossDeath,S_NULL},
{SPR_BOSS,14,8,0,S_BOSS_RAISE2},
{SPR_BOSS,13,8,0,S_BOSS_RAISE3},
{SPR_BOSS,12,8,0,S_BOSS_RAISE4},
{SPR_BOSS,11,8,0,S_BOSS_RAISE5},
{SPR_BOSS,10,8,0,S_BOSS_RAISE6},
{SPR_BOSS,9,8,0,S_BOSS_RAISE7},
{SPR_BOSS,8,8,0,S_BOSS_RUN1},
{SPR_BOS2,0,10,A_Look,S_BOS2_STND2},
{SPR_BOS2,1,10,A_Look,S_BOS2_STND},
{SPR_BOS2,0,3,A_Chase,S_BOS2_RUN2},
{SPR_BOS2,0,3,A_Chase,S_BOS2_RUN3},
{SPR_BOS2,1,3,A_Chase,S_BOS2_RUN4},
{SPR_BOS2,1,3,A_Chase,S_BOS2_RUN5},
{SPR_BOS2,2,3,A_Chase,S_BOS2_RUN6},
{SPR_BOS2,2,3,A_Chase,S_BOS2_RUN7},
{SPR_BOS2,3,3,A_Chase,S_BOS2_RUN8},
{SPR_BOS2,3,3,A_Chase,S_BOS2_RUN1},
{SPR_BOS2,4,8,A_FaceTarget,S_BOS2_ATK2},
{SPR_BOS2,5,8,A_FaceTarget,S_BOS2_ATK3},
{SPR_BOS2,6,8,A_BruisAttack,S_BOS2_RUN1},
{SPR_BOS2,7,2,0,S_BOS2_PAIN2},
{SPR_BOS2,7,2,A_Pain,S_BOS2_RUN1},
{SPR_BOS2,8,8,0,S_BOS2_DIE2},
{SPR_BOS2,9,8,A_Scream,S_BOS2_DIE3},
{SPR_BOS2,10,8,0,S_BOS2_DIE4},
{SPR_BOS2,11,8,A_Fall,S_BOS2_DIE5},
{SPR_BOS2,12,8,0,S_BOS2_DIE6},
{SPR_BOS2,13,8,0,S_BOS2_DIE7},
{SPR_BOS2,14,-1,0,S_NULL},
{SPR_BOS2,14,8,0,S_BOS2_RAISE2},
{SPR_BOS2,13,8,0,S_BOS2_RAISE3},
{SPR_BOS2,12,8,0,S_BOS2_RAISE4},
{SPR_BOS2,11,8,0,S_BOS2_RAISE5},
{SPR_BOS2,10,8,0,S_BOS2_RAISE6},
{SPR_BOS2,9,8,0,S_BOS2_RAISE7},
{SPR_BOS2,8,8,0,S_BOS2_RUN1},
{SPR_SKUL,32768,10,A_Look,S_SKULL_STND2},
{SPR_SKUL,32769,10,A_Look,S_SKULL_STND},
{SPR_SKUL,32768,6,A_Chase,S_SKULL_RUN2},
{SPR_SKUL,32769,6,A_Chase,S_SKULL_RUN1},
{SPR_SKUL,32770,10,A_FaceTarget,S_SKULL_ATK2},
{SPR_SKUL,32771,4,A_SkullAttack,S_SKULL_ATK3},
{SPR_SKUL,32770,4,0,S_SKULL_ATK4},
{SPR_SKUL,32771,4,0,S_SKULL_ATK3},
{SPR_SKUL,32772,3,0,S_SKULL_PAIN2},
{SPR_SKUL,32772,3,A_Pain,S_SKULL_RUN1},
{SPR_SKUL,32773,6,0,S_SKULL_DIE2},
{SPR_SKUL,32774,6,A_Scream,S_SKULL_DIE3},
{SPR_SKUL,32775,6,0,S_SKULL_DIE4},
{SPR_SKUL,32776,6,A_Fall,S_SKULL_DIE5},
{SPR_SKUL,9,6,0,S_SKULL_DIE6},
{SPR_SKUL,10,6,0,S_NULL},
{SPR_SPID,0,10,A_Look,S_SPID_STND2},
{SPR_SPID,1,10,A_Look,S_SPID_STND},
{SPR_SPID,0,3,A_Metal,S_SPID_RUN2},
{SPR_SPID,0,3,A_Chase,S_SPID_RUN3},
{SPR_SPID,1,3,A_Chase,S_SPID_RUN4},
{SPR_SPID,1,3,A_Chase,S_SPID_RUN5},
{SPR_SPID,2,3,A_Metal,S_SPID_RUN6},
{SPR_SPID,2,3,A_Chase,S_SPID_RUN7},
{SPR_SPID,3,3,A_Chase,S_SPID_RUN8},
{SPR_SPID,3,3,A_Chase,S_SPID_RUN9},
{SPR_SPID,4,3,A_Metal,S_SPID_RUN10},
{SPR_SPID,4,3,A_Chase,S_SPID_RUN11},
{SPR_SPID,5,3,A_Chase,S_SPID_RUN12},
{SPR_SPID,5,3,A_Chase,S_SPID_RUN1},
{SPR_SPID,32768,20,A_FaceTarget,S_SPID_ATK2},
{SPR_SPID,32774,4,A_SPosAttack,S_SPID_ATK3},
{SPR_SPID,32775,4,A_SPosAttack,S_SPID_ATK4},
{SPR_SPID,32775,1,A_SpidRefire,S_SPID_ATK2},
{SPR_SPID,8,3,0,S_SPID_PAIN2},
{SPR_SPID,8,3,A_Pain,S_SPID_RUN1},
{SPR_SPID,9,20,A_Scream,S_SPID_DIE2},
{SPR_SPID,10,10,A_Fall,S_SPID_DIE3},
{SPR_SPID,11,10,0,S_SPID_DIE4},
{SPR_SPID,12,10,0,S_SPID_DIE5},
{SPR_SPID,13,10,0,S_SPID_DIE6},
{SPR_SPID,14,10,0,S_SPID_DIE7},
{SPR_SPID,15,10,0,S_SPID_DIE8},
{SPR_SPID,16,10,0,S_SPID_DIE9},
{SPR_SPID,17,10,0,S_SPID_DIE10},
{SPR_SPID,18,30,0,S_SPID_DIE11},
{SPR_SPID,18,-1,A_BossDeath,S_NULL},
{SPR_BSPI,0,10,A_Look,S_BSPI_STND2},
{SPR_BSPI,1,10,A_Look,S_BSPI_STND},
{SPR_BSPI,0,20,0,S_BSPI_RUN1},
{SPR_BSPI,0,3,A_BabyMetal,S_BSPI_RUN2},
{SPR_BSPI,0,3,A_Chase,S_BSPI_RUN3},
{SPR_BSPI,1,3,A_Chase,S_BSPI_RUN4},
{SPR_BSPI,1,3,A_Chase,S_BSPI_RUN5},
{SPR_BSPI,2,3,A_Chase,S_BSPI_RUN6},
{SPR_BSPI,2,3,A_Chase,S_BSPI_RUN7},
{SPR_BSPI,3,3,A_BabyMetal,S_BSPI_RUN8},
{SPR_BSPI,3,3,A_Chase,S_BSPI_RUN9},
{SPR_BSPI,4,3,A_Chase,S_BSPI_RUN10},
{SPR_BSPI,4,3,A_Chase,S_BSPI_RUN11},
{SPR_BSPI,5,3,A_Chase,S_BSPI_RUN12},
{SPR_BSPI,5,3,A_Chase,S_BSPI_RUN1},
{SPR_BSPI,32768,20,A_FaceTarget,S_BSPI_ATK2},
{SPR_BSPI,32774,4,A_BspiAttack,S_BSPI_ATK3},
{SPR_BSPI,32775,4,0,S_BSPI_ATK4},
{SPR_BSPI,32775,1,A_SpidRefire,S_BSPI_ATK2},
{SPR_BSPI,8,3,0,S_BSPI_PAIN2},
{SPR_BSPI,8,3,A_Pain,S_BSPI_RUN1},
{SPR_BSPI,9,20,A_Scream,S_BSPI_DIE2},
{SPR_BSPI,10,7,A_Fall,S_BSPI_DIE3},
{SPR_BSPI,11,7,0,S_BSPI_DIE4},
{SPR_BSPI,12,7,0,S_BSPI_DIE5},
{SPR_BSPI,13,7,0,S_BSPI_DIE6},
{SPR_BSPI,14,7,0,S_BSPI_DIE7},
{SPR_BSPI,15,-1,A_BossDeath,S_NULL},
{SPR_BSPI,15,5,0,S_BSPI_RAISE2},
{SPR_BSPI,14,5,0,S_BSPI_RAISE3},
{SPR_BSPI,13,5,0,S_BSPI_RAISE4},
{SPR_BSPI,12,5,0,S_BSPI_RAISE5},
{SPR_BSPI,11,5,0,S_BSPI_RAISE6},
{SPR_BSPI,10,5,0,S_BSPI_RAISE7},
{SPR_BSPI,9,5,0,S_BSPI_RUN1},
{SPR_APLS,32768,5,0,S_ARACH_PLAZ2},
{SPR_APLS,32769,5,0,S_ARACH_PLAZ},
{SPR_APBX,32768,5,0,S_ARACH_PLEX2},
{SPR_APBX,32769,5,0,S_ARACH_PLEX3},
{SPR_APBX,32770,5,0,S_ARACH_PLEX4},
{SPR_APBX,32771,5,0,S_ARACH_PLEX5},
{SPR_APBX,32772,5,0,S_NULL},
{SPR_CYBR,0,10,A_Look,S_CYBER_STND2},
{SPR_CYBR,1,10,A_Look,S_CYBER_STND},
{SPR_CYBR,0,3,A_Hoof,S_CYBER_RUN2},
{SPR_CYBR,0,3,A_Chase,S_CYBER_RUN3},
{SPR_CYBR,1,3,A_Chase,S_CYBER_RUN4},
{SPR_CYBR,1,3,A_Chase,S_CYBER_RUN5},
{SPR_CYBR,2,3,A_Chase,S_CYBER_RUN6},
{SPR_CYBR,2,3,A_Chase,S_CYBER_RUN7},
{SPR_CYBR,3,3,A_Metal,S_CYBER_RUN8},
{SPR_CYBR,3,3,A_Chase,S_CYBER_RUN1},
{SPR_CYBR,4,6,A_FaceTarget,S_CYBER_ATK2},
{SPR_CYBR,5,12,A_CyberAttack,S_CYBER_ATK3},
{SPR_CYBR,4,12,A_FaceTarget,S_CYBER_ATK4},
{SPR_CYBR,5,12,A_CyberAttack,S_CYBER_ATK5},
{SPR_CYBR,4,12,A_FaceTarget,S_CYBER_ATK6},
{SPR_CYBR,5,12,A_CyberAttack,S_CYBER_RUN1},
{SPR_CYBR,6,10,A_Pain,S_CYBER_RUN1},
{SPR_CYBR,7,10,0,S_CYBER_DIE2},
{SPR_CYBR,8,10,A_Scream,S_CYBER_DIE3},
{SPR_CYBR,9,10,0,S_CYBER_DIE4},
{SPR_CYBR,10,10,0,S_CYBER_DIE5},
{SPR_CYBR,11,10,0,S_CYBER_DIE6},
{SPR_CYBR,12,10,A_Fall,S_CYBER_DIE7},
{SPR_CYBR,13,10,0,S_CYBER_DIE8},
{SPR_CYBR,14,10,0,S_CYBER_DIE9},
{SPR_CYBR,15,30,0,S_CYBER_DIE10},
{SPR_CYBR,15,-1,A_BossDeath,S_NULL},
{SPR_PAIN,0,10,A_Look,S_PAIN_STND},
{SPR_PAIN,0,3,A_Chase,S_PAIN_RUN2},
{SPR_PAIN,0,3,A_Chase,S_PAIN_RUN3},
{SPR_PAIN,1,3,A_Chase,S_PAIN_RUN4},
{SPR_PAIN,1,3,A_Chase,S_PAIN_RUN5},
{SPR_PAIN,2,3,A_Chase,S_PAIN_RUN6},
{SPR_PAIN,2,3,A_Chase,S_PAIN_RUN1},
{SPR_PAIN,3,5,A_FaceTarget,S_PAIN_ATK2},
{SPR_PAIN,4,5,A_FaceTarget,S_PAIN_ATK3},
{SPR_PAIN,32773,5,A_FaceTarget,S_PAIN_ATK4},
{SPR_PAIN,32773,0,A_PainAttack,S_PAIN_RUN1},
{SPR_PAIN,6,6,0,S_PAIN_PAIN2},
{SPR_PAIN,6,6,A_Pain,S_PAIN_RUN1},
{SPR_PAIN,32775,8,0,S_PAIN_DIE2},
{SPR_PAIN,32776,8,A_Scream,S_PAIN_DIE3},
{SPR_PAIN,32777,8,0,S_PAIN_DIE4},
{SPR_PAIN,32778,8,0,S_PAIN_DIE5},
{SPR_PAIN,32779,8,A_PainDie,S_PAIN_DIE6},
{SPR_PAIN,32780,8,0,S_NULL},
{SPR_PAIN,12,8,0,S_PAIN_RAISE2},
{SPR_PAIN,11,8,0,S_PAIN_RAISE3},
{SPR_PAIN,10,8,0,S_PAIN_RAISE4},
{SPR_PAIN,9,8,0,S_PAIN_RAISE5},
{SPR_PAIN,8,8,0,S_PAIN_RAISE6},
{SPR_PAIN,7,8,0,S_PAIN_RUN1},
{SPR_SSWV,0,10,A_Look,S_SSWV_STND2},
{SPR_SSWV,1,10,A_Look,S_SSWV_STND},
{SPR_SSWV,0,3,A_Chase,S_SSWV_RUN2},
{SPR_SSWV,0,3,A_Chase,S_SSWV_RUN3},
{SPR_SSWV,1,3,A_Chase,S_SSWV_RUN4},
{SPR_SSWV,1,3,A_Chase,S_SSWV_RUN5},
{SPR_SSWV,2,3,A_Chase,S_SSWV_RUN6},
{SPR_SSWV,2,3,A_Chase,S_SSWV_RUN7},
{SPR_SSWV,3,3,A_Chase,S_SSWV_RUN8},
{SPR_SSWV,3,3,A_Chase,S_SSWV_RUN1},
{SPR_SSWV,4,10,A_FaceTarget,S_SSWV_ATK2},
{SPR_SSWV,5,10,A_FaceTarget,S_SSWV_ATK3},
{SPR_SSWV,32774,4,A_CPosAttack,S_SSWV_ATK4},
{SPR_SSWV,5,6,A_FaceTarget,S_SSWV_ATK5},
{SPR_SSWV,32774,4,A_CPosAttack,S_SSWV_ATK6},
{SPR_SSWV,5,1,A_CPosRefire,S_SSWV_ATK2},
{SPR_SSWV,7,3,0,S_SSWV_PAIN2},
{SPR_SSWV,7,3,A_Pain,S_SSWV_RUN1},
{SPR_SSWV,8,5,0,S_SSWV_DIE2},
{SPR_SSWV,9,5,A_Scream,S_SSWV_DIE3},
{SPR_SSWV,10,5,A_Fall,S_SSWV_DIE4},
{SPR_SSWV,11,5,0,S_SSWV_DIE5},
{SPR_SSWV,12,-1,0,S_NULL},
{SPR_SSWV,13,5,0,S_SSWV_XDIE2},
{SPR_SSWV,14,5,A_XScream,S_SSWV_XDIE3},
{SPR_SSWV,15,5,A_Fall,S_SSWV_XDIE4},
{SPR_SSWV,16,5,0,S_SSWV_XDIE5},
{SPR_SSWV,17,5,0,S_SSWV_XDIE6},
{SPR_SSWV,18,5,0,S_SSWV_XDIE7},
{SPR_SSWV,19,5,0,S_SSWV_XDIE8},
{SPR_SSWV,20,5,0,S_SSWV_XDIE9},
{SPR_SSWV,21,-1,0,S_NULL},
{SPR_SSWV,12,5,0,S_SSWV_RAISE2},
{SPR_SSWV,11,5,0,S_SSWV_RAISE3},
{SPR_SSWV,10,5,0,S_SSWV_RAISE4},
{SPR_SSWV,9,5,0,S_SSWV_RAISE5},
{SPR_SSWV,8,5,0,S_SSWV_RUN1},
{SPR_KEEN,0,-1,0,S_KEENSTND},
{SPR_KEEN,0,6,0,S_COMMKEEN2},
{SPR_KEEN,1,6,0,S_COMMKEEN3},
{SPR_KEEN,2,6,A_Scream,S_COMMKEEN4},
{SPR_KEEN,3,6,0,S_COMMKEEN5},
{SPR_KEEN,4,6,0,S_COMMKEEN6},
{SPR_KEEN,5,6,0,S_COMMKEEN7},
{SPR_KEEN,6,6,0,S_COMMKEEN8},
{SPR_KEEN,7,6,0,S_COMMKEEN9},
{SPR_KEEN,8,6,0,S_COMMKEEN10},
{SPR_KEEN,9,6,0,S_COMMKEEN11},
{SPR_KEEN,10,6,A_KeenDie,S_COMMKEEN12},
{SPR_KEEN,11,-1,0,S_NULL},
{SPR_KEEN,12,4,0,S_KEENPAIN2},
{SPR_KEEN,12,8,A_Pain,S_KEENSTND},
{SPR_BBRN,0,-1,0,S_NULL},
{SPR_BBRN,1,36,A_BrainPain,S_BRAIN},
{SPR_BBRN,0,100,A_BrainScream,S_BRAIN_DIE2},
{SPR_BBRN,0,10,0,S_BRAIN_DIE3},
{SPR_BBRN,0,10,0,S_BRAIN_DIE4},
{SPR_BBRN,0,-1,A_BrainDie,S_NULL},
{SPR_SSWV,0,10,A_Look,S_BRAINEYE},
{SPR_SSWV,0,181,A_BrainAwake,S_BRAINEYE1},
{SPR_SSWV,0,150,A_BrainSpit,S_BRAINEYE1},
{SPR_BOSF,32768,3,A_SpawnSound,S_SPAWN2},
{SPR_BOSF,32769,3,A_SpawnFly,S_SPAWN3},
{SPR_BOSF,32770,3,A_SpawnFly,S_SPAWN4},
{SPR_BOSF,32771,3,A_SpawnFly,S_SPAWN1},
{SPR_FIRE,32768,4,A_Fire,S_SPAWNFIRE2},
{SPR_FIRE,32769,4,A_Fire,S_SPAWNFIRE3},
{SPR_FIRE,32770,4,A_Fire,S_SPAWNFIRE4},
{SPR_FIRE,32771,4,A_Fire,S_SPAWNFIRE5},
{SPR_FIRE,32772,4,A_Fire,S_SPAWNFIRE6},
{SPR_FIRE,32773,4,A_Fire,S_SPAWNFIRE7},
{SPR_FIRE,32774,4,A_Fire,S_SPAWNFIRE8},
{SPR_FIRE,32775,4,A_Fire,S_NULL},
{SPR_MISL,32769,10,0,S_BRAINEXPLODE2},
{SPR_MISL,32770,10,0,S_BRAINEXPLODE3},
{SPR_MISL,32771,10,A_BrainExplode,S_NULL},
{SPR_ARM1,0,6,0,S_ARM1A},
{SPR_ARM1,32769,7,0,S_ARM1},
{SPR_ARM2,0,6,0,S_ARM2A},
{SPR_ARM2,32769,6,0,S_ARM2},
{SPR_BAR1,0,6,0,S_BAR2},
{SPR_BAR1,1,6,0,S_BAR1},
{SPR_BEXP,32768,5,0,S_BEXP2},
{SPR_BEXP,32769,5,A_Scream,S_BEXP3},
{SPR_BEXP,32770,5,0,S_BEXP4},
{SPR_BEXP,32771,10,A_Explode,S_BEXP5},
{SPR_BEXP,32772,10,0,S_NULL},
{SPR_FCAN,32768,4,0,S_BBAR2},
{SPR_FCAN,32769,4,0,S_BBAR3},
{SPR_FCAN,32770,4,0,S_BBAR1},
{SPR_BON1,0,6,0,S_BON1A},
{SPR_BON1,1,6,0,S_BON1B},
{SPR_BON1,2,6,0,S_BON1C},
{SPR_BON1,3,6,0,S_BON1D},
{SPR_BON1,2,6,0,S_BON1E},
{SPR_BON1,1,6,0,S_BON1},
{SPR_BON2,0,6,0,S_BON2A},
{SPR_BON2,1,6,0,S_BON2B},
{SPR_BON2,2,6,0,S_BON2C},
{SPR_BON2,3,6,0,S_BON2D},
{SPR_BON2,2,6,0,S_BON2E},
{SPR_BON2,1,6,0,S_BON2},
{SPR_BKEY,0,10,0,S_BKEY2},
{SPR_BKEY,32769,10,0,S_BKEY},
{SPR_RKEY,0,10,0,S_RKEY2},
{SPR_RKEY,32769,10,0,S_RKEY},
{SPR_YKEY,0,10,0,S_YKEY2},
{SPR_YKEY,32769,10,0,S_YKEY},
{SPR_BSKU,0,10,0,S_BSKULL2},
{SPR_BSKU,32769,10,0,S_BSKULL},
{SPR_RSKU,0,10,0,S_RSKULL2},
{SPR_RSKU,32769,10,0,S_RSKULL},
{SPR_YSKU,0,10,0,S_YSKULL2},
{SPR_YSKU,32769,10,0,S_YSKULL},
{SPR_STIM,0,-1,0,S_NULL},
{SPR_MEDI,0,-1,0,S_NULL},
{SPR_SOUL,32768,6,0,S_SOUL2},
{SPR_SOUL,32769,6,0,S_SOUL3},
{SPR_SOUL,32770,6,0,S_SOUL4},
{SPR_SOUL,32771,6,0,S_SOUL5},
{SPR_SOUL,32770,6,0,S_SOUL6},
{SPR_SOUL,32769,6,0,S_SOUL},
{SPR_PINV,32768,6,0,S_PINV2},
{SPR_PINV,32769,6,0,S_PINV3},
{SPR_PINV,32770,6,0,S_PINV4},
{SPR_PINV,32771,6,0,S_PINV},
{SPR_PSTR,32768,-1,0,S_NULL},
{SPR_PINS,32768,6,0,S_PINS2},
{SPR_PINS,32769,6,0,S_PINS3},
{SPR_PINS,32770,6,0,S_PINS4},
{SPR_PINS,32771,6,0,S_PINS},
{SPR_MEGA,32768,6,0,S_MEGA2},
{SPR_MEGA,32769,6,0,S_MEGA3},
{SPR_MEGA,32770,6,0,S_MEGA4},
{SPR_MEGA,32771,6,0,S_MEGA},
{SPR_SUIT,32768,-1,0,S_NULL},
{SPR_PMAP,32768,6,0,S_PMAP2},
{SPR_PMAP,32769,6,0,S_PMAP3},
{SPR_PMAP,32770,6,0,S_PMAP4},
{SPR_PMAP,32771,6,0,S_PMAP5},
{SPR_PMAP,32770,6,0,S_PMAP6},
{SPR_PMAP,32769,6,0,S_PMAP},
{SPR_PVIS,32768,6,0,S_PVIS2},
{SPR_PVIS,1,6,0,S_PVIS},
{SPR_CLIP,0,-1,0,S_NULL},
{SPR_AMMO,0,-1,0,S_NULL},
{SPR_ROCK,0,-1,0,S_NULL},
{SPR_BROK,0,-1,0,S_NULL},
{SPR_CELL,0,-1,0,S_NULL},
{SPR_CELP,0,-1,0,S_NULL},
{SPR_SHEL,0,-1,0,S_NULL},
{SPR_SBOX,0,-1,0,S_NULL},
{SPR_BPAK,0,-1,0,S_NULL},
{SPR_BFUG,0,-1,0,S_NULL},
{SPR_MGUN,0,-1,0,S_NULL},
{SPR_CSAW,0,-1,0,S_NULL},
{SPR_LAUN,0,-1,0,S_NULL},
{SPR_PLAS,0,-1,0,S_NULL},
{SPR_SHOT,0,-1,0,S_NULL},
{SPR_SGN2,0,-1,0,S_NULL},
{SPR_COLU,32768,-1,0,S_NULL},
{SPR_SMT2,0,-1,0,S_NULL},
{SPR_GOR1,0,10,0,S_BLOODYTWITCH2},
{SPR_GOR1,1,15,0,S_BLOODYTWITCH3},
{SPR_GOR1,2,8,0,S_BLOODYTWITCH4},
{SPR_GOR1,1,6,0,S_BLOODYTWITCH},
{SPR_PLAY,13,-1,0,S_NULL},
{SPR_PLAY,18,-1,0,S_NULL},
{SPR_POL2,0,-1,0,S_NULL},
{SPR_POL5,0,-1,0,S_NULL},
{SPR_POL4,0,-1,0,S_NULL},
{SPR_POL3,32768,6,0,S_HEADCANDLES2},
{SPR_POL3,32769,6,0,S_HEADCANDLES},
{SPR_POL1,0,-1,0,S_NULL},
{SPR_POL6,0,6,0,S_LIVESTICK2},
{SPR_POL6,1,8,0,S_LIVESTICK},
{SPR_GOR2,0,-1,0,S_NULL},
{SPR_GOR3,0,-1,0,S_NULL},
{SPR_GOR4,0,-1,0,S_NULL},
{SPR_GOR5,0,-1,0,S_NULL},
{SPR_SMIT,0,-1,0,S_NULL},
{SPR_COL1,0,-1,0,S_NULL},
{SPR_COL2,0,-1,0,S_NULL},
{SPR_COL3,0,-1,0,S_NULL},
{SPR_COL4,0,-1,0,S_NULL},
{SPR_CAND,32768,-1,0,S_NULL},
{SPR_CBRA,32768,-1,0,S_NULL},
{SPR_COL6,0,-1,0,S_NULL},
{SPR_TRE1,0,-1,0,S_NULL},
{SPR_TRE2,0,-1,0,S_NULL},
{SPR_ELEC,0,-1,0,S_NULL},
{SPR_CEYE,32768,6,0,S_EVILEYE2},
{SPR_CEYE,32769,6,0,S_EVILEYE3},
{SPR_CEYE,32770,6,0,S_EVILEYE4},
{SPR_CEYE,32769,6,0,S_EVILEYE},
{SPR_FSKU,32768,6,0,S_FLOATSKULL2},
{SPR_FSKU,32769,6,0,S_FLOATSKULL3},
{SPR_FSKU,32770,6,0,S_FLOATSKULL},
{SPR_COL5,0,14,0,S_HEARTCOL2},
{SPR_COL5,1,14,0,S_HEARTCOL},
{SPR_TBLU,32768,4,0,S_BLUETORCH2},
{SPR_TBLU,32769,4,0,S_BLUETORCH3},
{SPR_TBLU,32770,4,0,S_BLUETORCH4},
{SPR_TBLU,32771,4,0,S_BLUETORCH},
{SPR_TGRN,32768,4,0,S_GREENTORCH2},
{SPR_TGRN,32769,4,0,S_GREENTORCH3},
{SPR_TGRN,32770,4,0,S_GREENTORCH4},
{SPR_TGRN,32771,4,0,S_GREENTORCH},
{SPR_TRED,32768,4,0,S_REDTORCH2},
{SPR_TRED,32769,4,0,S_REDTORCH3},
{SPR_TRED,32770,4,0,S_REDTORCH4},
{SPR_TRED,32771,4,0,S_REDTORCH},
{SPR_SMBT,32768,4,0,S_BTORCHSHRT2},
{SPR_SMBT,32769,4,0,S_BTORCHSHRT3},
{SPR_SMBT,32770,4,0,S_BTORCHSHRT4},
{SPR_SMBT,32771,4,0,S_BTORCHSHRT},
{SPR_SMGT,32768,4,0,S_GTORCHSHRT2},
{SPR_SMGT,32769,4,0,S_GTORCHSHRT3},
{SPR_SMGT,32770,4,0,S_GTORCHSHRT4},
{SPR_SMGT,32771,4,0,S_GTORCHSHRT},
{SPR_SMRT,32768,4,0,S_RTORCHSHRT2},
{SPR_SMRT,32769,4,0,S_RTORCHSHRT3},
{SPR_SMRT,32770,4,0,S_RTORCHSHRT4},
{SPR_SMRT,32771,4,0,S_RTORCHSHRT},
{SPR_HDB1,0,-1,0,S_NULL},
{SPR_HDB2,0,-1,0,S_NULL},
{SPR_HDB3,0,-1,0,S_NULL},
{SPR_HDB4,0,-1,0,S_NULL},
{SPR_HDB5,0,-1,0,S_NULL},
{SPR_HDB6,0,-1,0,S_NULL},
{SPR_POB1,0,-1,0,S_NULL},
{SPR_POB2,0,-1,0,S_NULL},
{SPR_BRS1,0,-1,0,S_NULL},
{SPR_TLMP,32768,4,0,S_TECHLAMP2},
{SPR_TLMP,32769,4,0,S_TECHLAMP3},
{SPR_TLMP,32770,4,0,S_TECHLAMP4},
{SPR_TLMP,32771,4,0,S_TECHLAMP},
{SPR_TLP2,32768,4,0,S_TECH2LAMP2},
{SPR_TLP2,32769,4,0,S_TECH2LAMP3},
{SPR_TLP2,32770,4,0,S_TECH2LAMP4},
{SPR_TLP2,32771,4,0,S_TECH2LAMP}
};

mobjinfo_t mobjinfo[NUMMOBJTYPES]={
{//MT_PLAYER
-1,
S_PLAY,
100,
S_PLAY_RUN1,
sfx_None,
0,
sfx_None,
S_PLAY_PAIN,
255,
sfx_plpain,
S_NULL,
S_PLAY_ATK1,
S_PLAY_DIE1,
S_PLAY_XDIE1,
sfx_pldeth,
0,
16*FRACUNIT,
56*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID|MF_SHOOTABLE|MF_DROPOFF|MF_PICKUP|MF_NOTDMATCH,
S_NULL
},

{//MT_POSSESSED
3004,
S_POSS_STND,
20,
S_POSS_RUN1,
sfx_posit1,
8,
sfx_pistol,
S_POSS_PAIN,
200,
sfx_popain,
0,
S_POSS_ATK1,
S_POSS_DIE1,
S_POSS_XDIE1,
sfx_podth1,
8,
20*FRACUNIT,
56*FRACUNIT,
100,
0,
sfx_posact,
MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,
S_POSS_RAISE1
},

{//MT_SHOTGUY
9,
S_SPOS_STND,
30,
S_SPOS_RUN1,
sfx_posit2,
8,
0,
S_SPOS_PAIN,
170,
sfx_popain,
0,
S_SPOS_ATK1,
S_SPOS_DIE1,
S_SPOS_XDIE1,
sfx_podth2,
8,
20*FRACUNIT,
56*FRACUNIT,
100,
0,
sfx_posact,
MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,
S_SPOS_RAISE1
},

{//MT_VILE
64,
S_VILE_STND,
700,
S_VILE_RUN1,
sfx_vilsit,
8,
0,
S_VILE_PAIN,
10,
sfx_vipain,
0,
S_VILE_ATK1,
S_VILE_DIE1,
S_NULL,
sfx_vildth,
15,
20*FRACUNIT,
56*FRACUNIT,
500,
0,
sfx_vilact,
MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,
S_NULL
},

{//MT_FIRE
-1,
S_FIRE1,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_NOBLOCKMAP|MF_NOGRAVITY,
S_NULL
},

{//MT_UNDEAD
66,
S_SKEL_STND,
300,
S_SKEL_RUN1,
sfx_skesit,
8,
0,
S_SKEL_PAIN,
100,
sfx_popain,
S_SKEL_FIST1,
S_SKEL_MISS1,
S_SKEL_DIE1,
S_NULL,
sfx_skedth,
10,
20*FRACUNIT,
56*FRACUNIT,
500,
0,
sfx_skeact,
MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,
S_SKEL_RAISE1
},

{//MT_TRACER
-1,
S_TRACER,
1000,
S_NULL,
sfx_skeatk,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_TRACEEXP1,
S_NULL,
sfx_barexp,
10*FRACUNIT,
11*FRACUNIT,
8*FRACUNIT,
100,
10,
sfx_None,
MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,
S_NULL
},

{//MT_SMOKE
-1,
S_SMOKE1,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_NOBLOCKMAP|MF_NOGRAVITY,
S_NULL
},

{//MT_FATSO
67,
S_FATT_STND,
600,
S_FATT_RUN1,
sfx_mansit,
8,
0,
S_FATT_PAIN,
80,
sfx_mnpain,
0,
S_FATT_ATK1,
S_FATT_DIE1,
S_NULL,
sfx_mandth,
8,
48*FRACUNIT,
64*FRACUNIT,
1000,
0,
sfx_posact,
MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,
S_FATT_RAISE1
},

{//MT_FATSHOT
-1,
S_FATSHOT1,
1000,
S_NULL,
sfx_firsht,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_FATSHOTX1,
S_NULL,
sfx_firxpl,
20*FRACUNIT,
6*FRACUNIT,
8*FRACUNIT,
100,
8,
sfx_None,
MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,
S_NULL
},

{//MT_CHAINGUY
65,
S_CPOS_STND,
70,
S_CPOS_RUN1,
sfx_posit2,
8,
0,
S_CPOS_PAIN,
170,
sfx_popain,
0,
S_CPOS_ATK1,
S_CPOS_DIE1,
S_CPOS_XDIE1,
sfx_podth2,
8,
20*FRACUNIT,
56*FRACUNIT,
100,
0,
sfx_posact,
MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,
S_CPOS_RAISE1
},

{//MT_TROOP
3001,
S_TROO_STND,
60,
S_TROO_RUN1,
sfx_bgsit1,
8,
0,
S_TROO_PAIN,
200,
sfx_popain,
S_TROO_ATK1,
S_TROO_ATK1,
S_TROO_DIE1,
S_TROO_XDIE1,
sfx_bgdth1,
8,
20*FRACUNIT,
56*FRACUNIT,
100,
0,
sfx_bgact,
MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,
S_TROO_RAISE1
},

{//MT_SERGEANT
3002,
S_SARG_STND,
150,
S_SARG_RUN1,
sfx_sgtsit,
8,
sfx_sgtatk,
S_SARG_PAIN,
180,
sfx_dmpain,
S_SARG_ATK1,
0,
S_SARG_DIE1,
S_NULL,
sfx_sgtdth,
10,
30*FRACUNIT,
56*FRACUNIT,
400,
0,
sfx_dmact,
MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,
S_SARG_RAISE1
},

{//MT_SHADOWS
58,
S_SARG_STND,
150,
S_SARG_RUN1,
sfx_sgtsit,
8,
sfx_sgtatk,
S_SARG_PAIN,
180,
sfx_dmpain,
S_SARG_ATK1,
0,
S_SARG_DIE1,
S_NULL,
sfx_sgtdth,
10,
30*FRACUNIT,
56*FRACUNIT,
400,
0,
sfx_dmact,
MF_SOLID|MF_SHOOTABLE|MF_SHADOW|MF_COUNTKILL,
S_SARG_RAISE1
},

{//MT_HEAD
3005,
S_HEAD_STND,
400,
S_HEAD_RUN1,
sfx_cacsit,
8,
0,
S_HEAD_PAIN,
128,
sfx_dmpain,
0,
S_HEAD_ATK1,
S_HEAD_DIE1,
S_NULL,
sfx_cacdth,
8,
31*FRACUNIT,
56*FRACUNIT,
400,
0,
sfx_dmact,
MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY|MF_COUNTKILL,
S_HEAD_RAISE1
},

{//MT_BRUISER
3003,
S_BOSS_STND,
1000,
S_BOSS_RUN1,
sfx_brssit,
8,
0,
S_BOSS_PAIN,
50,
sfx_dmpain,
S_BOSS_ATK1,
S_BOSS_ATK1,
S_BOSS_DIE1,
S_NULL,
sfx_brsdth,
8,
24*FRACUNIT,
64*FRACUNIT,
1000,
0,
sfx_dmact,
MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,
S_BOSS_RAISE1
},

{//MT_BRUISERSHOT
-1,
S_BRBALL1,
1000,
S_NULL,
sfx_firsht,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_BRBALLX1,
S_NULL,
sfx_firxpl,
15*FRACUNIT,
6*FRACUNIT,
8*FRACUNIT,
100,
8,
sfx_None,
MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,
S_NULL
},

{//MT_KNIGHT
69,
S_BOS2_STND,
500,
S_BOS2_RUN1,
sfx_kntsit,
8,
0,
S_BOS2_PAIN,
50,
sfx_dmpain,
S_BOS2_ATK1,
S_BOS2_ATK1,
S_BOS2_DIE1,
S_NULL,
sfx_kntdth,
8,
24*FRACUNIT,
64*FRACUNIT,
1000,
0,
sfx_dmact,
MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,
S_BOS2_RAISE1
},

{//MT_SKULL
3006,
S_SKULL_STND,
100,
S_SKULL_RUN1,
0,
8,
sfx_sklatk,
S_SKULL_PAIN,
256,
sfx_dmpain,
0,
S_SKULL_ATK1,
S_SKULL_DIE1,
S_NULL,
sfx_firxpl,
8,
16*FRACUNIT,
56*FRACUNIT,
50,
3,
sfx_dmact,
MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY,
S_NULL
},

{//MT_SPIDER
7,
S_SPID_STND,
3000,
S_SPID_RUN1,
sfx_spisit,
8,
sfx_shotgn,
S_SPID_PAIN,
40,
sfx_dmpain,
0,
S_SPID_ATK1,
S_SPID_DIE1,
S_NULL,
sfx_spidth,
12,
128*FRACUNIT,
100*FRACUNIT,
1000,
0,
sfx_dmact,
MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,
S_NULL
},

{//MT_BABY
68,
S_BSPI_STND,
500,
S_BSPI_SIGHT,
sfx_bspsit,
8,
0,
S_BSPI_PAIN,
128,
sfx_dmpain,
0,
S_BSPI_ATK1,
S_BSPI_DIE1,
S_NULL,
sfx_bspdth,
12,
64*FRACUNIT,
64*FRACUNIT,
600,
0,
sfx_bspact,
MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,
S_BSPI_RAISE1
},

{//MT_CYBORG
16,
S_CYBER_STND,
4000,
S_CYBER_RUN1,
sfx_cybsit,
8,
0,
S_CYBER_PAIN,
20,
sfx_dmpain,
0,
S_CYBER_ATK1,
S_CYBER_DIE1,
S_NULL,
sfx_cybdth,
16,
40*FRACUNIT,
110*FRACUNIT,
1000,
0,
sfx_dmact,
MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,
S_NULL
},

{//MT_PAIN
71,
S_PAIN_STND,
400,
S_PAIN_RUN1,
sfx_pesit,
8,
0,
S_PAIN_PAIN,
128,
sfx_pepain,
0,
S_PAIN_ATK1,
S_PAIN_DIE1,
S_NULL,
sfx_pedth,
8,
31*FRACUNIT,
56*FRACUNIT,
400,
0,
sfx_dmact,
MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY|MF_COUNTKILL,
S_PAIN_RAISE1
},

{//MT_WOLFSS
84,
S_SSWV_STND,
50,
S_SSWV_RUN1,
sfx_sssit,
8,
0,
S_SSWV_PAIN,
170,
sfx_popain,
0,
S_SSWV_ATK1,
S_SSWV_DIE1,
S_SSWV_XDIE1,
sfx_ssdth,
8,
20*FRACUNIT,
56*FRACUNIT,
100,
0,
sfx_posact,
MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,
S_SSWV_RAISE1
},

{//MT_KEEN
72,
S_KEENSTND,
100,
S_NULL,
sfx_None,
8,
sfx_None,
S_KEENPAIN,
256,
sfx_keenpn,
S_NULL,
S_NULL,
S_COMMKEEN,
S_NULL,
sfx_keendt,
0,
16*FRACUNIT,
72*FRACUNIT,
10000000,
0,
sfx_None,
MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY|MF_SHOOTABLE|MF_COUNTKILL,
S_NULL
},

{//MT_BOSSBRAIN
88,
S_BRAIN,
250,
S_NULL,
sfx_None,
8,
sfx_None,
S_BRAIN_PAIN,
255,
sfx_bospn,
S_NULL,
S_NULL,
S_BRAIN_DIE1,
S_NULL,
sfx_bosdth,
0,
16*FRACUNIT,
16*FRACUNIT,
10000000,
0,
sfx_None,
MF_SOLID|MF_SHOOTABLE,
S_NULL
},

{//MT_BOSSSPIT
89,
S_BRAINEYE,
1000,
S_BRAINEYESEE,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
32*FRACUNIT,
100,
0,
sfx_None,
MF_NOBLOCKMAP|MF_NOSECTOR,
S_NULL
},

{//MT_BOSSTARGET
87,
S_NULL,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
32*FRACUNIT,
100,
0,
sfx_None,
MF_NOBLOCKMAP|MF_NOSECTOR,
S_NULL
},

{//MT_SPAWNSHOT
-1,
S_SPAWN1,
1000,
S_NULL,
sfx_bospit,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_firxpl,
10*FRACUNIT,
6*FRACUNIT,
32*FRACUNIT,
100,
3,
sfx_None,
MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_NOCLIP,
S_NULL
},

{//MT_SPAWNFIRE
-1,
S_SPAWNFIRE1,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_NOBLOCKMAP|MF_NOGRAVITY,
S_NULL
},

{//MT_BARREL
2035,
S_BAR1,
20,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_BEXP,
S_NULL,
sfx_barexp,
0,
10*FRACUNIT,
42*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID|MF_SHOOTABLE|MF_NOBLOOD,
S_NULL
},

{//MT_TROOPSHOT
-1,
S_TBALL1,
1000,
S_NULL,
sfx_firsht,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_TBALLX1,
S_NULL,
sfx_firxpl,
10*FRACUNIT,
6*FRACUNIT,
8*FRACUNIT,
100,
3,
sfx_None,
MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,
S_NULL
},

{//MT_HEADSHOT
-1,
S_RBALL1,
1000,
S_NULL,
sfx_firsht,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_RBALLX1,
S_NULL,
sfx_firxpl,
10*FRACUNIT,
6*FRACUNIT,
8*FRACUNIT,
100,
5,
sfx_None,
MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,
S_NULL
},

{//MT_ROCKET
-1,
S_ROCKET,
1000,
S_NULL,
sfx_rlaunc,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_EXPLODE1,
S_NULL,
sfx_barexp,
20*FRACUNIT,
11*FRACUNIT,
8*FRACUNIT,
100,
20,
sfx_None,
MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,
S_NULL
},

{//MT_PLASMA
-1,
S_PLASBALL,
1000,
S_NULL,
sfx_plasma,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_PLASEXP,
S_NULL,
sfx_firxpl,
25*FRACUNIT,
13*FRACUNIT,
8*FRACUNIT,
100,
5,
sfx_None,
MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,
S_NULL
},

{//MT_BFG
-1,
S_BFGSHOT,
1000,
S_NULL,
0,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_BFGLAND,
S_NULL,
sfx_rxplod,
25*FRACUNIT,
13*FRACUNIT,
8*FRACUNIT,
100,
100,
sfx_None,
MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,
S_NULL
},

{//MT_ARACHPLAZ
-1,
S_ARACH_PLAZ,
1000,
S_NULL,
sfx_plasma,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_ARACH_PLEX,
S_NULL,
sfx_firxpl,
25*FRACUNIT,
13*FRACUNIT,
8*FRACUNIT,
100,
5,
sfx_None,
MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,
S_NULL
},

{//MT_PUFF
-1,
S_PUFF1,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_NOBLOCKMAP|MF_NOGRAVITY,
S_NULL
},

{//MT_BLOOD
-1,
S_BLOOD1,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_NOBLOCKMAP,
S_NULL
},

{//MT_TFOG
-1,
S_TFOG,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_NOBLOCKMAP|MF_NOGRAVITY,
S_NULL
},

{//MT_IFOG
-1,
S_IFOG,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_NOBLOCKMAP|MF_NOGRAVITY,
S_NULL
},

{//MT_TELEPORTMAN
14,
S_NULL,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_NOBLOCKMAP|MF_NOSECTOR,
S_NULL
},

{//MT_EXTRABFG
-1,
S_BFGEXP,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_NOBLOCKMAP|MF_NOGRAVITY,
S_NULL
},

{//MT_MISC0
2018,
S_ARM1,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_MISC1
2019,
S_ARM2,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_MISC2
2014,
S_BON1,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL|MF_COUNTITEM,
S_NULL
},

{//MT_MISC3
2015,
S_BON2,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL|MF_COUNTITEM,
S_NULL
},

{//MT_MISC4
5,
S_BKEY,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL|MF_NOTDMATCH,
S_NULL
},

{//MT_MISC5
13,
S_RKEY,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL|MF_NOTDMATCH,
S_NULL
},

{//MT_MISC6
6,
S_YKEY,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL|MF_NOTDMATCH,
S_NULL
},

{//MT_MISC7
39,
S_YSKULL,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL|MF_NOTDMATCH,
S_NULL
},

{//MT_MISC8
38,
S_RSKULL,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL|MF_NOTDMATCH,
S_NULL
},

{//MT_MISC9
40,
S_BSKULL,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL|MF_NOTDMATCH,
S_NULL
},

{//MT_MISC10
2011,
S_STIM,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_MISC11
2012,
S_MEDI,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_MISC12
2013,
S_SOUL,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL|MF_COUNTITEM,
S_NULL
},

{//MT_INV
2022,
S_PINV,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL|MF_COUNTITEM,
S_NULL
},

{//MT_MISC13
2023,
S_PSTR,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL|MF_COUNTITEM,
S_NULL
},

{//MT_INS
2024,
S_PINS,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL|MF_COUNTITEM,
S_NULL
},

{//MT_MISC14
2025,
S_SUIT,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_MISC15
2026,
S_PMAP,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL|MF_COUNTITEM,
S_NULL
},

{//MT_MISC16
2045,
S_PVIS,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL|MF_COUNTITEM,
S_NULL
},

{//MT_MEGA
83,
S_MEGA,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL|MF_COUNTITEM,
S_NULL
},

{//MT_CLIP
2007,
S_CLIP,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_MISC17
2048,
S_AMMO,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_MISC18
2010,
S_ROCK,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_MISC19
2046,
S_BROK,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_MISC20
2047,
S_CELL,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_MISC21
17,
S_CELP,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_MISC22
2008,
S_SHEL,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_MISC23
2049,
S_SBOX,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_MISC24
8,
S_BPAK,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_MISC25
2006,
S_BFUG,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_CHAINGUN
2002,
S_MGUN,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_MISC26
2005,
S_CSAW,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_MISC27
2003,
S_LAUN,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_MISC28
2004,
S_PLAS,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_SHOTGUN
2001,
S_SHOT,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_SUPERSHOTGUN
82,
S_SHOT2,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SPECIAL,
S_NULL
},

{//MT_MISC29
85,
S_TECHLAMP,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC30
86,
S_TECH2LAMP,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC31
2028,
S_COLU,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC32
30,
S_TALLGRNCOL,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC33
31,
S_SHRTGRNCOL,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC34
32,
S_TALLREDCOL,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC35
33,
S_SHRTREDCOL,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC36
37,
S_SKULLCOL,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC37
36,
S_HEARTCOL,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC38
41,
S_EVILEYE,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC39
42,
S_FLOATSKULL,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC40
43,
S_TORCHTREE,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC41
44,
S_BLUETORCH,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC42
45,
S_GREENTORCH,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC43
46,
S_REDTORCH,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC44
55,
S_BTORCHSHRT,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC45
56,
S_GTORCHSHRT,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC46
57,
S_RTORCHSHRT,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC47
47,
S_STALAGTITE,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC48
48,
S_TECHPILLAR,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC49
34,
S_CANDLESTIK,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
0,
S_NULL
},

{//MT_MISC50
35,
S_CANDELABRA,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC51
49,
S_BLOODYTWITCH,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
68*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,
S_NULL
},

{//MT_MISC52
50,
S_MEAT2,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
84*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,
S_NULL
},

{//MT_MISC53
51,
S_MEAT3,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
84*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,
S_NULL
},

{//MT_MISC54
52,
S_MEAT4,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
68*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,
S_NULL
},

{//MT_MISC55
53,
S_MEAT5,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
52*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,
S_NULL
},

{//MT_MISC56
59,
S_MEAT2,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
84*FRACUNIT,
100,
0,
sfx_None,
MF_SPAWNCEILING|MF_NOGRAVITY,
S_NULL
},

{//MT_MISC57
60,
S_MEAT4,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
68*FRACUNIT,
100,
0,
sfx_None,
MF_SPAWNCEILING|MF_NOGRAVITY,
S_NULL
},

{//MT_MISC58
61,
S_MEAT3,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
52*FRACUNIT,
100,
0,
sfx_None,
MF_SPAWNCEILING|MF_NOGRAVITY,
S_NULL
},

{//MT_MISC59
62,
S_MEAT5,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
52*FRACUNIT,
100,
0,
sfx_None,
MF_SPAWNCEILING|MF_NOGRAVITY,
S_NULL
},

{//MT_MISC60
63,
S_BLOODYTWITCH,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
68*FRACUNIT,
100,
0,
sfx_None,
MF_SPAWNCEILING|MF_NOGRAVITY,
S_NULL
},

{//MT_MISC61
22,
S_HEAD_DIE6,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
0,
S_NULL
},

{//MT_MISC62
15,
S_PLAY_DIE7,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
0,
S_NULL
},

{//MT_MISC63
18,
S_POSS_DIE5,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
0,
S_NULL
},

{//MT_MISC64
21,
S_SARG_DIE6,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
0,
S_NULL
},

{//MT_MISC65
23,
S_SKULL_DIE6,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
0,
S_NULL
},

{//MT_MISC66
20,
S_TROO_DIE5,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
0,
S_NULL
},

{//MT_MISC67
19,
S_SPOS_DIE5,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
0,
S_NULL
},

{//MT_MISC68
10,
S_PLAY_XDIE9,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
0,
S_NULL
},

{//MT_MISC69
12,
S_PLAY_XDIE9,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
0,
S_NULL
},

{//MT_MISC70
28,
S_HEADSONSTICK,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC71
24,
S_GIBS,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
0,
S_NULL
},

{//MT_MISC72
27,
S_HEADONASTICK,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC73
29,
S_HEADCANDLES,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC74
25,
S_DEADSTICK,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC75
26,
S_LIVESTICK,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC76
54,
S_BIGTREE,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
32*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC77
70,
S_BBAR1,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID,
S_NULL
},

{//MT_MISC78
73,
S_HANGNOGUTS,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
88*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,
S_NULL
},

{//MT_MISC79
74,
S_HANGBNOBRAIN,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
88*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,
S_NULL
},

{//MT_MISC80
75,
S_HANGTLOOKDN,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
64*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,
S_NULL
},

{//MT_MISC81
76,
S_HANGTSKULL,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
64*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,
S_NULL
},

{//MT_MISC82
77,
S_HANGTLOOKUP,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
64*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,
S_NULL
},

{//MT_MISC83
78,
S_HANGTNOBRAIN,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
16*FRACUNIT,
64*FRACUNIT,
100,
0,
sfx_None,
MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,
S_NULL
},

{//MT_MISC84
79,
S_COLONGIBS,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_NOBLOCKMAP,
S_NULL
},

{//MT_MISC85
80,
S_SMALLPOOL,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_NOBLOCKMAP,
S_NULL
},

{//MT_MISC86
81,
S_BRAINSTEM,
1000,
S_NULL,
sfx_None,
8,
sfx_None,
S_NULL,
0,
sfx_None,
S_NULL,
S_NULL,
S_NULL,
S_NULL,
sfx_None,
0,
20*FRACUNIT,
16*FRACUNIT,
100,
0,
sfx_None,
MF_NOBLOCKMAP,
S_NULL
}
};