// Emacs style mode select   -*- C++ -*-
//----------------------------------------------------------------------------
//
//  Copyright (C) 2004 Carlos Guariglia
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
//  02111-1307, USA.
//
//----------------------------------------------------------------------------

#include "tables.h"
int FixedMul(int a,int b)
{
 return ((long long)a*b>>16);
}
int FixedDiv(int a,int b)
{
 return (abs(a)>>14)>=abs(b)?((a^b)>>31)^0x7fffffff:
 (((long long)a<<16)/b);
}

int SlopeDiv(unsigned num, unsigned den)
{
unsigned ans;
if (den < 512)
return SLOPERANGE;
ans = (num<<3)/(den>>8);
return ans <= SLOPERANGE ? ans : SLOPERANGE;
}
fixed_t	finesine[5*FINEANGLES/4];
fixed_t* finecosine;
fixed_t	finetangent[FINEANGLES/2];