//----------------------------------------------------------------------------
//  EDGE DJGPP Networking Code
//----------------------------------------------------------------------------
// 
//  Copyright (c) 1999-2001  The EDGE Team.
// 
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//----------------------------------------------------------------------------

#include "..\i_defs.h"
#include "i_sysinc.h"

#include "..\m_argv.h"

// Address of doomcom in DOS memory
static int real_doomcom;
static boolean_t network_active = false;

//
// NETWORKING
//
// -ES- 2000/05/20 Re-added. Might work sometime.

//
// I_InitNetwork
//
void I_InitNetwork(void)
{
  const char *s;

  // set up for network

  // parse network game options,
  //  -net <consoleplayer> <host> <host> ...
  s = M_GetParm("-net");
  if (!s)
  {
    // single player game
    netgame = false;
    doomcom->id = DOOMCOM_ID;
    doomcom->numplayers = doomcom->numnodes = 1;
    doomcom->deathmatch = 0;
    doomcom->consoleplayer = 0;
    doomcom->extratics = 0;
    doomcom->ticdup = 1;
    return;
  }

  real_doomcom = atoi(s);
  movedata(_dos_ds, real_doomcom, _my_ds(), (int)doomcom, sizeof(*doomcom));

  doomcom->ticdup = 1;
  if (M_CheckParm("-extratic"))
    doomcom->extratics = 1;
  else
    doomcom->extratics = 0;

  s = M_GetParm("-dup");
  if (s)
  {
    doomcom->ticdup = atoi(s);
    if (doomcom->ticdup < 1)
      doomcom->ticdup = 1;
    if (doomcom->ticdup > 9)
      doomcom->ticdup = 9;
  }
  else
    doomcom->ticdup = 1;

  netgame = true;
  network_active = true;
}

//
// I_NetCmd
//
// Sends/Recieves a packet.  Puts doomcom into dos selector from ds.
// calls interrupt in realmode.  Pulls changed doomcom out of dos selector
// to our ds.  Method for accessing data from another selector without
// releasing memory protection.
//
// -KM- 1999/01/31 Replaces both PacketGet and PacketSend which were identical.
//
void I_NetCmd(void)
{
  __dpmi_regs r;

  DEV_ASSERT(network_active, ("I_NetCmd: Network not active!"));

  movedata(_my_ds(), (int)doomcom, _dos_ds, real_doomcom, sizeof(*doomcom));
  __dpmi_int(doomcom->intnum, &r);
  movedata(_dos_ds, real_doomcom, _my_ds(), (int)doomcom, sizeof(*doomcom));
}

