//----------------------------------------------------------------------------
//  EDGE DJGPP System specific header
//----------------------------------------------------------------------------
// 
//  Copyright (c) 1999-2001  The EDGE Team.
// 
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//----------------------------------------------------------------------------

#ifndef __SYSTEM_INTERNAL_H__
#define __SYSTEM_INTERNAL_H__

#include "..\i_defs.h"

#include <allegro.h>
#include <conio.h>
#include <dos.h>
#include <dpmi.h>
#include <errno.h>
#include <float.h>
#include <go32.h>
#include <malloc.h>
#include <pc.h>
#include <signal.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#include <sys/nearptr.h>
#include <sys/time.h>
#include <sys/types.h>

// Allegro Internal routines
void _unlock_dpmi_data(void *p, int len);

// I_CD.C - DJGPP CD Audio Routines....
boolean_t BCD_Startup(void);
boolean_t BCD_PlayTrack(int tracknum);
boolean_t BCD_ResumeTrack(void);
boolean_t BCD_StopTrack(void);
boolean_t BCD_IsPlaying(void);
boolean_t BCD_SetVolume(int volume);
void BCD_Shutdown(void);
char *BCD_ReturnError(void);

// I_MUS.C - DJGPP MUS Music Routines....
boolean_t I_StartupMUS(void);
int I_MUSPlayTrack(byte *data, int length, boolean_t loopy);
void I_MUSPause(void);
void I_MUSResume(void);
void I_MUSStop(void);
boolean_t I_MUSPlaying(void);
void I_MUSSetVolume(int vol);
void I_ShutdownMUS(void);

void I_PostMusicError(char *message);

#endif
